/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.bridges;

import java.util.Set;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.bridges.Bridge;
import org.jetbrains.kotlin.backend.common.bridges.BridgesKt;
import org.jetbrains.kotlin.backend.common.bridges.DescriptorBasedFunctionHandle;
import org.jetbrains.kotlin.backend.common.bridges.FunctionHandle;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverrideResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t#\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ2\u0003\u0005\u0001\u001b\ta\t\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u0001)\u000e\rQ2\u0003\u0005\u0003\u001b\ta\t\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u0001)\u000e\rQ2\u0004E\u0003\u001b\ta\t\u0001'\u0001\u001a\u0007!\tQ\"\u0001M\u00013\rA1!D\u0001\u0019\u0002Q\u001b\u0019!d\u000e\t\b59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001J\u0003\u0019\na!\u0011C\u0001\u0003\u0001\u0011\u0015I2\u0001C\u0001\u000e\u0003a-\u0011$\u0003\u0005\u0007\u001b\u001dI!!C\u0001\u0019\f%\u0011\u0011\"\u0001\u0013\u00061\u001b!61\u0001"}, strings={"findImplementationFromInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "ImplKt", "findTraitImplementation", "firstSuperMethodFromKotlin", "implementation", "generateBridgesForFunctionDescriptor", "", "Lorg/jetbrains/kotlin/backend/common/bridges/Bridge;", "Signature", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "signature", "Lkotlin/Function1;"}, moduleName="kotlin-compiler")
public final class ImplKt {
    @NotNull
    public static final <Signature> Set<Bridge<Signature>> generateBridgesForFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull Function1<? super FunctionDescriptor, ? extends Signature> signature) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(signature, "signature");
        return BridgesKt.generateBridges((FunctionHandle)new DescriptorBasedFunctionHandle(descriptor2), new Function1<DescriptorBasedFunctionHandle, Signature>(signature){
            final /* synthetic */ Function1 $signature;

            public final Signature invoke(@NotNull DescriptorBasedFunctionHandle it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return (Signature)this.$signature.invoke(it.getDescriptor());
            }
            {
                this.$signature = function1;
                super(1);
            }
        });
    }

    @Nullable
    public static final CallableMemberDescriptor findTraitImplementation(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2.getKind().isReal()) {
            return null;
        }
        if (CallResolverUtilKt.isOrOverridesSynthesized(descriptor2)) {
            return null;
        }
        CallableMemberDescriptor callableMemberDescriptor = ImplKt.findImplementationFromInterface(descriptor2);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor implementation = callableMemberDescriptor;
        CallableMemberDescriptor callableMemberDescriptor2 = ImplKt.firstSuperMethodFromKotlin(descriptor2, implementation);
        if (callableMemberDescriptor2 == null) {
            return null;
        }
        CallableMemberDescriptor immediateConcreteSuper = callableMemberDescriptor2;
        if (!DescriptorUtils.isInterface(immediateConcreteSuper.getContainingDeclaration())) {
            return null;
        }
        return immediateConcreteSuper;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CallableMemberDescriptor findImplementationFromInterface(@NotNull CallableMemberDescriptor descriptor2) {
        Object v0;
        block3: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Set<CallableMemberDescriptor> overridden = OverrideResolver.getOverriddenDeclarations(descriptor2);
            Set<CallableMemberDescriptor> filtered2 = OverrideResolver.filterOutOverridden(overridden);
            Iterable iterable = filtered2;
            for (Object element : $receiver) {
                CallableMemberDescriptor it = (CallableMemberDescriptor)element;
                if (!(Intrinsics.areEqual((Object)it.getModality(), (Object)Modality.ABSTRACT) ^ true)) continue;
                v0 = element;
                break block3;
            }
            v0 = null;
        }
        CallableMemberDescriptor callableMemberDescriptor = v0;
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor result2 = callableMemberDescriptor;
        DeclarationDescriptor container = result2.getContainingDeclaration();
        if (DescriptorUtils.isClass(container) || DescriptorUtils.isEnumClass(container)) {
            return null;
        }
        return result2;
    }

    @Nullable
    public static final CallableMemberDescriptor firstSuperMethodFromKotlin(@NotNull CallableMemberDescriptor descriptor2, @NotNull CallableMemberDescriptor implementation) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(implementation, "implementation");
            Iterable $receiver = descriptor2.getOverriddenDescriptors();
            for (Object element : $receiver) {
                CallableMemberDescriptor overridden = (CallableMemberDescriptor)element;
                if (!(Intrinsics.areEqual((Object)overridden.getModality(), (Object)Modality.ABSTRACT) ^ true && (Intrinsics.areEqual(overridden, implementation) || OverrideResolver.overrides((CallableDescriptor)overridden, (CallableDescriptor)implementation)))) continue;
                v0 = element;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

