/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorTracker
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.EditorTracker");
    private final WindowManager myWindowManager;
    private final EditorFactory myEditorFactory;
    private final Map<Window, List<Editor>> myWindowToEditorsMap = new HashMap<Window, List<Editor>>();
    private final Map<Window, WindowAdapter> myWindowToWindowFocusListenerMap = new HashMap<Window, WindowAdapter>();
    private final Map<Editor, Window> myEditorToWindowMap = new HashMap<Editor, Window>();
    private List<Editor> myActiveEditors = Collections.emptyList();
    private final EventDispatcher<EditorTrackerListener> myDispatcher = EventDispatcher.create(EditorTrackerListener.class);
    private IdeFrameImpl myIdeFrame;
    private Window myActiveWindow;

    public EditorTracker(Project project, WindowManager windowManager, EditorFactory editorFactory) {
        super(project);
        this.myWindowManager = windowManager;
        this.myEditorFactory = editorFactory;
    }

    public void projectOpened() {
        this.myIdeFrame = ((WindowManagerEx)this.myWindowManager).getFrame(this.myProject);
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/EditorTracker$1", "selectionChanged"));
                }
                if (EditorTracker.this.myIdeFrame == null || EditorTracker.this.myIdeFrame.getFocusOwner() == null) {
                    return;
                }
                EditorTracker.this.setActiveWindow(EditorTracker.this.myIdeFrame);
            }
        });
        final MyEditorFactoryListener myEditorFactoryListener = new MyEditorFactoryListener();
        this.myEditorFactory.addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener, (Disposable)this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                myEditorFactoryListener.executeOnRelease(null);
            }
        });
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("EditorTracker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/EditorTracker", "getComponentName"));
        }
        return "EditorTracker";
    }

    private void editorFocused(Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Window window = this.myEditorToWindowMap.get(editor);
        if (window == null) {
            return;
        }
        List<Editor> list = this.myWindowToEditorsMap.get(window);
        int index = list.indexOf(editor);
        LOG.assertTrue(index >= 0);
        if (list.isEmpty()) {
            return;
        }
        for (int i = index - 1; i >= 0; --i) {
            list.set(i + 1, list.get(i));
        }
        list.set(0, editor);
        this.setActiveWindow(window);
    }

    private void registerEditor(Editor editor) {
        this.unregisterEditor(editor);
        final Window window = this.windowByEditor(editor);
        if (window == null) {
            return;
        }
        this.myEditorToWindowMap.put(editor, window);
        List<Editor> list = this.myWindowToEditorsMap.get(window);
        if (list == null) {
            list = new ArrayList<Editor>();
            this.myWindowToEditorsMap.put(window, list);
            if (!(window instanceof IdeFrameImpl)) {
                WindowAdapter listener = new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowGainedFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(window);
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowLostFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowClosed:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }
                };
                this.myWindowToWindowFocusListenerMap.put(window, listener);
                window.addWindowFocusListener(listener);
                window.addWindowListener(listener);
                if (window.isFocused()) {
                    this.setActiveWindow(window);
                }
            }
        }
        list.add(editor);
        if (this.myActiveWindow == window) {
            this.setActiveWindow(window);
        }
    }

    private void unregisterEditor(Editor editor) {
        Window oldWindow = this.myEditorToWindowMap.get(editor);
        if (oldWindow != null) {
            this.myEditorToWindowMap.remove(editor);
            List<Editor> editorsList = this.myWindowToEditorsMap.get(oldWindow);
            boolean removed = editorsList.remove(editor);
            LOG.assertTrue(removed);
            if (editorsList.isEmpty()) {
                this.myWindowToEditorsMap.remove(oldWindow);
                WindowAdapter listener = this.myWindowToWindowFocusListenerMap.remove(oldWindow);
                if (listener != null) {
                    oldWindow.removeWindowFocusListener(listener);
                    oldWindow.removeWindowListener(listener);
                }
            }
        }
    }

    private Window windowByEditor(Editor editor) {
        Window window = SwingUtilities.windowForComponent(editor.getComponent());
        if (window instanceof IdeFrameImpl && window != this.myIdeFrame) {
            return null;
        }
        return window;
    }

    @NotNull
    List<Editor> getActiveEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Editor> list = this.myActiveEditors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/EditorTracker", "getActiveEditors"));
        }
        return list;
    }

    private void setActiveWindow(Window window) {
        this.myActiveWindow = window;
        List<Editor> editors = this.editorsByWindow(this.myActiveWindow);
        this.setActiveEditors(editors);
    }

    @NotNull
    private List<Editor> editorsByWindow(Window window) {
        List<Editor> list = this.myWindowToEditorsMap.get(window);
        if (list == null) {
            List<Editor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/EditorTracker", "editorsByWindow"));
            }
            return list2;
        }
        SmartList filtered = new SmartList();
        for (Editor editor : list) {
            if (!editor.getContentComponent().isShowing()) continue;
            filtered.add(editor);
        }
        SmartList smartList = filtered;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/EditorTracker", "editorsByWindow"));
        }
        return smartList;
    }

    void setActiveEditors(@NotNull List<Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/codeInsight/daemon/impl/EditorTracker", "setActiveEditors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActiveEditors = editors;
        if (LOG.isDebugEnabled()) {
            LOG.debug("active editors changed:");
            for (Editor editor : editors) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                LOG.debug("    " + psiFile);
            }
        }
        ((EditorTrackerListener)this.myDispatcher.getMulticaster()).activeEditorsChanged(editors);
    }

    void addEditorTrackerListener(@NotNull EditorTrackerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/codeInsight/daemon/impl/EditorTracker", "addEditorTrackerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/daemon/impl/EditorTracker", "addEditorTrackerListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    private class MyEditorFactoryListener
    implements EditorFactoryListener {
        private final Map<Editor, Runnable> myExecuteOnEditorRelease = new HashMap<Editor, Runnable>();

        private MyEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyEditorFactoryListener", "editorCreated"));
            }
            final Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != EditorTracker.this.myProject || EditorTracker.this.myProject.isDisposed()) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)EditorTracker.this.myProject).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return;
            }
            final JComponent component = editor.getComponent();
            final JComponent contentComponent = editor.getContentComponent();
            final HierarchyListener hierarchyListener = new HierarchyListener(){

                @Override
                public void hierarchyChanged(@NotNull HierarchyEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyEditorFactoryListener$1", "hierarchyChanged"));
                    }
                    EditorTracker.this.registerEditor(editor);
                }
            };
            component.addHierarchyListener(hierarchyListener);
            final FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(@NotNull FocusEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyEditorFactoryListener$2", "focusGained"));
                    }
                    EditorTracker.this.editorFocused(editor);
                }

                @Override
                public void focusLost(@NotNull FocusEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyEditorFactoryListener$2", "focusLost"));
                    }
                }
            };
            contentComponent.addFocusListener(focusListener);
            this.myExecuteOnEditorRelease.put(event.getEditor(), new Runnable(){

                @Override
                public void run() {
                    component.removeHierarchyListener(hierarchyListener);
                    contentComponent.removeFocusListener(focusListener);
                }
            });
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/EditorTracker$MyEditorFactoryListener", "editorReleased"));
            }
            Editor editor = event.getEditor();
            if (editor.getProject() != null && editor.getProject() != EditorTracker.this.myProject) {
                return;
            }
            EditorTracker.this.unregisterEditor(editor);
            this.executeOnRelease(editor);
        }

        private void executeOnRelease(Editor editor) {
            if (editor == null) {
                for (Runnable r : this.myExecuteOnEditorRelease.values()) {
                    r.run();
                }
                this.myExecuteOnEditorRelease.clear();
            } else {
                Runnable runnable = this.myExecuteOnEditorRelease.get(editor);
                if (runnable != null) {
                    runnable.run();
                    this.myExecuteOnEditorRelease.remove(editor);
                }
            }
        }
    }
}

