/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateSubstitutor;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateExpressionLookupElement;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandAdapter;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateState
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.TemplateState");
    private Project myProject;
    private Editor myEditor;
    private TemplateImpl myTemplate;
    private TemplateImpl myPrevTemplate;
    private TemplateSegments mySegments;
    private Map<String, String> myPredefinedVariableValues;
    private RangeMarker myTemplateRange;
    private final List<RangeHighlighter> myTabStopHighlighters;
    private int myCurrentVariableNumber;
    private int myCurrentSegmentNumber;
    private boolean ourLookupShown;
    private boolean myDocumentChangesTerminateTemplate;
    private boolean myDocumentChanged;
    @Nullable
    private CommandAdapter myCommandListener;
    @Nullable
    private CaretListener myCaretListener;
    private final List<TemplateEditingListener> myListeners;
    private DocumentAdapter myEditorDocumentListener;
    private final Map myProperties;
    private boolean myTemplateIndented;
    private Document myDocument;
    private boolean myFinished;
    @Nullable
    private PairProcessor<String, String> myProcessor;
    private boolean mySelectionCalculated;
    private boolean myStarted;

    public TemplateState(@NotNull Project project, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/template/impl/TemplateState", "<init>"));
        }
        this.mySegments = null;
        this.myTemplateRange = null;
        this.myTabStopHighlighters = new ArrayList<RangeHighlighter>();
        this.myCurrentVariableNumber = -1;
        this.myCurrentSegmentNumber = -1;
        this.ourLookupShown = false;
        this.myDocumentChangesTerminateTemplate = true;
        this.myDocumentChanged = false;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProperties = new HashMap();
        this.myTemplateIndented = false;
        this.mySelectionCalculated = false;
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
    }

    private void initListeners() {
        this.myEditorDocumentListener = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                TemplateState.this.myDocumentChanged = true;
            }
        };
        this.myCommandListener = new CommandAdapter(){
            boolean started = false;

            public void commandStarted(CommandEvent event) {
                TemplateState.this.myDocumentChangesTerminateTemplate = TemplateState.this.isCaretOutsideCurrentSegment();
                this.started = true;
            }

            public void beforeCommandFinished(CommandEvent event) {
                if (this.started && !TemplateState.this.isDisposed()) {
                    LookupImpl lookup;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            TemplateState.this.afterChangedUpdate();
                        }
                    };
                    LookupImpl lookupImpl = lookup = TemplateState.this.myEditor != null ? (LookupImpl)LookupManager.getActiveLookup(TemplateState.this.myEditor) : null;
                    if (lookup != null) {
                        lookup.performGuardedChange(runnable);
                    } else {
                        runnable.run();
                    }
                }
            }
        };
        this.myCaretListener = new CaretAdapter(){

            public void caretAdded(CaretEvent e) {
                if (TemplateState.this.isMultiCaretMode()) {
                    TemplateState.this.finishTemplateEditing();
                }
            }

            public void caretRemoved(CaretEvent e) {
                if (TemplateState.this.isMultiCaretMode()) {
                    TemplateState.this.finishTemplateEditing();
                }
            }
        };
        if (this.myEditor != null) {
            this.myEditor.getCaretModel().addCaretListener(this.myCaretListener);
        }
        this.myDocument.addDocumentListener((DocumentListener)this.myEditorDocumentListener, (Disposable)this);
        CommandProcessor.getInstance().addCommandListener((CommandListener)this.myCommandListener, (Disposable)this);
    }

    private boolean isCaretOutsideCurrentSegment() {
        if (this.myEditor != null && this.myCurrentSegmentNumber >= 0) {
            int offset = this.myEditor.getCaretModel().getOffset();
            return offset < this.mySegments.getSegmentStart(this.myCurrentSegmentNumber) || offset > this.mySegments.getSegmentEnd(this.myCurrentSegmentNumber);
        }
        return false;
    }

    private boolean isMultiCaretMode() {
        return this.myEditor != null && this.myEditor.getCaretModel().getCaretCount() > 1;
    }

    public synchronized void dispose() {
        this.myEditorDocumentListener = null;
        this.myCommandListener = null;
        this.myCaretListener = null;
        this.myProcessor = null;
        this.releaseAll();
        this.myDocument = null;
    }

    public boolean isToProcessTab() {
        LookupImpl lookup;
        if (this.isCaretOutsideCurrentSegment()) {
            return false;
        }
        if (this.ourLookupShown && (lookup = (LookupImpl)LookupManager.getActiveLookup(this.myEditor)) != null && !lookup.isFocused()) {
            return true;
        }
        return !this.ourLookupShown;
    }

    private void setCurrentVariableNumber(int variableNumber) {
        this.myCurrentVariableNumber = variableNumber;
        boolean isFinished = this.isFinished();
        if (this.myDocument != null) {
            ((DocumentEx)this.myDocument).setStripTrailingSpacesEnabled(isFinished);
        }
        this.myCurrentSegmentNumber = isFinished ? -1 : this.getCurrentSegmentNumber();
    }

    @Nullable
    public TextResult getVariableValue(@NotNull String variableName) {
        CharSequence text;
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/intellij/codeInsight/template/impl/TemplateState", "getVariableValue"));
        }
        if (variableName.equals("SELECTION")) {
            return new TextResult(StringUtil.notNullize((String)this.getSelectionBeforeTemplate()));
        }
        if (variableName.equals("END")) {
            return new TextResult("");
        }
        if (this.myPredefinedVariableValues != null && (text = this.myPredefinedVariableValues.get(variableName)) != null) {
            return new TextResult((String)text);
        }
        text = this.myDocument.getCharsSequence();
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0 || this.mySegments.getSegmentsCount() <= segmentNumber) {
            return null;
        }
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        int length = this.myDocument.getTextLength();
        if (start > length || end > length) {
            return null;
        }
        return new TextResult(text.subSequence(start, end).toString());
    }

    @Nullable
    private String getSelectionBeforeTemplate() {
        return (String)this.getProperties().get(ExpressionContext.SELECTION);
    }

    @Nullable
    public TextRange getCurrentVariableRange() {
        int number = this.getCurrentSegmentNumber();
        if (number == -1) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(number), this.mySegments.getSegmentEnd(number));
    }

    @Nullable
    public TextRange getVariableRange(String variableName) {
        int segment = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segment < 0) {
            return null;
        }
        return new TextRange(this.mySegments.getSegmentStart(segment), this.mySegments.getSegmentEnd(segment));
    }

    public int getSegmentsCount() {
        return this.mySegments.getSegmentsCount();
    }

    public TextRange getSegmentRange(int segment) {
        return new TextRange(this.mySegments.getSegmentStart(segment), this.mySegments.getSegmentEnd(segment));
    }

    public boolean isFinished() {
        return this.myCurrentVariableNumber < 0;
    }

    private void releaseAll() {
        if (this.mySegments != null) {
            this.mySegments.removeAll();
            this.mySegments = null;
        }
        if (this.myTemplateRange != null) {
            this.myTemplateRange.dispose();
            this.myTemplateRange = null;
        }
        this.myPrevTemplate = this.myTemplate;
        this.myTemplate = null;
        this.releaseEditor();
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            for (RangeHighlighter segmentHighlighter : this.myTabStopHighlighters) {
                segmentHighlighter.dispose();
            }
            this.myTabStopHighlighters.clear();
            this.myEditor = null;
        }
    }

    public void start(@NotNull TemplateImpl template, @Nullable PairProcessor<String, String> processor2, @Nullable Map<String, String> predefinedVarValues) {
        DocumentReference[] documentReferenceArray;
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateState", "start"));
        }
        LOG.assertTrue(!this.myStarted, (Object)"Already started");
        this.myStarted = true;
        PsiFile file = this.getPsiFile();
        this.myTemplate = TemplateState.substituteTemplate(file, this.myEditor.getCaretModel().getOffset(), template);
        this.myProcessor = processor2;
        if (this.myDocument != null) {
            DocumentReference[] documentReferenceArray2 = new DocumentReference[1];
            documentReferenceArray = documentReferenceArray2;
            documentReferenceArray2[0] = DocumentReferenceManager.getInstance().create(this.myDocument);
        } else {
            documentReferenceArray = null;
        }
        DocumentReference[] refs = documentReferenceArray;
        UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)new BasicUndoableAction(refs){

            public void undo() {
                if (TemplateState.this.myDocument != null) {
                    TemplateState.this.fireTemplateCancelled();
                    LookupManager.getInstance(TemplateState.this.myProject).hideActiveLookup();
                    int oldVar = TemplateState.this.myCurrentVariableNumber;
                    TemplateState.this.setCurrentVariableNumber(-1);
                    TemplateState.this.currentVariableChanged(oldVar);
                }
            }

            public void redo() {
            }
        });
        this.myTemplateIndented = false;
        this.myCurrentVariableNumber = -1;
        this.mySegments = new TemplateSegments(this.myEditor);
        this.myPrevTemplate = this.myTemplate;
        this.myPredefinedVariableValues = predefinedVarValues;
        if (this.myTemplate.isInline()) {
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset + this.myTemplate.getTemplateText().length());
        } else {
            this.preprocessTemplate(file, this.myEditor.getCaretModel().getOffset(), this.myTemplate.getTemplateText());
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myTemplateRange = this.myDocument.createRangeMarker(caretOffset, caretOffset);
        }
        this.myTemplateRange.setGreedyToLeft(true);
        this.myTemplateRange.setGreedyToRight(true);
        this.processAllExpressions(this.myTemplate);
    }

    private void fireTemplateCancelled() {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener : this.myListeners) {
            listener.templateCancelled(this.myTemplate);
        }
    }

    private static TemplateImpl substituteTemplate(PsiFile file, int caretOffset, TemplateImpl template) {
        for (TemplateSubstitutor substitutor : (TemplateSubstitutor[])Extensions.getExtensions(TemplateSubstitutor.EP_NAME)) {
            TemplateImpl substituted = substitutor.substituteTemplate(file, caretOffset, template);
            if (substituted == null) continue;
            template = substituted;
        }
        return template;
    }

    private void preprocessTemplate(PsiFile file, int caretOffset, String textToInsert) {
        for (TemplatePreprocessor preprocessor : (TemplatePreprocessor[])Extensions.getExtensions(TemplatePreprocessor.EP_NAME)) {
            preprocessor.preprocessTemplate(this.myEditor, file, caretOffset, textToInsert, this.myTemplate.getTemplateText());
        }
    }

    private void processAllExpressions(final @NotNull TemplateImpl template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/impl/TemplateState", "processAllExpressions"));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!template.isInline()) {
                    TemplateState.this.myDocument.insertString(TemplateState.this.myTemplateRange.getStartOffset(), (CharSequence)template.getTemplateText());
                }
                for (int i = 0; i < template.getSegmentsCount(); ++i) {
                    int segmentOffset = TemplateState.this.myTemplateRange.getStartOffset() + template.getSegmentOffset(i);
                    TemplateState.this.mySegments.addSegment(segmentOffset, segmentOffset);
                }
                LOG.assertTrue(TemplateState.this.myTemplateRange.isValid(), (Object)TemplateState.this.getRangesDebugInfo());
                TemplateState.this.calcResults(false);
                LOG.assertTrue(TemplateState.this.myTemplateRange.isValid(), (Object)TemplateState.this.getRangesDebugInfo());
                TemplateState.this.calcResults(false);
                LOG.assertTrue(TemplateState.this.myTemplateRange.isValid(), (Object)TemplateState.this.getRangesDebugInfo());
                TemplateState.this.doReformat(null);
                int nextVariableNumber = TemplateState.this.getNextVariableNumber(-1);
                if (nextVariableNumber >= 0) {
                    TemplateState.this.fireWaitingForInput();
                }
                if (nextVariableNumber == -1) {
                    TemplateState.this.finishTemplateEditing();
                } else {
                    TemplateState.this.setCurrentVariableNumber(nextVariableNumber);
                    TemplateState.this.initTabStopHighlighters();
                    TemplateState.this.initListeners();
                    TemplateState.this.focusCurrentExpression();
                    TemplateState.this.currentVariableChanged(-1);
                    if (TemplateState.this.isMultiCaretMode()) {
                        TemplateState.this.finishTemplateEditing();
                    }
                }
            }
        });
    }

    private String getRangesDebugInfo() {
        return this.myTemplateRange + "\ntemplateKey: " + this.myTemplate.getKey() + "\ntemplateText: " + this.myTemplate.getTemplateText() + "\ntemplateString: " + this.myTemplate;
    }

    private void doReformat(TextRange range) {
        RangeMarker rangeMarker = null;
        if (range != null) {
            rangeMarker = this.myDocument.createRangeMarker(range);
            rangeMarker.setGreedyToLeft(true);
            rangeMarker.setGreedyToRight(true);
        }
        final RangeMarker finalRangeMarker = rangeMarker;
        Runnable action = new Runnable(){

            @Override
            public void run() {
                IntArrayList indices = TemplateState.this.initEmptyVariables();
                TemplateState.this.mySegments.setSegmentsGreedy(false);
                LOG.assertTrue(TemplateState.this.myTemplateRange.isValid(), (Object)("template key: " + TemplateState.this.myTemplate.getKey() + "; " + "template text" + TemplateState.this.myTemplate.getTemplateText() + "; " + "variable number: " + TemplateState.this.getCurrentVariableNumber()));
                TemplateState.this.reformat(finalRangeMarker);
                TemplateState.this.mySegments.setSegmentsGreedy(true);
                TemplateState.this.restoreEmptyVariables(indices);
            }
        };
        ApplicationManager.getApplication().runWriteAction(action);
    }

    public void setSegmentsGreedy(boolean greedy) {
        this.mySegments.setSegmentsGreedy(greedy);
    }

    public void setTabStopHighlightersGreedy(boolean greedy) {
        for (RangeHighlighter highlighter : this.myTabStopHighlighters) {
            highlighter.setGreedyToLeft(greedy);
            highlighter.setGreedyToRight(greedy);
        }
    }

    private void shortenReferences() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiFile file = TemplateState.this.getPsiFile();
                if (file != null) {
                    IntArrayList indices = TemplateState.this.initEmptyVariables();
                    TemplateState.this.mySegments.setSegmentsGreedy(false);
                    for (TemplateOptionalProcessor processor2 : (TemplateOptionalProcessor[])Extensions.getExtensions(TemplateOptionalProcessor.EP_NAME)) {
                        processor2.processText(TemplateState.this.myProject, TemplateState.this.myTemplate, TemplateState.this.myDocument, TemplateState.this.myTemplateRange, TemplateState.this.myEditor);
                    }
                    TemplateState.this.mySegments.setSegmentsGreedy(true);
                    TemplateState.this.restoreEmptyVariables(indices);
                }
            }
        });
    }

    private void afterChangedUpdate() {
        if (this.isFinished()) {
            return;
        }
        LOG.assertTrue(this.myTemplate != null, (Object)TemplateState.presentTemplate(this.myPrevTemplate));
        if (this.myDocumentChanged) {
            if (this.myDocumentChangesTerminateTemplate || this.mySegments.isInvalid()) {
                int oldIndex = this.myCurrentVariableNumber;
                this.setCurrentVariableNumber(-1);
                this.currentVariableChanged(oldIndex);
                this.fireTemplateCancelled();
            } else {
                this.calcResults(true);
            }
            this.myDocumentChanged = false;
        }
    }

    private static String presentTemplate(@Nullable TemplateImpl template) {
        if (template == null) {
            return "no template";
        }
        String message = StringUtil.notNullize((String)template.getKey());
        message = message + "\n\nTemplate#string: " + StringUtil.notNullize((String)template.getString());
        message = message + "\n\nTemplate#text: " + StringUtil.notNullize((String)template.getTemplateText());
        return message;
    }

    private String getExpressionString(int index) {
        CharSequence text = this.myDocument.getCharsSequence();
        if (!this.mySegments.isValid(index)) {
            return "";
        }
        int start = this.mySegments.getSegmentStart(index);
        int end = this.mySegments.getSegmentEnd(index);
        return text.subSequence(start, end).toString();
    }

    private int getCurrentSegmentNumber() {
        if (this.myCurrentVariableNumber == -1) {
            return -1;
        }
        String variableName = this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber);
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            LOG.error("No segment for variable: var=" + this.myCurrentVariableNumber + "; name=" + variableName + "; " + TemplateState.presentTemplate(this.myTemplate));
        }
        return segmentNumber;
    }

    private void focusCurrentExpression() {
        if (this.isFinished()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        final int currentSegmentNumber = this.getCurrentSegmentNumber();
        this.lockSegmentAtTheSameOffsetIfAny();
        if (currentSegmentNumber < 0) {
            return;
        }
        int start = this.mySegments.getSegmentStart(currentSegmentNumber);
        int end = this.mySegments.getSegmentEnd(currentSegmentNumber);
        if (end >= 0) {
            this.myEditor.getCaretModel().moveToOffset(end);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
            this.myEditor.getSelectionModel().setSelection(start, end);
        }
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(new Runnable(){

            @Override
            public void run() {
                List<TemplateExpressionLookupElement> lookupItems;
                Expression expressionNode = TemplateState.this.getCurrentExpression();
                try {
                    lookupItems = TemplateState.this.getCurrentExpressionLookupItems();
                }
                catch (IndexNotReadyException e) {
                    lookupItems = Collections.emptyList();
                }
                PsiFile psiFile = TemplateState.this.getPsiFile();
                if (!lookupItems.isEmpty()) {
                    if (((TemplateManagerImpl)TemplateManager.getInstance(TemplateState.this.myProject)).shouldSkipInTests()) {
                        TemplateState.this.insertSingleItem(lookupItems);
                    } else {
                        for (LookupElement lookupElement : lookupItems) {
                            assert (lookupElement != null) : expressionNode;
                        }
                        TemplateState.this.runLookup(lookupItems, expressionNode.getAdvertisingText());
                    }
                } else {
                    try {
                        Result result2 = expressionNode.calculateResult(TemplateState.this.getCurrentExpressionContext());
                        if (result2 != null) {
                            result2.handleFocused(psiFile, TemplateState.this.myDocument, TemplateState.this.mySegments.getSegmentStart(currentSegmentNumber), TemplateState.this.mySegments.getSegmentEnd(currentSegmentNumber));
                        }
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            }
        });
        this.focusCurrentHighlighter(true);
    }

    PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    private void insertSingleItem(List<TemplateExpressionLookupElement> lookupItems) {
        TemplateExpressionLookupElement first = lookupItems.get(0);
        EditorModificationUtil.insertStringAtCaret((Editor)this.myEditor, (String)first.getLookupString());
        first.handleTemplateInsert(lookupItems, '\u0000');
    }

    @NotNull
    List<TemplateExpressionLookupElement> getCurrentExpressionLookupItems() {
        LookupElement[] elements = this.getCurrentExpression().calculateLookupItems(this.getCurrentExpressionContext());
        if (elements == null) {
            List<TemplateExpressionLookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateState", "getCurrentExpressionLookupItems"));
            }
            return list;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i = 0; i < elements.length; ++i) {
            result2.add(new TemplateExpressionLookupElement(this, elements[i], i));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateState", "getCurrentExpressionLookupItems"));
        }
        return arrayList;
    }

    ExpressionContext getCurrentExpressionContext() {
        return this.createExpressionContext(this.mySegments.getSegmentStart(this.getCurrentSegmentNumber()));
    }

    Expression getCurrentExpression() {
        return this.myTemplate.getExpressionAt(this.myCurrentVariableNumber);
    }

    private void runLookup(final List<TemplateExpressionLookupElement> lookupItems, @Nullable String advertisingText) {
        if (this.myEditor == null) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance(this.myProject);
        final LookupImpl lookup = (LookupImpl)lookupManager.showLookup(this.myEditor, lookupItems.toArray(new LookupElement[lookupItems.size()]));
        if (lookup == null) {
            return;
        }
        if (CodeInsightSettings.getInstance().AUTO_POPUP_COMPLETION_LOOKUP && this.myEditor.getUserData(InplaceRefactoring.INPLACE_RENAMER) == null) {
            lookup.setStartCompletionWhenNothingMatches(true);
        }
        if (advertisingText != null) {
            lookup.addAdvertisement(advertisingText, null);
        }
        lookup.refreshUi(true, true);
        this.ourLookupShown = true;
        lookup.addLookupListener(new LookupAdapter(){

            @Override
            public void lookupCanceled(LookupEvent event) {
                lookup.removeLookupListener(this);
                TemplateState.this.ourLookupShown = false;
            }

            @Override
            public void itemSelected(LookupEvent event) {
                lookup.removeLookupListener(this);
                if (TemplateState.this.isFinished()) {
                    return;
                }
                TemplateState.this.ourLookupShown = false;
                LookupElement item = event.getItem();
                if (item instanceof TemplateExpressionLookupElement) {
                    ((TemplateExpressionLookupElement)item).handleTemplateInsert(lookupItems, event.getCompletionChar());
                }
            }
        });
    }

    private void unblockDocument() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
    }

    void calcResults(final boolean isQuick) {
        String variableName;
        TextResult value;
        if (this.myProcessor != null && this.myCurrentVariableNumber >= 0 && (value = this.getVariableValue(variableName = this.myTemplate.getVariableNameAt(this.myCurrentVariableNumber))) != null && !value.getText().isEmpty() && !this.myProcessor.process((Object)variableName, (Object)value.getText())) {
            this.finishTemplateEditing();
            return;
        }
        this.fixOverlappedSegments(this.myCurrentSegmentNumber);
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (Runnable)new Runnable(){

            @Override
            public void run() {
                BitSet calcedSegments = new BitSet();
                int maxAttempts = (TemplateState.this.myTemplate.getVariableCount() + 1) * 3;
                do {
                    --maxAttempts;
                    calcedSegments.clear();
                    for (int i = TemplateState.this.myCurrentVariableNumber + 1; i < TemplateState.this.myTemplate.getVariableCount(); ++i) {
                        String variableName = TemplateState.this.myTemplate.getVariableNameAt(i);
                        final int segmentNumber = TemplateState.this.myTemplate.getVariableSegmentNumber(variableName);
                        if (segmentNumber < 0) continue;
                        final Expression expression = TemplateState.this.myTemplate.getExpressionAt(i);
                        final Expression defaultValue = TemplateState.this.myTemplate.getDefaultValueAt(i);
                        String oldValue = TemplateState.this.getVariableValueText(variableName);
                        DumbService.getInstance((Project)TemplateState.this.myProject).withAlternativeResolveEnabled(new Runnable(){

                            @Override
                            public void run() {
                                TemplateState.this.recalcSegment(segmentNumber, isQuick, expression, defaultValue);
                            }
                        });
                        TextResult value = TemplateState.this.getVariableValue(variableName);
                        assert (value != null) : "name=" + variableName + "\ntext=" + TemplateState.access$2400(TemplateState.this).getTemplateText();
                        String newValue = value.getText();
                        if (newValue.equals(oldValue)) continue;
                        calcedSegments.set(segmentNumber);
                    }
                    boolean selectionCalculated = false;
                    for (int i = 0; i < TemplateState.this.myTemplate.getSegmentsCount(); ++i) {
                        if (calcedSegments.get(i)) continue;
                        String variableName = TemplateState.this.myTemplate.getSegmentName(i);
                        if (variableName.equals("SELECTION")) {
                            if (TemplateState.this.mySelectionCalculated) continue;
                            selectionCalculated = true;
                        }
                        if ("END".equals(variableName)) continue;
                        String newValue = TemplateState.this.getVariableValueText(variableName);
                        int start = TemplateState.this.mySegments.getSegmentStart(i);
                        int end = TemplateState.this.mySegments.getSegmentEnd(i);
                        TemplateState.this.replaceString(newValue, start, end, i);
                    }
                    if (!selectionCalculated) continue;
                    TemplateState.this.mySelectionCalculated = true;
                } while (!calcedSegments.isEmpty() && maxAttempts >= 0);
            }
        });
    }

    private void fixOverlappedSegments(int currentSegment) {
        if (currentSegment >= 0) {
            int currentSegmentStart = this.mySegments.getSegmentStart(currentSegment);
            int currentSegmentEnd = this.mySegments.getSegmentEnd(currentSegment);
            for (int i = currentSegment + 1; i < this.mySegments.getSegmentsCount(); ++i) {
                int startOffset = this.mySegments.getSegmentStart(i);
                if (currentSegmentStart > startOffset || startOffset >= currentSegmentEnd) continue;
                this.mySegments.replaceSegmentAt(i, currentSegmentEnd, Math.max(this.mySegments.getSegmentEnd(i), currentSegmentEnd), true);
            }
        }
    }

    @NotNull
    private String getVariableValueText(String variableName) {
        TextResult value = this.getVariableValue(variableName);
        String string = value != null ? value.getText() : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/TemplateState", "getVariableValueText"));
        }
        return string;
    }

    private void recalcSegment(int segmentNumber, boolean isQuick, Expression expressionNode, Expression defaultValue) {
        boolean resultIsNullOrEmpty;
        Result result2;
        String oldValue = this.getExpressionString(segmentNumber);
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        PsiFile psiFile = this.getPsiFile();
        PsiElement element = psiFile.findElementAt(start);
        if (element != null) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        ExpressionContext context = this.createExpressionContext(start);
        Result result3 = result2 = isQuick ? expressionNode.calculateQuickResult(context) : expressionNode.calculateResult(context);
        if (isQuick && result2 == null && !oldValue.isEmpty()) {
            return;
        }
        boolean bl = resultIsNullOrEmpty = result2 == null || result2.equalsToText("", element);
        if (resultIsNullOrEmpty && this.myCurrentSegmentNumber >= 0 && (this.mySegments.getSegmentStart(segmentNumber) == this.mySegments.getSegmentEnd(this.myCurrentSegmentNumber) || this.mySegments.getSegmentEnd(segmentNumber) == this.mySegments.getSegmentStart(this.myCurrentSegmentNumber))) {
            return;
        }
        if (defaultValue != null && resultIsNullOrEmpty) {
            result2 = defaultValue.calculateResult(context);
        }
        if (element != null) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        if (result2 == null || result2.equalsToText(oldValue, element)) {
            return;
        }
        this.replaceString(StringUtil.notNullize((String)result2.toString()), start, end, segmentNumber);
        if (result2 instanceof RecalculatableResult) {
            IntArrayList indices = this.initEmptyVariables();
            this.shortenReferences();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
            ((RecalculatableResult)result2).handleRecalc(psiFile, this.myDocument, this.mySegments.getSegmentStart(segmentNumber), this.mySegments.getSegmentEnd(segmentNumber));
            this.restoreEmptyVariables(indices);
        }
    }

    private void replaceString(String newValue, int start, int end, int segmentNumber) {
        String oldText = this.myDocument.getCharsSequence().subSequence(start, end).toString();
        if (!oldText.equals(newValue)) {
            this.mySegments.setNeighboursGreedy(segmentNumber, false);
            this.myDocument.replaceString(start, end, (CharSequence)newValue);
            int newEnd = start + newValue.length();
            this.mySegments.replaceSegmentAt(segmentNumber, start, newEnd);
            this.mySegments.setNeighboursGreedy(segmentNumber, true);
            this.fixOverlappedSegments(segmentNumber);
        }
    }

    public int getCurrentVariableNumber() {
        return this.myCurrentVariableNumber;
    }

    public void previousTab() {
        if (this.isFinished()) {
            return;
        }
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int previousVariableNumber = this.getPreviousVariableNumber(oldVar);
        if (previousVariableNumber >= 0) {
            this.focusCurrentHighlighter(false);
            this.calcResults(false);
            this.doReformat(null);
            this.setCurrentVariableNumber(previousVariableNumber);
            this.focusCurrentExpression();
            this.currentVariableChanged(oldVar);
        }
    }

    public void nextTab() {
        if (this.isFinished()) {
            return;
        }
        this.unblockDocument();
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int nextVariableNumber = this.getNextVariableNumber(oldVar);
        if (nextVariableNumber == -1) {
            this.calcResults(false);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    TemplateState.this.reformat(null);
                }
            });
            this.finishTemplateEditing();
            return;
        }
        this.focusCurrentHighlighter(false);
        this.calcResults(false);
        this.doReformat(null);
        this.setCurrentVariableNumber(nextVariableNumber);
        this.focusCurrentExpression();
        this.currentVariableChanged(oldVar);
    }

    private void lockSegmentAtTheSameOffsetIfAny() {
        this.mySegments.lockSegmentAtTheSameOffsetIfAny(this.getCurrentSegmentNumber());
    }

    private ExpressionContext createExpressionContext(final int start) {
        return new ExpressionContext(){

            public Project getProject() {
                return TemplateState.this.myProject;
            }

            public Editor getEditor() {
                return TemplateState.this.myEditor;
            }

            public int getStartOffset() {
                return start;
            }

            public int getTemplateStartOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getStartOffset();
            }

            public int getTemplateEndOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getEndOffset();
            }

            public <T> T getProperty(Key<T> key) {
                return (T)TemplateState.this.myProperties.get(key);
            }

            @Nullable
            public PsiElement getPsiElementAtStartOffset() {
                Project project = this.getProject();
                int templateStartOffset = this.getTemplateStartOffset();
                int offset = templateStartOffset > 0 ? this.getTemplateStartOffset() - 1 : this.getTemplateStartOffset();
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                Editor editor = this.getEditor();
                if (editor == null) {
                    return null;
                }
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                return file == null ? null : file.findElementAt(offset);
            }
        };
    }

    public void gotoEnd(boolean brokenOff) {
        if (this.myTemplate == null) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        this.calcResults(false);
        if (!brokenOff) {
            this.doReformat(null);
        }
        this.setFinalEditorState(brokenOff);
        this.cleanupTemplateState(brokenOff);
    }

    public void gotoEnd() {
        this.gotoEnd(true);
    }

    public void cancelTemplate() {
        if (this.myTemplate == null) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        this.cleanupTemplateState(true);
    }

    private void finishTemplateEditing() {
        if (this.myTemplate == null) {
            return;
        }
        LookupManager.getInstance(this.myProject).hideActiveLookup();
        this.setFinalEditorState(false);
        this.cleanupTemplateState(false);
    }

    private void setFinalEditorState(boolean brokenOff) {
        this.myEditor.getSelectionModel().removeSelection();
        if (brokenOff && !((TemplateManagerImpl)TemplateManager.getInstance(this.myProject)).shouldSkipInTests()) {
            return;
        }
        int selectionSegment = this.myTemplate.getVariableSegmentNumber("SELECTION");
        int endSegmentNumber = selectionSegment >= 0 && this.getSelectionBeforeTemplate() == null ? selectionSegment : this.myTemplate.getEndSegmentNumber();
        int offset = -1;
        if (endSegmentNumber >= 0) {
            offset = this.mySegments.getSegmentStart(endSegmentNumber);
        } else if (!this.myTemplate.isSelectionTemplate() && !this.myTemplate.isInline()) {
            offset = this.myTemplateRange.getEndOffset();
        }
        if (this.isMultiCaretMode() && this.getCurrentVariableNumber() > -1) {
            offset = -1;
        }
        if (offset >= 0) {
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        if (selStart >= 0 && selEnd >= 0) {
            this.myEditor.getSelectionModel().setSelection(this.mySegments.getSegmentStart(selStart), this.mySegments.getSegmentStart(selEnd));
        }
    }

    boolean isDisposed() {
        return this.myDocument == null;
    }

    private void cleanupTemplateState(boolean brokenOff) {
        Editor editor = this.myEditor;
        this.fireBeforeTemplateFinished();
        if (!this.isDisposed()) {
            int oldVar = this.myCurrentVariableNumber;
            this.setCurrentVariableNumber(-1);
            this.currentVariableChanged(oldVar);
            TemplateManagerImpl.clearTemplateState(editor);
            this.fireTemplateFinished(brokenOff);
        }
        this.myListeners.clear();
        this.myProject = null;
    }

    private int getNextVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber + 1; i < this.myTemplate.getVariableCount(); ++i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber - 1; i >= 0; --i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkIfTabStop(int currentVariableNumber) {
        Expression expression = this.myTemplate.getExpressionAt(currentVariableNumber);
        if (expression == null) {
            return false;
        }
        if (this.myCurrentVariableNumber == -1 && this.myTemplate.skipOnStart(currentVariableNumber)) {
            return false;
        }
        String variableName = this.myTemplate.getVariableNameAt(currentVariableNumber);
        if ((this.myPredefinedVariableValues == null || !this.myPredefinedVariableValues.containsKey(variableName)) && this.myTemplate.isAlwaysStopAt(currentVariableNumber)) {
            return true;
        }
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            return false;
        }
        int start = this.mySegments.getSegmentStart(segmentNumber);
        ExpressionContext context = this.createExpressionContext(start);
        Result result2 = expression.calculateResult(context);
        if (result2 == null) {
            return true;
        }
        LookupElement[] items = expression.calculateLookupItems(context);
        return items != null && items.length > 1;
    }

    private IntArrayList initEmptyVariables() {
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        int selStart = this.myTemplate.getSelectionStartSegmentNumber();
        int selEnd = this.myTemplate.getSelectionEndSegmentNumber();
        IntArrayList indices = new IntArrayList();
        block0: for (int i = 0; i < this.myTemplate.getSegmentsCount(); ++i) {
            int length = this.mySegments.getSegmentEnd(i) - this.mySegments.getSegmentStart(i);
            if (length != 0 || i == endSegmentNumber || i == selStart || i == selEnd) continue;
            String name = this.myTemplate.getSegmentName(i);
            for (int j = 0; j < this.myTemplate.getVariableCount(); ++j) {
                if (!this.myTemplate.getVariableNameAt(j).equals(name)) continue;
                Expression e = this.myTemplate.getExpressionAt(j);
                String marker = "a";
                if (e instanceof MacroCallNode) {
                    marker = ((MacroCallNode)e).getMacro().getDefaultValue();
                }
                this.replaceString(marker, this.mySegments.getSegmentStart(i), this.mySegments.getSegmentEnd(i), i);
                indices.add(i);
                continue block0;
            }
        }
        return indices;
    }

    private void restoreEmptyVariables(IntArrayList indices) {
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            this.myDocument.deleteString(this.mySegments.getSegmentStart(index), this.mySegments.getSegmentEnd(index));
        }
    }

    private void initTabStopHighlighters() {
        HashSet<String> vars = new HashSet<String>();
        for (int i = 0; i < this.myTemplate.getVariableCount(); ++i) {
            int segmentNumber;
            String variableName = this.myTemplate.getVariableNameAt(i);
            if (!vars.add(variableName) || (segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName)) < 0) continue;
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(segmentNumber, false, false);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
        int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
        if (endSegmentNumber >= 0) {
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(endSegmentNumber, false, true);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
    }

    private RangeHighlighter getSegmentHighlighter(int segmentNumber, boolean isSelected, boolean isEnd) {
        TextAttributes lvAttr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.LIVE_TEMPLATE_ATTRIBUTES);
        TextAttributes attributes = isSelected ? lvAttr : new TextAttributes();
        TextAttributes endAttributes = new TextAttributes();
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        RangeHighlighter segmentHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(start, end, 6001, isEnd ? endAttributes : attributes, HighlighterTargetArea.EXACT_RANGE);
        segmentHighlighter.setGreedyToLeft(true);
        segmentHighlighter.setGreedyToRight(true);
        return segmentHighlighter;
    }

    private void focusCurrentHighlighter(boolean toSelect) {
        int segmentNumber;
        RangeHighlighter newSegmentHighlighter;
        if (this.isFinished()) {
            return;
        }
        if (this.myCurrentVariableNumber >= this.myTabStopHighlighters.size()) {
            return;
        }
        RangeHighlighter segmentHighlighter = this.myTabStopHighlighters.get(this.myCurrentVariableNumber);
        if (segmentHighlighter != null && (newSegmentHighlighter = this.getSegmentHighlighter(segmentNumber = this.getCurrentSegmentNumber(), toSelect, false)) != null) {
            segmentHighlighter.dispose();
            this.myTabStopHighlighters.set(this.myCurrentVariableNumber, newSegmentHighlighter);
        }
    }

    private void reformat(RangeMarker rangeMarkerToReformat) {
        PsiFile file = this.getPsiFile();
        if (file != null) {
            CodeStyleManager style = CodeStyleManager.getInstance((Project)this.myProject);
            DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(new Runnable(){

                @Override
                public void run() {
                    for (TemplateOptionalProcessor optionalProcessor : (TemplateOptionalProcessor[])Extensions.getExtensions(TemplateOptionalProcessor.EP_NAME)) {
                        optionalProcessor.processText(TemplateState.this.myProject, TemplateState.this.myTemplate, TemplateState.this.myDocument, TemplateState.this.myTemplateRange, TemplateState.this.myEditor);
                    }
                }
            });
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
            if (this.myTemplate.isToIndent() && !this.myTemplateIndented) {
                LOG.assertTrue(this.myTemplateRange.isValid(), (Object)TemplateState.presentTemplate(this.myTemplate));
                this.smartIndent(this.myTemplateRange.getStartOffset(), this.myTemplateRange.getEndOffset());
                this.myTemplateIndented = true;
            }
            if (this.myTemplate.isToReformat()) {
                try {
                    PsiElement whiteSpaceElement;
                    TextRange range;
                    int endSegmentNumber = this.myTemplate.getEndSegmentNumber();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
                    RangeMarker dummyAdjustLineMarkerRange = null;
                    int endVarOffset = -1;
                    if (endSegmentNumber >= 0 && (range = CodeStyleManagerImpl.insertNewLineIndentMarker(file, this.myDocument, endVarOffset = this.mySegments.getSegmentStart(endSegmentNumber))) != null) {
                        dummyAdjustLineMarkerRange = this.myDocument.createRangeMarker(range);
                    }
                    int reformatStartOffset = this.myTemplateRange.getStartOffset();
                    int reformatEndOffset = this.myTemplateRange.getEndOffset();
                    if (rangeMarkerToReformat != null) {
                        reformatStartOffset = rangeMarkerToReformat.getStartOffset();
                        reformatEndOffset = rangeMarkerToReformat.getEndOffset();
                    }
                    if (dummyAdjustLineMarkerRange == null && endVarOffset >= 0 && (whiteSpaceElement = CodeStyleManagerImpl.findWhiteSpaceNode(file, endVarOffset)) != null) {
                        TextRange whiteSpaceRange = whiteSpaceElement.getTextRange();
                        if (whiteSpaceElement.getContainingFile() != null) {
                            whiteSpaceRange = InjectedLanguageManager.getInstance((Project)file.getProject()).injectedToHost(whiteSpaceElement, whiteSpaceRange);
                        }
                        reformatStartOffset = Math.min(reformatStartOffset, whiteSpaceRange.getStartOffset());
                        reformatEndOffset = Math.max(reformatEndOffset, whiteSpaceRange.getEndOffset());
                    }
                    style.reformatText(file, reformatStartOffset, reformatEndOffset);
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
                    PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myDocument);
                    if (dummyAdjustLineMarkerRange != null && dummyAdjustLineMarkerRange.isValid()) {
                        this.mySegments.replaceSegmentAt(endSegmentNumber, dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        this.myDocument.deleteString(dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
                    }
                    if (endSegmentNumber >= 0) {
                        int offset = this.mySegments.getSegmentStart(endSegmentNumber);
                        int lineStart = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(offset));
                        if (this.myDocument.getCharsSequence().subSequence(lineStart, offset).toString().trim().isEmpty()) {
                            int adjustedOffset = style.adjustLineIndent(file, offset);
                            this.mySegments.replaceSegmentAt(endSegmentNumber, adjustedOffset, adjustedOffset);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private void smartIndent(int startOffset, int endOffset) {
        char ch;
        int indentLineNum;
        int startLineNum = this.myDocument.getLineNumber(startOffset);
        int endLineNum = this.myDocument.getLineNumber(endOffset);
        if (endLineNum == startLineNum) {
            return;
        }
        int selectionIndent = -1;
        int selectionStartLine = -1;
        int selectionEndLine = -1;
        int selectionSegment = this.myTemplate.getVariableSegmentNumber("SELECTION");
        if (selectionSegment >= 0) {
            selectionIndent = 0;
            String templateText = this.myTemplate.getTemplateText();
            for (int selectionStart = this.myTemplate.getSegmentOffset(selectionSegment); selectionStart > 0 && templateText.charAt(selectionStart - 1) == ' '; --selectionStart) {
                ++selectionIndent;
            }
            selectionStartLine = this.myDocument.getLineNumber(this.mySegments.getSegmentStart(selectionSegment));
            selectionEndLine = this.myDocument.getLineNumber(this.mySegments.getSegmentEnd(selectionSegment));
        }
        int lineLength = 0;
        for (indentLineNum = startLineNum; indentLineNum >= 0 && (lineLength = this.myDocument.getLineEndOffset(indentLineNum) - this.myDocument.getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
        }
        if (indentLineNum < 0) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        CharSequence text = this.myDocument.getCharsSequence();
        for (int i = 0; i < lineLength && ((ch = text.charAt(this.myDocument.getLineStartOffset(indentLineNum) + i)) == ' ' || ch == '\t'); ++i) {
            buffer.append(ch);
        }
        if (buffer.length() == 0 && selectionIndent <= 0) {
            return;
        }
        String stringToInsert = buffer.toString();
        for (int i = startLineNum + 1; i <= endLineNum; ++i) {
            if (i > selectionStartLine && i <= selectionEndLine) {
                this.myDocument.insertString(this.myDocument.getLineStartOffset(i), (CharSequence)StringUtil.repeatSymbol((char)' ', (int)selectionIndent));
                continue;
            }
            this.myDocument.insertString(this.myDocument.getLineStartOffset(i), (CharSequence)stringToInsert);
        }
    }

    public void addTemplateStateListener(TemplateEditingListener listener) {
        this.myListeners.add(listener);
    }

    private void fireTemplateFinished(boolean brokenOff) {
        if (this.myFinished) {
            return;
        }
        this.myFinished = true;
        for (TemplateEditingListener listener : this.myListeners) {
            listener.templateFinished((Template)ObjectUtils.chooseNotNull((Object)this.myTemplate, (Object)this.myPrevTemplate), brokenOff);
        }
    }

    private void fireBeforeTemplateFinished() {
        for (TemplateEditingListener listener : this.myListeners) {
            listener.beforeTemplateFinished(this, this.myTemplate);
        }
    }

    private void fireWaitingForInput() {
        for (TemplateEditingListener listener : this.myListeners) {
            listener.waitingForInput(this.myTemplate);
        }
    }

    private void currentVariableChanged(int oldIndex) {
        for (TemplateEditingListener listener : this.myListeners) {
            listener.currentVariableChanged(this, this.myTemplate, oldIndex, this.myCurrentVariableNumber);
        }
        if (this.myCurrentSegmentNumber < 0) {
            if (this.myCurrentVariableNumber >= 0) {
                LOG.error("A variable with no segment: " + this.myCurrentVariableNumber + "; " + TemplateState.presentTemplate(this.myTemplate));
            }
            this.releaseAll();
        }
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public Editor getEditor() {
        return this.myEditor;
    }
}

