/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.Browser;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionGroupNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionSeverityGroupNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.ui.actions.ExportHTMLAction;
import com.intellij.codeInspection.ui.actions.InspectionsOptionsToolbarAction;
import com.intellij.codeInspection.ui.actions.InvokeQuickFixAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SmartExpander;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionResultsView
extends JPanel
implements Disposable,
OccurenceNavigator,
DataProvider {
    public static final DataKey<InspectionResultsView> DATA_KEY = DataKey.create((String)"inspectionView");
    private final Project myProject;
    private final InspectionTree myTree;
    private final Browser myBrowser;
    private final ConcurrentMap<HighlightDisplayLevel, ConcurrentMap<String, InspectionGroupNode>> myGroups;
    private final OccurenceNavigator myOccurenceNavigator;
    private volatile InspectionProfile myInspectionProfile;
    private final AnalysisScope myScope;
    @NonNls
    private static final String HELP_ID = "reference.toolWindows.inspections";
    private final ConcurrentMap<HighlightDisplayLevel, InspectionSeverityGroupNode> mySeverityGroupNodes;
    private final Splitter mySplitter;
    @NotNull
    private final GlobalInspectionContextImpl myGlobalInspectionContext;
    private boolean myRerun;
    private volatile boolean myDisposed;
    @NotNull
    private final InspectionRVContentProvider myProvider;
    private AnAction myIncludeAction;
    private AnAction myExcludeAction;

    public InspectionResultsView(final @NotNull Project project, InspectionProfile inspectionProfile, @NotNull AnalysisScope scope, @NotNull GlobalInspectionContextImpl globalInspectionContext, @NotNull InspectionRVContentProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/InspectionResultsView", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ui/InspectionResultsView", "<init>"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/intellij/codeInspection/ui/InspectionResultsView", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInspection/ui/InspectionResultsView", "<init>"));
        }
        this.myGroups = ContainerUtil.newConcurrentMap();
        this.mySeverityGroupNodes = ContainerUtil.newConcurrentMap();
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myInspectionProfile = inspectionProfile;
        this.myScope = scope;
        this.myGlobalInspectionContext = globalInspectionContext;
        this.myProvider = provider;
        this.myTree = new InspectionTree(project, globalInspectionContext);
        this.initTreeListeners();
        this.myOccurenceNavigator = this.initOccurenceNavigator();
        this.myBrowser = new Browser(this);
        this.mySplitter = new OnePixelSplitter(false, AnalysisUIOptions.getInstance((Project)this.myProject).SPLITTER_PROPORTION);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)5));
        this.mySplitter.setSecondComponent((JComponent)this.myBrowser);
        this.mySplitter.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("proportion".equals(evt.getPropertyName())) {
                    InspectionResultsView.this.myGlobalInspectionContext.setSplitterProportion(((Float)evt.getNewValue()).floatValue());
                }
            }
        });
        this.add((Component)this.mySplitter, "Center");
        this.myBrowser.addClickListener(new Browser.ClickListener(){

            @Override
            public void referenceClicked(Browser.ClickEvent e) {
                if (e.getEventType() == 1) {
                    RefElement refElement = e.getClickedElement();
                    OpenFileDescriptor descriptor = InspectionResultsView.getOpenFileDescriptor(refElement);
                    if (descriptor != null) {
                        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, false);
                    }
                } else if (e.getEventType() == 2) {
                    VirtualFile file = e.getFile();
                    OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, e.getStartOffset());
                    Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
                    if (editor != null) {
                        TextAttributes selectionAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, e.getStartOffset(), e.getEndOffset(), selectionAttributes, true, null);
                    }
                }
            }
        });
        this.createActionsToolbar();
        TreeUtil.selectFirstNode((JTree)((Object)this.myTree));
    }

    private void initTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionResultsView.this.syncBrowser();
                if (InspectionResultsView.this.isAutoScrollMode()) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)false);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        this.myTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)InspectionResultsView.this), (boolean)false);
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                InspectionResultsView.this.popupInvoked(comp, x, y);
            }
        });
        SmartExpander.installOn((JTree)((Object)this.myTree));
    }

    private OccurenceNavigatorSupport initOccurenceNavigator() {
        return new OccurenceNavigatorSupport((JTree)((Object)this.myTree)){

            @Nullable
            protected Navigatable createDescriptorForNode(DefaultMutableTreeNode node) {
                if (node instanceof InspectionTreeNode && ((InspectionTreeNode)node).isResolved()) {
                    return null;
                }
                if (node instanceof RefElementNode) {
                    RefElementNode refNode = (RefElementNode)node;
                    if (refNode.hasDescriptorsUnder()) {
                        return null;
                    }
                    RefEntity element = refNode.getElement();
                    if (element == null || !element.isValid()) {
                        return null;
                    }
                    CommonProblemDescriptor problem = refNode.getProblem();
                    if (problem != null) {
                        return this.navigate(problem);
                    }
                    if (element instanceof RefElement) {
                        return InspectionResultsView.getOpenFileDescriptor((RefElement)element);
                    }
                } else if (node instanceof ProblemDescriptionNode) {
                    if (!((ProblemDescriptionNode)node).isValid()) {
                        return null;
                    }
                    return this.navigate(((ProblemDescriptionNode)node).getDescriptor());
                }
                return null;
            }

            @Nullable
            private Navigatable navigate(CommonProblemDescriptor descriptor) {
                return InspectionResultsView.this.getSelectedNavigatable(descriptor);
            }

            public String getNextOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.action.go.next", (Object[])new Object[0]);
            }

            public String getPreviousOccurenceActionName() {
                return InspectionsBundle.message((String)"inspection.actiongo.prev", (Object[])new Object[0]);
            }
        };
    }

    private void createActionsToolbar() {
        JComponent leftActionsToolbar = this.createLeftActionsToolbar();
        JComponent rightActionsToolbar = this.createRightActionsToolbar();
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)leftActionsToolbar, "West");
        westPanel.add((Component)rightActionsToolbar, "East");
        this.add((Component)westPanel, "West");
    }

    private JComponent createRightActionsToolbar() {
        this.myIncludeAction = new AnAction(InspectionsBundle.message((String)"inspections.result.view.include.action.text", (Object[])new Object[0])){
            {
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)InspectionResultsView.this.myTree));
            }

            public void actionPerformed(AnActionEvent e) {
                TreePath[] paths = InspectionResultsView.this.myTree.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path : paths) {
                        ((InspectionTreeNode)path.getLastPathComponent()).amnesty();
                    }
                }
                InspectionResultsView.this.updateView(false);
            }

            public void update(AnActionEvent e) {
                TreePath[] paths = InspectionResultsView.this.myTree.getSelectionPaths();
                e.getPresentation().setEnabled(paths != null && paths.length > 0 && !((InspectionResultsView)InspectionResultsView.this).myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS);
            }
        };
        this.myExcludeAction = new AnAction(InspectionsBundle.message((String)"inspections.result.view.exclude.action.text", (Object[])new Object[0])){
            {
                this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)InspectionResultsView.this.myTree));
            }

            public void actionPerformed(AnActionEvent e) {
                TreePath[] paths = InspectionResultsView.this.myTree.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path : paths) {
                        ((InspectionTreeNode)path.getLastPathComponent()).ignoreElement();
                    }
                }
                InspectionResultsView.this.updateView(false);
            }

            public void update(AnActionEvent e) {
                TreePath[] path = InspectionResultsView.this.myTree.getSelectionPaths();
                e.getPresentation().setEnabled(path != null && path.length > 0);
            }
        };
        DefaultActionGroup specialGroup = new DefaultActionGroup();
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupBySeverityAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createGroupByDirectoryAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createFilterResolvedItemsAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createShowOutdatedProblemsAction(this));
        specialGroup.add(this.myGlobalInspectionContext.getUIOptions().createShowDiffOnlyAction(this));
        specialGroup.add((AnAction)new EditSettingsAction());
        specialGroup.add((AnAction)new InvokeQuickFixAction(this));
        specialGroup.add((AnAction)new InspectionsOptionsToolbarAction(this));
        return InspectionResultsView.createToolbar(specialGroup);
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RerunAction(this));
        group.add((AnAction)new CloseAction());
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)((Object)InspectionResultsView.this.myTree));
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)((Object)InspectionResultsView.this.myTree), (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        group.add(actionsManager.createExpandAllAction(treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createCollapseAllAction(treeExpander, (JComponent)((Object)this.myTree)));
        group.add(actionsManager.createPrevOccurenceAction(this.getOccurenceNavigator()));
        group.add(actionsManager.createNextOccurenceAction(this.getOccurenceNavigator()));
        group.add((AnAction)this.myGlobalInspectionContext.createToggleAutoscrollAction());
        group.add((AnAction)new ExportHTMLAction(this));
        group.add((AnAction)new ContextHelpAction(HELP_ID));
        return InspectionResultsView.createToolbar(group);
    }

    private static JComponent createToolbar(DefaultActionGroup specialGroup) {
        return ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)specialGroup, false).getComponent();
    }

    public void dispose() {
        this.mySplitter.dispose();
        this.myBrowser.dispose();
        this.myInspectionProfile = null;
        this.myDisposed = true;
    }

    private boolean isAutoScrollMode() {
        String activeToolWindowId = ToolWindowManager.getInstance((Project)this.myProject).getActiveToolWindowId();
        return this.myGlobalInspectionContext.getUIOptions().AUTOSCROLL_TO_SOURCE && (activeToolWindowId == null || activeToolWindowId.equals(ToolWindowId.INSPECTION));
    }

    @Nullable
    private static OpenFileDescriptor getOpenFileDescriptor(final RefElement refElement) {
        final VirtualFile[] file = new VirtualFile[1];
        final int[] offset = new int[1];
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiElement psiElement = refElement.getElement();
                if (psiElement != null) {
                    PsiFile containingFile = psiElement.getContainingFile();
                    if (containingFile != null) {
                        file[0] = containingFile.getVirtualFile();
                        offset[0] = psiElement.getTextOffset();
                    }
                } else {
                    file[0] = null;
                }
            }
        });
        if (file[0] != null && file[0].isValid()) {
            return new OpenFileDescriptor(refElement.getRefManager().getProject(), file[0], offset[0]);
        }
        return null;
    }

    private void syncBrowser() {
        if (this.myTree.getSelectionModel().getSelectionCount() != 1) {
            this.myBrowser.showEmpty();
        } else {
            TreePath pathSelected = this.myTree.getSelectionModel().getLeadSelectionPath();
            if (pathSelected != null) {
                InspectionTreeNode node = (InspectionTreeNode)pathSelected.getLastPathComponent();
                if (node instanceof RefElementNode) {
                    RefElementNode refElementNode = (RefElementNode)node;
                    CommonProblemDescriptor problem = refElementNode.getProblem();
                    RefEntity refSelected = refElementNode.getElement();
                    if (problem != null) {
                        this.showInBrowser(refSelected, problem);
                    } else {
                        this.showInBrowser(refSelected);
                    }
                } else if (node instanceof ProblemDescriptionNode) {
                    ProblemDescriptionNode problemNode = (ProblemDescriptionNode)node;
                    this.showInBrowser(problemNode.getElement(), problemNode.getDescriptor());
                } else if (node instanceof InspectionNode) {
                    this.showInBrowser(((InspectionNode)node).getToolWrapper());
                } else {
                    this.myBrowser.showEmpty();
                }
            }
        }
    }

    private void showInBrowser(RefEntity refEntity) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showPageFor(refEntity);
        this.setCursor(currentCursor);
    }

    private void showInBrowser(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/InspectionResultsView", "showInBrowser"));
        }
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showDescription(toolWrapper);
        this.setCursor(currentCursor);
    }

    private void showInBrowser(RefEntity refEntity, CommonProblemDescriptor descriptor) {
        Cursor currentCursor = this.getCursor();
        this.setCursor(new Cursor(3));
        this.myBrowser.showPageFor(refEntity, descriptor);
        this.setCursor(currentCursor);
    }

    @NotNull
    public InspectionNode addTool(@NotNull InspectionToolWrapper toolWrapper, HighlightDisplayLevel errorLevel, boolean groupedBySeverity) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ui/InspectionResultsView", "addTool"));
        }
        String groupName = toolWrapper.getGroupDisplayName().isEmpty() ? InspectionProfileEntry.GENERAL_GROUP_NAME : toolWrapper.getGroupDisplayName();
        InspectionTreeNode parentNode = this.getToolParentNode(groupName, errorLevel, groupedBySeverity);
        InspectionNode toolNode = new InspectionNode(toolWrapper);
        boolean showStructure = this.myGlobalInspectionContext.getUIOptions().SHOW_STRUCTURE;
        this.myProvider.appendToolNodeContent(this.myGlobalInspectionContext, toolNode, parentNode, showStructure);
        InspectionToolPresentation presentation = this.myGlobalInspectionContext.getPresentation(toolWrapper);
        toolNode = presentation.createToolNode(this.myGlobalInspectionContext, toolNode, this.myProvider, parentNode, showStructure);
        ((DefaultInspectionToolPresentation)presentation).setToolNode(toolNode);
        this.registerActionShortcuts(presentation);
        InspectionNode inspectionNode = toolNode;
        if (inspectionNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "addTool"));
        }
        return inspectionNode;
    }

    private void registerActionShortcuts(@NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ui/InspectionResultsView", "registerActionShortcuts"));
        }
        QuickFixAction[] fixes = presentation.getQuickFixes(RefEntity.EMPTY_ELEMENTS_ARRAY);
        if (fixes != null) {
            for (QuickFixAction fix : fixes) {
                fix.registerCustomShortcutSet(fix.getShortcutSet(), this);
            }
        }
    }

    private void clearTree() {
        this.myTree.removeAllNodes();
        this.mySeverityGroupNodes.clear();
    }

    @Nullable
    public String getCurrentProfileName() {
        return this.myInspectionProfile == null ? null : this.myInspectionProfile.getDisplayName();
    }

    public InspectionProfile getCurrentProfile() {
        return this.myInspectionProfile;
    }

    public boolean update() {
        return this.updateView(true);
    }

    public boolean updateView(boolean strict) {
        if (!strict && !this.myGlobalInspectionContext.getUIOptions().FILTER_RESOLVED_ITEMS) {
            this.myTree.repaint();
            return false;
        }
        this.clearTree();
        boolean resultsFound = this.buildTree();
        this.myTree.restoreExpansionAndSelection();
        return resultsFound;
    }

    private boolean buildTree() {
        InspectionProfile profile = this.myInspectionProfile;
        boolean isGroupedBySeverity = this.myGlobalInspectionContext.getUIOptions().GROUP_BY_SEVERITY;
        this.myGroups.clear();
        Map<String, Tools> tools = this.myGlobalInspectionContext.getTools();
        boolean resultsFound = false;
        for (Tools currentTools : tools.values()) {
            InspectionToolWrapper defaultToolWrapper = currentTools.getDefaultState().getTool();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)defaultToolWrapper.getShortName());
            for (ScopeToolState scopeToolState : this.myProvider.getTools(currentTools)) {
                InspectionToolWrapper toolWrapper = scopeToolState.getTool();
                if (!this.myProvider.checkReportedProblems(this.myGlobalInspectionContext, toolWrapper)) continue;
                this.addTool(toolWrapper, ((InspectionProfileImpl)profile).getErrorLevel(key, scopeToolState.getScope(this.myProject), this.myProject), isGroupedBySeverity);
                resultsFound = true;
            }
        }
        return resultsFound;
    }

    @NotNull
    private InspectionTreeNode getToolParentNode(@NotNull String groupName, HighlightDisplayLevel errorLevel, boolean groupedBySeverity) {
        InspectionGroupNode group;
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/codeInspection/ui/InspectionResultsView", "getToolParentNode"));
        }
        if (groupName.isEmpty()) {
            InspectionTreeNode inspectionTreeNode = this.getRelativeRootNode(groupedBySeverity, errorLevel);
            if (inspectionTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getToolParentNode"));
            }
            return inspectionTreeNode;
        }
        ConcurrentMap map = (ConcurrentMap)this.myGroups.get(errorLevel);
        if (map == null) {
            map = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myGroups, (Object)errorLevel, (Object)ContainerUtil.newConcurrentMap());
        }
        if (groupedBySeverity) {
            group = (InspectionGroupNode)map.get(groupName);
        } else {
            Map groupMap;
            group = null;
            Iterator iterator = this.myGroups.values().iterator();
            while (iterator.hasNext() && (group = (InspectionGroupNode)(groupMap = (Map)iterator.next()).get(groupName)) == null) {
            }
        }
        if (group == null) {
            group = (InspectionGroupNode)ConcurrencyUtil.cacheOrGet((ConcurrentMap)map, (Object)groupName, (Object)new InspectionGroupNode(groupName));
            this.addChildNodeInEDT(this.getRelativeRootNode(groupedBySeverity, errorLevel), group);
        }
        InspectionGroupNode inspectionGroupNode = group;
        if (inspectionGroupNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getToolParentNode"));
        }
        return inspectionGroupNode;
    }

    @NotNull
    private InspectionTreeNode getRelativeRootNode(boolean isGroupedBySeverity, HighlightDisplayLevel level) {
        if (isGroupedBySeverity) {
            InspectionSeverityGroupNode newNode;
            InspectionSeverityGroupNode severityGroupNode = (InspectionSeverityGroupNode)this.mySeverityGroupNodes.get(level);
            if (severityGroupNode == null && (severityGroupNode = (InspectionSeverityGroupNode)ConcurrencyUtil.cacheOrGet(this.mySeverityGroupNodes, (Object)level, (Object)(newNode = new InspectionSeverityGroupNode(this.myProject, level)))) == newNode) {
                InspectionTreeNode root = this.myTree.getRoot();
                this.addChildNodeInEDT(root, severityGroupNode);
            }
            InspectionSeverityGroupNode inspectionSeverityGroupNode = severityGroupNode;
            if (inspectionSeverityGroupNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getRelativeRootNode"));
            }
            return inspectionSeverityGroupNode;
        }
        InspectionTreeNode inspectionTreeNode = this.myTree.getRoot();
        if (inspectionTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getRelativeRootNode"));
        }
        return inspectionTreeNode;
    }

    private void addChildNodeInEDT(final @NotNull DefaultMutableTreeNode root, final @NotNull MutableTreeNode severityGroupNode) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/codeInspection/ui/InspectionResultsView", "addChildNodeInEDT"));
        }
        if (severityGroupNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severityGroupNode", "com/intellij/codeInspection/ui/InspectionResultsView", "addChildNodeInEDT"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!InspectionResultsView.this.myDisposed) {
                    root.add(severityGroupNode);
                }
            }
        });
    }

    private OccurenceNavigator getOccurenceNavigator() {
        return this.myOccurenceNavigator;
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator != null && this.myOccurenceNavigator.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator != null && this.myOccurenceNavigator.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.goNextOccurence() : null;
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.goPreviousOccurence() : null;
    }

    public String getNextOccurenceActionName() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.getNextOccurenceActionName() : "";
    }

    public String getPreviousOccurenceActionName() {
        return this.myOccurenceNavigator != null ? this.myOccurenceNavigator.getPreviousOccurenceActionName() : "";
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getProject"));
        }
        return project;
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        if (this.myTree == null) {
            return null;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (paths.length > 1) {
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                return this.collectPsiElements();
            }
            return null;
        }
        TreePath path = paths[0];
        InspectionTreeNode selectedNode = (InspectionTreeNode)path.getLastPathComponent();
        if (selectedNode instanceof RefElementNode) {
            PsiElement psiElement;
            RefElementNode refElementNode = (RefElementNode)selectedNode;
            RefEntity refElement = refElementNode.getElement();
            if (refElement == null) {
                return null;
            }
            RefEntity item = refElement.getRefManager().getRefinedElement(refElement);
            if (!item.isValid()) {
                return null;
            }
            PsiElement psiElement2 = psiElement = item instanceof RefElement ? ((RefElement)item).getElement() : null;
            if (psiElement == null) {
                return null;
            }
            CommonProblemDescriptor problem = refElementNode.getProblem();
            if (problem != null) {
                if (problem instanceof ProblemDescriptor) {
                    psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement == null) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return this.getSelectedNavigatable(problem, psiElement);
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement.isValid() ? psiElement : null;
            }
        } else if (selectedNode instanceof ProblemDescriptionNode && CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getSelectedNavigatable(((ProblemDescriptionNode)selectedNode).getDescriptor());
        }
        return null;
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor) {
        return this.getSelectedNavigatable(descriptor, descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null);
    }

    @Nullable
    private Navigatable getSelectedNavigatable(CommonProblemDescriptor descriptor, PsiElement psiElement) {
        VirtualFile virtualFile;
        Navigatable navigatable;
        if (descriptor instanceof ProblemDescriptorBase && (navigatable = ((ProblemDescriptorBase)descriptor).getNavigatable()) != null) {
            return navigatable;
        }
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = containingFile == null ? null : containingFile.getVirtualFile();
        if (virtualFile != null) {
            TextRange textRange;
            int startOffset = psiElement.getTextOffset();
            if (descriptor instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor).getTextRangeForNavigation()) != null) {
                if (virtualFile instanceof VirtualFileWindow) {
                    virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
                }
                startOffset = textRange.getStartOffset();
            }
            return new OpenFileDescriptor(this.myProject, virtualFile, startOffset);
        }
        return null;
    }

    private PsiElement[] collectPsiElements() {
        RefEntity[] refElements = this.myTree.getSelectedElements();
        ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            psiElements.add(psiElement);
        }
        return PsiUtilCore.toPsiElementArray(psiElements);
    }

    private void popupInvoked(Component component, int x, int y) {
        TreePath path = this.myTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions.add(actionManager.getAction("EditSource"));
        actions.add(actionManager.getAction("FindUsages"));
        actions.add(this.myIncludeAction);
        actions.add(this.myExcludeAction);
        actions.addSeparator();
        InspectionToolWrapper toolWrapper = this.myTree.getSelectedToolWrapper();
        if (toolWrapper != null) {
            HighlightDisplayKey key;
            QuickFixAction[] quickFixes = this.myProvider.getQuickFixes(toolWrapper, this.myTree);
            if (quickFixes != null) {
                for (QuickFixAction quickFixe : quickFixes) {
                    actions.add((AnAction)quickFixe);
                }
            }
            if ((key = HighlightDisplayKey.find((String)toolWrapper.getShortName())) == null) {
                return;
            }
            actions.addSeparator();
            actions.add((AnAction)new EditSettingsAction());
            List<AnAction> options = new InspectionsOptionsToolbarAction(this).createActions();
            for (AnAction action : options) {
                actions.add(action);
            }
        }
        actions.addSeparator();
        actions.add(actionManager.getAction("VersionControlsGroup"));
        ActionPopupMenu menu = actionManager.createActionPopupMenu("CodeInspection", (ActionGroup)actions);
        menu.getComponent().show(component, x, y);
    }

    @NotNull
    public InspectionTree getTree() {
        InspectionTree inspectionTree = this.myTree;
        if (inspectionTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getTree"));
        }
        return inspectionTree;
    }

    @NotNull
    public GlobalInspectionContextImpl getGlobalInspectionContext() {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.myGlobalInspectionContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getGlobalInspectionContext"));
        }
        return globalInspectionContextImpl;
    }

    @NotNull
    public InspectionRVContentProvider getProvider() {
        InspectionRVContentProvider inspectionRVContentProvider = this.myProvider;
        if (inspectionRVContentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionResultsView", "getProvider"));
        }
        return inspectionRVContentProvider;
    }

    public boolean isSingleToolInSelection() {
        return this.myTree != null && this.myTree.getSelectedToolWrapper() != null;
    }

    public boolean isRerun() {
        boolean rerun = this.myRerun;
        this.myRerun = false;
        return rerun;
    }

    private InspectionProfile guessProfileToSelect(InspectionProjectProfileManager profileManager) {
        RefEntity[] selectedElements;
        HashSet<InspectionProfile> profiles = new HashSet<InspectionProfile>();
        for (RefEntity selectedElement : selectedElements = this.myTree.getSelectedElements()) {
            RefElement refElement;
            PsiElement element;
            if (!(selectedElement instanceof RefElement) || (element = (refElement = (RefElement)selectedElement).getElement()) == null) continue;
            profiles.add(profileManager.getInspectionProfile());
        }
        if (profiles.isEmpty()) {
            return (InspectionProfile)profileManager.getProjectProfileImpl();
        }
        return (InspectionProfile)profiles.iterator().next();
    }

    public boolean isProfileDefined() {
        return this.myInspectionProfile != null && this.myInspectionProfile.isEditable();
    }

    public static void showPopup(AnActionEvent e, JBPopup popup) {
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup.showUnderneathOf(event.getComponent());
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public void updateCurrentProfile() {
        String name = this.myInspectionProfile.getName();
        this.myInspectionProfile = (InspectionProfile)this.myInspectionProfile.getProfileManager().getProfile(name);
    }

    private class RerunAction
    extends AnAction {
        public RerunAction(JComponent comp) {
            super(InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.rerun", (Object[])new Object[0]), AllIcons.Actions.Rerun);
            this.registerCustomShortcutSet(CommonShortcuts.getRerun(), comp);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(InspectionResultsView.this.myScope.isValid());
        }

        public void actionPerformed(AnActionEvent e) {
            this.rerun();
        }

        private void rerun() {
            InspectionResultsView.this.myRerun = true;
            if (InspectionResultsView.this.myScope.isValid()) {
                AnalysisUIOptions.getInstance(InspectionResultsView.this.myProject).save(InspectionResultsView.this.myGlobalInspectionContext.getUIOptions());
                InspectionResultsView.this.myGlobalInspectionContext.doInspections(InspectionResultsView.this.myScope);
            }
        }
    }

    private class EditSettingsAction
    extends AnAction {
        private EditSettingsAction() {
            super(InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.edit.settings", (Object[])new Object[0]), AllIcons.General.Settings);
        }

        public void actionPerformed(AnActionEvent e) {
            HighlightDisplayKey key;
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(InspectionResultsView.this.myProject);
            InspectionToolWrapper toolWrapper = InspectionResultsView.this.myTree.getSelectedToolWrapper();
            InspectionProfile inspectionProfile = InspectionResultsView.this.myInspectionProfile;
            boolean profileIsDefined = InspectionResultsView.this.isProfileDefined();
            if (!profileIsDefined) {
                inspectionProfile = InspectionResultsView.this.guessProfileToSelect(profileManager);
            }
            if (toolWrapper != null && (key = HighlightDisplayKey.find((String)toolWrapper.getShortName())) != null) {
                if (new EditInspectionToolsSettingsAction(key).editToolSettings(InspectionResultsView.this.myProject, (InspectionProfileImpl)inspectionProfile, profileIsDefined) && profileIsDefined) {
                    InspectionResultsView.this.updateCurrentProfile();
                }
                return;
            }
            if (EditInspectionToolsSettingsAction.editToolSettings(InspectionResultsView.this.myProject, inspectionProfile, profileIsDefined, null) && profileIsDefined) {
                InspectionResultsView.this.updateCurrentProfile();
            }
        }
    }

    private class CloseAction
    extends AnAction
    implements DumbAware {
        private CloseAction() {
            super(CommonBundle.message((String)"action.close", (Object[])new Object[0]), null, AllIcons.Actions.Cancel);
        }

        public void actionPerformed(AnActionEvent e) {
            InspectionResultsView.this.myGlobalInspectionContext.close(true);
        }
    }
}

