/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CompilerEncodingServiceImpl
extends CompilerEncodingService {
    @NotNull
    private final Project myProject;
    private final CachedValue<Map<Module, Set<Charset>>> myModuleFileEncodings;

    public CompilerEncodingServiceImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "<init>"));
        }
        this.myProject = project;
        this.myModuleFileEncodings = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<Module, Set<Charset>>>(){

            public CachedValueProvider.Result<Map<Module, Set<Charset>>> compute() {
                Map result2 = CompilerEncodingServiceImpl.this.computeModuleCharsetMap();
                return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{ProjectRootManager.getInstance((Project)CompilerEncodingServiceImpl.this.myProject), ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)CompilerEncodingServiceImpl.this.myProject)).getModificationTracker()});
            }
        }, false);
    }

    @NotNull
    private Map<Module, Set<Charset>> computeModuleCharsetMap() {
        THashMap map = new THashMap();
        Map<VirtualFile, Charset> mappings = ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getAllMappings();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (Map.Entry<VirtualFile, Charset> entry : mappings.entrySet()) {
            Module module;
            VirtualFile file = entry.getKey();
            Charset charset = entry.getValue();
            if (file == null || charset == null || !file.isDirectory() && !compilerManager.isCompilableFileType(file.getFileType()) || !index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || (module = index.getModuleForFile(file)) == null) continue;
            LinkedHashSet<Charset> set = (LinkedHashSet<Charset>)map.get(module);
            if (set == null) {
                set = new LinkedHashSet<Charset>();
                map.put(module, set);
                VirtualFile sourceRoot = index.getSourceRootForFile(file);
                Charset parentCharset = null;
                for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
                    Charset currentCharset = mappings.get(current);
                    if (currentCharset != null) {
                        parentCharset = currentCharset;
                    }
                    if (current.equals(sourceRoot)) break;
                }
                if (parentCharset != null) {
                    set.add(parentCharset);
                }
            }
            set.add(charset);
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots(true)) {
                Charset encoding = EncodingProjectManager.getInstance((Project)this.myProject).getEncoding(file, true);
                if (encoding == null) continue;
                LinkedHashSet<Charset> charsets = (LinkedHashSet<Charset>)map.get(module);
                if (charsets == null) {
                    charsets = new LinkedHashSet<Charset>();
                    map.put(module, charsets);
                }
                charsets.add(encoding);
            }
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "computeModuleCharsetMap"));
        }
        return tHashMap;
    }

    @Nullable
    public Charset getPreferredModuleEncoding(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getPreferredModuleEncoding"));
        }
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module);
        return (Charset)ContainerUtil.getFirstItem((Collection)encodings, (Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
    }

    @NotNull
    public Collection<Charset> getAllModuleEncodings(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
        }
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module);
        if (encodings != null) {
            Set set = encodings;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
            }
            return set;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
        }
        return list;
    }
}

