/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.StringsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"c\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0011YA\u0002A\r\u00021\u0003i\n\u0011FQ!\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u0015\u0011\"\u0002\u0003\u0002\u0011\u000fi!\u0001$\u0001\u0019\t%)A!\u0001E\u0005\u001b\ta\t\u0001G\u0003\n\u000b\u0011\t\u00012B\u0007\u0003\u0019\u0003Ab!U\u0002\u0002\u0011\u001b)\u0003\u0002\u0002\u0006\t\u001c5\t\u0001DD\r\u0004\u0011;i\u0011\u0001G\b&\t!}QB\u0001G\u00011#)S\u0001\u0002\u0006\t!5\u0011A\u0012\u0001M\u0011K%!\u0011\u0001C\t\u000e\u0003a\r\u0012\u0004\u0002\u0005\u0013\u001b\ta\t\u0001'\n&\u001b!UQ\"\u0001M\u00123\u0011A1#\u0004\u0002\r\u0002aE\u0011\u0004\u0002E\u0014\u001b\ta\t\u0001g\u0001&\t\u0011Y\u0001\u0002F\u0007\u00021\u000bIs\u0001B!\u001d\u0011\u001di\u0011\u0001g\u0004R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0004rA\u0001\"\u0004\u0002\r\u0002aEA$\u0001\u0011\u0002#\u000e\tQ\u0001A\u0015\u0014\t\u000fc\u0002\"A\u0007\u00021\u0007I2\u0001C\u0005\u000e\u0003a\rAd\u0001\u0011\"#\u000e9Q\u0001A\u0007\u0003\t'A!\"\u0005\u0002\u0005\u0016!Y\u0011V\u0003\u0003K\u0011\u0006A9\"D\u0001\u0019\u0010E\u001bA!\u0002\u0001\u000e\u0005\u0011]\u0001\u0002D\u0015\t\t\u0005c\u0002\u0012D\u0007\u0003\u0019\u0003AR\"U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "file", "Ljava/io/File;", "fileSpec", "", "rootElementName", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "blockSavingTheContent", "", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<set-?>", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "isUseXmlProlog", "()Z", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "states", "Lcom/intellij/configurationStore/StateMap;", "getVirtualFile", "loadLocalData", "Lorg/jdom/Element;", "processReadException", "", "e", "Ljava/lang/Exception;", "virtualFile", "ioFileIfChanged", "toString", "FileSaveSession"}, moduleName="configuration-store-impl")
public class FileBasedStorage
extends XmlElementStorage {
    private volatile VirtualFile cachedVirtualFile;
    private LineSeparator lineSeparator;
    private boolean blockSavingTheContent;
    @NotNull
    private volatile File file;
    private final boolean isUseXmlProlog = false;

    @NotNull
    public final File getFile() {
        return this.file;
    }

    private final void setFile(File file) {
        this.file = file;
    }

    protected boolean isUseXmlProlog() {
        return this.isUseXmlProlog;
    }

    public final void setFile(@Nullable VirtualFile virtualFile, @Nullable File ioFileIfChanged) {
        this.cachedVirtualFile = virtualFile;
        if (ioFileIfChanged != null) {
            this.file = ioFileIfChanged;
        }
    }

    @Override
    @NotNull
    protected FileSaveSession createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkParameterIsNotNull((Object)states, (String)"states");
        return new FileSaveSession(states, this);
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.cachedVirtualFile;
        if (result2 == null) {
            this.cachedVirtualFile = result2 = LocalFileSystem.getInstance().findFileByIoFile(this.file);
        }
        return this.cachedVirtualFile;
    }

    @Override
    @Nullable
    protected Element loadLocalData() {
        block6: {
            this.blockSavingTheContent = false;
            try {
                VirtualFile file = this.getVirtualFile();
                if (file == null || file.isDirectory() || !file.isValid()) {
                    Logger $receiver = ComponentStoreImplKt.getLOG();
                    if ($receiver.isDebugEnabled()) {
                        Logger logger = $receiver;
                        String string = "Document was not loaded for " + this.getFileSpec() + " file is " + (file == null ? "null" : "directory");
                        logger.debug(string);
                    }
                    break block6;
                }
                if (file.getLength() == 0L) {
                    this.processReadException(null);
                    break block6;
                }
                CharBuffer charBuffer = CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(file.contentsToByteArray()));
                CharSequence charSequence = charBuffer;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"charBuffer");
                this.lineSeparator = FileBasedStorageKt.detectLineSeparators(charSequence, this.isUseXmlProlog() ? (LineSeparator)null : LineSeparator.LF);
                return JDOMUtil.loadDocument((CharSequence)charBuffer).detachRootElement();
            }
            catch (JDOMException e) {
                this.processReadException((Exception)((Object)e));
            }
            catch (IOException e) {
                this.processReadException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void processReadException(Exception e) {
        boolean contentTruncated = e == null;
        boolean bl = this.blockSavingTheContent = !contentTruncated && (FileBasedStorageKt.isProjectOrModuleFile(this.getFileSpec()) || Intrinsics.areEqual((Object)this.getFileSpec(), (Object)"$WORKSPACE_FILE$"));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            String string;
            Notification notification;
            if (e != null) {
                ComponentStoreImplKt.getLOG().info((Throwable)e);
            }
            Notification notification2 = notification;
            Notification notification3 = notification;
            String string2 = "System Messages";
            String string3 = "Load Settings";
            StringBuilder stringBuilder = new StringBuilder().append("Cannot load settings from file '").append(this.file).append("': ");
            if (contentTruncated) {
                string = "content truncated";
            } else {
                void $receiver;
                Exception exception = e;
                if (exception == null) {
                    Intrinsics.throwNpe();
                }
                Throwable throwable = exception;
                StringBuilder stringBuilder2 = stringBuilder;
                String string4 = string3;
                String string5 = string2;
                Notification notification4 = notification2;
                Notification notification5 = notification3;
                String string6 = $receiver.getMessage();
                notification3 = notification5;
                notification2 = notification4;
                string2 = string5;
                string3 = string4;
                stringBuilder = stringBuilder2;
                string = string6;
            }
            notification2(string2, string3, stringBuilder.append(string).append("\n").append(this.blockSavingTheContent ? "Please correct the file content" : "File content will be recreated").toString(), NotificationType.WARNING);
            notification3.notify((Project)null);
        }
    }

    @NotNull
    public String toString() {
        return FileUtilKt.getSystemIndependentPath(this.file);
    }

    public FileBasedStorage(@NotNull File file, @NotNull String fileSpec, @NotNull String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        super(fileSpec, rootElementName, pathMacroManager, roamingType, provider);
        this.file = file;
        if (ApplicationManager.getApplication().isUnitTestMode() && StringsKt.startsWith$default((CharSequence)file.getPath(), (char)'$', (boolean)false, (int)2)) {
            throw (Throwable)((Object)new AssertionError((Object)("It seems like some macros were not expanded for path: " + file)));
        }
    }

    public /* synthetic */ FileBasedStorage(File file, String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            roamingType = null;
        }
        if ((n & 0x20) != 0) {
            streamProvider = null;
        }
        this(file, string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    public static final /* synthetic */ void access$setBlockSavingTheContent$p(FileBasedStorage $this, boolean bl) {
        $this.blockSavingTheContent = bl;
    }

    @NotNull
    public static final /* synthetic */ File access$getFile$p(FileBasedStorage $this) {
        return $this.file;
    }

    public static final /* synthetic */ void access$setFile$p(FileBasedStorage $this, @NotNull File file) {
        $this.file = file;
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getCachedVirtualFile$p(FileBasedStorage $this) {
        return $this.cachedVirtualFile;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\t)a\u0001!\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001C+I1\u0001c\u0001\u000e\u0003a\u0011\u0011b\u0001E\u0003\u001b\u0005A\u0012!U\u0002\u0002\u0011\r)C\u0001B\u0006\t\b5\t\u0001\u0004B\u0013\n\t)AI!D\u0001\u0019\te!\u0001\"B\u0007\u0003\u0019\u0003AZ\u0001"}, strings={"Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSession;", "Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "Lcom/intellij/configurationStore/FileBasedStorage;", "storageData", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/FileBasedStorage;)V", "save", "", "saveLocally", "element", "Lorg/jdom/Element;"}, moduleName="configuration-store-impl")
    protected static class FileSaveSession
    extends XmlElementStorage.XmlElementStorageSaveSession<FileBasedStorage> {
        @Override
        public void save() {
            if (!((FileBasedStorage)this.getStorage()).blockSavingTheContent) {
                super.save();
            }
        }

        @Override
        protected void saveLocally(@Nullable Element element) {
            if (((FileBasedStorage)this.getStorage()).lineSeparator == null) {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                if (((FileBasedStorage)this.getStorage()).isUseXmlProlog()) {
                    lineSeparator = LineSeparator.LF;
                } else {
                    LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
                    lineSeparator = lineSeparator2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
                }
                fileBasedStorage.lineSeparator = lineSeparator;
            }
            VirtualFile virtualFile = ((FileBasedStorage)this.getStorage()).getVirtualFile();
            if (element == null) {
                FileBasedStorageKt.access$deleteFile(((FileBasedStorage)this.getStorage()).getFile(), this, virtualFile);
                ((FileBasedStorage)this.getStorage()).cachedVirtualFile = null;
            } else {
                LineSeparator lineSeparator;
                FileBasedStorage fileBasedStorage = (FileBasedStorage)this.getStorage();
                File file = ((FileBasedStorage)this.getStorage()).getFile();
                if (((FileBasedStorage)this.getStorage()).isUseXmlProlog()) {
                    lineSeparator = ((FileBasedStorage)this.getStorage()).lineSeparator;
                    if (lineSeparator == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    lineSeparator = LineSeparator.LF;
                }
                fileBasedStorage.cachedVirtualFile = FileBasedStorageKt.writeFile(file, this, virtualFile, element, lineSeparator, ((FileBasedStorage)this.getStorage()).isUseXmlProlog());
            }
        }

        public FileSaveSession(@NotNull StateMap storageData, @NotNull FileBasedStorage storage2) {
            Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            super(storageData, (XmlElementStorage)storage2);
        }
    }
}

