/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.revertion.Reverter;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionProcessingProgress;
import com.intellij.history.integration.ui.views.RevisionsList;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.Consumer;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HistoryDialog<T extends HistoryDialogModel>
extends FrameWrapper {
    private static final int UPDATE_DIFFS = 1;
    private static final int UPDATE_REVS = 2;
    protected final Project myProject;
    protected final IdeaGateway myGateway;
    protected final VirtualFile myFile;
    private Splitter mySplitter;
    private RevisionsList myRevisionsList;
    private MyDiffContainer myDiffView;
    private ActionToolbar myToolBar;
    private T myModel;
    private MergingUpdateQueue myUpdateQueue;
    private boolean isUpdating;

    protected HistoryDialog(@NotNull Project project, IdeaGateway gw, VirtualFile f, boolean doInit) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/history/integration/ui/views/HistoryDialog", "<init>"));
        }
        super(project);
        this.myProject = project;
        this.myGateway = gw;
        this.myFile = f;
        this.setProject(project);
        this.setDimensionKey(this.getPropertiesKey());
        this.setImage(ImageLoader.loadFromResource((String)"/diff/Diff.png"));
        this.closeOnEsc();
        if (doInit) {
            this.init();
        }
    }

    protected void init() {
        LocalHistoryFacade facade = LocalHistoryImpl.getInstanceImpl().getFacade();
        this.myModel = this.createModel(facade);
        this.setTitle(((HistoryDialogModel)this.myModel).getTitle());
        JComponent root = this.createComponent();
        this.setComponent(root);
        this.setPreferredFocusedComponent((JComponent)(this.showRevisionsList() ? this.myRevisionsList.getComponent() : this.myDiffView));
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass() + ".revisionsUpdate", 500, true, root, (Disposable)this, null, false);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        facade.addListener(new LocalHistoryFacade.Listener(){

            @Override
            public void changeSetFinished() {
                HistoryDialog.this.scheduleRevisionsUpdate(null);
            }
        }, this);
        this.scheduleRevisionsUpdate(null);
    }

    protected void scheduleRevisionsUpdate(final @Nullable Consumer<T> configRunnable) {
        this.doScheduleUpdate(2, new Computable<Runnable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Runnable compute() {
                HistoryDialogModel historyDialogModel = HistoryDialog.this.myModel;
                synchronized (historyDialogModel) {
                    if (configRunnable != null) {
                        configRunnable.consume((Object)HistoryDialog.this.myModel);
                    }
                    HistoryDialog.this.myModel.clearRevisions();
                    HistoryDialog.this.myModel.getRevisions();
                }
                return new Runnable(){

                    @Override
                    public void run() {
                        HistoryDialog.this.myRevisionsList.updateData(HistoryDialog.this.myModel);
                    }
                };
            }
        });
    }

    protected abstract T createModel(LocalHistoryFacade var1);

    protected JComponent createComponent() {
        JPanel root = new JPanel(new BorderLayout());
        ExcludingTraversalPolicy traversalPolicy = new ExcludingTraversalPolicy(new Component[0]);
        root.setFocusTraversalPolicy((FocusTraversalPolicy)traversalPolicy);
        root.setFocusTraversalPolicyProvider(true);
        Pair<JComponent, Dimension> diffAndToolbarSize = this.createDiffPanel(root, traversalPolicy);
        this.myDiffView = new MyDiffContainer((JComponent)diffAndToolbarSize.first);
        Disposer.register((Disposable)this, (Disposable)this.myDiffView);
        JComponent revisionsSide = this.createRevisionsSide((Dimension)diffAndToolbarSize.second);
        if (this.showRevisionsList()) {
            this.mySplitter = new Splitter(false, 0.3f);
            this.mySplitter.setFirstComponent(revisionsSide);
            this.mySplitter.setSecondComponent((JComponent)((Object)this.myDiffView));
            this.restoreSplitterProportion();
            root.add((Component)this.mySplitter);
            this.setDiffBorder(IdeBorderFactory.createBorder((int)3));
        } else {
            this.setDiffBorder(IdeBorderFactory.createBorder((int)10));
            root.add((Component)((Object)this.myDiffView));
        }
        return root;
    }

    protected boolean showRevisionsList() {
        return true;
    }

    protected abstract void setDiffBorder(Border var1);

    @Override
    public void dispose() {
        this.saveSplitterProportion();
        super.dispose();
    }

    protected abstract Pair<JComponent, Dimension> createDiffPanel(JPanel var1, ExcludingTraversalPolicy var2);

    private JComponent createRevisionsSide(Dimension prefToolBarSize) {
        ActionGroup actions = this.createRevisionsActions();
        this.myToolBar = this.createRevisionsToolbar(actions);
        this.myRevisionsList = new RevisionsList(new RevisionsList.SelectionListener(){

            @Override
            public void revisionsSelected(int first, int last) {
                HistoryDialog.this.scheduleDiffUpdate((Couple<Integer>)Couple.of((Object)first, (Object)last));
            }
        });
        this.addPopupMenuToComponent(this.myRevisionsList.getComponent(), actions);
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add(this.myToolBar.getComponent());
        if (prefToolBarSize != null) {
            toolBarPanel.setPreferredSize(new Dimension(1, prefToolBarSize.height));
        }
        result2.add((Component)toolBarPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myRevisionsList.getComponent());
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)6));
        result2.add((Component)scrollPane, "Center");
        return result2;
    }

    private ActionToolbar createRevisionsToolbar(ActionGroup actions) {
        ActionManager am = ActionManager.getInstance();
        return am.createActionToolbar("unknown", actions, true);
    }

    private ActionGroup createRevisionsActions() {
        DefaultActionGroup result2 = new DefaultActionGroup();
        result2.add((AnAction)new RevertAction());
        result2.add((AnAction)new CreatePatchAction());
        result2.add((AnAction)Separator.getInstance());
        result2.add((AnAction)new ContextHelpAction(this.getHelpId()));
        return result2;
    }

    private void addPopupMenuToComponent(JComponent comp, final ActionGroup ag) {
        comp.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component c, int x, int y) {
                ActionPopupMenu m = HistoryDialog.this.createPopupMenu(ag);
                m.getComponent().show(c, x, y);
            }
        });
    }

    private ActionPopupMenu createPopupMenu(ActionGroup ag) {
        ActionManager m = ActionManager.getInstance();
        return m.createActionPopupMenu("unknown", ag);
    }

    private void scheduleDiffUpdate(final @Nullable Couple<Integer> toSelect) {
        this.doScheduleUpdate(1, new Computable<Runnable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Runnable compute() {
                HistoryDialogModel historyDialogModel = HistoryDialog.this.myModel;
                synchronized (historyDialogModel) {
                    if (toSelect == null) {
                        HistoryDialog.this.myModel.resetSelection();
                    } else {
                        HistoryDialog.this.myModel.selectRevisions((Integer)toSelect.first, (Integer)toSelect.second);
                    }
                    return HistoryDialog.this.doUpdateDiffs(HistoryDialog.this.myModel);
                }
            }
        });
    }

    private void doScheduleUpdate(int id, final Computable<Runnable> update) {
        this.myUpdateQueue.queue(new Update(this, id){

            public boolean canEat(Update update1) {
                return this.getPriority() >= update1.getPriority();
            }

            public void run() {
                if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                    return;
                }
                HistoryDialog.this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                            return;
                        }
                        HistoryDialog.this.isUpdating = true;
                        HistoryDialog.this.updateActions();
                        HistoryDialog.this.myDiffView.startUpdating();
                    }
                });
                Runnable apply = null;
                try {
                    apply = (Runnable)update.compute();
                }
                catch (Exception e) {
                    LocalHistoryLog.LOG.error((Throwable)e);
                }
                final Runnable finalApply = apply;
                HistoryDialog.this.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (this.isDisposed() || HistoryDialog.this.myProject.isDisposed()) {
                            return;
                        }
                        HistoryDialog.this.isUpdating = false;
                        if (finalApply != null) {
                            try {
                                finalApply.run();
                            }
                            catch (Exception e) {
                                LocalHistoryLog.LOG.error((Throwable)e);
                            }
                        }
                        HistoryDialog.this.updateActions();
                        HistoryDialog.this.myDiffView.finishUpdating();
                    }
                });
            }
        });
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected void updateActions() {
        if (this.showRevisionsList()) {
            this.myToolBar.updateActionsImmediately();
        }
    }

    protected abstract Runnable doUpdateDiffs(T var1);

    protected ContentDiffRequest createDifference(final FileDifferenceModel m) {
        final Ref requestRef = new Ref();
        new Task.Modal(this.myProject, LocalHistoryBundle.message("message.processing.revisions", new Object[0]), false){

            public void run(final @NotNull ProgressIndicator i) {
                if (i == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "i", "com/intellij/history/integration/ui/views/HistoryDialog$7", "run"));
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        RevisionProcessingProgressAdapter p = new RevisionProcessingProgressAdapter(i);
                        p.processingLeftRevision();
                        DiffContent left = m.getLeftDiffContent(p);
                        p.processingRightRevision();
                        DiffContent right = m.getRightDiffContent(p);
                        requestRef.set((Object)new SimpleDiffRequest(m.getTitle(), left, right, m.getLeftTitle(p), m.getRightTitle(p)));
                    }
                });
            }
        }.queue();
        return (ContentDiffRequest)requestRef.get();
    }

    private void saveSplitterProportion() {
        SplitterProportionsData d = this.createSplitterData();
        d.saveSplitterProportions((Component)this.mySplitter);
        d.externalizeToDimensionService(this.getPropertiesKey());
    }

    private void restoreSplitterProportion() {
        SplitterProportionsData d = this.createSplitterData();
        d.externalizeFromDimensionService(this.getPropertiesKey());
        d.restoreSplitterProportions((Component)this.mySplitter);
    }

    private SplitterProportionsData createSplitterData() {
        return new SplitterProportionsDataImpl();
    }

    protected String getPropertiesKey() {
        return this.getClass().getName();
    }

    protected abstract String getHelpId();

    protected void revert() {
        this.revert(((HistoryDialogModel)this.myModel).createReverter());
    }

    private boolean isRevertEnabled() {
        return ((HistoryDialogModel)this.myModel).isRevertEnabled();
    }

    protected void revert(Reverter r) {
        try {
            if (!this.askForProceeding(r)) {
                return;
            }
            List<String> errors = r.checkCanRevert();
            if (!errors.isEmpty()) {
                this.showError(LocalHistoryBundle.message("message.cannot.revert.because", this.formatErrors(errors)));
                return;
            }
            r.revert();
            this.showNotification(r.getCommandName());
        }
        catch (IOException e) {
            this.showError(LocalHistoryBundle.message("message.error.during.revert", e));
        }
    }

    private boolean askForProceeding(Reverter r) throws IOException {
        List<String> questions = r.askUserForProceeding();
        if (questions.isEmpty()) {
            return true;
        }
        return Messages.showYesNoDialog((Project)this.myProject, (String)LocalHistoryBundle.message("message.do.you.want.to.proceed", this.formatQuestions(questions)), (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) == 0;
    }

    private String formatQuestions(List<String> questions) {
        if (questions.size() == 1) {
            return questions.get(0);
        }
        String result2 = "";
        for (int i = 0; i < questions.size(); ++i) {
            result2 = result2 + (i + 1) + ") " + questions.get(i) + "\n";
        }
        return result2.substring(0, result2.length() - 1);
    }

    private void showNotification(final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Balloon b = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(title, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(3000L).setShowCallout(false).createBalloon();
                Dimension size = HistoryDialog.this.myDiffView.getSize();
                RelativePoint point = new RelativePoint((Component)((Object)HistoryDialog.this.myDiffView), new Point(size.width / 2, size.height / 2));
                b.show(point, Balloon.Position.above);
            }
        });
    }

    private String formatErrors(List<String> errors) {
        if (errors.size() == 1) {
            return errors.get(0);
        }
        String result2 = "";
        for (String e : errors) {
            result2 = result2 + "\n    -" + e;
        }
        return result2;
    }

    private boolean isCreatePatchEnabled() {
        return ((HistoryDialogModel)this.myModel).isCreatePatchEnabled();
    }

    private void createPatch() {
        try {
            if (!((HistoryDialogModel)this.myModel).canPerformCreatePatch()) {
                this.showError(LocalHistoryBundle.message("message.cannot.create.patch.because.of.unavailable.content", new Object[0]));
                return;
            }
            CreatePatchConfigurationPanel p = new CreatePatchConfigurationPanel(this.myProject);
            p.setFileName(this.getDefaultPatchFile());
            if (!this.showAsDialog(p)) {
                return;
            }
            ((HistoryDialogModel)this.myModel).createPatch(p.getFileName(), p.isReversePatch());
            this.showNotification(LocalHistoryBundle.message("message.patch.created", new Object[0]));
            ShowFilePathAction.openFile(new File(p.getFileName()));
        }
        catch (VcsException e) {
            this.showError(LocalHistoryBundle.message("message.error.during.create.patch", new Object[]{e}));
        }
        catch (IOException e) {
            this.showError(LocalHistoryBundle.message("message.error.during.create.patch", e));
        }
    }

    private File getDefaultPatchFile() {
        return FileUtil.findSequentNonexistentFile((File)new File(this.myProject.getBasePath()), (String)"local_history", (String)"patch");
    }

    private boolean showAsDialog(CreatePatchConfigurationPanel p) {
        final DialogBuilder b = new DialogBuilder(this.myProject);
        JComponent createPatchPanel = p.getPanel();
        b.setPreferredFocusComponent(IdeFocusTraversalPolicy.getPreferredFocusedComponent(createPatchPanel));
        b.setTitle(LocalHistoryBundle.message("create.patch.dialog.title", new Object[0]));
        b.setCenterPanel(createPatchPanel);
        p.installOkEnabledListener(new Consumer<Boolean>(){

            public void consume(Boolean aBoolean) {
                b.setOkActionEnabled(aBoolean.booleanValue());
            }
        });
        return b.show() == 0;
    }

    public void showError(String s) {
        Messages.showErrorDialog((Project)this.myProject, (String)s, (String)CommonBundle.getErrorTitle());
    }

    protected void showHelp() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    private static class MyDiffContainer
    extends JBLayeredPane
    implements Disposable {
        private AnimatedIcon myIcon = new AsyncProcessIcon.Big(((Object)((Object)this)).getClass().getName());
        private JComponent myContent;
        private JComponent myLoadingPanel;

        private MyDiffContainer(JComponent content) {
            this.setLayout((LayoutManager)((Object)new MyOverlayLayout()));
            this.myContent = content;
            this.myLoadingPanel = new JPanel((LayoutManager)((Object)new MyPanelLayout()));
            this.myLoadingPanel.setOpaque(false);
            this.myLoadingPanel.add((Component)this.myIcon);
            this.add(this.myContent);
            this.add(this.myLoadingPanel, JLayeredPane.POPUP_LAYER);
            this.finishUpdating();
        }

        public void dispose() {
            this.myIcon.dispose();
        }

        public void startUpdating() {
            this.myLoadingPanel.setVisible(true);
            this.myIcon.resume();
        }

        public void finishUpdating() {
            this.myIcon.suspend();
            this.myLoadingPanel.setVisible(false);
        }

        private class MyPanelLayout
        extends AbstractLayoutManager {
            private MyPanelLayout() {
            }

            public void layoutContainer(Container parent) {
                Dimension size = MyDiffContainer.this.myIcon.getPreferredSize();
                MyDiffContainer.this.myIcon.setBounds((MyDiffContainer.this.getWidth() - size.width) / 2, (MyDiffContainer.this.getHeight() - size.height) / 2, size.width, size.height);
            }

            public Dimension preferredLayoutSize(Container parent) {
                return MyDiffContainer.this.myContent.getPreferredSize();
            }
        }

        private class MyOverlayLayout
        extends AbstractLayoutManager {
            private MyOverlayLayout() {
            }

            public void layoutContainer(Container parent) {
                MyDiffContainer.this.myContent.setBounds(0, 0, MyDiffContainer.this.getWidth(), MyDiffContainer.this.getHeight());
                MyDiffContainer.this.myLoadingPanel.setBounds(0, 0, MyDiffContainer.this.getWidth(), MyDiffContainer.this.getHeight());
            }

            public Dimension preferredLayoutSize(Container parent) {
                return MyDiffContainer.this.myContent.getPreferredSize();
            }
        }
    }

    private static class RevisionProcessingProgressAdapter
    implements RevisionProcessingProgress {
        private final ProgressIndicator myIndicator;

        public RevisionProcessingProgressAdapter(ProgressIndicator i) {
            this.myIndicator = i;
        }

        @Override
        public void processingLeftRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.left.revision", new Object[0]));
        }

        @Override
        public void processingRightRevision() {
            this.myIndicator.setText(LocalHistoryBundle.message("message.processing.right.revision", new Object[0]));
        }

        @Override
        public void processed(int percentage) {
            this.myIndicator.setFraction((double)percentage / 100.0);
        }
    }

    private class CreatePatchAction
    extends MyAction {
        public CreatePatchAction() {
            super(LocalHistoryBundle.message("action.create.patch", new Object[0]), null, AllIcons.Actions.CreatePatch);
        }

        @Override
        protected void doPerform(T model) {
            HistoryDialog.this.createPatch();
        }

        @Override
        protected boolean isEnabled(T model) {
            return HistoryDialog.this.isCreatePatchEnabled();
        }
    }

    private class RevertAction
    extends MyAction {
        public RevertAction() {
            super(LocalHistoryBundle.message("action.revert", new Object[0]), null, AllIcons.Actions.Rollback);
        }

        @Override
        protected void doPerform(T model) {
            HistoryDialog.this.revert();
        }

        @Override
        protected boolean isEnabled(T model) {
            return HistoryDialog.this.isRevertEnabled();
        }
    }

    protected abstract class MyAction
    extends AnAction {
        protected MyAction(String text, String description, Icon icon) {
            super(text, description, icon);
        }

        public void actionPerformed(AnActionEvent e) {
            this.doPerform(HistoryDialog.this.myModel);
        }

        protected abstract void doPerform(T var1);

        public void update(AnActionEvent e) {
            Presentation p = e.getPresentation();
            p.setEnabled(this.isEnabled());
        }

        private boolean isEnabled() {
            return !HistoryDialog.this.isUpdating && this.isEnabled(HistoryDialog.this.myModel);
        }

        protected abstract boolean isEnabled(T var1);

        public void performIfEnabled() {
            if (this.isEnabled()) {
                this.doPerform(HistoryDialog.this.myModel);
            }
        }
    }
}

