/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class MockApplication
extends MockComponentManager
implements Application {
    private ModalityState MODALITY_STATE_NONE;
    public static int INSTANCES_CREATED = 0;

    public MockApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockApplication", "<init>"));
        }
        super(null, parentDisposable);
        ++INSTANCES_CREATED;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isEAP() {
        return false;
    }

    public boolean isDispatchThread() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public void assertReadAccessAllowed() {
    }

    public void assertWriteAccessAllowed() {
    }

    public void assertIsDispatchThread() {
    }

    public boolean isReadAccessAllowed() {
        return true;
    }

    public boolean isWriteAccessAllowed() {
        return true;
    }

    public boolean isUnitTestMode() {
        return true;
    }

    public boolean isHeadlessEnvironment() {
        return true;
    }

    public boolean isCommandLine() {
        return true;
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        Future<?> future2 = PooledThreadExecutor.INSTANCE.submit(action);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        return future2;
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(@NotNull Callable<T> action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        Future<T> future2 = PooledThreadExecutor.INSTANCE.submit(action);
        if (future2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "executeOnPooledThread"));
        }
        return future2;
    }

    public boolean isDisposeInProgress() {
        return false;
    }

    public boolean isRestartCapable() {
        return false;
    }

    public void restart() {
    }

    public void runReadAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        action.run();
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runReadAction"));
        }
        return (T)computation.compute();
    }

    public void runWriteAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        action.run();
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        if (computation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computation", "com/intellij/mock/MockApplication", "runWriteAction"));
        }
        return (T)computation.compute();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "acquireReadActionLock"));
        }
        return accessToken;
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@Nullable Class marker) {
        AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "acquireWriteActionLock"));
        }
        return accessToken;
    }

    public boolean hasWriteAction(@Nullable Class<?> actionClass) {
        return false;
    }

    public void addApplicationListener(@NotNull ApplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
    }

    public void addApplicationListener(@NotNull ApplicationListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/mock/MockApplication", "addApplicationListener"));
        }
    }

    public void removeApplicationListener(@NotNull ApplicationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockApplication", "removeApplicationListener"));
        }
    }

    public long getStartTime() {
        return 0L;
    }

    public long getIdleTime() {
        return 0L;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        if (this.MODALITY_STATE_NONE == null) {
            this.MODALITY_STATE_NONE = new ModalityStateEx(){

                @Override
                public boolean dominates(@NotNull ModalityState anotherState) {
                    if (anotherState == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherState", "com/intellij/mock/MockApplication$1", "dominates"));
                    }
                    return false;
                }

                @Override
                public String toString() {
                    return "NONE";
                }
            };
        }
        ModalityState modalityState = this.MODALITY_STATE_NONE;
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getNoneModalityState"));
        }
        return modalityState;
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    public void invokeLater(@NotNull Runnable runnable, @NotNull ModalityState state) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeLater"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/mock/MockApplication", "invokeLater"));
        }
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        throw new UnsupportedOperationException();
    }

    public void invokeAndWait(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/mock/MockApplication", "invokeAndWait"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/mock/MockApplication", "invokeAndWait"));
        }
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getCurrentModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getAnyModalityState"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/mock/MockApplication", "getModalityStateForComponent"));
        }
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getModalityStateForComponent"));
        }
        return modalityState;
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        ModalityState modalityState = this.getNoneModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockApplication", "getDefaultModalityState"));
        }
        return modalityState;
    }

    public void exit() {
    }

    public void saveAll() {
    }

    public void saveSettings() {
    }
}

