/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.bidi.BidiRegionsSeparator;
import com.intellij.openapi.editor.bidi.LanguageBidiRegionsSeparator;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.ApproximationFragment;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.impl.view.LineFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextFragment;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineLayout {
    private final BidiRun[] myBidiRunsInLogicalOrder;
    private final BidiRun[] myBidiRunsInVisualOrder;
    private final float myWidth;

    LineLayout(@NotNull EditorView view, int startOffset, int endOffset, boolean skipBidiLayout) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, startOffset, endOffset, skipBidiLayout), false);
    }

    LineLayout(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this(LineLayout.createFragments(view, text, fontStyle), true);
    }

    private LineLayout(@NotNull List<BidiRun> runs, boolean calculateWidth) {
        if (runs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runs", "com/intellij/openapi/editor/impl/view/LineLayout", "<init>"));
        }
        this.myBidiRunsInLogicalOrder = runs.toArray(new BidiRun[runs.size()]);
        this.myBidiRunsInVisualOrder = (BidiRun[])this.myBidiRunsInLogicalOrder.clone();
        LineLayout.reorderRunsVisually(this.myBidiRunsInVisualOrder);
        this.myWidth = calculateWidth ? this.calculateWidth() : -1.0f;
    }

    private static void reorderRunsVisually(BidiRun[] bidiRuns) {
        if (bidiRuns.length > 1) {
            byte[] levels = new byte[bidiRuns.length];
            for (int i = 0; i < bidiRuns.length; ++i) {
                levels[i] = bidiRuns[i].level;
            }
            Bidi.reorderVisually(levels, 0, bidiRuns, 0, levels.length);
        }
    }

    static boolean isBidiLayoutRequired(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "isBidiLayoutRequired"));
        }
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        return Bidi.requiresBidi(chars, 0, chars.length);
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, int lineStartOffset, int lineEndOffset, boolean skipBidiLayout) {
        List<BidiRun> runs;
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (lineEndOffset <= lineStartOffset) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        if (skipBidiLayout) {
            runs = Collections.singletonList(new BidiRun(0, 0, lineEndOffset - lineStartOffset));
        } else {
            CharSequence text = editor.getDocument().getImmutableCharSequence().subSequence(lineStartOffset, lineEndOffset);
            char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
            runs = LineLayout.createRuns(editor, chars, lineStartOffset);
        }
        return runs;
    }

    private static List<BidiRun> createFragments(@NotNull EditorView view, @NotNull CharSequence text, @JdkConstants.FontStyle int fontStyle) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/view/LineLayout", "createFragments"));
        }
        if (text.length() == 0) {
            return Collections.emptyList();
        }
        EditorImpl editor = view.getEditor();
        FontRenderContext fontRenderContext = view.getFontRenderContext();
        FontPreferences fontPreferences = editor.getColorsScheme().getFontPreferences();
        char[] chars = CharArrayUtil.fromSequence((CharSequence)text);
        List<BidiRun> runs = LineLayout.createRuns(editor, chars, -1);
        for (BidiRun run2 : runs) {
            for (Chunk chunk : run2.getChunks()) {
                LineLayout.addFragments(run2, chunk, chars, chunk.startOffset, chunk.endOffset, fontStyle, fontPreferences, fontRenderContext, null);
            }
        }
        return runs;
    }

    private static List<BidiRun> createRuns(EditorImpl editor, char[] text, int startOffsetInEditor) {
        int textLength = text.length;
        if (editor.myDisableRtl) {
            return Collections.singletonList(new BidiRun(0, 0, textLength));
        }
        ArrayList<BidiRun> runs = new ArrayList<BidiRun>();
        if (startOffsetInEditor >= 0) {
            int lastOffset = startOffsetInEditor;
            IElementType lastToken = null;
            HighlighterIterator iterator = editor.getHighlighter().createIterator(startOffsetInEditor);
            int endOffsetInEditor = startOffsetInEditor + textLength;
            while (!iterator.atEnd() && iterator.getStart() < endOffsetInEditor) {
                IElementType currentToken = iterator.getTokenType();
                if (LineLayout.distinctTokens(lastToken, currentToken)) {
                    int tokenStart = Math.max(iterator.getStart(), startOffsetInEditor);
                    LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, tokenStart - startOffsetInEditor);
                    lastToken = currentToken;
                    lastOffset = tokenStart;
                }
                iterator.advance();
            }
            LineLayout.addRuns(runs, text, lastOffset - startOffsetInEditor, endOffsetInEditor - startOffsetInEditor);
        } else {
            LineLayout.addRuns(runs, text, 0, textLength);
        }
        return runs;
    }

    private static boolean distinctTokens(@Nullable IElementType token1, @Nullable IElementType token2) {
        if (token1 == token2) {
            return false;
        }
        if (token1 == null || token2 == null) {
            return true;
        }
        if (!token1.getLanguage().is(token2.getLanguage())) {
            return true;
        }
        BidiRegionsSeparator separator = (BidiRegionsSeparator)LanguageBidiRegionsSeparator.INSTANCE.forLanguage(token1.getLanguage());
        return separator.createBorderBetweenTokens(token1, token2);
    }

    private static void addRuns(List<BidiRun> runs, char[] text, int start, int end) {
        int afterLastTabPosition = start;
        for (int i = start; i < end; ++i) {
            if (text[i] != '\t') continue;
            LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, i);
            afterLastTabPosition = i + 1;
            LineLayout.addOrMergeRun(runs, new BidiRun(0, i, i + 1));
        }
        LineLayout.addRunsNoTabs(runs, text, afterLastTabPosition, end);
    }

    private static void addRunsNoTabs(List<BidiRun> runs, char[] text, int start, int end) {
        if (start >= end) {
            return;
        }
        Bidi bidi = new Bidi(text, start, null, 0, end - start, -2);
        int runCount = bidi.getRunCount();
        for (int i = 0; i < runCount; ++i) {
            LineLayout.addOrMergeRun(runs, new BidiRun((byte)bidi.getRunLevel(i), start + bidi.getRunStart(i), start + bidi.getRunLimit(i)));
        }
    }

    private static void addOrMergeRun(List<BidiRun> runs, BidiRun run2) {
        int size = runs.size();
        if (size > 0 && runs.get(size - 1).level == 0 && run2.level == 0) {
            BidiRun lastRun = runs.remove(size - 1);
            assert (lastRun.endOffset == run2.startOffset);
            runs.add(new BidiRun(0, lastRun.startOffset, run2.endOffset));
        } else {
            runs.add(run2);
        }
    }

    private static void addFragments(BidiRun run2, Chunk chunk, char[] text, int start, int end, int fontStyle, FontPreferences fontPreferences, FontRenderContext fontRenderContext, @Nullable TabFragment tabFragment) {
        assert (start < end);
        Font currentFont = null;
        int currentIndex = start;
        for (int i = start; i < end; ++i) {
            char c = text[i];
            if (c == '\t' && tabFragment != null) {
                assert (run2.level == 0);
                LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i, currentFont, fontRenderContext, false);
                chunk.fragments.add(tabFragment);
                currentFont = null;
                currentIndex = i + 1;
                continue;
            }
            Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c, fontStyle, fontPreferences).getFont();
            if (font.equals(currentFont)) continue;
            LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, i, currentFont, fontRenderContext, run2.isRtl());
            currentFont = font;
            currentIndex = i;
        }
        LineLayout.addTextFragmentIfNeeded(chunk, text, currentIndex, end, currentFont, fontRenderContext, run2.isRtl());
        assert (!chunk.fragments.isEmpty());
    }

    private static void addTextFragmentIfNeeded(Chunk chunk, char[] chars, int from, int to, Font font, FontRenderContext fontRenderContext, boolean isRtl) {
        if (to > from) {
            assert (font != null);
            chunk.fragments.add(new TextFragment(chars, from, to, isRtl, font, fontRenderContext));
        }
    }

    private float calculateWidth() {
        float x = 0.0f;
        for (VisualFragment fragment : this.getFragmentsInVisualOrder(x)) {
            x = fragment.getEndX();
        }
        return x;
    }

    float getWidth() {
        if (this.myWidth < 0.0f) {
            throw new RuntimeException("This LineLayout instance doesn't have precalculated width");
        }
        return this.myWidth;
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final float startX) {
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(null, 0, startX, 0, 0, 0, LineLayout.this.myBidiRunsInVisualOrder);
            }
        };
    }

    Iterable<VisualFragment> getFragmentsInVisualOrder(final @NotNull EditorView view, final int lineStartOffset, final float startX, final int startVisualColumn, final int startOffset, int endOffset, @Nullable Runnable quickEvaluationListener) {
        BidiRun[] runs;
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout", "getFragmentsInVisualOrder"));
        }
        assert (startOffset <= endOffset);
        if (startOffset == endOffset) {
            runs = new BidiRun[]{};
        } else {
            ArrayList<BidiRun> runList = new ArrayList<BidiRun>();
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (run2.endOffset <= startOffset) continue;
                if (run2.startOffset >= endOffset) break;
                runList.add(run2.subRun(view, lineStartOffset, startOffset, endOffset, quickEvaluationListener));
            }
            runs = runList.toArray(new BidiRun[runList.size()]);
            LineLayout.reorderRunsVisually(runs);
        }
        final int startLogicalColumn = view.offsetToLogicalPosition((int)(lineStartOffset + startOffset)).column;
        return new Iterable<VisualFragment>(){

            @Override
            public Iterator<VisualFragment> iterator() {
                return new VisualOrderIterator(view, lineStartOffset, startX, startVisualColumn, startLogicalColumn, startOffset, runs);
            }
        };
    }

    boolean isLtr() {
        return this.myBidiRunsInLogicalOrder.length == 0 || this.myBidiRunsInLogicalOrder.length == 1 && !this.myBidiRunsInLogicalOrder[0].isRtl();
    }

    boolean isRtlLocation(int offset, boolean leanForward) {
        if (offset == 0 && !leanForward) {
            return false;
        }
        for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
            if (offset >= run2.endOffset && (offset != run2.endOffset || leanForward)) continue;
            return run2.isRtl();
        }
        return false;
    }

    int findNearestDirectionBoundary(int offset, boolean lookForward) {
        if (lookForward) {
            byte originLevel = -1;
            for (BidiRun run2 : this.myBidiRunsInLogicalOrder) {
                if (originLevel >= 0) {
                    if (run2.level == originLevel) continue;
                    return run2.startOffset;
                }
                if (run2.endOffset <= offset) continue;
                originLevel = run2.level;
            }
            return originLevel > 0 ? this.myBidiRunsInLogicalOrder[this.myBidiRunsInLogicalOrder.length - 1].endOffset : -1;
        }
        byte originLevel = -1;
        for (int i = this.myBidiRunsInLogicalOrder.length - 1; i >= 0; --i) {
            BidiRun run3 = this.myBidiRunsInLogicalOrder[i];
            if (originLevel >= 0) {
                if (run3.level == originLevel) continue;
                return run3.endOffset;
            }
            if (run3.startOffset >= offset) continue;
            originLevel = run3.level;
        }
        return originLevel > 0 ? 0 : -1;
    }

    static class VisualFragment {
        private LineFragment delegate;
        private int startOffset;
        private int startLogicalColumn;
        private int startVisualColumn;
        private float startX;
        private boolean isRtl;

        VisualFragment() {
        }

        boolean isRtl() {
            return this.isRtl;
        }

        int getMinOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset;
        }

        int getMaxOffset() {
            return this.isRtl ? this.startOffset : this.startOffset + this.getLength();
        }

        int getStartOffset() {
            return this.startOffset;
        }

        int getEndOffset() {
            return this.isRtl ? this.startOffset - this.getLength() : this.startOffset + this.getLength();
        }

        int getLength() {
            return this.delegate.getLength();
        }

        int getStartLogicalColumn() {
            return this.startLogicalColumn;
        }

        int getEndLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getMinLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn - this.getLogicalColumnCount() : this.startLogicalColumn;
        }

        int getMaxLogicalColumn() {
            return this.isRtl ? this.startLogicalColumn : this.startLogicalColumn + this.getLogicalColumnCount();
        }

        int getStartVisualColumn() {
            return this.startVisualColumn;
        }

        int getEndVisualColumn() {
            return this.startVisualColumn + this.getVisualColumnCount();
        }

        int getLogicalColumnCount() {
            return this.isRtl ? this.getLength() : this.delegate.getLogicalColumnCount(this.getMinLogicalColumn());
        }

        int getVisualColumnCount() {
            return this.delegate.getVisualColumnCount(this.startX);
        }

        float getStartX() {
            return this.startX;
        }

        float getEndX() {
            return this.delegate.offsetToX(this.startX, 0, this.getLength());
        }

        float getWidth() {
            return this.getEndX() - this.getStartX();
        }

        int logicalToVisualColumn(int column) {
            return this.startVisualColumn + this.delegate.logicalToVisualColumn(this.startX, this.getMinLogicalColumn(), this.isRtl ? this.startLogicalColumn - column : column - this.startLogicalColumn);
        }

        int visualToLogicalColumn(int column) {
            int relativeLogicalColumn = this.delegate.visualToLogicalColumn(this.startX, this.getMinLogicalColumn(), column - this.startVisualColumn);
            return this.isRtl ? this.startLogicalColumn - relativeLogicalColumn : this.startLogicalColumn + relativeLogicalColumn;
        }

        float offsetToX(int offset) {
            return this.delegate.offsetToX(this.startX, 0, this.getRelativeOffset(offset));
        }

        float offsetToX(float startX, int startOffset, int offset) {
            return this.delegate.offsetToX(startX, this.getRelativeOffset(startOffset), this.getRelativeOffset(offset));
        }

        int[] xToVisualColumn(float x) {
            int[] column = this.delegate.xToVisualColumn(this.startX, x);
            column[0] = column[0] + this.startVisualColumn;
            return column;
        }

        float visualColumnToX(int column) {
            return this.delegate.visualColumnToX(this.startX, column - this.startVisualColumn);
        }

        void draw(Graphics2D g, float x, float y) {
            this.delegate.draw(g, x, y, 0, this.getLength());
        }

        void draw(Graphics2D g, float x, float y, int startRelativeColumn, int endRelativeColumn) {
            this.delegate.draw(g, x, y, startRelativeColumn, endRelativeColumn);
        }

        private int getRelativeOffset(int offset) {
            return this.isRtl ? this.startOffset - offset : offset - this.startOffset;
        }
    }

    private static class VisualOrderIterator
    implements Iterator<VisualFragment> {
        private final EditorView myView;
        private final int myLineStartOffset;
        private final BidiRun[] myRuns;
        private int myRunIndex = 0;
        private int myChunkIndex = 0;
        private int myFragmentIndex = 0;
        private int myOffsetInsideRun = 0;
        private VisualFragment myFragment = new VisualFragment();

        private VisualOrderIterator(EditorView view, int lineStartOffset, float startX, int startVisualColumn, int startLogicalColumn, int startOffset, BidiRun[] runsInVisualOrder) {
            this.myView = view;
            this.myLineStartOffset = lineStartOffset;
            this.myRuns = runsInVisualOrder;
            this.myFragment.startX = startX;
            this.myFragment.startVisualColumn = startVisualColumn;
            this.myFragment.startLogicalColumn = startLogicalColumn;
            this.myFragment.startOffset = startOffset;
        }

        @Override
        public boolean hasNext() {
            if (this.myRunIndex >= this.myRuns.length) {
                return false;
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            Chunk[] chunks = run2.getChunks();
            if (this.myChunkIndex >= chunks.length) {
                return false;
            }
            Chunk chunk = chunks[run2.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            if (this.myView != null) {
                chunk.ensureLayout(this.myView, run2, this.myLineStartOffset);
            }
            return this.myFragmentIndex < chunk.fragments.size();
        }

        @Override
        public VisualFragment next() {
            VisualFragment visualFragment;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BidiRun run2 = this.myRuns[this.myRunIndex];
            if (this.myRunIndex == 0 && this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                visualFragment = this.myFragment;
                visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run2.isRtl() ? run2.endOffset : run2.startOffset) - this.myFragment.startOffset);
            } else {
                this.myFragment.startLogicalColumn = this.myFragment.getEndLogicalColumn();
                if (this.myChunkIndex == 0 && this.myFragmentIndex == 0) {
                    visualFragment = this.myFragment;
                    visualFragment.startLogicalColumn = visualFragment.startLogicalColumn + ((run2.isRtl() ? run2.endOffset : run2.startOffset) - this.myFragment.getEndOffset());
                }
                this.myFragment.startVisualColumn = this.myFragment.getEndVisualColumn();
                this.myFragment.startX = this.myFragment.getEndX();
            }
            this.myFragment.isRtl = run2.isRtl();
            Chunk[] chunks = run2.getChunks();
            Chunk chunk = chunks[run2.isRtl() ? chunks.length - 1 - this.myChunkIndex : this.myChunkIndex];
            assert (!chunk.fragments.isEmpty());
            this.myFragment.delegate = chunk.fragments.get(run2.isRtl() ? chunk.fragments.size() - 1 - this.myFragmentIndex : this.myFragmentIndex);
            this.myFragment.startOffset = run2.isRtl() ? run2.endOffset - this.myOffsetInsideRun : run2.startOffset + this.myOffsetInsideRun;
            this.myOffsetInsideRun += this.myFragment.getLength();
            ++this.myFragmentIndex;
            if (this.myFragmentIndex >= chunk.fragments.size()) {
                this.myFragmentIndex = 0;
                ++this.myChunkIndex;
                if (this.myChunkIndex >= chunks.length) {
                    this.myChunkIndex = 0;
                    this.myOffsetInsideRun = 0;
                    ++this.myRunIndex;
                }
            }
            return this.myFragment;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ApproximationChunk
    extends Chunk {
        private ApproximationChunk(@NotNull EditorView view, int lineStartOffset, int start, int end) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$ApproximationChunk", "<init>"));
            }
            super(start, end);
            int startColumn = view.offsetToLogicalPosition((int)(lineStartOffset + start)).column;
            int endColumn = view.offsetToLogicalPosition((int)(lineStartOffset + end)).column;
            this.fragments.add(new ApproximationFragment(end - start, endColumn - startColumn, view.getMaxCharWidth()));
        }

        @Override
        boolean isReal() {
            return false;
        }
    }

    static class Chunk {
        final List<LineFragment> fragments = new ArrayList<LineFragment>();
        private int startOffset;
        private int endOffset;

        private Chunk(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private void ensureLayout(@NotNull EditorView view, BidiRun run2, int lineStartOffset) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$Chunk", "ensureLayout"));
            }
            if (this.isReal()) {
                view.getTextLayoutCache().onChunkAccess(this);
            }
            if (!this.fragments.isEmpty()) {
                return;
            }
            int start = lineStartOffset + this.startOffset;
            int end = lineStartOffset + this.endOffset;
            IterationState it = new IterationState(view.getEditor(), start, end, false, false, false, false);
            FontPreferences fontPreferences = view.getEditor().getColorsScheme().getFontPreferences();
            char[] chars = CharArrayUtil.fromSequence((CharSequence)view.getEditor().getDocument().getImmutableCharSequence(), (int)start, (int)end);
            while (!it.atEnd()) {
                LineLayout.addFragments(run2, this, chars, it.getStartOffset() - start, it.getEndOffset() - start, it.getMergedAttributes().getFontType(), fontPreferences, view.getFontRenderContext(), view.getTabFragment());
                it.advance();
            }
            view.getSizeManager().textLayoutPerformed(start, end);
            assert (!this.fragments.isEmpty());
        }

        private Chunk subChunk(EditorView view, BidiRun run2, int lineStartOffset, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            if (quickEvaluationListener != null && this.fragments.isEmpty()) {
                quickEvaluationListener.run();
                return new ApproximationChunk(view, lineStartOffset, start, end);
            }
            if (start == this.startOffset && end == this.endOffset) {
                return this;
            }
            this.ensureLayout(view, run2, lineStartOffset);
            Chunk chunk = new Chunk(start, end);
            int offset = this.startOffset;
            for (LineFragment fragment : this.fragments) {
                if (end <= offset) break;
                int endOffset = offset + fragment.getLength();
                if (start < endOffset) {
                    chunk.fragments.add(fragment.subFragment(Math.max(start, offset) - offset, Math.min(end, endOffset) - offset));
                }
                offset = endOffset;
            }
            return chunk;
        }

        boolean isReal() {
            return true;
        }

        void clearCache() {
            this.fragments.clear();
        }
    }

    private static class BidiRun {
        private static final int CHUNK_CHARACTERS = 1024;
        private final byte level;
        private final int startOffset;
        private final int endOffset;
        private Chunk[] chunks;

        private BidiRun(byte level, int startOffset, int endOffset) {
            this.level = level;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isRtl() {
            return (this.level & 1) != 0;
        }

        private Chunk[] getChunks() {
            if (this.chunks == null) {
                int chunkCount = (this.endOffset - this.startOffset + 1024 - 1) / 1024;
                this.chunks = new Chunk[chunkCount];
                for (int i = 0; i < chunkCount; ++i) {
                    Chunk chunk;
                    int from = this.startOffset + i * 1024;
                    int to = i == chunkCount - 1 ? this.endOffset : from + 1024;
                    this.chunks[i] = chunk = new Chunk(from, to);
                }
            }
            return this.chunks;
        }

        private BidiRun subRun(@NotNull EditorView view, int lineStartOffset, int targetStartOffset, int targetEndOffset, @Nullable Runnable quickEvaluationListener) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/openapi/editor/impl/view/LineLayout$BidiRun", "subRun"));
            }
            assert (targetStartOffset < this.endOffset);
            assert (targetEndOffset > this.startOffset);
            int start = Math.max(this.startOffset, targetStartOffset);
            int end = Math.min(this.endOffset, targetEndOffset);
            BidiRun subRun = new BidiRun(this.level, start, end);
            ArrayList<Chunk> subChunks = new ArrayList<Chunk>();
            for (Chunk chunk : this.getChunks()) {
                if (chunk.endOffset <= start) continue;
                if (chunk.startOffset >= end) break;
                subChunks.add(chunk.subChunk(view, this, lineStartOffset, start, end, quickEvaluationListener));
            }
            subRun.chunks = subChunks.toArray(new Chunk[subChunks.size()]);
            return subRun;
        }
    }
}

