/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483646)
public class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDataService.class.getName()));
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = new NotNullFunction<String, File>(){

        @NotNull
        public File fun(String path) {
            File file = new File(path);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "fun"));
            }
            return file;
        }
    };
    @NotNull
    private final ExternalLibraryPathTypeMapper myLibraryPathTypeMapper;

    public LibraryDataService(@NotNull ExternalLibraryPathTypeMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "<init>"));
        }
        this.myLibraryPathTypeMapper = mapper;
    }

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importData"));
        }
        for (DataNode<LibraryData> dataNode : toImport) {
            this.importLibrary((LibraryData)dataNode.getData(), modelsProvider);
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        String libraryName = toImport.getInternalName();
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library != null) {
            this.syncPaths(toImport, library, modelsProvider);
            return;
        }
        this.importLibrary(libraryName, libraryFiles, modelsProvider);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        HashMap result2 = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths = data.getPaths(pathType);
            if (paths.isEmpty()) continue;
            result2.put(this.myLibraryPathTypeMapper.map(pathType), ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        HashMap hashMap = result2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "prepareLibraryFiles"));
        }
        return hashMap;
    }

    private void importLibrary(@NotNull String libraryName, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "importLibrary"));
        }
        Library library = modelsProvider.createLibrary(libraryName);
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        this.registerPaths(libraryFiles, libraryModel, libraryName);
    }

    public void registerPaths(@NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Library.ModifiableModel model, @NotNull String libraryName) {
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "registerPaths"));
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file : entry.getValue()) {
                VirtualFile virtualFile = ExternalSystemUtil.refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file)), (String[])(urls = model.getUrls(entry.getKey())))) continue;
                    model.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files = model.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files)) continue;
                    model.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files = model.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files)) continue;
                model.addRoot(root, entry.getKey());
            }
        }
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "postProcess"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "postProcess"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "postProcess"));
        }
        if (projectData == null) {
            return;
        }
        if (modelsProvider instanceof IdeUIModifiableModelsProvider) {
            return;
        }
        List orphanIdeLibraries = ContainerUtil.newSmartList();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)projectData.getOwner()) || !LibraryDataService.isOrphanProjectLibrary(library, modelsProvider)) continue;
            orphanIdeLibraries.add(library);
        }
        for (Library library : orphanIdeLibraries) {
            Library libraryToRemove;
            String libraryName = library.getName();
            if (libraryName == null || (libraryToRemove = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(libraryToRemove);
        }
    }

    private void syncPaths(@NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (externalLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (ideLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideLibrary", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "syncPaths"));
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        HashMap toRemove = ContainerUtilRt.newHashMap();
        HashMap toAdd = ContainerUtilRt.newHashMap();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = this.myLibraryPathTypeMapper.map(pathType);
            HashSet toAddPerType = ContainerUtilRt.newHashSet((Iterable)externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            HashSet toRemovePerType = ContainerUtilRt.newHashSet();
            toRemove.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
        for (Map.Entry entry : toRemove.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                libraryModel.removeRoot(path, (OrderRootType)entry.getKey());
            }
        }
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap roots = ContainerUtilRt.newHashMap();
            roots.put(entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
            this.registerPaths(roots, libraryModel, externalLibrary.getInternalName());
        }
    }

    private static boolean isOrphanProjectLibrary(final @NotNull Library library, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "isOrphanProjectLibrary"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService", "isOrphanProjectLibrary"));
        }
        RootPolicy<Boolean> visitor = new RootPolicy<Boolean>(){

            public Boolean visitLibraryOrderEntry(LibraryOrderEntry ideDependency, Boolean value) {
                return !ideDependency.isModuleLevel() && library == ideDependency.getLibrary();
            }
        };
        for (Module module : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
                if (!((Boolean)entry.accept((RootPolicy)visitor, (Object)false)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }
}

