/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.roots.ui.componentsList.layout.VerticalStackLayout;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditorListenerAdapter;
import com.intellij.openapi.roots.ui.configuration.ContentEntryTreeEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CommonContentEntriesEditor
extends ModuleElementsEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.ContentEntriesEditor");
    public static final String NAME = ProjectBundle.message((String)"module.paths.title", (Object[])new Object[0]);
    private static final Color BACKGROUND_COLOR = UIUtil.getListBackground();
    protected ContentEntryTreeEditor myRootTreeEditor;
    private MyContentEntryEditorListener myContentEntryEditorListener;
    protected JPanel myEditorsPanel;
    protected final Map<String, ContentEntryEditor> myEntryToEditorMap = new HashMap<String, ContentEntryEditor>();
    private String mySelectedEntryUrl;
    private VirtualFile myLastSelectedDir = null;
    private final String myModuleName;
    private final ModulesProvider myModulesProvider;
    private final ModuleConfigurationState myState;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers = new ArrayList();

    public CommonContentEntriesEditor(String moduleName, final ModuleConfigurationState state, JpsModuleSourceRootType<?> ... rootTypes) {
        super(state);
        this.myState = state;
        this.myModuleName = moduleName;
        this.myModulesProvider = state.getModulesProvider();
        for (JpsModuleSourceRootType<?> type : rootTypes) {
            ContainerUtil.addIfNotNull(this.myEditHandlers, ModuleSourceRootEditHandler.getEditHandler(type));
        }
        final VirtualFileManagerAdapter fileManagerListener = new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                if (state.getProject().isDisposed()) {
                    return;
                }
                Module module = CommonContentEntriesEditor.this.getModule();
                if (module == null || module.isDisposed()) {
                    return;
                }
                for (ContentEntryEditor editor : CommonContentEntriesEditor.this.myEntryToEditorMap.values()) {
                    editor.update();
                }
            }
        };
        final VirtualFileManager fileManager = VirtualFileManager.getInstance();
        fileManager.addVirtualFileManagerListener((VirtualFileManagerListener)fileManagerListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                fileManager.removeVirtualFileManagerListener((VirtualFileManagerListener)fileManagerListener);
            }
        });
    }

    @Override
    protected ModifiableRootModel getModel() {
        return this.myState.getRootModel();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.sources";
    }

    public String getDisplayName() {
        return NAME;
    }

    protected final List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    @Override
    public void disposeUIResources() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.setContentEntryEditor(null);
        }
        this.myEntryToEditorMap.clear();
        super.disposeUIResources();
    }

    @Override
    public JPanel createComponentImpl() {
        ContentEntry[] contentEntries;
        ModifiableRootModel model;
        Module module = this.getModule();
        Project project = module.getProject();
        this.myContentEntryEditorListener = new MyContentEntryEditorListener();
        JPanel mainPanel = new JPanel(new BorderLayout());
        if (!Registry.is((String)"ide.new.project.settings")) {
            mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        }
        this.addAdditionalSettingsToPanel(mainPanel);
        JPanel entriesPanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        AddContentEntryAction action = new AddContentEntryAction();
        action.registerCustomShortcutSet(67, 512, mainPanel);
        group.add((AnAction)action);
        this.myEditorsPanel = new ScrollablePanel(new VerticalStackLayout());
        this.myEditorsPanel.setBackground(BACKGROUND_COLOR);
        JScrollPane myScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEditorsPanel, (boolean)Registry.is((String)"ide.new.project.settings"));
        ToolbarPanel toolbarPanel = new ToolbarPanel((JComponent)myScrollPane, (ActionGroup)group);
        if (Registry.is((String)"ide.new.project.settings")) {
            toolbarPanel.setBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        }
        entriesPanel.add((Component)toolbarPanel, "Center");
        OnePixelSplitter splitter = Registry.is((String)"ide.new.project.settings") ? new OnePixelSplitter(false) : new JBSplitter(false);
        splitter.setProportion(0.6f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myRootTreeEditor = this.createContentEntryTreeEditor(project);
        JComponent component = this.myRootTreeEditor.createComponent();
        if (Registry.is((String)"ide.new.project.settings")) {
            component.setBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        }
        splitter.setFirstComponent(component);
        splitter.setSecondComponent((JComponent)entriesPanel);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        if (!Registry.is((String)"ide.new.project.settings")) {
            contentPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.myRootTreeEditor.getEditingActionsGroup(), true);
        contentPanel.add((Component)new JLabel("Mark as:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        contentPanel.add((Component)actionToolbar.getComponent(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPanel.add((Component)splitter, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)contentPanel, "Center");
        JPanel innerPanel = this.createBottomControl(module);
        if (innerPanel != null) {
            mainPanel.add((Component)innerPanel, "South");
        }
        if ((model = this.getModel()) != null && (contentEntries = model.getContentEntries()).length > 0) {
            for (ContentEntry contentEntry : contentEntries) {
                this.addContentEntryPanel(contentEntry.getUrl());
            }
            this.selectContentEntry(contentEntries[0].getUrl());
        }
        return mainPanel;
    }

    @Nullable
    protected JPanel createBottomControl(Module module) {
        return null;
    }

    protected ContentEntryTreeEditor createContentEntryTreeEditor(Project project) {
        return new ContentEntryTreeEditor(project, this.myEditHandlers);
    }

    protected void addAdditionalSettingsToPanel(JPanel mainPanel) {
    }

    protected Module getModule() {
        return this.myModulesProvider.getModule(this.myModuleName);
    }

    protected void addContentEntryPanel(String contentEntry) {
        final ContentEntryEditor contentEntryEditor = this.createContentEntryEditor(contentEntry);
        contentEntryEditor.initUI();
        contentEntryEditor.addContentEntryEditorListener(this.myContentEntryEditorListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                contentEntryEditor.removeContentEntryEditorListener(CommonContentEntriesEditor.this.myContentEntryEditorListener);
            }
        });
        this.myEntryToEditorMap.put(contentEntry, contentEntryEditor);
        Border border = BorderFactory.createEmptyBorder(2, 2, 0, 2);
        JComponent component = contentEntryEditor.getComponent();
        Border componentBorder = component.getBorder();
        if (componentBorder != null) {
            border = BorderFactory.createCompoundBorder(border, componentBorder);
        }
        if (Registry.is((String)"ide.new.project.settings")) {
            component.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            component.setBorder(border);
        }
        this.myEditorsPanel.add(component);
    }

    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new ContentEntryEditor(contentEntryUrl, this.myEditHandlers){

            @Override
            protected ModifiableRootModel getModel() {
                return CommonContentEntriesEditor.this.getModel();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectContentEntry(String contentEntryUrl) {
        if (this.mySelectedEntryUrl != null && this.mySelectedEntryUrl.equals(contentEntryUrl)) {
            return;
        }
        try {
            ContentEntryEditor editor;
            if (this.mySelectedEntryUrl != null && (editor = this.myEntryToEditorMap.get(this.mySelectedEntryUrl)) != null) {
                editor.setSelected(false);
            }
            if (contentEntryUrl != null && (editor = this.myEntryToEditorMap.get(contentEntryUrl)) != null) {
                editor.setSelected(true);
                final JComponent component = editor.getComponent();
                final JComponent scroller = (JComponent)component.getParent();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        scroller.scrollRectToVisible(component.getBounds());
                    }
                });
                this.myRootTreeEditor.setContentEntryEditor(editor);
                this.myRootTreeEditor.requestFocus();
            }
        }
        finally {
            this.mySelectedEntryUrl = contentEntryUrl;
        }
    }

    @Override
    public void moduleStateChanged() {
        if (this.myRootTreeEditor != null) {
            this.myRootTreeEditor.update();
        }
    }

    @Nullable
    private String getNextContentEntry(String contentEntryUrl) {
        return this.getAdjacentContentEntry(contentEntryUrl, 1);
    }

    @Nullable
    private String getAdjacentContentEntry(String contentEntryUrl, int delta) {
        ContentEntry[] contentEntries = this.getModel().getContentEntries();
        for (int idx = 0; idx < contentEntries.length; ++idx) {
            ContentEntry entry = contentEntries[idx];
            if (!contentEntryUrl.equals(entry.getUrl())) continue;
            int nextEntryIndex = (idx + delta) % contentEntries.length;
            if (nextEntryIndex < 0) {
                nextEntryIndex += contentEntries.length;
            }
            return nextEntryIndex == idx ? null : contentEntries[nextEntryIndex].getUrl();
        }
        return null;
    }

    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        ArrayList<ContentEntry> contentEntries = new ArrayList<ContentEntry>();
        for (VirtualFile file : files) {
            if (this.isAlreadyAdded(file)) continue;
            ContentEntry contentEntry = this.getModel().addContentEntry(file);
            contentEntries.add(contentEntry);
        }
        return contentEntries;
    }

    private boolean isAlreadyAdded(VirtualFile file) {
        VirtualFile[] contentRoots;
        for (VirtualFile contentRoot : contentRoots = this.getModel().getContentRoots()) {
            if (!contentRoot.equals(file)) continue;
            return true;
        }
        return false;
    }

    public void saveData() {
    }

    protected void addContentEntryPanels(ContentEntry[] contentEntriesArray) {
        for (ContentEntry contentEntry : contentEntriesArray) {
            this.addContentEntryPanel(contentEntry.getUrl());
        }
        this.myEditorsPanel.revalidate();
        this.myEditorsPanel.repaint();
        this.selectContentEntry(contentEntriesArray[contentEntriesArray.length - 1].getUrl());
    }

    private class AddContentEntryAction
    extends IconWithTextAction
    implements DumbAware {
        private final FileChooserDescriptor myDescriptor;

        public AddContentEntryAction() {
            super(ProjectBundle.message((String)"module.paths.add.content.action", (Object[])new Object[0]), ProjectBundle.message((String)"module.paths.add.content.action.description", (Object[])new Object[0]), AllIcons.Modules.AddContentEntry);
            this.myDescriptor = new FileChooserDescriptor(false, true, true, false, true, true){

                public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                    AddContentEntryAction.this.validateContentEntriesCandidates(files);
                }
            };
            this.myDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CommonContentEntriesEditor.this.getModule());
            this.myDescriptor.setTitle(ProjectBundle.message((String)"module.paths.add.content.title", (Object[])new Object[0]));
            this.myDescriptor.setDescription(ProjectBundle.message((String)"module.paths.add.content.prompt", (Object[])new Object[0]));
            this.myDescriptor.putUserData(FileChooserKeys.DELETE_ACTION_AVAILABLE, (Object)false);
        }

        public void actionPerformed(AnActionEvent e) {
            FileChooser.chooseFiles((FileChooserDescriptor)this.myDescriptor, (Project)CommonContentEntriesEditor.this.myProject, (VirtualFile)CommonContentEntriesEditor.this.myLastSelectedDir, (Consumer)new Consumer<List<VirtualFile>>(){

                public void consume(List<VirtualFile> files) {
                    CommonContentEntriesEditor.this.myLastSelectedDir = files.get(0);
                    CommonContentEntriesEditor.this.addContentEntries(VfsUtilCore.toVirtualFileArray(files));
                }
            });
        }

        @Nullable
        private ContentEntry getContentEntry(String url) {
            ContentEntry[] entries;
            for (ContentEntry entry : entries = CommonContentEntriesEditor.this.getModel().getContentEntries()) {
                if (!entry.getUrl().equals(url)) continue;
                return entry;
            }
            return null;
        }

        private void validateContentEntriesCandidates(VirtualFile[] files) throws Exception {
            for (VirtualFile file : files) {
                Module[] modules;
                for (String contentEntryUrl : CommonContentEntriesEditor.this.myEntryToEditorMap.keySet()) {
                    VirtualFile contentEntryFile;
                    ContentEntry contentEntry = this.getContentEntry(contentEntryUrl);
                    if (contentEntry == null || (contentEntryFile = contentEntry.getFile()) == null) continue;
                    if (contentEntryFile.equals(file)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.already.exists.error", (Object[])new Object[]{file.getPresentableUrl()}));
                    }
                    if (VfsUtilCore.isAncestor((VirtualFile)contentEntryFile, (VirtualFile)file, (boolean)true)) {
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.intersect.error", (Object[])new Object[]{file.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                    }
                    if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)contentEntryFile, (boolean)true)) continue;
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.dominate.error", (Object[])new Object[]{file.getPresentableUrl(), contentEntryFile.getPresentableUrl()}));
                }
                for (Module module : modules = CommonContentEntriesEditor.this.myModulesProvider.getModules()) {
                    VirtualFile[] moduleContentRoots;
                    if (CommonContentEntriesEditor.this.myModuleName.equals(module.getName())) continue;
                    ModuleRootModel rootModel = CommonContentEntriesEditor.this.myModulesProvider.getRootModel(module);
                    LOG.assertTrue(rootModel != null);
                    for (VirtualFile moduleContentRoot : moduleContentRoots = rootModel.getContentRoots()) {
                        if (!file.equals(moduleContentRoot)) continue;
                        throw new Exception(ProjectBundle.message((String)"module.paths.add.content.duplicate.error", (Object[])new Object[]{file.getPresentableUrl(), module.getName()}));
                    }
                }
            }
        }
    }

    private final class MyContentEntryEditorListener
    extends ContentEntryEditorListenerAdapter {
        private MyContentEntryEditorListener() {
        }

        @Override
        public void editingStarted(@NotNull ContentEntryEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$MyContentEntryEditorListener", "editingStarted"));
            }
            CommonContentEntriesEditor.this.selectContentEntry(editor.getContentEntryUrl());
        }

        @Override
        public void beforeEntryDeleted(@NotNull ContentEntryEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$MyContentEntryEditorListener", "beforeEntryDeleted"));
            }
            String entryUrl = editor.getContentEntryUrl();
            if (CommonContentEntriesEditor.this.mySelectedEntryUrl != null && CommonContentEntriesEditor.this.mySelectedEntryUrl.equals(entryUrl)) {
                CommonContentEntriesEditor.this.myRootTreeEditor.setContentEntryEditor(null);
            }
            String nextContentEntryUrl = CommonContentEntriesEditor.this.getNextContentEntry(entryUrl);
            this.removeContentEntryPanel(entryUrl);
            CommonContentEntriesEditor.this.selectContentEntry(nextContentEntryUrl);
            editor.removeContentEntryEditorListener(this);
        }

        @Override
        public void navigationRequested(@NotNull ContentEntryEditor editor, VirtualFile file) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/ui/configuration/CommonContentEntriesEditor$MyContentEntryEditorListener", "navigationRequested"));
            }
            if (CommonContentEntriesEditor.this.mySelectedEntryUrl != null && CommonContentEntriesEditor.this.mySelectedEntryUrl.equals(editor.getContentEntryUrl())) {
                CommonContentEntriesEditor.this.myRootTreeEditor.requestFocus();
                CommonContentEntriesEditor.this.myRootTreeEditor.select(file);
            } else {
                CommonContentEntriesEditor.this.selectContentEntry(editor.getContentEntryUrl());
                CommonContentEntriesEditor.this.myRootTreeEditor.requestFocus();
                CommonContentEntriesEditor.this.myRootTreeEditor.select(file);
            }
        }

        private void removeContentEntryPanel(String contentEntryUrl) {
            ContentEntryEditor editor = CommonContentEntriesEditor.this.myEntryToEditorMap.get(contentEntryUrl);
            if (editor != null) {
                CommonContentEntriesEditor.this.myEditorsPanel.remove(editor.getComponent());
                CommonContentEntriesEditor.this.myEntryToEditorMap.remove(contentEntryUrl);
                CommonContentEntriesEditor.this.myEditorsPanel.revalidate();
                CommonContentEntriesEditor.this.myEditorsPanel.repaint();
            }
        }
    }
}

