/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.ui.AdditionalLocalChangeActionsInstaller;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserExtender;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.SelectedListChangeListener;
import com.intellij.ui.ColoredListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleChangeListBrowser
extends ChangesBrowser {
    private final ChangeListChooser myChangeListChooser;
    private final ChangeListListener myChangeListListener = new MyChangeListListener();
    private final boolean myShowingAllChangeLists;
    private final EventDispatcher<SelectedListChangeListener> myDispatcher = EventDispatcher.create(SelectedListChangeListener.class);
    private final ChangesBrowserExtender myExtender;
    private final Disposable myParentDisposable;
    private final Runnable myRebuildListListener;
    private Collection<Change> myAllChanges;
    private Map<Change, LocalChangeList> myChangeListsMap;
    private boolean myInRebuildList;

    public MultipleChangeListBrowser(Project project, List<? extends ChangeList> changeLists, List<Change> changes, Disposable parentDisposable, ChangeList initialListSelection, boolean capableOfExcludingChanges, boolean highlightProblems, Runnable rebuildListListener, @Nullable Runnable inclusionListener, AnAction ... additionalActions) {
        super(project, changeLists, changes, initialListSelection, capableOfExcludingChanges, highlightProblems, inclusionListener, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myParentDisposable = parentDisposable;
        this.myRebuildListListener = rebuildListListener;
        this.myChangeListChooser = new ChangeListChooser(changeLists);
        this.myHeaderPanel.add((Component)this.myChangeListChooser, "East");
        this.myShowingAllChangeLists = Comparing.haveEqualElements(changeLists, (Collection)ChangeListManager.getInstance((Project)project).getChangeLists());
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener(this.myChangeListListener);
        this.myExtender = new Extender(project, this, additionalActions);
        ActionManager actionManager = ActionManager.getInstance();
        final AnAction moveAction = actionManager.getAction("ChangesView.Move");
        actionManager.addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                if (moveAction.equals(action)) {
                    MultipleChangeListBrowser.this.rebuildList();
                }
            }
        }, this.myParentDisposable);
    }

    @Override
    protected void setInitialSelection(List<? extends ChangeList> changeLists, List<Change> changes, ChangeList initialListSelection) {
        this.myAllChanges = new ArrayList<Change>();
        this.mySelectedChangeList = initialListSelection;
        block0: for (ChangeList changeList : changeLists) {
            if (!(changeList instanceof LocalChangeList)) continue;
            this.myAllChanges.addAll(changeList.getChanges());
            if (initialListSelection != null) continue;
            for (Change c : changeList.getChanges()) {
                if (!changes.contains(c)) continue;
                this.mySelectedChangeList = changeList;
                continue block0;
            }
        }
        if (this.mySelectedChangeList == null) {
            for (ChangeList changeList : changeLists) {
                if (!(changeList instanceof LocalChangeList) || !((LocalChangeList)changeList).isDefault()) continue;
                this.mySelectedChangeList = changeList;
                break;
            }
            if (this.mySelectedChangeList == null && !changeLists.isEmpty()) {
                this.mySelectedChangeList = changeLists.get(0);
            }
        }
    }

    @Override
    public void dispose() {
        ChangeListManager.getInstance((Project)this.myProject).removeChangeListListener(this.myChangeListListener);
    }

    public Collection<Change> getAllChanges() {
        return this.myAllChanges;
    }

    public ChangesBrowserExtender getExtender() {
        return this.myExtender;
    }

    public void addSelectedListChangeListener(SelectedListChangeListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeSelectedListChangeListener(SelectedListChangeListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    private void setSelectedList(ChangeList list) {
        this.mySelectedChangeList = list;
        this.rebuildList();
        ((SelectedListChangeListener)this.myDispatcher.getMulticaster()).selectedListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildList() {
        if (this.myInRebuildList) {
            return;
        }
        try {
            this.myInRebuildList = true;
            if (this.myChangesToDisplay == null) {
                ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
                this.myChangeListsMap = new HashMap<Change, LocalChangeList>();
                List lists = manager.getChangeListsCopy();
                ArrayList<Change> allChanges = new ArrayList<Change>();
                for (LocalChangeList list : lists) {
                    Collection changes = list.getChanges();
                    allChanges.addAll(changes);
                    for (Change change : changes) {
                        this.myChangeListsMap.put(change, list);
                    }
                }
                this.myAllChanges = allChanges;
                this.updateListsInChooser();
            }
            super.rebuildList();
            if (this.myRebuildListListener != null) {
                this.myRebuildListListener.run();
            }
        }
        finally {
            this.myInRebuildList = false;
        }
    }

    @Override
    public List<Change> getCurrentDisplayedChanges() {
        if (this.myChangesToDisplay == null) {
            return this.sortChanges(this.filterBySelectedChangeList(this.myAllChanges));
        }
        return super.getCurrentDisplayedChanges();
    }

    @NotNull
    public List<Change> getCurrentIncludedChanges() {
        List<Change> list = this.filterBySelectedChangeList(this.myViewer.getIncludedChanges());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getCurrentIncludedChanges"));
        }
        return list;
    }

    @NotNull
    public Collection<Change> getChangesIncludedInAllLists() {
        Collection<Change> collection = this.myViewer.getIncludedChanges();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/MultipleChangeListBrowser", "getChangesIncludedInAllLists"));
        }
        return collection;
    }

    private List<Change> filterBySelectedChangeList(Collection<Change> changes) {
        ArrayList<Change> filtered = new ArrayList<Change>();
        for (Change change : changes) {
            if (!Comparing.equal((Object)this.getList(change), (Object)this.mySelectedChangeList)) continue;
            filtered.add(change);
        }
        return filtered;
    }

    private ChangeList getList(Change change) {
        return (ChangeList)this.myChangeListsMap.get(change);
    }

    @Override
    protected void buildToolBar(DefaultActionGroup toolBarGroup) {
        super.buildToolBar(toolBarGroup);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction moveAction = actionManager.getAction("ChangesView.Move");
        moveAction.registerCustomShortcutSet(CommonShortcuts.getMove(), (JComponent)this.myViewer);
        toolBarGroup.add(moveAction);
    }

    @Override
    protected List<AnAction> createDiffActions() {
        List<AnAction> actions = super.createDiffActions();
        actions.add(new MoveAction());
        return actions;
    }

    private void updateListsInChooser() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (MultipleChangeListBrowser.this.myChangeListChooser != null && MultipleChangeListBrowser.this.myShowingAllChangeLists) {
                    MultipleChangeListBrowser.this.myChangeListChooser.updateLists(ChangeListManager.getInstance((Project)MultipleChangeListBrowser.this.myProject).getChangeListsCopy());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)this));
        }
    }

    private class MoveAction
    extends MoveChangesToAnotherListAction {
        private MoveAction() {
        }

        @Override
        protected boolean isEnabled(AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (change == null) {
                return false;
            }
            return super.isEnabled(e);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            MoveAction.askAndMove(MultipleChangeListBrowser.this.myProject, Collections.singletonList(change), null);
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListAdded(ChangeList list) {
            MultipleChangeListBrowser.this.updateListsInChooser();
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_LEN = 35;
        private final JComboBox myChooser;

        public ChangeListChooser(List<? extends ChangeList> lists) {
            super(new BorderLayout(4, 2));
            this.myChooser = new JComboBox();
            this.myChooser.setRenderer(new ColoredListCellRendererWrapper<LocalChangeList>(){

                protected void doCustomize(JList list, LocalChangeList value, int index, boolean selected, boolean hasFocus) {
                    if (value != null) {
                        String name = value.getName().trim();
                        if (name.length() > 35) {
                            name = name.substring(0, 32) + "...";
                        }
                        this.append(name, value.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LocalChangeList changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem();
                        MultipleChangeListBrowser.this.setSelectedList((ChangeList)changeList);
                        ChangeListChooser.this.myChooser.setToolTipText(changeList == null ? "" : changeList.getName());
                    }
                }
            });
            this.updateLists(lists);
            this.myChooser.setEditable(false);
            this.add((Component)this.myChooser, "Center");
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setLabelFor(this.myChooser);
            this.add((Component)label, "West");
        }

        public void updateLists(List<? extends ChangeList> lists) {
            this.myChooser.setModel(new DefaultComboBoxModel<Object>(lists.toArray()));
            this.myChooser.setEnabled(lists.size() > 1);
            if (lists.contains(MultipleChangeListBrowser.this.mySelectedChangeList)) {
                this.myChooser.setSelectedItem(MultipleChangeListBrowser.this.mySelectedChangeList);
            } else if (this.myChooser.getItemCount() > 0) {
                this.myChooser.setSelectedIndex(0);
            }
            MultipleChangeListBrowser.this.mySelectedChangeList = (ChangeList)this.myChooser.getSelectedItem();
        }
    }

    private static class Extender
    implements ChangesBrowserExtender {
        private final Project myProject;
        private final MultipleChangeListBrowser myBrowser;
        private final AnAction[] myAdditionalActions;

        private Extender(Project project, MultipleChangeListBrowser browser, AnAction[] additionalActions) {
            this.myProject = project;
            this.myBrowser = browser;
            this.myAdditionalActions = additionalActions;
        }

        @Override
        public void addToolbarActions(DialogWrapper dialogWrapper) {
            final Icon icon = AllIcons.Actions.Refresh;
            if (this.myBrowser.myChangesToDisplay == null) {
                this.myBrowser.addToolbarAction(new AnAction("Refresh Changes"){

                    public void actionPerformed(AnActionEvent e) {
                        Extender.this.myBrowser.rebuildList();
                    }

                    public void update(AnActionEvent e) {
                        e.getPresentation().setIcon(icon);
                    }
                });
            }
            RollbackDialogAction rollback = new RollbackDialogAction();
            EmptyAction.setupAction((AnAction)rollback, (String)"ChangesView.Revert", (JComponent)this.myBrowser);
            this.myBrowser.addToolbarAction(rollback);
            EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myBrowser);
            editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myBrowser);
            this.myBrowser.addToolbarAction(editSourceAction);
            this.myBrowser.addToolbarAction(ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar"));
            List<AnAction> actions = AdditionalLocalChangeActionsInstaller.calculateActions(this.myProject, this.myBrowser.getAllChanges());
            if (actions != null) {
                for (AnAction action : actions) {
                    this.myBrowser.addToolbarAction(action);
                }
            }
            if (this.myAdditionalActions != null && this.myAdditionalActions.length > 0) {
                for (int i = 0; i < this.myAdditionalActions.length; ++i) {
                    AnAction action;
                    action = this.myAdditionalActions[i];
                    this.myBrowser.addToolbarAction(action);
                }
            }
        }

        @Override
        public void addSelectedListChangeListener(SelectedListChangeListener listener) {
            this.myBrowser.addSelectedListChangeListener(listener);
        }

        @Override
        public Collection<AbstractVcs> getAffectedVcses() {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            HashSet<AbstractVcs> vcses = new HashSet<AbstractVcs>(Arrays.asList(vcsManager.getAllActiveVcss()));
            HashSet<AbstractVcs> result2 = new HashSet<AbstractVcs>();
            for (Change change : this.myBrowser.myAllChanges) {
                if (vcses.isEmpty()) break;
                AbstractVcs vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myBrowser.myProject);
                if (vcs == null) continue;
                result2.add(vcs);
                vcses.remove(vcs);
            }
            return result2;
        }

        @Override
        public List<Change> getCurrentIncludedChanges() {
            return this.myBrowser.getCurrentIncludedChanges();
        }
    }
}

