/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileManagerImpl
extends VirtualFileManagerEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final List<VirtualFileSystem> myPhysicalFileSystems;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<VirtualFileManagerListener> myVirtualFileManagerListeners;
    private int myRefreshCount;

    public VirtualFileManagerImpl(@NotNull VirtualFileSystem[] fileSystems, @NotNull MessageBus bus) {
        if (fileSystems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystems", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "<init>"));
        }
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "<init>"));
        }
        this.myCollector = new KeyedExtensionCollector<VirtualFileSystem, String>("com.intellij.virtualFileSystem"){

            @NotNull
            protected String keyToString(@NotNull String key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1", "keyToString"));
                }
                String string = key;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$1", "keyToString"));
                }
                return string;
            }
        };
        this.myPhysicalFileSystems = new ArrayList<VirtualFileSystem>();
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.myVirtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRefreshCount = 0;
        for (VirtualFileSystem fileSystem : fileSystems) {
            this.registerFileSystem(fileSystem);
        }
        if (LOG.isDebugEnabled()) {
            this.addVirtualFileListener(new LoggingListener());
        }
        bus.connect().subscribe(VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    private void registerFileSystem(@NotNull VirtualFileSystem fileSystem) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystem", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "registerFileSystem"));
        }
        this.myCollector.addExplicitExtension((Object)fileSystem.getProtocol(), (Object)fileSystem);
        if (!(fileSystem instanceof CachingVirtualFileSystem)) {
            fileSystem.addVirtualFileListener((VirtualFileListener)this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        this.myPhysicalFileSystems.add(fileSystem);
    }

    public long getStructureModificationCount() {
        return 0L;
    }

    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List systems = this.myCollector.forKey((Object)protocol);
        if (systems.isEmpty()) {
            return null;
        }
        LOG.assertTrue(systems.size() == 1);
        return (VirtualFileSystem)systems.get(0);
    }

    public long syncRefresh() {
        return this.doRefresh(false, null);
    }

    public long asyncRefresh(@Nullable Runnable postAction) {
        return this.doRefresh(true, postAction);
    }

    protected long doRefresh(boolean asynchronous, @Nullable Runnable postAction) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) continue;
            fileSystem.refresh(asynchronous);
        }
        return 0L;
    }

    public void refreshWithoutFileWatcher(boolean asynchronous) {
        if (!asynchronous) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        for (VirtualFileSystem fileSystem : this.getPhysicalFileSystems()) {
            if (fileSystem instanceof CachingVirtualFileSystem) {
                ((CachingVirtualFileSystem)fileSystem).refreshWithoutFileWatcher(asynchronous);
                continue;
            }
            fileSystem.refresh(asynchronous);
        }
    }

    private List<VirtualFileSystem> getPhysicalFileSystems() {
        return this.myPhysicalFileSystems;
    }

    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "findFileByUrl"));
        }
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.findFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    public VirtualFile refreshAndFindFileByUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "refreshAndFindFileByUrl"));
        }
        VirtualFileSystem fileSystem = this.getFileSystemForUrl(url);
        if (fileSystem == null) {
            return null;
        }
        return fileSystem.refreshAndFindFileByPath(VirtualFileManagerImpl.extractPath((String)url));
    }

    @Nullable
    private VirtualFileSystem getFileSystemForUrl(String url) {
        String protocol = VirtualFileManagerImpl.extractProtocol((String)url);
        if (protocol == null) {
            return null;
        }
        return this.getFileSystem(protocol);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileListener"));
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener);
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileListener"));
        }
        this.myVirtualFileListenerMulticaster.addListener((EventListener)listener, parentDisposable);
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "removeVirtualFileListener"));
        }
        this.myVirtualFileListenerMulticaster.removeListener((EventListener)listener);
    }

    public void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileManagerListener"));
        }
        this.myVirtualFileManagerListeners.add(listener);
    }

    public void addVirtualFileManagerListener(final @NotNull VirtualFileManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "addVirtualFileManagerListener"));
        }
        this.addVirtualFileManagerListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                VirtualFileManagerImpl.this.removeVirtualFileManagerListener(listener);
            }
        });
    }

    public void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "removeVirtualFileManagerListener"));
        }
        this.myVirtualFileManagerListeners.remove(listener);
    }

    public void notifyPropertyChanged(final @NotNull VirtualFile virtualFile, final @NotNull String property, final Object oldValue, final Object newValue) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "notifyPropertyChanged"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl", "notifyPropertyChanged"));
        }
        final Application application = ApplicationManager.getApplication();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (virtualFile.isValid() && !application.isDisposed()) {
                    application.runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, virtualFile, property, oldValue, newValue, false));
                            BulkFileListener listener = (BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
                            listener.before(events);
                            listener.after(events);
                        }
                    });
                }
            }
        };
        application.invokeLater(runnable, ModalityState.NON_MODAL);
    }

    @Override
    public void fireBeforeRefreshStart(boolean asynchronous) {
        if (this.myRefreshCount++ == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                try {
                    listener.beforeRefreshStart(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @Override
    public void fireAfterRefreshFinish(boolean asynchronous) {
        if (--this.myRefreshCount == 0) {
            for (VirtualFileManagerListener listener : this.myVirtualFileManagerListeners) {
                try {
                    listener.afterRefreshFinish(asynchronous);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public long getModificationCount() {
        return 0L;
    }

    @Override
    public List<LocalFileProvider> getLocalFileProviders() {
        return ContainerUtil.findAll(this.myPhysicalFileSystems, LocalFileProvider.class);
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "propertyChanged"));
            }
            LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "contentsChanged"));
            }
            LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileCreated"));
            }
            LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileDeleted"));
            }
            LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileMoved"));
            }
            LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "fileCopied"));
            }
            LOG.debug("fileCopied: file = " + event.getFile() + "originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
        }

        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeContentsChange"));
            }
            LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
        }

        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforePropertyChange"));
            }
            LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeFileDeletion"));
            }
            LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            LOG.assertTrue(event.getFile().isValid());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener", "beforeFileMovement"));
            }
            LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
        }
    }
}

