/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ui.DependencyNodeComparator;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.Gray;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDependenciesNode
extends DefaultMutableTreeNode
implements Navigatable {
    private static final EmptyIcon EMPTY_ICON = new EmptyIcon(0, IconUtil.getEmptyIcon((boolean)false).getIconHeight());
    private Set<VirtualFile> myRegisteredFiles;
    private boolean myHasUnmarked;
    private boolean myHasMarked;
    private boolean myEquals;
    protected Color myColor;
    protected static final Color NOT_CHANGED = Gray._0;
    protected Project myProject;
    private boolean mySorted;

    public PackageDependenciesNode(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ui/PackageDependenciesNode", "<init>"));
        }
        this.myRegisteredFiles = null;
        this.myHasUnmarked = false;
        this.myHasMarked = false;
        this.myColor = null;
        this.myProject = project;
    }

    public void setEquals(boolean equals) {
        this.myEquals = equals;
    }

    public boolean isEquals() {
        return this.myEquals;
    }

    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile vFile : this.getRegisteredFiles()) {
            PsiFile psiFile = psiManager.findFile(vFile);
            if (psiFile == null || !psiFile.isValid()) continue;
            set.add(psiFile);
        }
    }

    public void addFile(VirtualFile file, boolean isMarked) {
        this.getRegisteredFiles().add(file);
        this.updateMarked(!isMarked, isMarked);
    }

    public Icon getIcon() {
        return EMPTY_ICON;
    }

    public int getWeight() {
        return 0;
    }

    public boolean hasUnmarked() {
        return this.myHasUnmarked;
    }

    public boolean hasMarked() {
        return this.myHasMarked;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    public void updateColor() {
        this.myColor = null;
    }

    public int getContainingFiles() {
        int result2 = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            result2 += ((PackageDependenciesNode)this.getChildAt(i)).getContainingFiles();
        }
        return result2;
    }

    public String getPresentableFilesCount() {
        int filesCount = this.getContainingFiles();
        return filesCount > 0 ? " (" + AnalysisScopeBundle.message((String)"package.dependencies.node.items.count", (Object[])new Object[]{filesCount}) + ")" : "";
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        boolean hasUnmarked = ((PackageDependenciesNode)newChild).hasUnmarked();
        boolean hasMarked = ((PackageDependenciesNode)newChild).hasMarked();
        this.updateMarked(hasUnmarked, hasMarked);
    }

    private void updateMarked(boolean hasUnmarked, boolean hasMarked) {
        if (hasUnmarked && !this.myHasUnmarked || hasMarked && !this.myHasMarked) {
            this.myHasUnmarked |= hasUnmarked;
            this.myHasMarked |= hasMarked;
            PackageDependenciesNode parent = (PackageDependenciesNode)this.getParent();
            if (parent != null) {
                parent.updateMarked(this.myHasUnmarked, this.myHasMarked);
            }
        }
    }

    public void navigate(boolean focus) {
        if (this.canNavigate()) {
            this.openTextEditor(focus);
        }
    }

    @Nullable
    private Editor openTextEditor(boolean focus) {
        OpenFileDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            return FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(descriptor, focus);
        }
        return null;
    }

    public boolean canNavigate() {
        if (this.getProject() == null) {
            return false;
        }
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    private Project getProject() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null || psiElement.getContainingFile() == null) {
            return null;
        }
        return psiElement.getContainingFile().getProject();
    }

    @Nullable
    private OpenFileDescriptor getDescriptor() {
        if (this.getProject() == null) {
            return null;
        }
        PsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.getProject(), virtualFile, psiElement.getTextOffset());
    }

    @Override
    public Object getUserObject() {
        return this.toString();
    }

    public boolean isValid() {
        return true;
    }

    public Set<VirtualFile> getRegisteredFiles() {
        if (this.myRegisteredFiles == null) {
            this.myRegisteredFiles = new HashSet<VirtualFile>();
        }
        return this.myRegisteredFiles;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean canSelectInLeftTree(Map<PsiFile, Set<PsiFile>> deps) {
        return false;
    }

    public boolean isSorted() {
        return this.mySorted;
    }

    public void setSorted(boolean sorted) {
        this.mySorted = sorted;
    }

    public void sortChildren() {
        if (this.isSorted()) {
            return;
        }
        ArrayList children2 = TreeUtil.childrenToArray((TreeNode)this);
        Collections.sort(children2, new DependencyNodeComparator());
        this.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)this, (List)children2);
        this.setSorted(true);
    }
}

