/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageFileWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.ui.actions.PackageFileWorker");
    private final File myFile;
    private final String myRelativeOutputPath;
    private final boolean myPackIntoArchives;

    private PackageFileWorker(File file, String relativeOutputPath, boolean packIntoArchives) {
        this.myFile = file;
        this.myRelativeOutputPath = relativeOutputPath;
        this.myPackIntoArchives = packIntoArchives;
    }

    public static void startPackagingFiles(Project project, List<VirtualFile> files, Artifact[] artifacts, final @NotNull Runnable onFinishedInAwt) {
        if (onFinishedInAwt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onFinishedInAwt", "com/intellij/packaging/impl/ui/actions/PackageFileWorker", "startPackagingFiles"));
        }
        PackageFileWorker.startPackagingFiles(project, files, artifacts, true).doWhenProcessed(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(onFinishedInAwt);
            }
        });
    }

    public static ActionCallback startPackagingFiles(final Project project, final List<VirtualFile> files, final Artifact[] artifacts, final boolean packIntoArchives) {
        final ActionCallback callback = new ActionCallback();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Packaging Files"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packaging/impl/ui/actions/PackageFileWorker$2", "run"));
                }
                try {
                    for (final VirtualFile file : files) {
                        indicator.checkCanceled();
                        new ReadAction(){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/ui/actions/PackageFileWorker$2$1", "run"));
                                }
                                try {
                                    PackageFileWorker.packageFile(file, project, artifacts, packIntoArchives);
                                }
                                catch (IOException e) {
                                    String message = CompilerBundle.message((String)"message.tect.package.file.io.error", (Object[])new Object[]{e.toString()});
                                    Notifications.Bus.notify((Notification)new Notification("Package File", "Cannot package file", message, NotificationType.ERROR));
                                }
                            }
                        }.execute();
                        callback.setDone();
                    }
                }
                finally {
                    if (!callback.isDone()) {
                        callback.setRejected();
                    }
                }
            }
        });
        return callback;
    }

    public static void packageFile(@NotNull VirtualFile file, @NotNull Project project, Artifact[] artifacts, boolean packIntoArchives) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packaging/impl/ui/actions/PackageFileWorker", "packageFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/ui/actions/PackageFileWorker", "packageFile"));
        }
        LOG.debug("Start packaging file: " + file.getPath());
        Collection<Trinity<Artifact, PackagingElementPath, String>> items = ArtifactUtil.findContainingArtifactsWithOutputPaths(file, project, artifacts);
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        for (Trinity<Artifact, PackagingElementPath, String> item : items) {
            Artifact artifact = (Artifact)item.getFirst();
            String outputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)outputPath)) continue;
            PackageFileWorker worker = new PackageFileWorker(ioFile, (String)item.getThird(), packIntoArchives);
            LOG.debug(" package to " + outputPath);
            worker.packageFile(outputPath, ((PackagingElementPath)item.getSecond()).getParents());
        }
    }

    private void packageFile(String outputPath, List<CompositePackagingElement<?>> parents) throws IOException {
        List<Object> parentsList = new ArrayList(parents);
        Collections.reverse(parentsList);
        if (!parentsList.isEmpty() && parentsList.get(0) instanceof ArtifactRootElement) {
            parentsList = parentsList.subList(1, parentsList.size());
        }
        this.copyFile(outputPath, parentsList);
    }

    private void copyFile(String outputPath, List<CompositePackagingElement<?>> parents) throws IOException {
        if (parents.isEmpty()) {
            String fullOutputPath = DeploymentUtil.appendToPath((String)outputPath, (String)this.myRelativeOutputPath);
            File target = new File(fullOutputPath);
            if (FileUtil.filesEqual((File)this.myFile, (File)target)) {
                LOG.debug("  skipping copying file to itself");
            } else {
                LOG.debug("  copying to " + fullOutputPath);
                FileUtil.copy((File)this.myFile, (File)target);
            }
            return;
        }
        CompositePackagingElement<?> element = parents.get(0);
        String nextOutputPath = outputPath + "/" + element.getName();
        List<CompositePackagingElement<?>> parentsTrail = parents.subList(1, parents.size());
        if (element instanceof ArchivePackagingElement) {
            if (this.myPackIntoArchives) {
                this.packFile(nextOutputPath, "", parentsTrail);
            }
        } else {
            this.copyFile(nextOutputPath, parentsTrail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFile(String archivePath, String pathInArchive, List<CompositePackagingElement<?>> parents) throws IOException {
        File archiveFile = new File(archivePath);
        if (parents.isEmpty()) {
            LOG.debug("  adding to archive " + archivePath);
            JBZipFile file = PackageFileWorker.getOrCreateZipFile(archiveFile);
            try {
                String fullPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)this.myRelativeOutputPath));
                JBZipEntry entry = file.getOrCreateEntry(fullPathInArchive);
                entry.setData(FileUtil.loadFileBytes((File)this.myFile));
            }
            finally {
                file.close();
            }
            return;
        }
        CompositePackagingElement<?> element = parents.get(0);
        String nextPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)element.getName()));
        List<CompositePackagingElement<?>> parentsTrail = parents.subList(1, parents.size());
        if (element instanceof ArchivePackagingElement) {
            JBZipFile zipFile = PackageFileWorker.getOrCreateZipFile(archiveFile);
            try {
                JBZipEntry entry = zipFile.getOrCreateEntry(nextPathInArchive);
                LOG.debug("  extracting to temp file: " + nextPathInArchive + " from " + archivePath);
                File tempFile = FileUtil.createTempFile((String)("packageFile" + FileUtil.sanitizeFileName((String)nextPathInArchive)), (String)FileUtilRt.getExtension((String)PathUtil.getFileName((String)nextPathInArchive)));
                if (entry.getSize() != -1L) {
                    FileUtil.writeToFile((File)tempFile, (byte[])entry.getData());
                }
                this.packFile(FileUtil.toSystemIndependentName((String)tempFile.getAbsolutePath()), "", parentsTrail);
                entry.setData(FileUtil.loadFileBytes((File)tempFile));
                FileUtil.delete((File)tempFile);
            }
            finally {
                zipFile.close();
            }
        } else {
            this.packFile(archivePath, nextPathInArchive, parentsTrail);
        }
    }

    private static JBZipFile getOrCreateZipFile(File archiveFile) throws IOException {
        FileUtil.createIfDoesntExist((File)archiveFile);
        return new JBZipFile(archiveFile);
    }
}

