/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentBlock
extends AbstractJavaBlock {
    public DocCommentBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, alignment, indent, settings, javaSettings);
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result2 = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JavaDocTokenType.DOC_COMMENT_START) {
                result2.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getNoneIndent(), null, AlignmentStrategy.getNullStrategy()));
                continue;
            }
            if (FormatterUtil.containsWhiteSpacesOnly(child) || child.getText().trim().isEmpty()) continue;
            result2.add(this.createJavaBlock(child, this.mySettings, this.myJavaSettings, Indent.getSpaceIndent((int)1), null, AlignmentStrategy.getNullStrategy()));
        }
        return result2;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getSpaceIndent((int)1), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/DocCommentBlock", "getChildAttributes"));
        }
        return childAttributes;
    }
}

