/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.XmlUnusedNamespaceInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlImportOptimizer
implements ImportOptimizer {
    private final XmlUnusedNamespaceInspection myInspection = new XmlUnusedNamespaceInspection();
    private final Condition<ProblemDescriptor> myCondition = new Condition<ProblemDescriptor>(){

        public boolean value(ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            return parent != null && !XmlImportOptimizer.this.myInspection.isSuppressedFor(parent);
        }
    };

    public boolean supports(PsiFile file) {
        return file instanceof XmlFile;
    }

    @NotNull
    public ImportOptimizer.CollectingInfoRunnable processFile(final PsiFile file) {
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){
            int myRemovedNameSpaces = 0;

            public void run() {
                XmlFile xmlFile = (XmlFile)file;
                Project project = xmlFile.getProject();
                HighlightDisplayKey key = HighlightDisplayKey.find((String)XmlImportOptimizer.this.myInspection.getShortName());
                if (!InspectionProjectProfileManager.getInstance(project).getInspectionProfile().isToolEnabled(key, (PsiElement)xmlFile)) {
                    return;
                }
                ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance((Project)project), (PsiFile)xmlFile, false);
                final XmlElementVisitor visitor = (XmlElementVisitor)XmlImportOptimizer.this.myInspection.buildVisitor(holder, false);
                new PsiRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        if (element instanceof XmlAttribute) {
                            visitor.visitXmlAttribute((XmlAttribute)element);
                        } else {
                            super.visitElement(element);
                        }
                    }
                }.visitFile((PsiFile)xmlFile);
                Object[] results = holder.getResultsArray();
                ArrayUtil.reverseArray((Object[])results);
                List list = ContainerUtil.filter((Object[])results, (Condition)XmlImportOptimizer.this.myCondition);
                LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor> fixes = new LinkedHashMap<XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix, ProblemDescriptor>();
                for (ProblemDescriptor result2 : list) {
                    for (QuickFix fix : result2.getFixes()) {
                        if (!(fix instanceof XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)) continue;
                        fixes.put((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix, result2);
                    }
                }
                SmartPsiElementPointer<XmlTag> pointer = null;
                for (Map.Entry fix : fixes.entrySet()) {
                    pointer = ((XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix)fix.getKey()).doFix(project, (ProblemDescriptor)fix.getValue(), false);
                    ++this.myRemovedNameSpaces;
                }
                if (pointer != null) {
                    XmlUnusedNamespaceInspection.RemoveNamespaceDeclarationFix.reformatStartTag(project, pointer);
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myRemovedNameSpaces > 0 ? "Removed " + this.myRemovedNameSpaces + " namespace" + (this.myRemovedNameSpaces > 1 ? "s" : "") : null;
            }
        };
        if (collectingInfoRunnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/XmlImportOptimizer", "processFile"));
        }
        return collectingInfoRunnable;
    }
}

