/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.AbstractRemoteProcessHandler;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRemoteProcessHandler<T extends RemoteProcess>
extends AbstractRemoteProcessHandler<T>
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(BaseRemoteProcessHandler.class);
    @Nullable
    protected final String myCommandLine;
    protected final ProcessWaitFor myWaitFor;
    @Nullable
    protected final Charset myCharset;
    protected T myProcess;

    public BaseRemoteProcessHandler(@NotNull T process, @Nullable String commandLine, @Nullable Charset charset) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/remote/BaseRemoteProcessHandler", "<init>"));
        }
        this.myProcess = process;
        this.myCommandLine = commandLine;
        this.myWaitFor = new ProcessWaitFor(process, (TaskExecutor)this);
        this.myCharset = charset;
    }

    @Override
    public T getProcess() {
        return this.myProcess;
    }

    protected void destroyProcessImpl() {
        if (!((RemoteProcess)this.myProcess).killProcessTree()) {
            this.baseDestroyProcessImpl();
        }
    }

    public void startNotify() {
        if (this.myCommandLine != null) {
            this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        }
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                try {
                    final RemoteOutputReader stdoutReader = new RemoteOutputReader(((Process)BaseRemoteProcessHandler.this.myProcess).getInputStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remote/BaseRemoteProcessHandler$1$1", "onTextAvailable"));
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
                        }

                        protected Future<?> executeOnPooledThread(Runnable runnable) {
                            return BaseRemoteProcessHandler.executeOnPooledThread(runnable);
                        }
                    };
                    final RemoteOutputReader stderrReader = new RemoteOutputReader(((Process)BaseRemoteProcessHandler.this.myProcess).getErrorStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/remote/BaseRemoteProcessHandler$1$2", "onTextAvailable"));
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDERR);
                        }

                        protected Future<?> executeOnPooledThread(Runnable runnable) {
                            return BaseRemoteProcessHandler.executeOnPooledThread(runnable);
                        }
                    };
                    BaseRemoteProcessHandler.this.myWaitFor.setTerminationCallback((Consumer)new Consumer<Integer>(){

                        public void consume(Integer exitCode) {
                            try {
                                try {
                                    stderrReader.waitFor();
                                    stdoutReader.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                BaseRemoteProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    BaseRemoteProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected void baseDestroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        ((Process)this.getProcess()).destroy();
    }

    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseRemoteProcessHandler.this.closeStreams();
                BaseRemoteProcessHandler.this.myWaitFor.detach();
                BaseRemoteProcessHandler.this.notifyProcessDetached();
            }
        };
        BaseRemoteProcessHandler.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            ((Process)this.myProcess).getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return ((Process)this.myProcess).getOutputStream();
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    protected static Future<?> executeOnPooledThread(Runnable task) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            return application.executeOnPooledThread(task);
        }
        return BaseOSProcessHandler.ExecutorServiceHolder.submit((Runnable)task);
    }

    public Future<?> executeTask(Runnable task) {
        return BaseRemoteProcessHandler.executeOnPooledThread(task);
    }

    @Nullable
    public String getCommandLine() {
        return this.myCommandLine;
    }

    private static abstract class RemoteOutputReader
    extends BaseOutputReader {
        @NotNull
        private final RemoteProcess myRemoteProcess;
        private boolean myClosed;

        public RemoteOutputReader(@NotNull InputStream inputStream, Charset charset, @NotNull RemoteProcess remoteProcess) {
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader", "<init>"));
            }
            if (remoteProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteProcess", "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader", "<init>"));
            }
            super(inputStream, charset);
            this.myRemoteProcess = remoteProcess;
            this.start();
        }

        protected void doRun() {
            try {
                this.setClosed(false);
                while (true) {
                    boolean read = this.readAvailable();
                    if (this.myRemoteProcess.isDisconnected()) {
                        this.myReader.close();
                        break;
                    }
                    if (this.isStopped) {
                        break;
                    }
                    Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read));
                }
            }
            catch (InterruptedException read) {
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this.setClosed(true);
            }
        }

        protected synchronized void setClosed(boolean closed) {
            this.myClosed = closed;
        }

        public void waitFor() throws InterruptedException {
            while (!this.isClosed()) {
                Thread.sleep(100L);
            }
        }

        private synchronized boolean isClosed() {
            return this.myClosed;
        }
    }
}

