/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ClassNameDiffersFromFileNameInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.name.differs.from.file.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNameDiffersFromFileNameVisitor();
    }

    private static class ClassNameDiffersFromFileNameVisitor
    extends BaseInspectionVisitor {
        private ClassNameDiffersFromFileNameVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/classlayout/ClassNameDiffersFromFileNameInspectionBase$ClassNameDiffersFromFileNameVisitor", "visitClass"));
            }
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)parent;
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String fileName = file.getName();
            int prefixIndex = fileName.indexOf(46);
            if (prefixIndex < 0) {
                return;
            }
            String filenameWithoutPrefix = fileName.substring(0, prefixIndex);
            if (className.equals(filenameWithoutPrefix)) {
                return;
            }
            this.registerClassError(aClass, file);
        }
    }
}

