/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class EqualityToEqualsFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EqualityToEqualsFix", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("object.comparison.replace.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EqualityToEqualsFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiExpression lhs;
        PsiExpression strippedLhs;
        PsiElement comparisonToken = descriptor.getPsiElement();
        PsiElement parent = comparisonToken.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)parent;
        boolean negated = false;
        IElementType tokenType = expression.getOperationTokenType();
        if (JavaTokenType.NE.equals(tokenType)) {
            negated = true;
        }
        if ((strippedLhs = ParenthesesUtils.stripParentheses(lhs = expression.getLOperand())) == null) {
            return;
        }
        PsiExpression rhs = expression.getROperand();
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String expString = PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression) ? "java.util.Objects.equals(" + strippedLhs.getText() + ',' + strippedRhs.getText() + ')' : (ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? '(' + strippedLhs.getText() + ").equals(" + strippedRhs.getText() + ')' : strippedLhs.getText() + ".equals(" + strippedRhs.getText() + ')');
        String newExpression = negated ? '!' + expString : expString;
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression, newExpression);
    }
}

