/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;

public class RelaxIncludeIndex {
    public static boolean processForwardDependencies(XmlFile file, PsiElementProcessor<XmlFile> processor2) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return processor2.execute((PsiElement)file);
        }
        Project project = file.getProject();
        VirtualFile[] files = FileIncludeManager.getManager((Project)project).getIncludedFiles(virtualFile, true);
        return RelaxIncludeIndex.processRelatedFiles((PsiFile)file, files, processor2);
    }

    public static boolean processBackwardDependencies(@NotNull XmlFile file, PsiElementProcessor<XmlFile> processor2) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/resolve/RelaxIncludeIndex", "processBackwardDependencies"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return processor2.execute((PsiElement)file);
        }
        Project project = file.getProject();
        VirtualFile[] files = FileIncludeManager.getManager((Project)project).getIncludingFiles(virtualFile, true);
        return RelaxIncludeIndex.processRelatedFiles((PsiFile)file, files, processor2);
    }

    private static boolean processRelatedFiles(PsiFile file, VirtualFile[] files, PsiElementProcessor<XmlFile> processor2) {
        PsiFile[] psiFiles;
        Project project = file.getProject();
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (PsiFile psiFile : psiFiles = (PsiFile[])ContainerUtil.map2Array((Object[])files, PsiFile.class, (Function)new NullableFunction<VirtualFile, PsiFile>(){

            public PsiFile fun(VirtualFile file) {
                return psiManager.findFile(file);
            }
        })) {
            if (RelaxIncludeIndex.processFile(psiFile, processor2)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFile(PsiFile psiFile, PsiElementProcessor<XmlFile> processor2) {
        FileType type = psiFile.getFileType();
        return !(type == XmlFileType.INSTANCE && RelaxIncludeIndex.isRngFile(psiFile) ? !processor2.execute((PsiElement)((XmlFile)psiFile)) : type == RncFileType.getInstance() && !processor2.execute((PsiElement)((XmlFile)psiFile)));
    }

    static boolean isRngFile(PsiFile psiFile) {
        return psiFile instanceof XmlFile && DomManager.getDomManager((Project)psiFile.getProject()).getFileElement((XmlFile)psiFile, RngGrammar.class) != null;
    }
}

