/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!%\u0005\u0005\u0003\"A\u0001!D\u0001\u0019\u0002E\u001b\u0011!\u0002\u0001U\u0007\u0005\t\n\u0002B!\t\u0011\u0007i\u0011\u0001'\u0001R\u0007\u0005)\u0001\u0001V\u0002\u0002"}, strings={"EMPTY_PATH_RESOLVER", "Lorg/jetbrains/builtInWebServer/FileResolver;", "WebServerPathToFileManagerKt", "RELATIVE_PATH_RESOLVER"}, moduleName="built-in-server")
public final class WebServerPathToFileManagerKt {
    private static final FileResolver RELATIVE_PATH_RESOLVER = new FileResolver(){

        @Nullable
        public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            if (root.isInLocalFileSystem() && Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance())) {
                File file = new File(root.getPath(), path);
                if (file.exists()) {
                    return new PathInfo(file, (VirtualFile)null, root, moduleName, isLibrary);
                }
                return null;
            }
            VirtualFile virtualFile = root.findFileByRelativePath(path);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            return new PathInfo((File)null, file, root, moduleName, isLibrary);
        }
    };
    private static final FileResolver EMPTY_PATH_RESOLVER = new FileResolver(){

        @Nullable
        public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            return new PathInfo((File)null, file, root, moduleName, isLibrary);
        }
    };

    @NotNull
    public static final /* synthetic */ FileResolver access$getEMPTY_PATH_RESOLVER$p() {
        return EMPTY_PATH_RESOLVER;
    }

    @NotNull
    public static final /* synthetic */ FileResolver access$getRELATIVE_PATH_RESOLVER$p() {
        return RELATIVE_PATH_RESOLVER;
    }
}

