/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.rpc.CommandProcessorKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\u0001a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019Q\u0005\u0003\u0003\f\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0006S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/FunctionScopesValueGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "functionValue", "Lorg/jetbrains/debugger/values/FunctionValue;", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/values/FunctionValue;Lorg/jetbrains/debugger/VariableContext;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;"}, moduleName="script-debugger-ui")
public final class FunctionScopesValueGroup
extends XValueGroup {
    private final FunctionValue functionValue;
    private final VariableContext variableContext;

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        Promise<FunctionValue> $receiver = this.functionValue.resolve();
        $receiver.done((Consumer)new ObsolescentConsumer<T>((Obsolescent)node, this, node){
            final /* synthetic */ FunctionScopesValueGroup this$0;
            final /* synthetic */ XCompositeNode $node$inlined;

            public void consume(T param) {
                FunctionValue it = (FunctionValue)param;
                Scope[] scopes = it.getScopes();
                if (scopes == null || ((Object[])scopes).length == 0) {
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                } else {
                    List<Scope> list = Arrays.asList(Arrays.copyOf(scopes, scopes.length));
                    Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*scopes)");
                    ScopeVariablesGroupKt.createAndAddScopeList(this.$node$inlined, list, FunctionScopesValueGroup.access$getVariableContext$p(this.this$0), null);
                }
            }
            {
                void $super_call_param$1;
                this.this$0 = functionScopesValueGroup;
                this.$node$inlined = xCompositeNode;
                super((Obsolescent)$super_call_param$1);
            }
        }).rejected((Consumer)new Consumer<Throwable>(node){
            final /* synthetic */ XCompositeNode $node;

            public final void consume(Throwable it) {
                Promise.logError((Logger)CommandProcessorKt.getLOG(), (Throwable)it);
                String string = it.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$node.setErrorMessage(string);
            }
            {
                this.$node = xCompositeNode;
            }
        });
    }

    public FunctionScopesValueGroup(@NotNull FunctionValue functionValue, @NotNull VariableContext variableContext) {
        Intrinsics.checkParameterIsNotNull((Object)functionValue, (String)"functionValue");
        Intrinsics.checkParameterIsNotNull((Object)variableContext, (String)"variableContext");
        super("Function scopes");
        this.functionValue = functionValue;
        this.variableContext = variableContext;
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getVariableContext$p(FunctionScopesValueGroup $this) {
        return $this.variableContext;
    }
}

