/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"{\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!\u0005R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!Q\u0001B\n\r\u0001e\t\u0001\u0014AQ\t\u0013\u0015A\u0011!D\u0002\n\u0003\u0011\r\u00014A)\u0004\u0003!\u0011QE\u0004\u0003\u000b\u0011/i\u0011\u0001\u0007\u0007\u001a\u000b!eQbA\u0005\u0002\t\u0007Aj!G\u0002\t\u001b5\t\u00014D\u0013\u0004\u00119i\u0011\u0001\u0007\u0007&/\u0011\u0011\u0002RD\u0007\u00021=Ib\u0001#\u0007\u000e\t%\tA1\u0001G\u00011\u001bI2\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0010\u001b\u0005A\u0002#G\u0002\t\"5\t\u00014D\u0013\u0011\u0011Ei1!C\u0001\u0005\u0004a\r\u0012$\u0002E\r\u001b\rI\u0011\u0001b\u0001\u0019\u000ee!A!\u0001\u0005\u000e\u001b\u0005AZ\"J\u0006\u0005%!\u0011R\u0002B\u0005\u0003\u0013\u0005Az\u0001'\n\u001a\u0007!\u0019R\"\u0001M\u0014K\u0001\"!\u0001\u0003\u000b\u000e\u0003a=\u0011D\u0002E\r\u001b\u0011I\u0011\u0001b\u0001\r\u0002a5\u0011d\u0001E\u0010\u001b\u0005A\u0002#G\u0002\t\"5\t\u00014D\r\r\t\u0005AI#D\u0005\n\r%)\u0011b\u0001C\u0001\u0013\u0005Az\u0001g\t\r\u0002a)R\u0005\u0003\u0003\f\u0011Wi\u0011\u0001g\u0007\u001a\u0007!eQ\"\u0001M\bK)Aa#D\u0001\u0019\u001ce1\u0001RF\u0007\u0005\u0013\tI\u0011\u0001g\u0004\u0019&\u0015*\u0001bF\u0007\u0004\u0013\u0005!\u0019\u0001g\t&\u001f!=RbA\u0005\u0002\t\u0007A\u001a#G\u0003\t\u001a5\u0019\u0011\"\u0001C\u00021\u001bI2\u0001\u0003\r\u000e\u0003amQe\u0002E\u0019\u001b\u0005AB\"G\u0002\t'5\t\u0001tE\u0013\n\u0011ei\u0011\u0001\u0007\u0007\u001a\u000b!eQbA\u0005\u0002\t\u0007Aj!J\u000f\t35\t\u0001\u0004D\r\u0006\u00113i1!C\u0001\u0005\u0004a5\u0011D\u0002E\u001a\u001b\u0011I!!C\u0001\u0019!a\u0015\u0012\u0004\u0004\u0003\u0002\u0011Si\u0011\"\u0003\u0004\n\u000b%\u0019A\u0011A\u0005\u00021\u001fA\u001a\u0003$\u0001\u0019+\u0015\u001a\u0001BG\u0007\u000211I#\u0002B!\t\u0011\u000bi\u0011\u0001G\u0002\u001dCE\u001b1!\u0004\u0002\u0005\b!!\u0011f\u0002\u0003B\u0011!%Q\"\u0001\r\u0006#\u000e\tQ\u0001A\u0015\n\t\u0005C\u0001\"A\u0007\u0004\u0013\u0005!\u0019\u0001g\u0001R\u0007\u0005)\u0001!\u000b\n\u0005\u0003\"AY!\u0004\u0007\n\t%\u0019\u0011\"\u0001C\u00021\u001bIQ!\u0003\u0003\n\u0005%\t\u0001t\u0002\r\b1\u0019\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\t\u001b\u0005A\n\"U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011%iA!\u0003\u0002\n\u0003a=\u00014C)\u0004\u0003\u0015\u0001\u0011&\u0006\u0003C\u0011!QQ\u0002D\u0005\u0003\u0013\u0005Az!C\u0004\n\r%!\u0011bA\u0005\u0002\t\u0007Aj\u0001G\u0004\u0019\rE\u001bA!\u0002\u0001\u000e\u0005\u0011U\u0001b\u0003"}, strings={"Lorg/jetbrains/debugger/LineBreakpointManager;", "", "debugProcess", "Lorg/jetbrains/debugger/DebugProcessImpl;", "(Lorg/jetbrains/debugger/DebugProcessImpl;)V", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "getBreakpointManager", "()Lorg/jetbrains/debugger/BreakpointManager;", "breakpointResolvedListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ideToVmBreakpoints", "Lgnu/trove/THashMap;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "", "Lorg/jetbrains/debugger/Breakpoint;", "lock", "Ljava/lang/Object;", "runToLocationBreakpoints", "Lgnu/trove/THashSet;", "vmToIdeBreakpoints", "getVmToIdeBreakpoints", "()Lgnu/trove/THashMap;", "beforeBreakpointRemoved", "", "breakpoint", "disable", "", "clearRunToLocationBreakpoints", "createTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "isTemporary", "doRemoveBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "doSetBreakpoint", "promiseRef", "Lcom/intellij/openapi/util/Ref;", "isAnyFirstLineBreakpoint", "isRunToCursorBreakpoints", "breakpoints", "removeAllBreakpoints", "removeBreakpoint", "temporary", "runToLocation", "setBreakpoint", "locations", "updateAllBreakpoints"}, moduleName="script-debugger-ui")
public abstract class LineBreakpointManager {
    private final THashMap<XLineBreakpoint<?>, List<Breakpoint>> ideToVmBreakpoints;
    @NotNull
    private final THashMap<Breakpoint, List<XLineBreakpoint<?>>> vmToIdeBreakpoints;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final AtomicBoolean breakpointResolvedListenerAdded;
    private final DebugProcessImpl<?> debugProcess;

    @NotNull
    protected final THashMap<Breakpoint, List<XLineBreakpoint<?>>> getVmToIdeBreakpoints() {
        return this.vmToIdeBreakpoints;
    }

    private final BreakpointManager getBreakpointManager() {
        Vm vm = this.debugProcess.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        return vm.getBreakpointManager();
    }

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        List list;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object lock = this.lock;
        synchronized (lock) {
            list = (List)this.ideToVmBreakpoints.get(breakpoint);
        }
        List target = list;
        if (target == null) {
            LineBreakpointManager.setBreakpoint$default(this, breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint), null, 4);
        } else {
            BreakpointManager breakpointManager = this.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.getEnabled()) continue;
                vmBreakpoint.setEnabled(true);
                breakpointManager.flush(vmBreakpoint).rejected((Consumer)new Consumer<Throwable>(this, breakpoint){
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    public final void consume(Throwable it) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(this.$breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, it.getMessage());
                    }
                    {
                        this.this$0 = lineBreakpointManager;
                        this.$breakpoint = xLineBreakpoint;
                    }
                });
            }
        }
    }

    @NotNull
    public final Promise<?> removeBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<?> doRemoveBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SetsKt.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            block13: {
                block12: {
                    if (disable) break block12;
                    List list = (List)this.ideToVmBreakpoints.remove(breakpoint);
                    if (list == null) {
                        return PromiseKt.resolvedPromise();
                    }
                    vmBreakpoints.element = list;
                    if (!((Collection)vmBreakpoints.element).isEmpty()) {
                        for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                            UtilKt.remove((Map)this.getVmToIdeBreakpoints(), vmBreakpoint, breakpoint);
                            if (!this.getVmToIdeBreakpoints().containsKey((Object)vmBreakpoint)) continue;
                            return PromiseKt.resolvedPromise();
                        }
                    }
                    break block13;
                }
                List list = (List)this.ideToVmBreakpoints.get(breakpoint);
                if (list == null) {
                    return PromiseKt.resolvedPromise();
                }
                List list2 = list;
                Iterator iterator = list2.iterator();
                List list3 = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"list");
                vmBreakpoints.element = list3;
                while (iterator.hasNext()) {
                    Breakpoint vmBreakpoint = (Breakpoint)iterator.next();
                    List list4 = (List)this.getVmToIdeBreakpoints().get((Object)vmBreakpoint);
                    if ((list4 != null ? list4.size() : -1) <= 1) continue;
                    iterator.remove();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (((Collection)vmBreakpoints.element).isEmpty()) {
            return PromiseKt.resolvedPromise();
        }
        BreakpointManager breakpointManager = this.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                vmBreakpoint.setEnabled(false);
                promises.add(breakpointManager.flush(vmBreakpoint));
            }
        } else {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.remove(vmBreakpoint));
            }
        }
        Promise promise2 = Promise.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.all(promises)");
        return promise2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Promise doRemoveBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lineBreakpointManager.doRemoveBreakpoint(xLineBreakpoint, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<? extends Location> locations, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            vmBreakpoints.add((Object)this.doSetBreakpoint(breakpoint, location, false, promiseRef));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoints.put(breakpoint, (Object)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                UtilKt.putValue((Map)this.getVmToIdeBreakpoints(), vmBreakpoint, breakpoint);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* bridge */ /* synthetic */ void setBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, List list, Ref ref, int n) {
        if ((n & 4) != 0) {
            ref = null;
        }
        lineBreakpointManager.setBreakpoint(xLineBreakpoint, list, (Ref<Promise<? extends Breakpoint>>)ref);
    }

    @NotNull
    protected final Breakpoint doSetBreakpoint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location, boolean isTemporary, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (this.breakpointResolvedListenerAdded.compareAndSet(false, true)) {
            this.getBreakpointManager().addBreakpointListener(new BreakpointListener(this){
                final /* synthetic */ LineBreakpointManager this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resolved(@NotNull Breakpoint breakpoint) {
                    Unit unit;
                    List list;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        list = (List)this.this$0.getVmToIdeBreakpoints().get((Object)breakpoint);
                    }
                    List list2 = list;
                    if (list2 != null) {
                        List $receiver = list2;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void errorOccurred(@NotNull Breakpoint breakpoint, @Nullable String errorMessage) {
                    Unit unit;
                    List list;
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    if (this.this$0.isAnyFirstLineBreakpoint(breakpoint)) {
                        return;
                    }
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        bl = LineBreakpointManager.access$getRunToLocationBreakpoints$p(this.this$0).remove((Object)breakpoint);
                    }
                    if (bl) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().reportError("Cannot run to cursor: " + errorMessage);
                        return;
                    }
                    lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        list = (List)this.this$0.getVmToIdeBreakpoints().get((Object)breakpoint);
                    }
                    List list2 = list;
                    if (list2 != null) {
                        List $receiver = list2;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nonProvisionalBreakpointRemoved(@NotNull Breakpoint breakpoint) {
                    Unit unit;
                    List list;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        List list2;
                        List list3 = (List)this.this$0.getVmToIdeBreakpoints().remove((Object)breakpoint);
                        if (list3 != null) {
                            List $receiver = list3;
                            List it = $receiver;
                            for (XLineBreakpoint ideBreakpoint : it) {
                                UtilKt.remove((Map)LineBreakpointManager.access$getIdeToVmBreakpoints$p(this.this$0), ideBreakpoint, breakpoint);
                            }
                            list2 = it;
                        } else {
                            list2 = null;
                        }
                        list = list2;
                    }
                    List list4 = list;
                    if (list4 != null) {
                        List $receiver = list4;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.setBreakpoint$default(this.this$0, ideBreakpoint, LineBreakpointManager.access$getDebugProcess$p(this.this$0).getLocationsForBreakpoint(ideBreakpoint), null, 4);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        BreakpointManager breakpointManager = this.getBreakpointManager();
        BreakpointTarget target = this.createTarget(breakpoint, breakpointManager, location, isTemporary);
        XLineBreakpoint<?> xLineBreakpoint = breakpoint;
        XExpression condition = xLineBreakpoint != null ? xLineBreakpoint.getConditionExpression() : null;
        XExpression xExpression = condition;
        return BreakpointManager.DefaultImpls.setBreakpoint$default(breakpointManager, target, location.getLine(), location.getColumn(), xExpression != null ? xExpression.getExpression() : null, 0, false, promiseRef, 48);
    }

    @NotNull
    protected static /* bridge */ /* synthetic */ Breakpoint doSetBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, Location location, boolean bl, Ref ref, int n) {
        if ((n & 8) != 0) {
            ref = null;
        }
        return lineBreakpointManager.doSetBreakpoint(xLineBreakpoint, location, bl, (Ref<Promise<? extends Breakpoint>>)ref);
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> var1, @NotNull BreakpointManager var2, @NotNull Location var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = this.ideToVmBreakpoints.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            xLineBreakpointArray = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<?> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoints.clear();
            this.getVmToIdeBreakpoints().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE;
        }
        return this.getBreakpointManager().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            void $receiver;
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            Collection collection = (Collection)this.runToLocationBreakpoints;
            THashSet<Breakpoint> tHashSet = this.runToLocationBreakpoints;
            int n = $receiver.size();
            Breakpoint[] breakpoints = (Breakpoint[])tHashSet.toArray((Object[])new Breakpoint[n]);
            this.runToLocationBreakpoints.clear();
            breakpointArray = breakpoints;
        }
        Breakpoint[] breakpoints = breakpointArray;
        BreakpointManager breakpointManager = this.getBreakpointManager();
        for (int i = 0; i < breakpoints.length; ++i) {
            Breakpoint breakpoint;
            Breakpoint breakpoint2 = breakpoint = breakpoints[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
            breakpointManager.remove(breakpoint2);
        }
    }

    public LineBreakpointManager(@NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoints = new THashMap();
        this.vmToIdeBreakpoints = new THashMap();
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.breakpointResolvedListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(LineBreakpointManager $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ DebugProcessImpl<?> access$getDebugProcess$p(LineBreakpointManager $this) {
        return $this.debugProcess;
    }
}

