/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Consumer;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.values.ValueManager;

public abstract class SuspendContextManagerBase<T extends SuspendContextBase, CALL_FRAME extends CallFrame>
implements SuspendContextManager<CALL_FRAME> {
    protected final AtomicReference<T> context = new AtomicReference();
    protected final AtomicReference<AsyncPromise<Void>> suspendCallback = new AtomicReference();

    public final void setContext(@NotNull T newContext) {
        if (newContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "org/jetbrains/debugger/SuspendContextManagerBase", "setContext"));
        }
        if (!this.context.compareAndSet(null, newContext)) {
            throw new IllegalStateException("Attempt to set context, but current suspend context is already exists");
        }
    }

    protected final void dismissContext() {
        SuspendContext context = this.getContext();
        if (context != null) {
            this.contextDismissed(context);
        }
    }

    @NotNull
    protected final Promise<Void> dismissContextOnDone(@NotNull Promise<Void> promise2) {
        if (promise2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/debugger/SuspendContextManagerBase", "dismissContextOnDone"));
        }
        SuspendContext context = this.getContextOrFail();
        promise2.done((Consumer)new Consumer<Void>((SuspendContextBase)context){
            final /* synthetic */ SuspendContextBase val$context;
            {
                this.val$context = suspendContextBase;
            }

            public void consume(Void aVoid) {
                SuspendContextManagerBase.this.contextDismissed(this.val$context);
            }
        });
        Promise<Void> promise3 = promise2;
        if (promise3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "dismissContextOnDone"));
        }
        return promise3;
    }

    protected abstract DebugEventListener getDebugListener();

    public final void contextDismissed(@NotNull T context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/SuspendContextManagerBase", "contextDismissed"));
        }
        if (!this.context.compareAndSet(context, null)) {
            throw new IllegalStateException("Expected " + context + ", but another suspend context exists");
        }
        ((ValueManager)((SuspendContextBase)context).getValueManager()).markObsolete();
        this.getDebugListener().resumed();
    }

    @Nullable
    public final T getContext() {
        return (T)((SuspendContextBase)this.context.get());
    }

    @NotNull
    public T getContextOrFail() {
        SuspendContext context = this.getContext();
        if (context == null) {
            throw new IllegalStateException("No current suspend context");
        }
        SuspendContext suspendContext = context;
        if (suspendContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "getContextOrFail"));
        }
        return (T)suspendContext;
    }

    @Override
    @NotNull
    public final Promise<?> suspend() {
        Promise callback = (Promise)this.suspendCallback.get();
        if (callback != null) {
            Promise promise2 = callback;
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
            }
            return promise2;
        }
        if (this.context.get() != null) {
            Promise promise3 = Promise.DONE;
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
            }
            return promise3;
        }
        Promise<?> promise4 = this.doSuspend();
        if (promise4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "suspend"));
        }
        return promise4;
    }

    @NotNull
    protected abstract Promise<?> doSuspend();

    @Override
    public boolean isContextObsolete(@NotNull SuspendContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/debugger/SuspendContextManagerBase", "isContextObsolete"));
        }
        return this.context.get() != context;
    }

    @Override
    public void setOverlayMessage(@Nullable String message) {
    }

    @Override
    @NotNull
    public final Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callFrame", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        Promise<Boolean> promise2 = this.restartFrame(callFrame, this.getContextOrFail());
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        return promise2;
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull CALL_FRAME callFrame, @NotNull T currentContext) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callFrame", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        if (currentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentContext", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        Promise promise2 = Promise.reject((String)"Unsupported");
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextManagerBase", "restartFrame"));
        }
        return promise2;
    }

    @Override
    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        if (callFrame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callFrame", "org/jetbrains/debugger/SuspendContextManagerBase", "canRestartFrame"));
        }
        return false;
    }

    @Override
    public boolean isRestartFrameSupported() {
        return false;
    }
}

