/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueCallback;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.ArrayPresentation;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.FunctionScopesValueGroup;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.ObjectValuePresentation;
import org.jetbrains.debugger.PsiVisitors;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManager;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableView$Companion$WhenMappings;
import org.jetbrains.debugger.VariableView$WhenMappings;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0011\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u00071\u0001\u0001\u0003I\r\u00021\u0003I\u0012\u0001G\u0001\u001e\u0004\u0001\u0006\u0013%)\b\n\u0007!\rQ\"\u0001\r\u0003\u0013\rA)!D\u0001\u0019\u0007%\u0019\u0001rA\u0007\u00021\u0005\t6!\u0001\u0005\u0005K\u0011!1\u0002#\u0006\u000e\u0003aYQe\u0004\u0003\u0002\u0011/i\u0011\u0001\u0007\u0007\u001a\r!eQ\u0002B\u0005\u0003\u0013\u0005A2\u0001\u0007\u0005\u001a\u0007!iQ\"\u0001M\u000eK!!1\u0002\u0003\b\u000e\u0003aa\u0011d\u0001\u0005\u000e\u001b\u0005AZ\"\n\n\u0005\u0003!uQbA\u0005\u0002\t\u0007Ar\"G\u0002\t\u00145\t\u0001tD\r\u0004\u00115i\u0011\u0001g\u0007\u001a\u0007!\u0001R\"\u0001\r\fK!!1\u0002#\t\u000e\u0003a\t\u0012d\u0001E\u0012\u001b\u0005A\"#j\r\u0005\u0003!\u0015RRC\u0005\u0007\u0013\u0015\u00012#\u0006\u0002\r\u0002aa\u0001\u0004\u0004\r\u0010#\u000e\tAqE\r\u0004\u0011'i\u0011\u0001\u0007\u000b\u001a\u0007!iQ\"\u0001M\u000e3\rA\u0001#D\u0001\u0019\u0017\u0015bAa\u0003E\u0015\u001b\u0005AB\"G\u0002\t\u001b5\t\u0001$F\r\u0004\u0011Wi\u0011\u0001\u0007\f&\u0019\u0011\t\u0001\u0012F\u0007\u000211I2\u0001c\u0005\u000e\u0003aQ\u0011d\u0001\u0005\u000e\u001b\u0005AR#\n\u0005\u0005\u0017!5R\"\u0001\r\r3\rAq#D\u0001\u00190\u00156Aa\u0003\u0005\u0019\u001b\u000fA\n$U\u0002\u0002\tO)S\u0001B\u0006\t35\u0011A\u0012\u0001\r\u0003K\u001d!1\u0002c\r\u000e\t%\u0011\u0011\"\u0001\r\b1=)S\u0001B\u0006\t55\u0011A\u0012\u0001M\u001bK\u0011!1\u0002C\u000e\u000e\u0003a\tQu\u0002\u0003\f\u0011oiI\u0001$\u0001\u00199E\u001b\u0011\u0001\"\u000f&\u000e!iR\u0012\u0002G\u00011)\t6!\u0001C\u001dK\u001b!1\u0002c\u000f\u000e\baq\u0012kA\u0001\u0005(\u0015\u0012B!\u0001E\u001f\u001b\u0005AB\"\u0007\u0003\t\u00145\u0011A\u0012\u0001\r\u000b3\u0011Aq$\u0004\u0002\r\u0002a\u0011\u0011d\u0001\u0005\u000e\u001b\u0005AR#\n\u0003\u0005\u0017!}R\"\u0001\r\fS\u001d!\u0011\t\u0003E\u0004\u001b\u0005A\u0012!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\u0013i\u0011\u0001G\u0003\u001dCE\u001b1!\u0004\u0002\u0005\f!1\u0011\u0006\u0003\u0003B9!5QB\u0001G\u00011\u001d\t6!A\u0003\u0001S5!\u0019\t\bE\b\u001b\u0015I!!C\u0001\u0019\u00071\u0005\u0001\u0004\u0003\u000f\u0002A\u0005\t6!A\u0003\u0001S%!\u0019\t\bE\t\u001b\u0005A\u0012\u0002H\u0001!\u0003E\u001b\u0011!\u0002\u0001*\u0015\u0011\rE\u0004c\u0005\u000e\u00051\u0005\u0001D\u0003\u000f\u0002A\u0005\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/VariableView;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "Lorg/jetbrains/debugger/VariableContext;", "name", "", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "(Ljava/lang/String;Lorg/jetbrains/debugger/Variable;Lorg/jetbrains/debugger/VariableContext;)V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "remainingChildren", "", "remainingChildrenOffset", "", "value", "Lorg/jetbrains/debugger/values/Value;", "canNavigateToSource", "", "computeArrayRanges", "", "properties", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeChildren", "computeIndexedProperties", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/values/ArrayValue;", "isLastChildren", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computeNamedProperties", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/debugger/values/ObjectValue;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluationExpression", "getMemberFilter", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "getParent", "getScope", "Lorg/jetbrains/debugger/Scope;", "Lorg/jetbrains/annotations/Nullable;", "getValue", "getViewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "setEvaluatedValue", "error", "watchableAsEvaluationExpression", "Companion", "MyFullValueEvaluator", "ObsolescentIndexedVariablesConsumer"}, moduleName="script-debugger-ui")
public final class VariableView
extends XNamedValue
implements VariableContext {
    private volatile Value value;
    private MemberFilter memberFilter;
    private volatile List<? extends Variable> remainingChildren;
    private volatile int remainingChildrenOffset;
    private final Variable variable;
    private final VariableContext context;
    public static final Companion Companion = org.jetbrains.debugger.VariableView$Companion.INSTANCE;

    @Override
    public boolean watchableAsEvaluationExpression() {
        return this.context.watchableAsEvaluationExpression();
    }

    @Override
    @NotNull
    public DebuggerViewSupport getViewSupport() {
        return this.context.getViewSupport();
    }

    @Override
    @NotNull
    public VariableContext getParent() {
        return this.context;
    }

    @Override
    @NotNull
    public Promise<MemberFilter> getMemberFilter() {
        return this.context.getViewSupport().getMemberFilter(this);
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        this.value = this.variable.getValue();
        if (this.value != null) {
            Value value = this.value;
            if (value == null) {
                Intrinsics.throwNpe();
            }
            this.computePresentation(value, node);
            return;
        }
        if (!(this.variable instanceof ObjectProperty) || ((ObjectProperty)this.variable).getGetter() == null) {
            Promise $receiver = this.getEvaluateContext().evaluate(this.variable.getName());
            $receiver = $receiver.done((Consumer)new ObsolescentConsumer<T>((Obsolescent)node, this, node){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node$inlined;

                public void consume(T param) {
                    EvaluateResult it = (EvaluateResult)param;
                    if (it.wasThrown) {
                        VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(VariableView.access$getValue$p(this.this$0), null), null, this.$node$inlined);
                    } else {
                        VariableView.access$setValue$p(this.this$0, it.value);
                        Value value = it.value;
                        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"it.value");
                        VariableView.access$computePresentation(this.this$0, value, this.$node$inlined);
                    }
                }
                {
                    void $super_call_param$1;
                    this.this$0 = variableView;
                    this.$node$inlined = xValueNode;
                    super((Obsolescent)$super_call_param$1);
                }
            });
            $receiver.rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, this, node){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XValueNode $node$inlined;

                public void consume(Throwable param) {
                    Throwable it = param;
                    VariableView.access$setEvaluatedValue(this.this$0, this.this$0.getViewSupport().transformErrorOnGetUsedReferenceValue(null, it.getMessage()), it.getMessage(), this.$node$inlined);
                }
                {
                    void $super_call_param$1;
                    this.this$0 = variableView;
                    this.$node$inlined = xValueNode;
                    super((Obsolescent)$super_call_param$1);
                }
            });
            return;
        }
        node.setPresentation((Icon)null, new XValuePresentation(){

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                renderer.renderValue("\u2026");
            }
        }, false);
        node.setFullValueEvaluator(new XFullValueEvaluator(this, node, " (invoke getter)"){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ XValueNode $node;

            /*
             * WARNING - void declaration
             */
            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                void node;
                void $receiver;
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                ValueModifier valueModifier = ((ObjectProperty)VariableView.access$getVariable$p(this.this$0)).getValueModifier();
                PreconditionsKt.assert((valueModifier != null ? 1 : 0) != 0);
                ValueModifier valueModifier2 = valueModifier;
                if (valueModifier2 == null) {
                    Intrinsics.throwNpe();
                }
                Variable variable = VariableView.access$getVariable$p(this.this$0);
                EvaluateContext evaluateContext2 = this.this$0.getEvaluateContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
                Promise<Value> promise2 = valueModifier2.evaluateGet(variable, evaluateContext2);
                Obsolescent obsolescent = (Obsolescent)this.$node;
                $receiver.done((Consumer)new ObsolescentConsumer<T>((Obsolescent)node, this, callback){
                    final /* synthetic */ computePresentation.4 this$0;
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback$inlined;

                    public void consume(T param) {
                        Value it = (Value)param;
                        this.$callback$inlined.evaluated("");
                        VariableView.access$setEvaluatedValue(this.this$0.this$0, it, null, this.this$0.$node);
                    }
                    {
                        void $super_call_param$1;
                        this.this$0 = var2_2;
                        this.$callback$inlined = xFullValueEvaluationCallback;
                        super((Obsolescent)$super_call_param$1);
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$node = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.setShowValuePopup(false));
    }

    private final void setEvaluatedValue(Value value, String error, XValueNode node) {
        if (value == null) {
            String string = null;
            String string2 = error;
            if (string2 == null) {
                string2 = "Internal Error";
            }
            node.setPresentation(AllIcons.Debugger.Db_primitive, string, string2, false);
        } else {
            this.value = value;
            this.computePresentation(value, node);
        }
    }

    private final void computePresentation(Value value, XValueNode node) {
        switch (VariableView$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
            case 1: 
            case 2: {
                Value value2 = value;
                if (value2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
                }
                this.context.getViewSupport().computeObjectPresentation((ObjectValue)value2, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 3: {
                node.setPresentation(this.getIcon(), (XValuePresentation)new ObjectValuePresentation(VariableViewKt.trimFunctionDescription(value)), true);
                break;
            }
            case 4: {
                this.context.getViewSupport().computeArrayPresentation(value, this.variable, this.context, node, this.getIcon());
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, (XValuePresentation)new XKeywordValuePresentation(string), false);
                break;
            }
            case 8: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, VariableViewKt.access$createNumberPresentation(string), false);
                break;
            }
            case 9: {
                Icon icon = this.getIcon();
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(string), false);
                if (!(value instanceof StringValue) || !((StringValue)value).isTruncated()) {
                    String string2 = value.getValueString();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (string2.length() <= 1000) break;
                }
                node.setFullValueEvaluator((XFullValueEvaluator)new MyFullValueEvaluator(value));
                break;
            }
            default: {
                Icon icon = this.getIcon();
                String string = null;
                String string3 = value.getValueString();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                node.setPresentation(icon, string, string3, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        node.setAlreadySorted(true);
        if (!(this.value instanceof ObjectValue)) {
            node.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        List<? extends Variable> list = this.remainingChildren;
        if (list != null) {
            int to = Math.min(this.remainingChildrenOffset + 100, list.size());
            boolean isLast = to == list.size();
            node.addChildren(VariablesKt.createVariablesList(list, this.remainingChildrenOffset, to, this, this.memberFilter), isLast);
            if (!isLast) {
                node.tooManyChildren(list.size() - to);
                this.remainingChildrenOffset += 100;
            }
            return;
        }
        Value value = this.value;
        if (value == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ObjectValue");
        }
        ObjectValue objectValue = (ObjectValue)value;
        boolean hasNamedProperties = Intrinsics.areEqual((Object)objectValue.hasProperties(), (Object)ThreeState.NO) ^ true;
        boolean hasIndexedProperties = Intrinsics.areEqual((Object)objectValue.hasIndexedProperties(), (Object)ThreeState.NO) ^ true;
        SmartList promises = new SmartList();
        Promise<?> additionalProperties = this.getViewSupport().computeAdditionalObjectProperties(objectValue, this.variable, this, node);
        if (additionalProperties != null) {
            promises.add(additionalProperties);
        }
        if (hasIndexedProperties) {
            ObjectValue objectValue2 = objectValue;
            if (objectValue2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.ArrayValue");
            }
            promises.add(this.computeIndexedProperties((ArrayValue)objectValue2, node, !hasNamedProperties && additionalProperties == null));
        }
        if (hasNamedProperties) {
            if (additionalProperties == null || Intrinsics.areEqual((Object)additionalProperties.getState(), (Object)Promise.State.PENDING) ^ true) {
                promises.add(this.computeNamedProperties(objectValue, node, !hasIndexedProperties && additionalProperties == null));
            } else {
                void $receiver;
                Promise<?> promise2 = additionalProperties;
                SmartList smartList = promises;
                Promise promise3 = $receiver.then((AsyncFunction)new ValueNodeAsyncFunction<T, SUB_RESULT>((Obsolescent)node, this, objectValue, node){
                    final /* synthetic */ VariableView this$0;
                    final /* synthetic */ ObjectValue $objectValue$inlined;
                    final /* synthetic */ XCompositeNode $node$inlined;

                    public Promise<SUB_RESULT> fun(T param) {
                        T it = param;
                        return VariableView.access$computeNamedProperties(this.this$0, this.$objectValue$inlined, this.$node$inlined, true);
                    }
                    {
                        void $super_call_param$1;
                        this.this$0 = variableView;
                        this.$objectValue$inlined = objectValue;
                        this.$node$inlined = xCompositeNode;
                        super((Obsolescent)$super_call_param$1);
                    }
                });
                smartList.add((Object)promise3);
            }
        }
        if (hasIndexedProperties == hasNamedProperties || additionalProperties != null) {
            Promise.all((Collection)((Collection)promises)).processed((Consumer)new ObsolescentConsumer<Object>(node, (Obsolescent)node){
                final /* synthetic */ XCompositeNode $node;

                public void consume(@Nullable Object aVoid) {
                    this.$node.addChildren(XValueChildrenList.EMPTY, true);
                }
                {
                    this.$node = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            });
        }
    }

    private final Promise<?> computeIndexedProperties(ArrayValue value, XCompositeNode node, boolean isLastChildren) {
        return value.getIndexedProperties(0, value.getLength(), 100, new ObsolescentIndexedVariablesConsumer(this, value, node, isLastChildren, node){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ArrayValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public void consumeRanges(@Nullable int[] ranges) {
                if (ranges == null) {
                    XValueChildrenList groupList = new XValueChildrenList();
                    LazyVariablesGroup.addGroups(this.$value, LazyVariablesGroup.GROUP_FACTORY, groupList, 0, this.$value.getLength(), 100, this.this$0);
                    this.$node.addChildren(groupList, this.$isLastChildren);
                } else {
                    LazyVariablesGroup.addRanges(this.$value, ranges, this.$node, this.this$0, this.$isLastChildren);
                }
            }

            public void consumeVariables(@NotNull List<? extends Variable> variables) {
                Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
                this.$node.addChildren(VariablesKt.createVariablesList(variables, this.this$0, null), this.$isLastChildren);
            }
            {
                this.this$0 = $outer;
                this.$value = $captured_local_variable$1;
                this.$node = $captured_local_variable$2;
                this.$isLastChildren = $captured_local_variable$3;
                super($super_call_param$4);
            }
        }, null);
    }

    private final Promise<Unit> computeNamedProperties(ObjectValue value, XCompositeNode node, boolean isLastChildren) {
        return VariablesKt.processVariables(this, value.getProperties(), (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, ? extends Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(this, value, node, isLastChildren){
            final /* synthetic */ VariableView this$0;
            final /* synthetic */ ObjectValue $value;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLastChildren;

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                FunctionValue functionValue;
                Intrinsics.checkParameterIsNotNull((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
                VariableView.access$setMemberFilter$p(this.this$0, memberFilter);
                if (Intrinsics.areEqual((Object)((Object)this.$value.getType()), (Object)((Object)ValueType.ARRAY)) && !(this.$value instanceof ArrayValue)) {
                    VariableView.access$computeArrayRanges(this.this$0, variables, this.$node);
                    return;
                }
                ObjectValue objectValue = this.$value;
                if (!(objectValue instanceof FunctionValue)) {
                    objectValue = null;
                }
                if ((functionValue = (FunctionValue)objectValue) != null && Intrinsics.areEqual((Object)functionValue.hasScopes(), (Object)ThreeState.NO)) {
                    functionValue = null;
                }
                VariableView.access$setRemainingChildren$p(this.this$0, VariablesKt.processNamedObjectProperties(variables, this.$node, this.this$0, memberFilter, 100, this.$isLastChildren && functionValue == null));
                if (VariableView.access$getRemainingChildren$p(this.this$0) != null) {
                    VariableView.access$setRemainingChildrenOffset$p(this.this$0, 100);
                }
                if (functionValue != null) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new FunctionScopesValueGroup(functionValue, VariableView.access$getContext$p(this.this$0))), this.$isLastChildren);
                }
            }
            {
                this.this$0 = variableView;
                this.$value = objectValue;
                this.$node = xCompositeNode;
                this.$isLastChildren = bl;
                super(2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void computeArrayRanges(List<? extends Variable> properties, XCompositeNode node) {
        int notGroupedVariablesOffset;
        int bucketSize;
        List<Variable> variables;
        int count;
        MemberFilter memberFilter = this.memberFilter;
        if (memberFilter == null) {
            Intrinsics.throwNpe();
        }
        if ((count = (variables = VariablesKt.filterAndSort(properties, memberFilter)).size()) <= (bucketSize = 100)) {
            node.addChildren(VariablesKt.createVariablesList(variables, this, null), true);
            return;
        }
        while (count > 0 && !Character.isDigit(variables.get(count - 1).getName().charAt(0))) {
            --count;
        }
        XValueChildrenList groupList = new XValueChildrenList();
        if (count > 0) {
            LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, 0, count, bucketSize, this);
        }
        if (variables.size() - count > bucketSize) {
            for (notGroupedVariablesOffset = variables.size(); notGroupedVariablesOffset > 0 && StringsKt.startsWith$default((String)variables.get(notGroupedVariablesOffset - 1).getName(), (String)"__", (boolean)false, (int)2); --notGroupedVariablesOffset) {
            }
            if (notGroupedVariablesOffset > 0) {
                LazyVariablesGroup.addGroups(variables, VariablesGroup.GROUP_FACTORY, groupList, count, notGroupedVariablesOffset, bucketSize, this);
            }
        } else {
            notGroupedVariablesOffset = count;
        }
        int n = notGroupedVariablesOffset;
        int n2 = variables.size() - 1;
        if (n <= n2) {
            while (true) {
                void i;
                Variable variable = variables.get((int)i);
                MemberFilter memberFilter2 = this.memberFilter;
                if (memberFilter2 == null) {
                    Intrinsics.throwNpe();
                }
                String string = memberFilter2.rawNameToSource(variable);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"memberFilter!!.rawNameToSource(variable)");
                groupList.add((XNamedValue)new VariableView(string, variable, this));
                if (i == n2) break;
                ++i;
            }
        }
        node.addChildren(groupList, true);
    }

    private final Icon getIcon() {
        Value value = this.value;
        if (value == null) {
            Intrinsics.throwNpe();
        }
        return Companion.getIcon(value);
    }

    @Nullable
    public XValueModifier getModifier() {
        if (!this.variable.isMutable()) {
            return null;
        }
        return new XValueModifier(this){
            final /* synthetic */ VariableView this$0;

            @Nullable
            public String getInitialValueEditorText() {
                String string;
                Value value = VariableView.access$getValue$p(this.this$0);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)((Object)value.getType()), (Object)((Object)ValueType.STRING))) {
                    Value value2 = VariableView.access$getValue$p(this.this$0);
                    if (value2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = value2.getValueString();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    String string3 = string2;
                    StringBuilder builder = new StringBuilder(string3.length());
                    builder.append('\"');
                    StringUtil.escapeStringCharacters((int)string3.length(), (String)string3, (StringBuilder)builder);
                    builder.append('\"');
                    return builder.toString();
                }
                Value value3 = VariableView.access$getValue$p(this.this$0);
                if (value3 == null) {
                    Intrinsics.throwNpe();
                }
                if (value3.getType().isObjectType()) {
                    string = null;
                } else {
                    Value value4 = VariableView.access$getValue$p(this.this$0);
                    if (value4 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = value4.getValueString();
                }
                return string;
            }

            public void setValue(@NotNull String expression, @NotNull XValueModifier.XModificationCallback callback) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                ValueModifier valueModifier = VariableView.access$getVariable$p(this.this$0).getValueModifier();
                if (valueModifier == null) {
                    Intrinsics.throwNpe();
                }
                Variable variable = VariableView.access$getVariable$p(this.this$0);
                EvaluateContext evaluateContext2 = this.this$0.getEvaluateContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
                valueModifier.setValue(variable, expression, evaluateContext2).done((Consumer)new Consumer<Object>(this, callback){
                    final /* synthetic */ getModifier.1 this$0;
                    final /* synthetic */ XValueModifier.XModificationCallback $callback;

                    public final void consume(@Nullable Object it) {
                        VariableView.access$setValue$p(this.this$0.this$0, null);
                        this.$callback.valueModified();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = xModificationCallback;
                    }
                }).rejected(VariableViewKt.access$createErrorMessageConsumer((XValueCallback)callback));
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    @Override
    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.context.getEvaluateContext();
    }

    @Nullable
    public final Value getValue() {
        return this.variable.getValue();
    }

    public boolean canNavigateToSource() {
        return this.value instanceof FunctionValue || this.getViewSupport().canNavigateToSource(this.variable, this.context);
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        if (this.value instanceof FunctionValue) {
            Value value = this.value;
            if (value == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.values.FunctionValue");
            }
            ((FunctionValue)value).resolve().done(new Consumer<T>(this, navigatable){
                final /* synthetic */ VariableView this$0;
                final /* synthetic */ XNavigatable $navigatable;

                public final void consume(FunctionValue function) {
                    Vm vm = this.this$0.getViewSupport().getVm();
                    if (vm == null) {
                        Intrinsics.throwNpe();
                    }
                    ScriptManager scriptManager = vm.getScriptManager();
                    FunctionValue functionValue = function;
                    Intrinsics.checkExpressionValueIsNotNull((Object)functionValue, (String)"function");
                    scriptManager.getScript(functionValue).done((Consumer)new Consumer<T>(this, function){
                        final /* synthetic */ computeSourcePosition.1 this$0;
                        final /* synthetic */ FunctionValue $function;

                        public final void consume(Script it) {
                            SourceInfo position = it == null ? (SourceInfo)null : this.this$0.this$0.getViewSupport().getSourceInfo((String)null, it, this.$function.getOpenParenLine(), this.$function.getOpenParenColumn());
                            this.this$0.$navigatable.setSourcePosition((XSourcePosition)(position == null ? null : new XSourcePositionWrapper(position){

                                @NotNull
                                public Navigatable createNavigatable(@NotNull Project project) {
                                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                                    Navigatable result2 = PsiVisitors.visit(this.myPosition, project, new PsiVisitors.Visitor<Navigatable>(){

                                        @Nullable
                                        public Navigatable visit(@NotNull PsiElement element, int positionOffset, @NotNull Document document) {
                                            PsiElement psiElement;
                                            PsiElement psiReference;
                                            block5: {
                                                PsiElement referenceCandidate;
                                                block4: {
                                                    PsiElement psiElement2;
                                                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                                                    Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                                                    referenceCandidate = element;
                                                    psiReference = null;
                                                    do {
                                                        if ((psiElement2 = referenceCandidate) != null && (psiElement2 = psiElement2.getPrevSibling()) != null) continue;
                                                        break block4;
                                                    } while (!((referenceCandidate = psiElement2) instanceof PsiReference));
                                                    psiReference = referenceCandidate;
                                                }
                                                if (psiReference == null) {
                                                    PsiElement psiElement3;
                                                    referenceCandidate = element.getParent();
                                                    do {
                                                        if ((psiElement3 = referenceCandidate) != null && (psiElement3 = psiElement3.getPrevSibling()) != null) continue;
                                                        break block5;
                                                    } while (!((referenceCandidate = psiElement3) instanceof PsiReference));
                                                    psiReference = referenceCandidate;
                                                }
                                            }
                                            if (!((psiElement = psiReference == null ? element.getNavigationElement() : psiReference.getNavigationElement()) instanceof Navigatable)) {
                                                psiElement = null;
                                            }
                                            return (Navigatable)psiElement;
                                        }
                                    }, null);
                                    Navigatable navigatable = result2;
                                    if (navigatable == null) {
                                        Navigatable navigatable2 = super.createNavigatable(project);
                                        navigatable = navigatable2;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)navigatable2, (String)"super.createNavigatable(project)");
                                    }
                                    return navigatable;
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$function = functionValue;
                        }
                    });
                }
                {
                    this.this$0 = variableView;
                    this.$navigatable = xNavigatable;
                }
            });
        } else {
            DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
            String string = this.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            Value value = this.value;
            if (value == null) {
                Intrinsics.throwNpe();
            }
            debuggerViewSupport.computeSourcePosition(string, value, this.variable, this.context, navigatable);
        }
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        DebuggerViewSupport debuggerViewSupport = this.getViewSupport();
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        return debuggerViewSupport.computeInlineDebuggerData(string, this.variable, this.context, callback);
    }

    @Nullable
    public String getEvaluationExpression() {
        if (!this.watchableAsEvaluationExpression()) {
            return null;
        }
        SmartList list = new SmartList((Object)this.variable.getName());
        for (VariableContext parent = this.context; parent != null && parent.getName() != null; parent = parent.getParent()) {
            String string = parent.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            list.add((Object)string);
        }
        return this.context.getViewSupport().propertyNamesToString((List)list, false);
    }

    @Override
    @Nullable
    public Scope getScope() {
        return this.context.getScope();
    }

    public VariableView(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(name);
        this.variable = variable;
        this.context = context;
    }

    @Nullable
    public static final /* synthetic */ Value access$getValue$p(VariableView $this) {
        return $this.value;
    }

    public static final /* synthetic */ void access$setValue$p(VariableView $this, @Nullable Value value) {
        $this.value = value;
    }

    @Nullable
    public static final /* synthetic */ MemberFilter access$getMemberFilter$p(VariableView $this) {
        return $this.memberFilter;
    }

    public static final /* synthetic */ void access$setMemberFilter$p(VariableView $this, @Nullable MemberFilter memberFilter) {
        $this.memberFilter = memberFilter;
    }

    @Nullable
    public static final /* synthetic */ List<Variable> access$getRemainingChildren$p(VariableView $this) {
        return $this.remainingChildren;
    }

    public static final /* synthetic */ void access$setRemainingChildren$p(VariableView $this, @Nullable List<? extends Variable> list) {
        $this.remainingChildren = list;
    }

    public static final /* synthetic */ int access$getRemainingChildrenOffset$p(VariableView $this) {
        return $this.remainingChildrenOffset;
    }

    public static final /* synthetic */ void access$setRemainingChildrenOffset$p(VariableView $this, int n) {
        $this.remainingChildrenOffset = n;
    }

    public static final /* synthetic */ void access$setEvaluatedValue(VariableView $this, @Nullable Value value, @Nullable String error, @NotNull XValueNode node) {
        $this.setEvaluatedValue(value, error, node);
    }

    public static final /* synthetic */ void access$computePresentation(VariableView $this, @NotNull Value value, @NotNull XValueNode node) {
        $this.computePresentation(value, node);
    }

    @NotNull
    public static final /* synthetic */ Variable access$getVariable$p(VariableView $this) {
        return $this.variable;
    }

    @NotNull
    public static final /* synthetic */ Promise<Unit> access$computeNamedProperties(VariableView $this, @NotNull ObjectValue value, @NotNull XCompositeNode node, boolean isLastChildren) {
        return $this.computeNamedProperties(value, node, isLastChildren);
    }

    public static final /* synthetic */ void access$computeArrayRanges(VariableView $this, @NotNull List<? extends Variable> properties, @NotNull XCompositeNode node) {
        $this.computeArrayRanges(properties, node);
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getContext$p(VariableView $this) {
        return $this.context;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0017!1\u0003\u0004\u0001\u001a\u0003a\u0005\u0011UB\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005A!!\n\u0003\u0005\u0017!\u001dQ\"\u0001\r\u0005S)!!\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0005\u000b\u0001i!\u0001\"\u0002\t\u0007\u0001"}, strings={"Lorg/jetbrains/debugger/VariableView$ObsolescentIndexedVariablesConsumer;", "Lorg/jetbrains/debugger/values/IndexedVariablesConsumer;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "getNode", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "isObsolete", ""}, moduleName="script-debugger-ui")
    public static abstract class ObsolescentIndexedVariablesConsumer
    extends IndexedVariablesConsumer {
        @NotNull
        private final XCompositeNode node;

        @Override
        public boolean isObsolete() {
            return this.node.isObsolete();
        }

        @NotNull
        protected final XCompositeNode getNode() {
            return this.node;
        }

        public ObsolescentIndexedVariablesConsumer(@NotNull XCompositeNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.node = node;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001d\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0011\tA\u0002A\r\u00021\u0003\tk!C\u0002\t\u00035\t\u00014A)\u0004\u0003!\u0011Q\u0005\u0003\u0003\f\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u0005S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/debugger/VariableView$MyFullValueEvaluator;", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator;", "value", "Lorg/jetbrains/debugger/values/Value;", "(Lorg/jetbrains/debugger/values/Value;)V", "startEvaluation", "", "callback", "Lcom/intellij/xdebugger/frame/XFullValueEvaluator$XFullValueEvaluationCallback;"}, moduleName="script-debugger-ui")
    private static final class MyFullValueEvaluator
    extends XFullValueEvaluator {
        private final Value value;

        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            if (!(this.value instanceof StringValue) || !((StringValue)this.value).isTruncated()) {
                String string = this.value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                callback.evaluated(string);
                return;
            }
            AtomicBoolean evaluated = new AtomicBoolean();
            ((StringValue)this.value).getFullString().done(new Consumer<T>(this, callback, evaluated){
                final /* synthetic */ MyFullValueEvaluator this$0;
                final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;
                final /* synthetic */ AtomicBoolean $evaluated;

                public final void consume(String it) {
                    if (!this.$callback.isObsolete() && this.$evaluated.compareAndSet(false, true)) {
                        String string = ((StringValue)MyFullValueEvaluator.access$getValue$p(this.this$0)).getValueString();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        this.$callback.evaluated(string);
                    }
                }
                {
                    this.this$0 = myFullValueEvaluator;
                    this.$callback = xFullValueEvaluationCallback;
                    this.$evaluated = atomicBoolean;
                }
            }).rejected(VariableViewKt.access$createErrorMessageConsumer((XValueCallback)callback));
        }

        public MyFullValueEvaluator(@NotNull Value value) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (value instanceof StringValue) {
                n = ((StringValue)value).getLength();
            } else {
                String string = value.getValueString();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                n = string.length();
            }
            super(n);
            this.value = value;
        }

        @NotNull
        public static final /* synthetic */ Value access$getValue$p(MyFullValueEvaluator $this) {
            return $this.value;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!J\u0004\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002&'!\u001dQ\"\u0001\r\u00053\rA)!D\u0001\u0019\u0007e\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a\u0011\u0011d\u0001\u0005\u0007\u001b\u0005Aj!J\b\t\u000f5\t\u0001\u0004B\r\u0004\u0011\u000bi\u0011\u0001g\u0004\u001a\u0007!-Q\"\u0001\r\u00033\rAa!D\u0001\u0019\u000e\u0001"}, strings={"Lorg/jetbrains/debugger/VariableView$Companion;", "", "()V", "getIcon", "Ljavax/swing/Icon;", "value", "Lorg/jetbrains/debugger/values/Value;", "setArrayPresentation", "", "context", "Lorg/jetbrains/debugger/VariableContext;", "icon", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "setObjectPresentation", "Lorg/jetbrains/debugger/values/ObjectValue;"}, moduleName="script-debugger-ui")
    public static final class Companion {
        public static final Companion INSTANCE;

        public final void setObjectPresentation(@NotNull ObjectValue value, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            node.setPresentation(icon, (XValuePresentation)new ObjectValuePresentation(VariableViewKt.getObjectValueDescription(value)), Intrinsics.areEqual((Object)value.hasProperties(), (Object)ThreeState.NO) ^ true);
        }

        public final void setArrayPresentation(@NotNull Value value, @NotNull VariableContext context, @NotNull Icon icon, @NotNull XValueNode node) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            PreconditionsKt.assert((boolean)Intrinsics.areEqual((Object)((Object)value.getType()), (Object)((Object)ValueType.ARRAY)));
            if (value instanceof ArrayValue) {
                int length = ((ArrayValue)value).getLength();
                node.setPresentation(icon, (XValuePresentation)new ArrayPresentation(length, ((ArrayValue)value).getClassName()), length > 0);
                return;
            }
            String valueString = value.getValueString();
            if (valueString != null && StringsKt.endsWith$default((String)valueString, (String)"]", (boolean)false, (int)2) && VariableViewKt.access$getARRAY_DESCRIPTION_PATTERN$p().matcher(valueString).find()) {
                node.setPresentation(icon, (String)null, valueString, true);
            } else {
                Promise $receiver;
                Promise<EvaluateResult> promise2 = context.getEvaluateContext().evaluate("a.length", Collections.singletonMap("a", value), false);
                $receiver = $receiver.done((Consumer)new ObsolescentConsumer<T>((Obsolescent)node, node, icon){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;

                    public void consume(T param) {
                        EvaluateResult it = (EvaluateResult)param;
                        this.$node$inlined.setPresentation(this.$icon$inlined, (String)null, "Array[" + it.value.getValueString() + "]", true);
                    }
                    {
                        void $super_call_param$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super((Obsolescent)$super_call_param$1);
                    }
                });
                $receiver.rejected((Consumer)new ObsolescentConsumer<Throwable>((Obsolescent)node, node, icon){
                    final /* synthetic */ XValueNode $node$inlined;
                    final /* synthetic */ Icon $icon$inlined;

                    public void consume(Throwable param) {
                        Throwable it = param;
                        this.$node$inlined.setPresentation(this.$icon$inlined, (String)null, "Internal error: " + it, false);
                    }
                    {
                        void $super_call_param$1;
                        this.$node$inlined = xValueNode;
                        this.$icon$inlined = icon;
                        super((Obsolescent)$super_call_param$1);
                    }
                });
            }
        }

        @NotNull
        public final Icon getIcon(@NotNull Value value) {
            Icon icon;
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            ValueType type = value.getType();
            switch (VariableView$Companion$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    Icon icon2 = AllIcons.Nodes.Function;
                    icon = icon2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Nodes.Function");
                    break;
                }
                case 2: {
                    Icon icon3 = AllIcons.Debugger.Db_array;
                    icon = icon3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Debugger.Db_array");
                    break;
                }
                default: {
                    icon = type.isObjectType() ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
                }
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when (type) {\n        Va\u2026gger.Db_primitive\n      }");
            return icon;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

