/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XValueCallback;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.regex.Pattern;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"E\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u0007)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u000e\u001a!\u0011Q\"\u0001M\u00033\rA1!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013!61AG\r\t\u0005AQ!\u0004\u0003\n\u0005%\t\u0001D\u0002M\u00063\rAi!D\u0001\u0019\u000fQ\u001b\u0019!d\u0005\u0005\u0003!=Q\"\u0001\r\t3\rA\t\"D\u0001\u0019\u0013Q\u001b\u0019!$\u0005\t\u00145\t\u0001$C\r\u0004\u0011#i\u0011\u0001\u0007\u0006U\u0007\u0007i\t\u0002#\u0006\u000e\u0003aI\u0011d\u0001E\t\u001b\u0005A\"\u0002VB\u0002\u001b'!\u0001\u0001C\u0006\u000e\u0003aI\u0011d\u0001E\t\u001b\u0005A:\u0002VB\u0002#3!\u0011\t\u0003\u0005\u0001\u001b\u0015\u0001\u0012!\u0006\u0002\r\u0002a\u0005\u0001\u0014A)\u0004\u0003\u0015\u0001Aka\u0001"}, strings={"ARRAY_DESCRIPTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VariableViewKt", "VariableView", "Lorg/jetbrains/debugger/VariableView;", "variable", "Lorg/jetbrains/debugger/Variable;", "context", "Lorg/jetbrains/debugger/VariableContext;", "createErrorMessageConsumer", "Lcom/intellij/util/Consumer;", "", "callback", "Lcom/intellij/xdebugger/frame/XValueCallback;", "createNumberPresentation", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "", "getClassName", "Lorg/jetbrains/debugger/values/ObjectValue;", "getObjectValueDescription", "trimFunctionDescription", "Lorg/jetbrains/debugger/values/Value;"}, moduleName="script-debugger-ui")
public final class VariableViewKt {
    private static final Pattern ARRAY_DESCRIPTION_PATTERN = Pattern.compile("^[a-zA-Z\\d]+\\[\\d+\\]$");

    @NotNull
    public static final VariableView VariableView(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = variable.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variable.name");
        return new VariableView(string, variable, context);
    }

    @NotNull
    public static final String getClassName(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String className = value.getClassName();
        if (StringsKt.isNullOrEmpty((CharSequence)className)) {
            string = "Object";
        } else {
            string = className;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    @NotNull
    public static final String getObjectValueDescription(@NotNull ObjectValue value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String description = value.getValueString();
        if (StringsKt.isNullOrEmpty((CharSequence)description)) {
            string = VariableViewKt.getClassName(value);
        } else {
            string = description;
            if (string == null) {
                Intrinsics.throwNpe();
            }
        }
        return string;
    }

    @NotNull
    public static final String trimFunctionDescription(@NotNull Value value) {
        int endIndex;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String string = value.getValueString();
        if (string == null) {
            return "";
        }
        String presentableValue = string;
        for (endIndex = 0; endIndex < presentableValue.length() && !StringUtil.isLineBreak((char)presentableValue.charAt(endIndex)); ++endIndex) {
        }
        while (endIndex > 0 && Character.isWhitespace(presentableValue.charAt(endIndex - 1))) {
            --endIndex;
        }
        return StringsKt.substring((String)presentableValue, (int)0, (int)endIndex);
    }

    private static final XValuePresentation createNumberPresentation(String value) {
        return Intrinsics.areEqual((Object)value, (Object)"NaN") || Intrinsics.areEqual((Object)value, (Object)"Infinity") ? (XValuePresentation)new XKeywordValuePresentation(value) : (XValuePresentation)new XNumericValuePresentation(value);
    }

    private static final Consumer<Throwable> createErrorMessageConsumer(XValueCallback callback) {
        return (Consumer)new Consumer<Throwable>(callback){
            final /* synthetic */ XValueCallback $callback;

            public void consume(@NotNull Throwable error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                String string = error.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                this.$callback.errorOccurred(string);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ Consumer<Throwable> access$createErrorMessageConsumer(@NotNull XValueCallback callback) {
        return VariableViewKt.createErrorMessageConsumer(callback);
    }

    public static final /* synthetic */ Pattern access$getARRAY_DESCRIPTION_PATTERN$p() {
        return ARRAY_DESCRIPTION_PATTERN;
    }

    @NotNull
    public static final /* synthetic */ XValuePresentation access$createNumberPresentation(@NotNull String value) {
        return VariableViewKt.createNumberPresentation(value);
    }
}

