/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppIcon;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Window;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

public class ActivateApplicationHttpService
extends RestService {
    @Override
    @NotNull
    protected String getServiceName() {
        if ("show" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/ActivateApplicationHttpService", "getServiceName"));
        }
        return "show";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/ide/ActivateApplicationHttpService", "isMethodSupported"));
        }
        return method == HttpMethod.GET;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        if (urlDecoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDecoder", "org/jetbrains/ide/ActivateApplicationHttpService", "execute"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/ide/ActivateApplicationHttpService", "execute"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/ide/ActivateApplicationHttpService", "execute"));
        }
        final IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
        if (frame instanceof Window) {
            ActivateApplicationHttpService.sendOk(request, context);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Window window = (Window)frame;
                    window.toFront();
                    window.requestFocusInWindow();
                    AppIcon.getInstance().requestFocus(frame);
                }
            };
            SwingUtilities.invokeLater(runnable);
            return "Success";
        }
        ActivateApplicationHttpService.sendStatus(HttpResponseStatus.NOT_FOUND, false, context.channel());
        return "Can't find IDE Frame";
    }
}

