/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.commonmark;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.AtxHeaderProvider;
import org.intellij.markdown.parser.markerblocks.providers.BlockQuoteProvider;
import org.intellij.markdown.parser.markerblocks.providers.CodeBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.CodeFenceProvider;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.markerblocks.providers.ListMarkerProvider;
import org.intellij.markdown.parser.markerblocks.providers.SetextHeaderProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"C\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!\u0019\u0001B\u0006\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!(\u0001\u000eC+I1\u0001c\u0001\u000e\u0003a\u0011\u0011b\u0001E\u0003\u001b\u0005A2!U\u0002\u0002\u0011\u000f)\u0013\u0003B\u0006\t\u00115!\u0011BA\u0005\u00021#AJ!G\u0003\t\u00135\u0019\u00014C\u0015\u00021)I2\u0001c\u0001\u000e\u0003a\u0011QE\u0003\u0003\u000b\u0011+iq!C\u0003\n\t%\u0011\u0011\"\u0001\r\u00021\u0015AJ!\n\n\u0005\u0015!YQ\"\u0001M\f3\u0015A\u0011\"D\u0002\u0019\u0014%\n\u0001DC\r\u0004\u00111i\u0011\u0001G\u0002\u001a\u0007!\rQ\"\u0001\r\u0003K)!!\u0002#\u0007\u000e\u0003a]\u0011$\u0002\u0005\n\u001b\rA\u001a\"K\u0001\u0019\u0015%jA!\u0011\u0005\t\t59\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u000ba%\u0011kA\u0001\u0006\u0001%rAA\u0013\u000f\t\f5\t\u0001$\u0001\u0011\f#\u000e9Q\u0001A\u0007\u0003\t\u0019Ai!\u0005\u0002\u0005\u000f!=\u0001"}, strings={"Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor;", "Lorg/intellij/markdown/parser/MarkerProcessor;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "constraintsBase", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "(Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;)V", "markerBlockProviders", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "stateInfo", "getStateInfo", "()Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "setStateInfo", "(Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;)V", "createNewMarkerBlocks", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "getMarkerBlockProviders", "populateConstraintsTokens", "", "constraints", "updateStateInfo", "Factory"}, moduleName="intellij-markdown")
public class CommonMarkMarkerProcessor
extends MarkerProcessor<MarkerProcessor.StateInfo> {
    @NotNull
    private MarkerProcessor.StateInfo stateInfo;
    private final List<? extends MarkerBlockProvider<MarkerProcessor.StateInfo>> markerBlockProviders;

    @Override
    @NotNull
    protected MarkerProcessor.StateInfo getStateInfo() {
        return this.stateInfo;
    }

    public void setStateInfo(@NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"<set-?>");
        this.stateInfo = stateInfo;
    }

    @Override
    @NotNull
    protected List<MarkerBlockProvider<MarkerProcessor.StateInfo>> getMarkerBlockProviders() {
        return this.markerBlockProviders;
    }

    @Override
    protected void updateStateInfo(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (pos.getChar() == '\n') {
            this.setStateInfo(new MarkerProcessor.StateInfo(this.getStartConstraints(), MarkdownConstraints.Companion.fillFromPrevious(pos.getCurrentLine(), 0, this.getTopBlockConstraints()), this.getMarkersStack()));
        } else if (MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, this.getStateInfo().getNextConstraints())) {
            MarkdownConstraints markdownConstraints = this.getStateInfo().getNextConstraints();
            MarkdownConstraints markdownConstraints2 = this.getStateInfo().getNextConstraints().addModifierIfNeeded(pos);
            if (markdownConstraints2 == null) {
                markdownConstraints2 = this.getStateInfo().getNextConstraints();
            }
            this.setStateInfo(new MarkerProcessor.StateInfo(markdownConstraints, markdownConstraints2, this.getMarkersStack()));
        }
    }

    @Override
    protected void populateConstraintsTokens(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        if (constraints.getIndent() == 0) {
            return;
        }
        int startOffset = pos.getOffset();
        int endOffset = Math.min(pos.getOffset() - pos.getOffsetInCurrentLine() + constraints.getCharsEaten(pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        Character c = constraints.getLastType();
        IElementType type = Intrinsics.areEqual((Object)c, (Object)Character.valueOf('>')) ? MarkdownTokenTypes.Companion.getBLOCK_QUOTE() : (Intrinsics.areEqual((Object)c, (Object)Character.valueOf('.')) || Intrinsics.areEqual((Object)c, (Object)Character.valueOf(')')) ? MarkdownTokenTypes.Companion.getLIST_NUMBER() : MarkdownTokenTypes.Companion.getLIST_BULLET());
        productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node((Range<Integer>)((Range)new IntRange(startOffset, endOffset)), type)));
    }

    @Override
    @NotNull
    public List<MarkerBlock> createNewMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        if (pos.getChar() == '\n') {
            return this.getNO_BLOCKS();
        }
        return super.createNewMarkerBlocks(pos, productionHolder);
    }

    public CommonMarkMarkerProcessor(@NotNull ProductionHolder productionHolder, @NotNull MarkdownConstraints constraintsBase) {
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)constraintsBase, (String)"constraintsBase");
        super(productionHolder, constraintsBase);
        this.stateInfo = new MarkerProcessor.StateInfo(this.getStartConstraints(), this.getStartConstraints(), this.getMarkersStack());
        this.markerBlockProviders = CollectionsKt.listOf((Object[])new MarkerBlockProvider[]{new CodeBlockProvider(), new HorizontalRuleProvider(), new SetextHeaderProvider(), new BlockQuoteProvider(), new ListMarkerProvider(), new AtxHeaderProvider(), new CodeFenceProvider(), new HtmlBlockProvider(), new LinkReferenceDefinitionProvider()});
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u0015\u0011Y\u00012A\u0007\u0004\u0013\u0005!\u0019\u0001\u0007\u0002\u001a\u0007!\u0015Q\"\u0001\r\u0004"}, strings={"Lorg/intellij/markdown/flavours/commonmark/CommonMarkMarkerProcessor$Factory;", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "()V", "createMarkerProcessor", "Lorg/intellij/markdown/parser/MarkerProcessor;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;"}, moduleName="intellij-markdown")
    public static final class Factory
    implements MarkerProcessorFactory {
        public static final Factory INSTANCE;
        public static final Factory INSTANCE$;

        @Override
        @NotNull
        public MarkerProcessor<?> createMarkerProcessor(@NotNull ProductionHolder productionHolder) {
            Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
            return new CommonMarkMarkerProcessor(productionHolder, MarkdownConstraints.Companion.getBASE());
        }

        static {
            new Factory();
        }

        private Factory() {
            INSTANCE = this;
            INSTANCE$ = this;
        }
    }
}

