/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.ArrayList;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.ListItemMarkerBlock;
import org.intellij.markdown.parser.markerblocks.impl.ListMarkerBlock;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!)\u0002R\u0007\u0005A\u0019!J\u000b\u0005\u0017!\u0011Q\u0002B\u0005\u0003\u0013\u0005A2\u0001'\u0002\u001a\u000b!\u001dQb\u0001\r\u0005S\u0005AJ!G\u0002\t\u000b5\t\u00014B\r\u0004\u0011\u0019i\u0011\u0001G\u0001&\u001d\u0011Y\u0001RB\u0007\u00021\u001dIR\u0001c\u0002\u000e\u0007a!\u0011&\u0001M\u00053\rAy!D\u0001\u0019\u0011\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/ListMarkerProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;"}, moduleName="intellij-markdown")
public final class ListMarkerProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        MarkdownConstraints currentConstraints = stateInfo.getCurrentConstraints();
        MarkdownConstraints nextConstraints = stateInfo.getNextConstraints();
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, currentConstraints)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)nextConstraints, (Object)currentConstraints) ^ true && Intrinsics.areEqual((Object)nextConstraints.getLastType(), (Object)Character.valueOf('>')) ^ true && Intrinsics.areEqual((Object)nextConstraints.getLastExplicit(), (Object)true)) {
            ArrayList<MarkerBlockImpl> result = new ArrayList<MarkerBlockImpl>();
            if (!(stateInfo.getLastBlock() instanceof ListMarkerBlock)) {
                ProductionHolder.Marker marker = productionHolder.mark();
                Character c = nextConstraints.getLastType();
                if (c == null) {
                    Intrinsics.throwNpe();
                }
                result.add(new ListMarkerBlock(nextConstraints, marker, c.charValue()));
            }
            result.add(new ListItemMarkerBlock(nextConstraints, productionHolder.mark()));
            return result;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        return false;
    }
}

