/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.List;
import kotlin.IntRange;
import kotlin.Range;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001E\u0007\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\t\u0001\u0002B\u0003\u0002\t\u0007a\u0001\u0001%\u0006\u001a\u0003a\u0005Q\u0014!\u0006\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003S5!1\n\u0003E\u0003\u001b\u0011I!!C\u0001\u0019\ba\u0019\u0011k\u0001\u0003\u0006\u00015\u0011A\u0001\u0002E\u0005S5!1\n\u0003\u0005\u0006\u001b\u0011I!!C\u0001\u0019\ba\u0019\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002E\u0005S)!1\n\u0003\u0005\u0007\u001b\u0005Aj!U\u0002\u0005\u000b\u0001i!\u0001B\u0004\t\u0010%jAa\u0013\u0005\t\u00115!\u0011BA\u0005\u00021%A\n\"U\u0002\u0005\u000b\u0001i!\u0001b\u0005\t\u0015\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache;", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "lexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "(Lorg/intellij/markdown/lexer/MarkdownLexer;)V", "cachedTokens", "", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "getCachedTokens", "()Ljava/util/List;", "filteredTokens", "getFilteredTokens", "originalText", "", "getOriginalText", "()Ljava/lang/CharSequence;", "originalTextRange", "Lkotlin/Range;", "", "getOriginalTextRange", "()Lkotlin/Range;", "Companion"}, moduleName="intellij-markdown")
public final class LexerBasedTokensCache
extends TokensCache {
    @NotNull
    private final List<? extends TokensCache.TokenInfo> cachedTokens;
    @NotNull
    private final List<? extends TokensCache.TokenInfo> filteredTokens;
    @NotNull
    private final CharSequence originalText;
    @NotNull
    private final Range<Integer> originalTextRange;
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache$Companion.INSTANCE;

    @Override
    @NotNull
    public List<TokensCache.TokenInfo> getCachedTokens() {
        return this.cachedTokens;
    }

    @Override
    @NotNull
    public List<TokensCache.TokenInfo> getFilteredTokens() {
        return this.filteredTokens;
    }

    @Override
    @NotNull
    public CharSequence getOriginalText() {
        return this.originalText;
    }

    @Override
    @NotNull
    public Range<Integer> getOriginalTextRange() {
        return this.originalTextRange;
    }

    /*
     * WARNING - void declaration
     */
    public LexerBasedTokensCache(@NotNull MarkdownLexer lexer) {
        void _filteredTokens;
        void _cachedTokens;
        Intrinsics.checkParameterIsNotNull((Object)lexer, (String)"lexer");
        Companion.ResultOfCaching resultOfCaching = LexerBasedTokensCache.Companion.cacheTokens(lexer);
        List<TokensCache.TokenInfo> list = resultOfCaching.component1();
        List<TokensCache.TokenInfo> list2 = resultOfCaching.component2();
        resultOfCaching = null;
        this.cachedTokens = _cachedTokens;
        this.filteredTokens = _filteredTokens;
        this.originalText = lexer.getOriginalText();
        this.originalTextRange = (Range)new IntRange(lexer.getBufferStart(), lexer.getBufferEnd() - 1);
        this.verify();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!19\u0001\u0007\u00013\u0005A\n!(A\u0006C\u000f!\u0011!U\u0002\u0002\u0011\u0005)\u0003\u0002B\u0001\t\u00045\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002&\u0013\u0011\t\u0001rA\u0007\u00021\u0011IB\u0001#\u0003\u000e\u00051\u0005\u0001$\u0002"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion;", "", "()V", "cacheTokens", "Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion$ResultOfCaching;", "lexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "isWhitespace", "", "elementType", "Lorg/intellij/markdown/IElementType;", "ResultOfCaching"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final boolean isWhitespace(IElementType elementType) {
            return Intrinsics.areEqual((Object)elementType, (Object)MarkdownTokenTypes.Companion.getWHITE_SPACE());
        }

        private final ResultOfCaching cacheTokens(MarkdownLexer lexer) {
            ArrayList<TokensCache.TokenInfo> cachedTokens = new ArrayList<TokensCache.TokenInfo>();
            ArrayList<TokensCache.TokenInfo> filteredTokens = new ArrayList<TokensCache.TokenInfo>();
            while (lexer.getType() != null) {
                IElementType iElementType = lexer.getType();
                if (iElementType == null) {
                    Intrinsics.throwNpe();
                }
                TokensCache.TokenInfo info = new TokensCache.TokenInfo(iElementType, lexer.getTokenStart(), lexer.getTokenEnd(), cachedTokens.size(), -1);
                cachedTokens.add(info);
                if (!this.isWhitespace(info.getType())) {
                    info.setNormIndex(filteredTokens.size());
                    filteredTokens.add(info);
                }
                lexer.advance();
            }
            return new ResultOfCaching((List<? extends TokensCache.TokenInfo>)cachedTokens, (List<? extends TokensCache.TokenInfo>)filteredTokens);
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t!\u0015\tA\"A\u0003\u0002\t\u0011!1\t\u0002\u0007\u00013\u0005A\n!)\t\n\r!\tQ\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001\n\r!\u0015Q\u0002B\u0005\u0003\u0013\u0005A\"\u0001g\u0001R\u0007\u0005A1!j\u0004\u0005\u0007\u001eAQ!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002K\u001f!1i\u0002E\u0006\u001b\u0011I!!C\u0001\u0019\u0005a\rQ\u0015\u0006\u0003D\u0007!1Q\"\u0001\r\u00013\u001d!\u0011\u0001C\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0007Ir\u0001B\u0001\t\u00065!\u0011BA\u0005\u00021\tA\u001a!K\u0007\u0005\u0007\"A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u000fAA!K\u0007\u0005\u0007\"A)!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0013AA\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/LexerBasedTokensCache$Companion$ResultOfCaching;", "", "cachedTokens", "", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$TokenInfo;", "filteredTokens", "(Ljava/util/List;Ljava/util/List;)V", "getCachedTokens", "()Ljava/util/List;", "getFilteredTokens", "component1", "component2", "copy"}, moduleName="intellij-markdown")
        public static final class ResultOfCaching {
            @NotNull
            private final List<? extends TokensCache.TokenInfo> cachedTokens;
            @NotNull
            private final List<? extends TokensCache.TokenInfo> filteredTokens;

            @NotNull
            public final List<TokensCache.TokenInfo> getCachedTokens() {
                return this.cachedTokens;
            }

            @NotNull
            public final List<TokensCache.TokenInfo> getFilteredTokens() {
                return this.filteredTokens;
            }

            public ResultOfCaching(@NotNull List<? extends TokensCache.TokenInfo> cachedTokens, @NotNull List<? extends TokensCache.TokenInfo> filteredTokens) {
                Intrinsics.checkParameterIsNotNull(cachedTokens, (String)"cachedTokens");
                Intrinsics.checkParameterIsNotNull(filteredTokens, (String)"filteredTokens");
                this.cachedTokens = cachedTokens;
                this.filteredTokens = filteredTokens;
            }

            @NotNull
            public final List<TokensCache.TokenInfo> component1() {
                return this.cachedTokens;
            }

            @NotNull
            public final List<TokensCache.TokenInfo> component2() {
                return this.filteredTokens;
            }

            @NotNull
            public final ResultOfCaching copy(@NotNull List<? extends TokensCache.TokenInfo> cachedTokens, @NotNull List<? extends TokensCache.TokenInfo> filteredTokens) {
                Intrinsics.checkParameterIsNotNull(cachedTokens, (String)"cachedTokens");
                Intrinsics.checkParameterIsNotNull(filteredTokens, (String)"filteredTokens");
                return new ResultOfCaching(cachedTokens, filteredTokens);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ ResultOfCaching copy$default(ResultOfCaching resultOfCaching, List list, List list2, int n) {
                if ((n & 1) != 0) {
                    list = resultOfCaching.cachedTokens;
                }
                if ((n & 2) != 0) {
                    list2 = resultOfCaching.filteredTokens;
                }
                return resultOfCaching.copy(list, list2);
            }

            public String toString() {
                return "ResultOfCaching(cachedTokens=" + this.cachedTokens + ", filteredTokens=" + this.filteredTokens + ")";
            }

            public int hashCode() {
                List<? extends TokensCache.TokenInfo> list = this.cachedTokens;
                List<? extends TokensCache.TokenInfo> list2 = this.filteredTokens;
                return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
            }

            public boolean equals(Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ResultOfCaching)) break block3;
                        ResultOfCaching resultOfCaching = (ResultOfCaching)object;
                        if (!Intrinsics.areEqual(this.cachedTokens, resultOfCaching.cachedTokens) || !Intrinsics.areEqual(this.filteredTokens, resultOfCaching.filteredTokens)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

