/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configurations.EncodingEnvironmentUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.HashMap;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private final Charset myDefaultCharset = CharsetToolkit.UTF8_CHARSET;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static boolean hasLoginArgument(String name) {
        return name.equals("bash") || name.equals("sh") || name.equals("zsh");
    }

    private static String getShellName(String path) {
        return new File(path).getName();
    }

    private static File findRCFile() {
        try {
            File rcFile;
            String folder = PtyUtil.getPtyLibFolderPath();
            if (folder != null && (rcFile = new File(folder, "jediterm.in")).exists()) {
                return rcFile;
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to get JAR folder", (Throwable)e);
        }
        return null;
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        LocalTerminalDirectRunner localTerminalDirectRunner = new LocalTerminalDirectRunner(project);
        if (localTerminalDirectRunner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner", "createTerminalRunner"));
        }
        return localTerminalDirectRunner;
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        HashMap envs = new HashMap(System.getenv());
        envs.put("TERM", "xterm-256color");
        EncodingEnvironmentUtil.setLocaleEnvironmentIfMac((Map)envs, (Charset)this.myDefaultCharset);
        try {
            return PtyProcess.exec((String[])this.getCommand(), (Map)envs, (String)(directory != null ? directory : this.currentProjectFolder()));
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    private String currentProjectFolder() {
        VirtualFile baseDir;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        VirtualFile[] roots = projectRootManager.getContentRoots();
        if (roots.length == 1) {
            roots[0].getCanonicalPath();
        }
        return (baseDir = this.myProject.getBaseDir()) == null ? null : baseDir.getCanonicalPath();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, this.getCommand()[0]);
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset);
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand() {
        String[] command;
        String shellPath = TerminalOptionsProvider.getInstance().getShellPath();
        if (SystemInfo.isUnix) {
            File rcFile = LocalTerminalDirectRunner.findRCFile();
            String shellName = LocalTerminalDirectRunner.getShellName(shellPath);
            command = rcFile != null && (shellName.equals("bash") || shellName.equals("sh")) ? new String[]{shellPath, "--rcfile", rcFile.getAbsolutePath(), "-i"} : (LocalTerminalDirectRunner.hasLoginArgument(shellName) ? new String[]{shellPath, "--login"} : shellPath.split(" "));
        } else {
            command = new String[]{shellPath};
        }
        return command;
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        public PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "<init>"));
            }
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    try {
                        PtyProcessHandler.this.myWaitFor.setTerminationCallback((Consumer)new Consumer<Integer>(){

                            public void consume(Integer integer) {
                                PtyProcessHandler.this.notifyProcessTerminated(integer);
                            }
                        });
                    }
                    finally {
                        PtyProcessHandler.this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "executeTask"));
            }
            Future<?> future = PtyProcessHandler.executeOnPooledThread(task);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/terminal/LocalTerminalDirectRunner$PtyProcessHandler", "executeTask"));
            }
            return future;
        }

        protected static Future<?> executeOnPooledThread(Runnable task) {
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                return application.executeOnPooledThread(task);
            }
            return BaseOSProcessHandler.submit((Runnable)task);
        }
    }
}

