/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupported;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.TaskExecutionView;
import org.jetbrains.plugins.gradle.util.GradleBundle;

public class GradleRunnerUtil {
    public static DuplexConsoleView attachTaskExecutionView(@NotNull Project project, final @NotNull ConsoleView consoleView, boolean isTaskConsoleEnabledByDefault, final @Nullable String stateStorageKey, @NotNull ProcessHandler processHandler, @NotNull ExternalSystemTaskId taskId) {
        String tripleStateStorageKey;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil", "attachTaskExecutionView"));
        }
        String string = tripleStateStorageKey = stateStorageKey != null ? stateStorageKey + "_str" : null;
        if (stateStorageKey != null && isTaskConsoleEnabledByDefault && !PropertiesComponent.getInstance().isValueSet(tripleStateStorageKey)) {
            PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.TRUE.toString());
            PropertiesComponent.getInstance().setValue(stateStorageKey, Boolean.TRUE.booleanValue());
        }
        TaskExecutionView gradleExecutionConsole = new TaskExecutionView(project);
        final Ref duplexConsoleViewRef = Ref.create();
        DuplexConsoleView<ConsoleView, ConsoleView> duplexConsoleView = new DuplexConsoleView<ConsoleView, ConsoleView>((ConsoleView)gradleExecutionConsole, consoleView, stateStorageKey){

            public void enableConsole(boolean primary) {
                super.enableConsole(primary);
                if (stateStorageKey != null) {
                    PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.toString(primary));
                }
            }

            @NotNull
            public AnAction[] createConsoleActions() {
                AnAction[] consoleActions;
                DefaultActionGroup textActionGroup = new DefaultActionGroup(){

                    public void update(AnActionEvent e) {
                        super.update(e);
                        if (duplexConsoleViewRef.get() != null) {
                            e.getPresentation().setVisible(!((DuplexConsoleView)duplexConsoleViewRef.get()).isPrimaryConsoleEnabled());
                        }
                    }
                };
                for (AnAction anAction : consoleActions = consoleView.createConsoleActions()) {
                    textActionGroup.add(anAction);
                }
                ArrayList anActions = ContainerUtil.newArrayList((Object[])super.createConsoleActions());
                anActions.add(textActionGroup);
                AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)anActions, AnAction.class);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$1", "createConsoleActions"));
                }
                return anActionArray;
            }
        };
        duplexConsoleViewRef.set((Object)duplexConsoleView);
        duplexConsoleView.setDisableSwitchConsoleActionOnProcessEnd(false);
        duplexConsoleView.getSwitchConsoleActionPresentation().setIcon(AllIcons.Actions.ChangeView);
        duplexConsoleView.getSwitchConsoleActionPresentation().setText(GradleBundle.message("gradle.runner.toggle.tree.text.action.name", new Object[0]));
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter((DuplexConsoleView)duplexConsoleView, gradleExecutionConsole, progressManager){
            final /* synthetic */ DuplexConsoleView val$duplexConsoleView;
            final /* synthetic */ TaskExecutionView val$gradleExecutionConsole;
            final /* synthetic */ ExternalSystemProgressNotificationManager val$progressManager;
            {
                this.val$duplexConsoleView = duplexConsoleView;
                this.val$gradleExecutionConsole = taskExecutionView;
                this.val$progressManager = externalSystemProgressNotificationManager;
            }

            public void onStatusChange(final @NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onStatusChange"));
                }
                if (event instanceof ExternalSystemTaskExecutionEvent) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemProgressEventUnsupported) {
                                val$duplexConsoleView.enableConsole(false);
                            }
                            val$gradleExecutionConsole.onStatusChange((ExternalSystemTaskExecutionEvent)event);
                        }
                    });
                }
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, final @NotNull Exception e) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onFailure"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onFailure"));
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        val$gradleExecutionConsole.onFailure(e);
                    }
                });
            }

            public void onEnd(@NotNull ExternalSystemTaskId id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2", "onEnd"));
                }
                this.val$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }
        };
        progressManager.addNotificationListener(taskId, (ExternalSystemTaskNotificationListener)taskListener);
        return duplexConsoleView;
    }
}

