/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectPreview;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.execution.UnsupportedCancellationToken;
import org.jetbrains.plugins.gradle.service.project.BaseGradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.DefaultProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.GradleImportCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleProjectResolver.class.getName()));
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer;
    private final MultiMap<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;
    public static final Key<Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>>> RESOLVED_SOURCE_SETS = Key.create((String)"resolvedSourceSets");
    public static final Key<Map<String, Pair<String, ExternalSystemSourceType>>> MODULES_OUTPUTS = Key.create((String)"moduleOutputsMap");
    public static final Key<Map<String, String>> CONFIGURATION_ARTIFACTS = Key.create((String)"gradleArtifactsMap");

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "<init>"));
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myCancellationMap = MultiMap.create();
        this.myHelper = helper;
    }

    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (settings != null) {
            this.myHelper.ensureInstalledWrapper(id, projectPath, settings, listener);
        }
        GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain(settings);
        DefaultProjectResolverContext resolverContext = new DefaultProjectResolverContext(id, projectPath, settings, listener, isPreviewMode);
        DataNode<ProjectData> resultProjectDataNode = this.myHelper.execute(projectPath, settings, new ProjectConnectionDataNodeFunction(resolverContext, projectResolverChain, false));
        String buildSrcProjectPath = projectPath + "/buildSrc";
        DefaultProjectResolverContext buildSrcResolverCtx = new DefaultProjectResolverContext(id, buildSrcProjectPath, settings, listener, isPreviewMode);
        resolverContext.copyUserDataTo(buildSrcResolverCtx);
        this.handleBuildSrcProject(resultProjectDataNode, new ProjectConnectionDataNodeFunction(buildSrcResolverCtx, projectResolverChain, true));
        return resultProjectDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "cancelTask"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "cancelTask"));
        }
        MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
        synchronized (multiMap) {
            for (CancellationTokenSource cancellationTokenSource : this.myCancellationMap.get((Object)id)) {
                cancellationTokenSource.cancel();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull DefaultProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        IdeaModule ideaModule;
        DataNode moduleDataNode;
        IdeaProject ideaProject;
        ProjectImportAction.AllModels allModels;
        void var11_14;
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        if (projectResolverChain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverChain", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        ProjectImportAction projectImportAction = new ProjectImportAction(resolverCtx.isPreviewMode());
        ArrayList<KeyValue<String, String>> extraJvmArgs = new ArrayList<KeyValue<String, String>>();
        ArrayList commandLineArgs = ContainerUtil.newArrayList();
        HashSet toolingExtensionClasses = ContainerUtil.newHashSet();
        if (resolverCtx.isPreviewMode()) {
            commandLineArgs.add("-Didea.isPreviewMode=true");
            Set previewLightWeightToolingModels = ContainerUtil.set((Object[])new Class[]{ExternalProjectPreview.class});
            projectImportAction.addExtraProjectModelClasses(previewLightWeightToolingModels);
        }
        GradleImportCustomizer importCustomizer = GradleImportCustomizer.get();
        for (GradleProjectResolverExtension resolverExtension = projectResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            if (!resolverCtx.isPreviewMode()) {
                projectImportAction.addExtraProjectModelClasses(resolverExtension.getExtraProjectModelClasses());
            }
            if (importCustomizer == null || importCustomizer.useExtraJvmArgs()) {
                extraJvmArgs.addAll(resolverExtension.getExtraJvmArgs());
            }
            commandLineArgs.addAll(resolverExtension.getExtraCommandLineArgs());
            toolingExtensionClasses.addAll(resolverExtension.getToolingExtensionsClasses());
        }
        ParametersList parametersList = new ParametersList();
        for (KeyValue keyValue : extraJvmArgs) {
            parametersList.addProperty((String)keyValue.getKey(), (String)keyValue.getValue());
        }
        BuildEnvironment buildEnvironment = GradleExecutionHelper.getBuildEnvironment(resolverCtx.getConnection());
        Object var11_12 = null;
        if (buildEnvironment != null) {
            GradleVersion gradleVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        }
        BuildActionExecuter buildActionExecutor = resolverCtx.getConnection().action((BuildAction)projectImportAction);
        File initScript = GradleExecutionHelper.generateInitScript(isBuildSrcProject, toolingExtensionClasses);
        if (initScript != null) {
            ContainerUtil.addAll((Collection)commandLineArgs, (Object[])new String[]{"--init-script", initScript.getAbsolutePath()});
        }
        GradleExecutionHelper.prepare((LongRunningOperation)buildActionExecutor, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getListener(), parametersList.getParameters(), commandLineArgs, resolverCtx.getConnection());
        resolverCtx.checkCancelled();
        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
        try {
            resolverCtx.setCancellationTokenSource(cancellationTokenSource);
            buildActionExecutor.withCancellationToken(cancellationTokenSource.token());
            MultiMap<ExternalSystemTaskId, CancellationTokenSource> multiMap = this.myCancellationMap;
            synchronized (multiMap) {
                this.myCancellationMap.putValue((Object)resolverCtx.getExternalSystemTaskId(), (Object)cancellationTokenSource);
                if (var11_14 != null && var11_14.compareTo(GradleVersion.version((String)"2.1")) < 0) {
                    this.myCancellationMap.putValue((Object)resolverCtx.getExternalSystemTaskId(), (Object)new UnsupportedCancellationToken());
                }
            }
            allModels = (ProjectImportAction.AllModels)buildActionExecutor.run();
            if (allModels == null) {
                throw new IllegalStateException("Unable to get project model for the project: " + resolverCtx.getProjectPath());
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            resolverCtx.checkCancelled();
            Class aClass = resolverCtx.isPreviewMode() ? BasicIdeaProject.class : IdeaProject.class;
            ModelBuilder<BasicIdeaProject> modelBuilder = this.myHelper.getModelBuilder(aClass, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getConnection(), resolverCtx.getListener(), parametersList.getParameters());
            ideaProject = (IdeaProject)modelBuilder.get();
            allModels = new ProjectImportAction.AllModels(ideaProject);
        }
        finally {
            MultiMap<ExternalSystemTaskId, CancellationTokenSource> unsupportedVersionException = this.myCancellationMap;
            synchronized (unsupportedVersionException) {
                this.myCancellationMap.remove((Object)resolverCtx.getExternalSystemTaskId(), (Object)cancellationTokenSource);
            }
        }
        resolverCtx.checkCancelled();
        allModels.setBuildEnvironment(buildEnvironment);
        GradleProjectResolver.extractExternalProjectModels(allModels, resolverCtx.isPreviewMode());
        resolverCtx.setModels(allModels);
        ProjectData projectData = projectResolverChain.createProject();
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        JavaProjectData javaProjectData = projectResolverChain.createJavaProjectData();
        projectDataNode.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        ideaProject = resolverCtx.getModels().getIdeaProject();
        projectResolverChain.populateProjectExtraModels(ideaProject, (DataNode<ProjectData>)projectDataNode);
        DomainObjectSet gradleModules = ideaProject.getModules();
        if (gradleModules == null || gradleModules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + ideaProject);
        }
        HashMap moduleMap = ContainerUtilRt.newHashMap();
        HashMap sourceSetsMap = ContainerUtil.newHashMap();
        projectDataNode.putUserData(RESOLVED_SOURCE_SETS, (Object)sourceSetsMap);
        THashMap moduleOutputsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(MODULES_OUTPUTS, (Object)moduleOutputsMap);
        THashMap artifactsMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        projectDataNode.putUserData(CONFIGURATION_ARTIFACTS, (Object)artifactsMap);
        for (Object gradleModule : gradleModules) {
            String moduleName;
            if (gradleModule == null) continue;
            resolverCtx.checkCancelled();
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
            }
            moduleDataNode = projectResolverChain.createModule((IdeaModule)gradleModule, (DataNode<ProjectData>)projectDataNode);
            String mainModuleId = GradleProjectResolverUtil.getModuleId((IdeaModule)gradleModule);
            moduleMap.put(mainModuleId, Pair.create((Object)moduleDataNode, (Object)gradleModule));
        }
        File gradleHomeDir = null;
        for (Pair pair : moduleMap.values()) {
            BuildScriptClasspathModel buildScriptClasspathModel;
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            if (gradleHomeDir == null && (buildScriptClasspathModel = resolverCtx.getExtraProject(ideaModule, BuildScriptClasspathModel.class)) != null) {
                gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
            }
            projectResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            if (!isBuildSrcProject) {
                projectResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            }
            List modules = ContainerUtil.newSmartList();
            modules.add(moduleDataNode);
            modules.addAll(ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, GradleSourceSetData.KEY));
            ExternalSystemSourceType[] sourceTypes = new ExternalSystemSourceType[]{ExternalSystemSourceType.SOURCE, ExternalSystemSourceType.RESOURCE, ExternalSystemSourceType.TEST, ExternalSystemSourceType.TEST_RESOURCE};
            for (DataNode module : modules) {
                ModuleData moduleData = (ModuleData)module.getData();
                for (ExternalSystemSourceType sourceType : sourceTypes) {
                    String path = moduleData.getCompileOutputPath(sourceType);
                    if (path == null) continue;
                    moduleOutputsMap.put(path, Pair.create((Object)moduleData.getId(), (Object)sourceType));
                }
                if (!(moduleData instanceof GradleSourceSetData)) continue;
                for (File artifactFile : moduleData.getArtifacts()) {
                    artifactsMap.put(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getAbsolutePath()), moduleData.getId());
                }
            }
        }
        for (Pair pair : moduleMap.values()) {
            moduleDataNode = (DataNode)pair.first;
            ideaModule = (IdeaModule)pair.second;
            projectResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            projectResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
        }
        GradleProjectResolver.mergeSourceSetContentRoots(moduleMap, resolverCtx);
        GradleProjectResolver.mergeLibraryAndModuleDependencyData((DataNode<ProjectData>)projectDataNode, gradleHomeDir, (GradleVersion)var11_14);
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        DataNode dataNode = projectDataNode;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        return dataNode;
    }

    private static void mergeLibraryAndModuleDependencyData(DataNode<ProjectData> projectDataNode, @Nullable File gradleHomeDir, @Nullable GradleVersion gradleVersion) {
        Map sourceSetMap = (Map)projectDataNode.getUserData(RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map moduleOutputsMap = (Map)projectDataNode.getUserData(MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map artifactsMap = (Map)projectDataNode.getUserData(CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively(projectDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.LIBRARY_DEPENDENCY);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            LibraryDependencyData libraryDependencyData;
            LibraryData libraryData;
            Set libraryPaths;
            DataNode libraryNodeParent;
            if (!libraryDependencyDataNode.getChildren().isEmpty() || (libraryNodeParent = libraryDependencyDataNode.getParent()) == null || (libraryPaths = (libraryData = (LibraryData)(libraryDependencyData = (LibraryDependencyData)libraryDependencyDataNode.getData()).getTarget()).getPaths(LibraryPathType.BINARY)).isEmpty() || StringUtil.isNotEmpty((String)libraryData.getExternalName())) continue;
            LinkedList unprocessedPaths = ContainerUtil.newLinkedList((Iterable)libraryPaths);
            while (!unprocessedPaths.isEmpty()) {
                Pair pair;
                String moduleId;
                String path = (String)unprocessedPaths.remove();
                Set targetModuleOutputPaths = null;
                Pair sourceTypePair = (Pair)moduleOutputsMap.get(path);
                if (sourceTypePair == null) {
                    moduleId = (String)artifactsMap.get(path);
                    if (moduleId != null) {
                        targetModuleOutputPaths = ContainerUtil.set((Object[])new String[]{path});
                    }
                } else {
                    moduleId = (String)sourceTypePair.first;
                }
                if (moduleId == null || (pair = (Pair)sourceSetMap.get(moduleId)) == null) continue;
                ModuleData moduleData = (ModuleData)((DataNode)pair.first).getData();
                if (targetModuleOutputPaths == null) {
                    HashSet compileSet = ContainerUtil.newHashSet();
                    ContainerUtil.addAllNotNull((Collection)compileSet, (Object[])new String[]{moduleData.getCompileOutputPath(ExternalSystemSourceType.SOURCE), moduleData.getCompileOutputPath(ExternalSystemSourceType.RESOURCE)});
                    if (!compileSet.isEmpty() && ContainerUtil.intersects((Collection)libraryPaths, (Collection)compileSet)) {
                        targetModuleOutputPaths = compileSet;
                    } else {
                        HashSet testSet = ContainerUtil.newHashSet();
                        ContainerUtil.addAllNotNull((Collection)testSet, (Object[])new String[]{moduleData.getCompileOutputPath(ExternalSystemSourceType.TEST), moduleData.getCompileOutputPath(ExternalSystemSourceType.TEST_RESOURCE)});
                        if (compileSet.isEmpty() && ContainerUtil.intersects((Collection)libraryPaths, (Collection)testSet)) {
                            targetModuleOutputPaths = testSet;
                        }
                    }
                }
                ModuleData ownerModule = libraryDependencyData.getOwnerModule();
                final ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, moduleData);
                moduleDependencyData.setScope(libraryDependencyData.getScope());
                if ("test".equals(((ExternalSourceSet)pair.second).getName())) {
                    moduleDependencyData.setProductionOnTestDependency(true);
                }
                DataNode found = ExternalSystemApiUtil.find((DataNode)libraryNodeParent, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE_DEPENDENCY, (BooleanFunction)new BooleanFunction<DataNode<ModuleDependencyData>>(){

                    public boolean fun(DataNode<ModuleDependencyData> node) {
                        return moduleDependencyData.equals(node.getData());
                    }
                });
                if (targetModuleOutputPaths != null) {
                    if (found == null) {
                        libraryNodeParent.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
                    }
                    libraryPaths.removeAll(targetModuleOutputPaths);
                    unprocessedPaths.removeAll(targetModuleOutputPaths);
                    if (!libraryPaths.isEmpty()) continue;
                    libraryDependencyDataNode.clear(true);
                    break;
                }
                if (found != null) {
                    libraryPaths.remove(path);
                    if (!libraryPaths.isEmpty()) continue;
                    libraryDependencyDataNode.clear(true);
                    break;
                }
                ExternalSourceDirectorySet directorySet = (ExternalSourceDirectorySet)((ExternalSourceSet)pair.second).getSources().get(sourceTypePair.second);
                if (directorySet == null) continue;
                for (File file : directorySet.getSrcDirs()) {
                    libraryData.addPath(LibraryPathType.SOURCE, file.getAbsolutePath());
                }
            }
            if (libraryDependencyDataNode.getParent() == null || libraryPaths.size() <= 1) continue;
            List toRemove = ContainerUtil.newSmartList();
            for (String path : libraryPaths) {
                File binaryPath = new File(path);
                if (!binaryPath.isFile()) continue;
                LibraryData extractedLibrary = new LibraryData(libraryDependencyData.getOwner(), "");
                extractedLibrary.addPath(LibraryPathType.BINARY, path);
                if (gradleHomeDir != null && gradleVersion != null) {
                    GradleProjectResolverUtil.attachGradleSdkSources(binaryPath, extractedLibrary, gradleHomeDir, gradleVersion);
                }
                LibraryDependencyData extractedDependencyData = new LibraryDependencyData(libraryDependencyData.getOwnerModule(), extractedLibrary, LibraryLevel.MODULE);
                libraryDependencyDataNode.getParent().createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)extractedDependencyData);
                toRemove.add(path);
            }
            libraryPaths.removeAll(toRemove);
            if (!libraryPaths.isEmpty()) continue;
            libraryDependencyDataNode.clear(true);
        }
    }

    private static Map<String, ExternalProject> extractExternalProjectModels(ProjectImportAction.AllModels models, boolean isPreview) {
        ExternalProject externalRootProject;
        ExternalProject externalProject = externalRootProject = isPreview ? (ExternalProject)models.getExtraProject(null, ExternalProjectPreview.class) : (ExternalProject)models.getExtraProject(null, ExternalProject.class);
        if (externalRootProject == null) {
            return Collections.emptyMap();
        }
        DefaultExternalProject wrappedExternalRootProject = new DefaultExternalProject(externalRootProject);
        models.addExtraProject((Object)wrappedExternalRootProject, ExternalProject.class);
        Map<String, ExternalProject> externalProjectsMap = GradleProjectResolver.createExternalProjectsMap((ExternalProject)wrappedExternalRootProject);
        DomainObjectSet gradleModules = models.getIdeaProject().getModules();
        if (gradleModules != null && !gradleModules.isEmpty()) {
            for (IdeaModule ideaModule : gradleModules) {
                ExternalProject externalProject2 = externalProjectsMap.get(GradleProjectResolverUtil.getModuleId(ideaModule));
                if (externalProject2 == null) continue;
                models.addExtraProject((Object)externalProject2, ExternalProject.class, (Object)ideaModule);
            }
        }
        return externalProjectsMap;
    }

    private static Map<String, ExternalProject> createExternalProjectsMap(@Nullable ExternalProject rootExternalProject) {
        HashMap externalProjectMap = ContainerUtilRt.newHashMap();
        if (rootExternalProject == null) {
            return externalProjectMap;
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(rootExternalProject);
        while (!queue.isEmpty()) {
            ExternalProject externalProject = (ExternalProject)queue.remove();
            queue.addAll(externalProject.getChildProjects().values());
            String moduleName = externalProject.getName();
            String qName = externalProject.getQName();
            String moduleId = StringUtil.isEmpty((String)qName) || ":".equals(qName) ? moduleName : qName;
            externalProjectMap.put(moduleId, externalProject);
        }
        return externalProjectMap;
    }

    private static void mergeSourceSetContentRoots(@NotNull Map<String, Pair<DataNode<ModuleData>, IdeaModule>> moduleMap, @NotNull ProjectResolverContext resolverCtx) {
        DataNode moduleNode;
        if (moduleMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "mergeSourceSetContentRoots"));
        }
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "mergeSourceSetContentRoots"));
        }
        class Counter {
            int count;

            Counter() {
            }

            void increment() {
                ++this.count;
            }
        }
        Factory<Counter> counterFactory = new Factory<Counter>(){

            public Counter create() {
                return new Counter();
            }
        };
        HashMap weightMap = ContainerUtil.newHashMap();
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                    ((Counter)ContainerUtil.getOrCreate((Map)weightMap, (Object)file.getPath(), (Factory)counterFactory)).increment();
                }
            }
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                HashSet set = ContainerUtil.newHashSet();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    for (File file = new File(((ContentRootData)contentRootNode.getData()).getRootPath()); file != null; file = file.getParentFile()) {
                        set.add(file.getPath());
                    }
                }
                for (String path : set) {
                    ((Counter)ContainerUtil.getOrCreate((Map)weightMap, (Object)path, (Factory)counterFactory)).increment();
                }
            }
        }
        for (Pair<DataNode<ModuleData>, IdeaModule> pair : moduleMap.values()) {
            moduleNode = (DataNode)pair.first;
            ExternalProject externalProject = resolverCtx.getExtraProject((IdeaModule)pair.second, ExternalProject.class);
            if (externalProject == null) continue;
            File buildDir = externalProject.getBuildDir();
            for (DataNode sourceSetNode : ExternalSystemApiUtil.findAll((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                LinkedHashMap sourceSetRoots = ContainerUtil.newLinkedHashMap();
                for (DataNode contentRootNode : ExternalSystemApiUtil.findAll((DataNode)sourceSetNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.CONTENT_ROOT)) {
                    File root = new File(((ContentRootData)contentRootNode.getData()).getRootPath());
                    if (FileUtil.isAncestor((File)buildDir, (File)root, (boolean)true)) continue;
                    while (weightMap.containsKey(root.getParent()) && ((Counter)weightMap.get((Object)root.getParent())).count <= 1) {
                        root = root.getParentFile();
                    }
                    DataNode mergedContentRootNode = (DataNode)sourceSetRoots.get(root.getPath());
                    if (mergedContentRootNode == null) {
                        ContentRootData mergedContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, root.getAbsolutePath());
                        mergedContentRootNode = sourceSetNode.createChild(ProjectKeys.CONTENT_ROOT, (Object)mergedContentRoot);
                        sourceSetRoots.put(root.getPath(), mergedContentRootNode);
                    }
                    for (ExternalSystemSourceType sourceType : ExternalSystemSourceType.values()) {
                        for (ContentRootData.SourceRoot sourceRoot : ((ContentRootData)contentRootNode.getData()).getPaths(sourceType)) {
                            ((ContentRootData)mergedContentRootNode.getData()).storePath(sourceType, sourceRoot.getPath(), sourceRoot.getPackagePrefix());
                        }
                    }
                    contentRootNode.clear(true);
                }
            }
        }
    }

    private void handleBuildSrcProject(@NotNull DataNode<ProjectData> resultProjectDataNode, @NotNull ProjectConnectionDataNodeFunction projectConnectionDataNodeFunction) {
        if (resultProjectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultProjectDataNode", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "handleBuildSrcProject"));
        }
        if (projectConnectionDataNodeFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectConnectionDataNodeFunction", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "handleBuildSrcProject"));
        }
        String projectPath = projectConnectionDataNodeFunction.myResolverContext.getProjectPath();
        if (!new File(projectPath).isDirectory()) {
            return;
        }
        if (projectConnectionDataNodeFunction.myResolverContext.isPreviewMode()) {
            ModuleData buildSrcModuleData = new ModuleData(":buildSrc", GradleConstants.SYSTEM_ID, StdModuleTypes.JAVA.getId(), "buildSrc", projectPath, projectPath);
            resultProjectDataNode.createChild(ProjectKeys.MODULE, (Object)buildSrcModuleData);
            return;
        }
        DataNode<ModuleData> buildSrcModuleDataNode = GradleProjectResolverUtil.findModule(resultProjectDataNode, projectPath);
        if (buildSrcModuleDataNode != null) {
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataDataNode = this.myHelper.execute(projectPath, projectConnectionDataNodeFunction.myResolverContext.getSettings(), projectConnectionDataNodeFunction);
        if (buildSrcProjectDataDataNode != null) {
            for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(buildSrcProjectDataDataNode, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE)) {
                resultProjectDataNode.addChild(moduleNode);
                ModuleData moduleData = (ModuleData)moduleNode.getData();
                if (moduleData.getIdeModuleGroup() == null) continue;
                String[] moduleGroup = (String[])ArrayUtil.prepend((Object)((ProjectData)resultProjectDataNode.getData()).getInternalName(), (Object[])moduleData.getIdeModuleGroup());
                moduleData.setIdeModuleGroup(moduleGroup);
                for (DataNode sourceSetNode : ExternalSystemApiUtil.getChildren((DataNode)moduleNode, GradleSourceSetData.KEY)) {
                    ((GradleSourceSetData)((Object)sourceSetNode.getData())).setIdeModuleGroup(moduleGroup);
                }
            }
        }
    }

    @NotNull
    public static GradleProjectResolverExtension createProjectResolverChain(@Nullable GradleExecutionSettings settings) {
        GradleProjectResolverExtension projectResolverChain;
        if (settings != null) {
            List<ClassHolder<? extends GradleProjectResolverExtension>> extensionClasses = settings.getResolverExtensions();
            ArrayDeque<GradleProjectResolverExtension> extensions = new ArrayDeque<GradleProjectResolverExtension>();
            for (ClassHolder<? extends GradleProjectResolverExtension> holder : extensionClasses) {
                GradleProjectResolverExtension extension;
                try {
                    extension = holder.getTargetClass().newInstance();
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(String.format("Can't instantiate project resolve extension for class '%s'", holder.getTargetClassName()), e);
                }
                GradleProjectResolverExtension previous = (GradleProjectResolverExtension)extensions.peekLast();
                if (previous != null) {
                    previous.setNext(extension);
                    if (previous.getNext() != extension) {
                        throw new AssertionError((Object)("Illegal next resolver got, current resolver class is " + previous.getClass().getName()));
                    }
                }
                extensions.add(extension);
            }
            GradleProjectResolverExtension resolverExtension = projectResolverChain = (GradleProjectResolverExtension)extensions.peekFirst();
            assert (resolverExtension != null);
            while (resolverExtension.getNext() != null) {
                resolverExtension = resolverExtension.getNext();
            }
            if (!(resolverExtension instanceof BaseGradleProjectResolverExtension)) {
                throw new AssertionError((Object)("Illegal last resolver got of class " + resolverExtension.getClass().getName()));
            }
        } else {
            projectResolverChain = new BaseGradleProjectResolverExtension();
        }
        BaseGradleProjectResolverExtension baseGradleProjectResolverExtension = projectResolverChain;
        if (baseGradleProjectResolverExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "createProjectResolverChain"));
        }
        return baseGradleProjectResolverExtension;
    }

    private class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;
        private DefaultProjectResolverContext myResolverContext;

        public ProjectConnectionDataNodeFunction(@NotNull DefaultProjectResolverContext resolverContext, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            if (resolverContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverContext", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            if (projectResolverChain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectResolverChain", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            this.myResolverContext = resolverContext;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            try {
                this.myResolverContext.setConnection(connection);
                return GradleProjectResolver.this.doResolveProjectInfo(this.myResolverContext, this.myProjectResolverChain, this.myIsBuildSrcProject);
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                throw this.myProjectResolverChain.getUserFriendlyError(e, this.myResolverContext.getProjectPath(), null);
            }
        }
    }
}

