/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashSet;
import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.PathStringDescriptor;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.inline.InlineUtilKt;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.incremental.CacheFormatVersion;
import org.jetbrains.kotlin.jps.incremental.ChangeInfo;
import org.jetbrains.kotlin.jps.incremental.CompilationResult;
import org.jetbrains.kotlin.jps.incremental.DifferenceKind;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.jps.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMap;
import org.jetbrains.kotlin.jps.incremental.storage.BasicMapsOwner;
import org.jetbrains.kotlin.jps.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.jps.incremental.storage.ConstantsMapExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.jps.incremental.storage.PathCollectionExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.PathFunctionPair;
import org.jetbrains.kotlin.jps.incremental.storage.PathFunctionPairKeyDescriptor;
import org.jetbrains.kotlin.jps.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.jps.incremental.storage.ProtoMapValueExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.StringListExternalizer;
import org.jetbrains.kotlin.jps.incremental.storage.StringToLongMapExternalizer;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeaderKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.jvm.BitEncoding;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!yQ\u0001A\u0003\u0002\u0011%)\u0011\u0001\"\u0002\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005A\u0001#B\u0001\u0005\b\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001D\u0001\u0006\u0003\u0011-A\u0002\u0001\t(3\u0005A\n!G\u0001\u0019\u0003u-qu\nU)S'R+fk\u0016-C+I1\u0001c\u0001\u000e\u0003a\u0011\u0011b\u0001E\u0003\u001b\u0005A2!U\u0002\u0002\u0011\u000f)s\u0001c\n\u000e\u0003a!\u0012d\u0001E\u0015\u001b\u0005A\u0002!\n\u0003\u0005\u0017!)R\"\u0001\r\u0015K\rAY#D\u0001\u0019)\u0015\u001a\u0001BF\u0007\u00021[)\u0003\u0002B\u0006\t/5\t\u0001DE\r\u0004\u0011_i\u0011\u0001\u0007\n&\r!AR\u0002B\u0005\u0003\u0013\u0005A\"\u0001'\r&\u000b\u0011Y\u0001\"G\u0007\u0003\u0019\u0003A\u001a$J\u0005\u0005\u0017!QRB\u0001G\u00011II2\u0001#\u000e\u000e\u0003a\u0011Re\u0002\u0003\f\u0011miA!\u0003\u0002\n\u0003a\u0011\u0002\u0014G\u0013\b\t-A9$\u0004\u0003\n\u0005%\t\u0001D\u0005M\u0019K%!1\u0002\u0003\u000f\u000e\u00051\u0005\u0001\u0014H\r\u0004\u0011ui\u0011\u0001\u0007\n&\u0019\u0011Y\u00012H\u0007\u0006\u0013\tI\u0011\u0001\u0007\n\r\u0002aE\u0012d\u0001\u0005\u001f\u001b\u0005A\"#\n\u0006\t>5\t\u0001\u0004F\r\u0007\u0011}iA!\u0003\u0002\n\u0003a\u0011\u0001tH\u0013\u0011\t-A\u0001%D\u0001\u0019)e\u0019\u0001\u0012I\u0007\u00021II2\u0001C\u0011\u000e\u0003a\u0011\u0012d\u0001E\"\u001b\u0005A\"#J\u0002\tE5\t\u0001\u0004F\u0013\b\u0011\u000bj\u0011\u0001'\f\u001a\u0007!\u0019S\"\u0001M$K9AA%D\u0001\u0019.e1\u0001\u0012J\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u00192e\u0019\u0001\"J\u0007\u00021\t);\u0002B\u0001\tL5\t\u0001\u0004F\u000b\u00021[IJ\u0001\u0003\u0014\u000e\u0003a5\u0003k!\u0001*\u000f\u0011\t\u0005\u0002\u0003\u0003\u000e\u0003a\u0011\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\n5\t\u0001$B)\u0004\u0003\u0015\u0001\u0011&\u0003\u0003B\u0011!-Qb\u0001\r\u0007S\u0005A\u0002!U\u0002\u0002\u000b\u0001I#\u0002B!\t\u0011\u001biA!\u0003\u0002\n\u0003a\u0001\u0001dB)\u0004\u0003\u0015\u0001\u0011&\u0003\u0003B\u0011!=Qb\u0001\r\tS\u0005A\u0002!U\u0002\u0002\u000b\u0001I\u0013\u0002B!\t\u0011#i1\u0001G\u0005*\u0003a\u0001\u0011kA\u0001\u0006\u0001%JA!\u0011\u0005\t\u00145\u0019\u0001DC\u0015\u00021\u0001\t6!A\u0003\u0001S%!\u0011\t\u0003E\u000b\u001b\rA2\"K\u0001\u0019\u0001E\u001b\u0011!\u0002\u0001*\u0013\u0011\t\u0005\u0002c\u0006\u000e\u0007aa\u0011&\u0001\r\u0001#\u000e\tQ\u0001A\u0015\n\t\u0005C\u0001\u0012D\u0007\u000415I\u0013\u0001\u0007\u0001R\u0007\u0005)\u0001!k\u0005\u0005\u0003\"AY\"d\u0002\u0019\u0005E\u001b\u0011\u0001\u0002\bR\u0007\u0005)\u0001!K\u0005\u0005\u0003\"Ai\"D\u0002\u0019\u001f%\n\u0001\u0004A)\u0004\u0003\u0015\u0001\u0011&\u0003\u0003B\u0011!}Qb\u0001\r\u0011S\u0005A\u0002!U\u0002\u0002\u000b\u0001I\u0013\u0002B!\t\u0011Ci1\u0001G\t*\u0003a\u0001\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00065\t\u0001dA)\u0004\u0003\u0015\u0001\u0011\u0006\u0004\u0003B\u0011!\rR\"\u0001\r\u0003+\u0005A\"\u0003H\u0011R\u0007\ri!\u0001\"\n\t'\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMapsOwner;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "targetDataRoot", "Ljava/io/File;", "target", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Ljava/io/File;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "baseDir", "cacheFormatVersion", "Lorg/jetbrains/kotlin/jps/incremental/CacheFormatVersion;", "constantsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "dependents", "Ljava/util/ArrayList;", "dirtyInlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "inlineFunctionsMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "inlinedTo", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "multifileClassFacadeMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "multifileClassPartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "outputDir", "Lorg/jetbrains/annotations/Nullable;", "packagePartMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "protoMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "storageFile", "", "getStorageFile", "(Ljava/lang/String;)Ljava/io/File;", "addDependentCache", "", "cache", "clean", "cleanDirtyInlineFunctions", "clearCacheForRemovedClasses", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "getClassFilePath", "internalClassName", "getFilesToReinline", "", "getModuleMappingData", "", "getMultifileFacade", "partInternalName", "getObsoleteMultifileClasses", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "fqName", "getStableMultifileFacadeParts", "facadeInternalName", "markOutputClassesDirty", "removedAndCompiledSources", "", "registerInline", "fromPath", "jvmSignature", "toPath", "saveCacheFormatVersion", "saveFileToCache", "generatedClass", "Lorg/jetbrains/kotlin/jps/build/GeneratedJvmClass;", "saveModuleMappingToCache", "sourceFiles", "file", "logIfSomethingChanged", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Companion", "ConstantsMap", "DirtyInlineFunctionsMap", "DirtyOutputClassesMap", "InlineFunctionsFilesMap", "InlineFunctionsMap", "MultifileClassFacadeMap", "MultifileClassPartMap", "PackagePartMap", "ProtoMap", "SourceToClassesMap"}, moduleName="jps-plugin")
public final class IncrementalCacheImpl
extends BasicMapsOwner
implements IncrementalCache {
    @NotNull
    public static final String PROTO_MAP = "proto";
    @NotNull
    public static final String CONSTANTS_MAP = "constants";
    @NotNull
    public static final String INLINE_FUNCTIONS = "inline-functions";
    @NotNull
    public static final String PACKAGE_PARTS = "package-parts";
    @NotNull
    public static final String MULTIFILE_CLASS_FACADES = "multifile-class-facades";
    @NotNull
    public static final String MULTIFILE_CLASS_PARTS = "multifile-class-parts";
    @NotNull
    public static final String SOURCE_TO_CLASSES = "source-to-classes";
    @NotNull
    public static final String DIRTY_OUTPUT_CLASSES = "dirty-output-classes";
    @NotNull
    public static final String DIRTY_INLINE_FUNCTIONS = "dirty-inline-functions";
    @NotNull
    public static final String INLINED_TO = "inlined-to";
    private static final String MODULE_MAPPING_FILE_NAME = ".kotlin_module";
    private final File baseDir;
    private final ProtoMap protoMap;
    private final ConstantsMap constantsMap;
    private final InlineFunctionsMap inlineFunctionsMap;
    private final PackagePartMap packagePartMap;
    private final MultifileClassFacadeMap multifileClassFacadeMap;
    private final MultifileClassPartMap multifileClassPartMap;
    private final SourceToClassesMap sourceToClassesMap;
    private final DirtyOutputClassesMap dirtyOutputClassesMap;
    private final DirtyInlineFunctionsMap dirtyInlineFunctionsMap;
    private final InlineFunctionsFilesMap inlinedTo;
    private final CacheFormatVersion cacheFormatVersion;
    private final ArrayList<IncrementalCacheImpl> dependents;
    private final File outputDir;
    private final ModuleBuildTarget target;
    public static final Companion Companion = org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.INSTANCE;

    static {
        PROTO_MAP = PROTO_MAP;
        CONSTANTS_MAP = CONSTANTS_MAP;
        INLINE_FUNCTIONS = INLINE_FUNCTIONS;
        PACKAGE_PARTS = PACKAGE_PARTS;
        MULTIFILE_CLASS_FACADES = MULTIFILE_CLASS_FACADES;
        MULTIFILE_CLASS_PARTS = MULTIFILE_CLASS_PARTS;
        SOURCE_TO_CLASSES = SOURCE_TO_CLASSES;
        DIRTY_OUTPUT_CLASSES = DIRTY_OUTPUT_CLASSES;
        DIRTY_INLINE_FUNCTIONS = DIRTY_INLINE_FUNCTIONS;
        INLINED_TO = INLINED_TO;
        MODULE_MAPPING_FILE_NAME = "." + ModuleMapping.Companion.getMAPPING_FILE_EXT();
    }

    private final File getStorageFile(String $receiver) {
        return new File(this.baseDir, $receiver + "." + BasicMapsOwner.Companion.getCACHE_EXTENSION());
    }

    public void registerInline(@NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        this.inlinedTo.add(fromPath, jvmSignature, toPath);
    }

    public final void addDependentCache(@NotNull IncrementalCacheImpl cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.dependents.add(cache);
    }

    /*
     * WARNING - void declaration
     */
    public final void markOutputClassesDirty(@NotNull List<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        for (File file : removedAndCompiledSources) {
            void $receiver;
            Collection<JvmClassName> classes2 = this.sourceToClassesMap.get(file);
            Iterable iterable = classes2;
            for (Object element : $receiver) {
                JvmClassName it = (JvmClassName)element;
                DirtyOutputClassesMap dirtyOutputClassesMap = this.dirtyOutputClassesMap;
                String string = it.getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.internalName");
                dirtyOutputClassesMap.markDirty(string);
            }
            this.sourceToClassesMap.clearOutputsForSource(file);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFilesToReinline() {
        void destination;
        void $receiver;
        Object addFilesAffectedByChangedInlineFuns$;
        Object className2;
        THashSet result = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        Object object = MapsKt.iterator(this.dirtyInlineFunctionsMap.getEntries());
        while (object.hasNext()) {
            void $receiver2;
            void $receiver3;
            void $receiver4;
            Map.Entry entry = (Map.Entry)object.next();
            Map.Entry entry2 = entry;
            className2 = (JvmClassName)$receiver4.getKey();
            Map.Entry $i$f$component1 = entry;
            List functions2 = (List)$receiver3.getValue();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            String classFilePath = this.getClassFilePath(string);
            addFilesAffectedByChangedInlineFuns$ = new Function1<IncrementalCacheImpl, Unit>(functions2, classFilePath, result){
                final /* synthetic */ List $functions;
                final /* synthetic */ String $classFilePath;
                final /* synthetic */ THashSet $result;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IncrementalCacheImpl cache) {
                    void destination;
                    void $receiver;
                    Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
                    Iterable $receiver2 = this.$functions;
                    Iterable iterable = $receiver2;
                    Collection collection = new ArrayList<E>();
                    for (T element : $receiver) {
                        String it = (String)element;
                        Iterable list = IncrementalCacheImpl.access$getInlinedTo$p(cache).get(this.$classFilePath, it);
                        CollectionsKt.addAll((Collection)destination, (Iterable)list);
                    }
                    List targetFiles = (List)destination;
                    this.$result.addAll((Collection)targetFiles);
                }
                {
                    this.$functions = list;
                    this.$classFilePath = string;
                    this.$result = tHashSet;
                    super(1);
                }
            };
            ((Object)addFilesAffectedByChangedInlineFuns$).invoke(this);
            Iterable iterable = this.dependents;
            for (Object element : $receiver2) {
                IncrementalCacheImpl p1 = (IncrementalCacheImpl)element;
                addFilesAffectedByChangedInlineFuns$.invoke(p1);
            }
        }
        this.cleanDirtyInlineFunctions();
        Iterable $receiver5 = (Iterable)result;
        object = $receiver5;
        className2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver5, (int)10));
        for (Object item : $receiver) {
            void it;
            addFilesAffectedByChangedInlineFuns$ = (String)item;
            void var14_12 = destination;
            File file = new File((String)it);
            var14_12.add(file);
        }
        return (List)destination;
    }

    public final void cleanDirtyInlineFunctions() {
        this.dirtyInlineFunctionsMap.clean();
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        String string = FileUtil.toSystemIndependentName((String)new File(this.outputDir, internalClassName + ".class").getCanonicalPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toSystemIndependentName(\u2026me.class\").canonicalPath)");
        return string;
    }

    public final void saveCacheFormatVersion() {
        this.cacheFormatVersion.saveIfNeeded();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveModuleMappingToCache(@NotNull Collection<? extends File> sourceFiles, @NotNull File file) {
        void $receiver;
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        JvmClassName jvmClassName2 = jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"jvmClassName");
        byte[] byArray = FilesKt.readBytes((File)file);
        JvmClassName jvmClassName3 = jvmClassName2;
        ProtoMap protoMap = this.protoMap;
        Object[] objectArray = new String[0];
        protoMap.process(jvmClassName3, byArray, (String[])objectArray, false, false);
        this.dirtyOutputClassesMap.notDirty(IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Iterable $i$f$emptyArray = sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName4 = jvmClassName;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"jvmClassName");
            sourceToClassesMap.add(it, jvmClassName4);
        }
        return CompilationResult.Companion.getNO_CHANGES();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult saveFileToCache(@NotNull GeneratedJvmClass generatedClass) {
        Object partNames;
        CompilationResult compilationResult;
        void $receiver22;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)generatedClass, (String)"generatedClass");
        Object sourceFiles = generatedClass.getSourceFiles();
        LocalFileKotlinClass kotlinClass = generatedClass.getOutputClass();
        JvmClassName className2 = JvmClassName.byClassId((ClassId)kotlinClass.getClassId());
        String string = className2.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
        this.dirtyOutputClassesMap.notDirty(string);
        Iterable iterable = (Iterable)sourceFiles;
        for (Object element : $receiver) {
            File it = (File)element;
            SourceToClassesMap sourceToClassesMap = this.sourceToClassesMap;
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            sourceToClassesMap.add(it, jvmClassName);
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (KotlinClassHeaderKt.isCompatibleFileFacadeKind((KotlinClassHeader)header)) {
            Unit unit;
            Object element;
            element = sourceFiles;
            boolean $receiver22 = $receiver22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "Package part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassKind((KotlinClassHeader)header)) {
            Object object = kotlinClass.getClassHeader().getFilePartClassNames();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Multifile class has no parts: " + kotlinClass.getClassName())));
            }
            partNames = object;
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.multifileClassFacadeMap.add(jvmClassName, (List<? extends String>)partNames);
            compilationResult = this.constantsMap.process(kotlinClass).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else if (KotlinClassHeaderKt.isCompatibleMultifileClassPartKind((KotlinClassHeader)header)) {
            Unit unit;
            partNames = sourceFiles;
            boolean $receiver3 = $receiver22.size() == 1;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value;
                if (value == false) {
                    String message = "Multifile class part from several source files: " + sourceFiles;
                    throw (Throwable)((Object)new AssertionError((Object)message));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            JvmClassName jvmClassName = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
            this.packagePartMap.addPackagePart(jvmClassName);
            String string2 = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.internalName");
            String string3 = header.getMultifileClassName();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            this.multifileClassPartMap.add(string2, string3);
            compilationResult = this.protoMap.process(kotlinClass, true).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, true));
        } else {
            compilationResult = KotlinClassHeaderKt.isCompatibleClassKind((KotlinClassHeader)header) && !header.isLocalClass() ? this.protoMap.process(kotlinClass, false).plus(this.constantsMap.process(kotlinClass)).plus(this.inlineFunctionsMap.process(kotlinClass, false)) : CompilationResult.Companion.getNO_CHANGES();
        }
        CompilationResult changesInfo = compilationResult;
        JvmClassName jvmClassName = className2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"className");
        this.logIfSomethingChanged(changesInfo, jvmClassName);
        return changesInfo;
    }

    private final void logIfSomethingChanged(CompilationResult $receiver, JvmClassName className2) {
        if (Intrinsics.areEqual((Object)$receiver, (Object)CompilationResult.Companion.getNO_CHANGES())) {
            return;
        }
        KotlinBuilder.Companion.getLOG().debug(className2 + " is changed: " + $receiver);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompilationResult clearCacheForRemovedClasses() {
        void initial;
        Sequence sequence;
        CompilationResult destination;
        Object element;
        Iterable $receiver;
        Iterator p1;
        Iterable destination2;
        Iterable $receiver2;
        void $receiver3;
        clearCacheForRemovedClasses.1 getNonPrivateNames$ = clearCacheForRemovedClasses.1.INSTANCE;
        Function1<JvmClassName, ChangeInfo> createChangeInfo$ = new Function1<JvmClassName, ChangeInfo>(this){
            final /* synthetic */ IncrementalCacheImpl this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ChangeInfo invoke(@NotNull JvmClassName className2) {
                ChangeInfo.Removed removed;
                Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
                if (Intrinsics.areEqual((Object)className2.getInternalName(), (Object)org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl$Companion.access$getMODULE_MAPPING_FILE_NAME$p(IncrementalCacheImpl.Companion))) {
                    return null;
                }
                ProtoMapValue protoMapValue = IncrementalCacheImpl.access$getProtoMap$p(this.this$0).get(className2);
                if (protoMapValue == null) {
                    return null;
                }
                ProtoMapValue mapValue = protoMapValue;
                if (mapValue.isPackageFacade()) {
                    PackageData packageData = JvmProtoBufUtil.readPackageDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Set<String> memberNames2 = clearCacheForRemovedClasses.1.INSTANCE.invoke(packageData.getPackageProto(), packageData.getNameResolver(), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.1.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.2.INSTANCE));
                    FqName fqName = className2.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.packageFqName");
                    removed = new ChangeInfo.Removed(fqName, (Collection<? extends String>)memberNames2);
                } else {
                    List list;
                    void destination;
                    void $receiver;
                    void $receiver2;
                    ClassData classData = JvmProtoBufUtil.readClassDataFrom((byte[])mapValue.getBytes(), (String[])mapValue.getStrings());
                    Iterable iterable = classData.getClassProto().getEnumEntryList();
                    Set<String> set = clearCacheForRemovedClasses.1.INSTANCE.invoke(classData.getClassProto(), classData.getNameResolver(), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.3.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.4.INSTANCE), (Function1)Reflection.function((FunctionReference)clearCacheForRemovedClasses.memberNames.5.INSTANCE));
                    void var6_9 = $receiver2;
                    Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                    for (T item : $receiver) {
                        void it;
                        Integer n = (Integer)item;
                        list = destination;
                        String string = classData.getNameResolver().getString(((Number)it).intValue());
                        list.add(string);
                    }
                    list = (List)destination;
                    Set memberNames3 = SetsKt.plus(set, (Iterable)CollectionsKt.toSet((Iterable)list));
                    FqName fqName = className2.getFqNameForClassNameWithoutDollars();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"className.fqNameForClassNameWithoutDollars");
                    removed = new ChangeInfo.Removed(fqName, memberNames3);
                }
                return removed;
            }
            {
                this.this$0 = incrementalCacheImpl;
                super(1);
            }
        };
        Iterable iterable = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        void var5_4 = $receiver3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            String string = (String)item;
            void var22_7 = destination2;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)((Object)p1));
            var22_7.add(jvmClassName);
        }
        List dirtyClasses = CollectionsKt.toList((Iterable)((List)destination2));
        if (IncrementalCompilation.isExperimental()) {
            void $receiver4;
            Object item;
            $receiver2 = dirtyClasses;
            destination2 = $receiver2;
            Iterator iterator2 = new ArrayList();
            item = $receiver;
            p1 = $receiver4.iterator();
            while (p1.hasNext()) {
                Boolean bl;
                JvmClassName it;
                Object element2;
                element = element2 = p1.next();
                JvmClassName jvmClassName = it = (JvmClassName)element;
                Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
                if (createChangeInfo$.invoke(jvmClassName) != null) {
                    void $receiver5;
                    void it2 = $receiver5;
                    bl = destination.add(it2);
                    continue;
                }
                bl = null;
            }
            sequence = CollectionsKt.asSequence((Iterable)((List)((Object)destination)));
        } else {
            sequence = SequencesKt.emptySequence();
        }
        Sequence changes2 = sequence;
        $receiver = dirtyClasses;
        destination = new CompilationResult(false, false, false, false, changes2, 15, null);
        CompilationResult accumulator = initial;
        for (Object element2 : $receiver) {
            void className2;
            element = (JvmClassName)element2;
            CompilationResult info = accumulator;
            ProtoMap protoMap = this.protoMap;
            void v4 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"className");
            boolean bl = protoMap.contains((JvmClassName)v4);
            ConstantsMap constantsMap = this.constantsMap;
            void v7 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"className");
            CompilationResult newInfo = new CompilationResult(bl, constantsMap.contains((JvmClassName)v7), false, false, null, 28, null);
            void v8 = className2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"className");
            this.logIfSomethingChanged(newInfo, (JvmClassName)v8);
            accumulator = info.plus(newInfo);
        }
        CompilationResult changesInfo = accumulator;
        $receiver = dirtyClasses;
        for (Object element3 : $receiver) {
            JvmClassName it = (JvmClassName)element3;
            ProtoMap protoMap = this.protoMap;
            JvmClassName jvmClassName = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"it");
            protoMap.remove(jvmClassName);
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"it");
            packagePartMap.remove(jvmClassName2);
            MultifileClassFacadeMap multifileClassFacadeMap = this.multifileClassFacadeMap;
            JvmClassName jvmClassName3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName3, (String)"it");
            multifileClassFacadeMap.remove(jvmClassName3);
            MultifileClassPartMap multifileClassPartMap = this.multifileClassPartMap;
            JvmClassName jvmClassName4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName4, (String)"it");
            multifileClassPartMap.remove(jvmClassName4);
            ConstantsMap constantsMap = this.constantsMap;
            JvmClassName jvmClassName5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName5, (String)"it");
            constantsMap.remove(jvmClassName5);
            InlineFunctionsMap inlineFunctionsMap = this.inlineFunctionsMap;
            JvmClassName jvmClassName6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName6, (String)"it");
            inlineFunctionsMap.remove(jvmClassName6);
        }
        this.dirtyOutputClassesMap.clean();
        return changesInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getObsoletePackageParts() {
        void destination;
        void $receiver;
        Iterable $receiver2 = this.dirtyOutputClassesMap.getDirtyOutputClasses();
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            PackagePartMap packagePartMap = this.packagePartMap;
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(it)");
            if (!packagePartMap.isPackagePart(jvmClassName)) continue;
            destination.add(element);
        }
        List obsoletePackageParts = (List)destination;
        KotlinBuilder.Companion.getLOG().debug("Obsolete package parts: " + obsoletePackageParts);
        return obsoletePackageParts;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String fqName) {
        JvmPackagePartProto jvmPackagePartProto;
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)fqName);
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalName(fqName)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        if (protoMapValue != null) {
            ProtoMapValue $receiver = protoMapValue;
            ProtoMapValue value = $receiver;
            jvmPackagePartProto = new JvmPackagePartProto(value.getBytes(), value.getStrings());
        } else {
            jvmPackagePartProto = null;
        }
        return jvmPackagePartProto;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        LinkedHashSet obsoleteMultifileClasses = SetsKt.linkedSetOf((Object[])new String[0]);
        for (String dirtyClass : this.dirtyOutputClassesMap.getDirtyOutputClasses()) {
            String dirtyFacade;
            if (this.multifileClassPartMap.getFacadeName(dirtyClass) == null) {
                continue;
            }
            obsoleteMultifileClasses.add(dirtyFacade);
        }
        KotlinBuilder.Companion.getLOG().debug("Obsolete multifile class facades: " + obsoleteMultifileClasses);
        return obsoleteMultifileClasses;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)facadeInternalName, (String)"facadeInternalName");
        List<String> list = this.multifileClassFacadeMap.getMultifileClassParts(facadeInternalName);
        if (list == null) {
            return null;
        }
        List<String> partNames = list;
        Iterable $receiver2 = partNames;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element : $receiver) {
            String it = (String)element;
            if (!(!this.dirtyOutputClassesMap.isDirty(it))) continue;
            destination.add(element);
        }
        return (List)destination;
    }

    @Nullable
    public String getMultifileFacade(@NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        return this.multifileClassPartMap.getFacadeName(partInternalName);
    }

    @Nullable
    public byte[] getModuleMappingData() {
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)IncrementalCacheImpl.Companion.getMODULE_MAPPING_FILE_NAME());
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName, (String)"JvmClassName.byInternalN\u2026MODULE_MAPPING_FILE_NAME)");
        ProtoMapValue protoMapValue = this.protoMap.get(jvmClassName);
        return (byte[])(protoMapValue != null ? protoMapValue.getBytes() : null);
    }

    @Override
    public void clean() {
        super.clean();
        this.cacheFormatVersion.clean();
    }

    /*
     * WARNING - void declaration
     */
    public IncrementalCacheImpl(@NotNull File targetDataRoot, @NotNull ModuleBuildTarget target) {
        File file;
        void value;
        Intrinsics.checkParameterIsNotNull((Object)targetDataRoot, (String)"targetDataRoot");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.baseDir = new File(targetDataRoot, IncrementalCacheImplKt.getCACHE_DIRECTORY_NAME());
        this.protoMap = (ProtoMap)this.registerMap((BasicMap)new ProtoMap(this.getStorageFile(Companion.getPROTO_MAP())));
        this.constantsMap = (ConstantsMap)this.registerMap((BasicMap)new ConstantsMap(this.getStorageFile(Companion.getCONSTANTS_MAP())));
        this.inlineFunctionsMap = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(Companion.getINLINE_FUNCTIONS())));
        this.packagePartMap = (PackagePartMap)this.registerMap((BasicMap)new PackagePartMap(this.getStorageFile(Companion.getPACKAGE_PARTS())));
        this.multifileClassFacadeMap = (MultifileClassFacadeMap)this.registerMap((BasicMap)new MultifileClassFacadeMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_FACADES())));
        this.multifileClassPartMap = (MultifileClassPartMap)this.registerMap((BasicMap)new MultifileClassPartMap(this.getStorageFile(Companion.getMULTIFILE_CLASS_PARTS())));
        this.sourceToClassesMap = (SourceToClassesMap)this.registerMap((BasicMap)new SourceToClassesMap(this.getStorageFile(Companion.getSOURCE_TO_CLASSES())));
        this.dirtyOutputClassesMap = (DirtyOutputClassesMap)this.registerMap((BasicMap)new DirtyOutputClassesMap(this.getStorageFile(Companion.getDIRTY_OUTPUT_CLASSES())));
        this.dirtyInlineFunctionsMap = (DirtyInlineFunctionsMap)this.registerMap((BasicMap)new DirtyInlineFunctionsMap(this.getStorageFile(Companion.getDIRTY_INLINE_FUNCTIONS())));
        this.inlinedTo = (InlineFunctionsFilesMap)this.registerMap((BasicMap)new InlineFunctionsFilesMap(this.getStorageFile(Companion.getINLINED_TO())));
        this.cacheFormatVersion = new CacheFormatVersion(targetDataRoot);
        this.dependents = CollectionsKt.arrayListOf((Object[])new IncrementalCacheImpl[0]);
        File file2 = this.target.getOutputDir();
        IncrementalCacheImpl incrementalCacheImpl = this;
        if (value == null) {
            String message = "Target is expected to have output directory: " + this.target;
            throw (Throwable)new IllegalArgumentException(message.toString());
        }
        incrementalCacheImpl.outputDir = file = file2;
    }

    @NotNull
    public static final /* synthetic */ InlineFunctionsFilesMap access$getInlinedTo$p(IncrementalCacheImpl $this) {
        return $this.inlinedTo;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001\u0003\f\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!k\u0006\u0005\u0007\"\u000b\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%^Aa\u0011%\u0002\u0011\u000fi\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011!\u0001bAU\f\t\rC\u0015\u0001#\u0003\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\u0006\u0011\rI;\u0002B\"I\u0003!-Q\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!a\u0001C\u0002*\u0018\u0011\u0019\u0005*\u0001E\u0007\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u000f!\u0019\u0011v\u0003\u0003B\u0011\u0006Ay!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011A\u0001\u0003\u0005\u0004S/!1\tS\u0001\t\u00125\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t%A1!k\u0006\u0005\u0007\"\u000b\u00012C\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\u0002\u0006\t\u0007%^Aa\u0011%\u0002\u0011+i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011Y\u0001bAU\f\t\rC\u0015\u0001c\u0006\u000e\u0003a\u0011\u0011kA\u0003\u0006\u00031\u0005QB\u0001\u0003\r\u0011\rI;\u0002B\"I\u0003!eQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!Q\u0002C\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$Companion;", "", "()V", "CONSTANTS_MAP", "", "getCONSTANTS_MAP", "()Ljava/lang/String;", "DIRTY_INLINE_FUNCTIONS", "getDIRTY_INLINE_FUNCTIONS", "DIRTY_OUTPUT_CLASSES", "getDIRTY_OUTPUT_CLASSES", "INLINED_TO", "getINLINED_TO", "INLINE_FUNCTIONS", "getINLINE_FUNCTIONS", "MODULE_MAPPING_FILE_NAME", "getMODULE_MAPPING_FILE_NAME", "MULTIFILE_CLASS_FACADES", "getMULTIFILE_CLASS_FACADES", "MULTIFILE_CLASS_PARTS", "getMULTIFILE_CLASS_PARTS", "PACKAGE_PARTS", "getPACKAGE_PARTS", "PROTO_MAP", "getPROTO_MAP", "SOURCE_TO_CLASSES", "getSOURCE_TO_CLASSES"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getPROTO_MAP() {
            return PROTO_MAP;
        }

        @NotNull
        public final String getCONSTANTS_MAP() {
            return CONSTANTS_MAP;
        }

        @NotNull
        public final String getINLINE_FUNCTIONS() {
            return INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getPACKAGE_PARTS() {
            return PACKAGE_PARTS;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_FACADES() {
            return MULTIFILE_CLASS_FACADES;
        }

        @NotNull
        public final String getMULTIFILE_CLASS_PARTS() {
            return MULTIFILE_CLASS_PARTS;
        }

        @NotNull
        public final String getSOURCE_TO_CLASSES() {
            return SOURCE_TO_CLASSES;
        }

        @NotNull
        public final String getDIRTY_OUTPUT_CLASSES() {
            return DIRTY_OUTPUT_CLASSES;
        }

        @NotNull
        public final String getDIRTY_INLINE_FUNCTIONS() {
            return DIRTY_INLINE_FUNCTIONS;
        }

        @NotNull
        public final String getINLINED_TO() {
            return INLINED_TO;
        }

        private final String getMODULE_MAPPING_FILE_NAME() {
            return MODULE_MAPPING_FILE_NAME;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\"C\u0003\u0001\u000b\u0005A\t\"B\u0001\u0005\u0006\u0015\t\u0001\"\u0001\u0003B\u00051\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0012\u0001'\u0001\"\u0011%%\u00012A\u0007\u00021\t\u00016\u0011A)\u0004\u0003!\u0015Q\u0015\u0003\u0003D\t!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n\u0015BAA\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$AS\n\t\r#\u0001RB\u0007\u0003\u0019\u0003A\u0012!G\u0002\t\t5\t\u0001\u0014B\u0013\f\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\b\u0015f\u0002bB\u0007\u00021\u001fI2\u0001\u0003\u0003\u000e\u0003a%\u0011d\u0001E\n\u001b\u0005A\"\"\u0007\u0004\t\u00165!\u0011BA\u0005\u00021\u0017A2\"G\u0002\t\u00135\t\u0001tA\r\u0004\u0011/i\u0011\u0001g\u0002R\u0007\u0005AA\"j\u000f\u0005\u0003!eQ\"\u0001M\b3\rAA!D\u0001\u0019\ne\u0019\u0001\"D\u0007\u00021)Ib\u0001#\u0006\u000e\t%\u0011\u0011\"\u0001M\u00061-I2\u0001C\u0005\u000e\u0003a\u001d\u0011d\u0001E\f\u001b\u0005A:!U\u0002\u0002\u00111)s\u0001c\u0007\u000e\u0003aq\u0011d\u0001\u0005\u0005\u001b\u0005AJ\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ProtoMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/ProtoMapValue;", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "get", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "isPackage", "data", "", "strings", "", "checkChangesIsOpenPart", "(Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;[B[Ljava/lang/String;ZZ)Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "put", "bytes", "remove", ""}, moduleName="jps-plugin")
    private final class ProtoMap
    extends BasicStringMap<ProtoMapValue> {
        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            KotlinClassHeader header = kotlinClass.getClassHeader();
            String[] stringArray = header.getAnnotationData();
            if (stringArray == null) {
                Intrinsics.throwNpe();
            }
            byte[] bytes = BitEncoding.decodeBytes((String[])stringArray);
            JvmClassName jvmClassName = kotlinClass.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"bytes");
            String[] stringArray2 = header.getStrings();
            if (stringArray2 == null) {
                Intrinsics.throwNpe();
            }
            return this.put(jvmClassName, bytes, stringArray2, isPackage, true);
        }

        @NotNull
        public final CompilationResult process(@NotNull JvmClassName className2, @NotNull byte[] data, @NotNull String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
            return this.put(className2, data, strings, isPackage, checkChangesIsOpenPart);
        }

        private final CompilationResult put(JvmClassName className2, byte[] bytes, String[] strings, boolean isPackage, boolean checkChangesIsOpenPart) {
            Sequence sequence;
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            ProtoMapValue oldData = (ProtoMapValue)lazyStorage.get(string);
            ProtoMapValue data = new ProtoMapValue(isPackage, bytes, strings);
            if (oldData == null || !Arrays.equals(bytes, oldData.getBytes()) || !Arrays.equals(strings, oldData.getStrings()) || isPackage != oldData.isPackageFacade()) {
                LazyStorage<String, ProtoMapValue> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, data);
            }
            if (oldData == null || !checkChangesIsOpenPart) {
                return new CompilationResult(true, false, false, false, null, 30, null);
            }
            DifferenceKind diff = ProtoDifferenceUtilsKt.difference(oldData, data);
            if (!IncrementalCompilation.isExperimental()) {
                return new CompilationResult(Intrinsics.areEqual((Object)diff, (Object)DifferenceKind.NONE.INSTANCE) ^ true, false, false, false, null, 30, null);
            }
            FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
            DifferenceKind differenceKind = diff;
            if (differenceKind instanceof DifferenceKind.NONE) {
                sequence = SequencesKt.emptySequence();
            } else if (differenceKind instanceof DifferenceKind.CLASS_SIGNATURE) {
                Object[] objectArray = new ChangeInfo.SignatureChanged[1];
                FqName fqName2 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"fqName");
                objectArray[0] = new ChangeInfo.SignatureChanged(fqName2);
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else if (differenceKind instanceof DifferenceKind.MEMBERS) {
                Object[] objectArray = new ChangeInfo.MembersChanged[1];
                FqName fqName3 = fqName;
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"fqName");
                objectArray[0] = new ChangeInfo.MembersChanged(fqName3, ((DifferenceKind.MEMBERS)diff).getNames());
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Sequence changes2 = sequence;
            return new CompilationResult(Intrinsics.areEqual((Object)diff, (Object)DifferenceKind.NONE.INSTANCE) ^ true, false, false, false, changes2, 14, null);
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Nullable
        public final ProtoMapValue get(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return (ProtoMapValue)lazyStorage.get(string);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull ProtoMapValue value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return (value.isPackageFacade() ? "1" : "0") + Long.toHexString(IncrementalCacheImplKt.access$md5(value.getBytes()));
        }

        public ProtoMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ProtoMapValueExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0005\u0003\na\u0001!\u0007\u0006\n\u0011%9\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u0005a\t\u0001\u0014A\u0011\t\u0013\u0013A)!D\u0001\u0019\u0007A\u001b\t!U\u0002\u0002\u0011\u000f)\u000b\u0002B\"\u0005\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u0006K9!!\u0002\u0003\u0004\u000e\u0003a\r\u0011$\u0003E\u0007\u001b\u001dI!!C\u0001\u0019\u0004%\u0011\u0011\"\u0001\r\u00031\u0005)s\u0002B\u0001\t\u000f5A\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u00051\u0005\u0001$A\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0005&\u000f!EQ\"\u0001\r\n3\rA\u0019\"D\u0001\u0019\u0015\u0015\u001aB!\u0001E\u000b\u001b\u0005A\u0012\"G\u0002\t\u000b5\t\u00014B\r\u000b\u0011-i\u0001\"\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\ta\t\u0001G\u0001&\u000f!]Q\"\u0001\r\r3\rAQ!D\u0001\u0019\f\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$ConstantsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "contains", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "value", "getConstantsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "put", "constantsMap", "remove", ""}, moduleName="jps-plugin")
    private final class ConstantsMap
    extends BasicStringMap<Map<String, ? extends Object>> {
        private final Map<String, Object> getConstantsMap(byte[] bytes) {
            HashMap result = new HashMap();
            new ClassReader(bytes).accept(new ClassVisitor(result, 327680){
                final /* synthetic */ HashMap $result;

                @Nullable
                public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    int staticFinal = 8 | 0x10 | 2;
                    if (value != null && (access & staticFinal) == (8 | 0x10)) {
                        MapsKt.set((Map)this.$result, (Object)name, (Object)value);
                    }
                    return null;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }, 1 | 2 | 4);
            return result.isEmpty() ? (HashMap)null : result;
        }

        public final boolean contains(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getConstantsMap(kotlinClass.getFileContents()));
        }

        private final CompilationResult put(JvmClassName className2, Map<String, ? extends Object> constantsMap) {
            String key = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            Map oldMap = (Map)lazyStorage.get(string);
            if (Intrinsics.areEqual((Object)oldMap, constantsMap)) {
                return CompilationResult.Companion.getNO_CHANGES();
            }
            if (constantsMap != null) {
                LazyStorage<String, Map<String, ? extends Object>> lazyStorage2 = this.getStorage();
                String string2 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                lazyStorage2.set(string2, constantsMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = key;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"key");
                lazyStorage3.remove(string3);
            }
            return new CompilationResult(false, true, false, false, null, 29, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.put(className2, null);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, (Function1)Reflection.function((FunctionReference)dumpValue.1.INSTANCE));
        }

        public ConstantsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, ConstantsMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001E\u0005\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0015Q!\u0001\u0005\n\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0005\u0003\na\u0001!\u0007\u0006\n\u0011%9\u0011BA\u0005\u00021\u0007I!!C\u0001\u0019\u0005a\t\u0001\u0014A\u0011\t\u0013\u0013A)!D\u0001\u0019\u0007A\u001b\t!U\u0002\u0002\u0011\u000f)c\u0002\u0002\u0006\t\t5\t\u00014A\r\n\u0011\u0013iq!\u0003\u0002\n\u0003a\r\u0011BA\u0005\u00021\tA\u0012!\n\b\u0005\u0003!)QbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0004&\u0017!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0011e\u0019\u0001\u0012C\u0007\u00021%)c\u0003B\u0001\t\u00145\t\u0001dB\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\u0013!YQbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003a\u0011\u0001$A\r\u0004\u0011#i\u0011\u0001G\u0005&\u000f!]Q\"\u0001\r\r3\rA!\"D\u0001\u0019\u0016\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getInlineFunctionsMap", "bytes", "", "process", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "kotlinClass", "Lorg/jetbrains/kotlin/jps/incremental/LocalFileKotlinClass;", "isPackage", "", "put", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "newMap", "remove", ""}, moduleName="jps-plugin")
    private final class InlineFunctionsMap
    extends BasicStringMap<Map<String, ? extends Long>> {
        private final Map<String, Long> getInlineFunctionsMap(byte[] bytes) {
            HashMap result = new HashMap();
            Set inlineFunctions = InlineUtilKt.inlineFunctionsJvmNames((byte[])bytes);
            if (inlineFunctions.isEmpty()) {
                return MapsKt.emptyMap();
            }
            new ClassReader(bytes).accept(new ClassVisitor(inlineFunctions, result, 327680){
                final /* synthetic */ Set $inlineFunctions;
                final /* synthetic */ HashMap $result;

                @Nullable
                public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
                    ClassWriter dummyClassWriter = new ClassWriter(327680);
                    return new MethodVisitor(this, name, desc, dummyClassWriter, 327680, dummyClassWriter.visitMethod(0, name, desc, (String)null, exceptions)){
                        final /* synthetic */ getInlineFunctionsMap.1 this$0;
                        final /* synthetic */ String $name;
                        final /* synthetic */ String $desc;
                        final /* synthetic */ ClassWriter $dummyClassWriter;

                        public void visitEnd() {
                            String jvmName = this.$name + this.$desc;
                            if (this.this$0.$inlineFunctions.contains(jvmName) ^ true) {
                                return;
                            }
                            byte[] byArray = this.$dummyClassWriter.toByteArray();
                            if (byArray == null) {
                                Intrinsics.throwNpe();
                            }
                            byte[] dummyBytes = byArray;
                            long hash = IncrementalCacheImplKt.access$md5(dummyBytes);
                            MapsKt.set((Map)this.this$0.$result, (Object)jvmName, (Object)hash);
                        }
                        {
                            this.this$0 = $outer;
                            this.$name = $captured_local_variable$1;
                            this.$desc = $captured_local_variable$2;
                            this.$dummyClassWriter = $captured_local_variable$3;
                            super($super_call_param$4, $super_call_param$5);
                        }
                    };
                }
                {
                    this.$inlineFunctions = $captured_local_variable$0;
                    this.$result = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            }, 0);
            return result;
        }

        @NotNull
        public final CompilationResult process(@NotNull LocalFileKotlinClass kotlinClass, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinClass), (String)"kotlinClass");
            return this.put(kotlinClass.getClassName(), this.getInlineFunctionsMap(kotlinClass.getFileContents()), isPackage);
        }

        private final CompilationResult put(JvmClassName className2, Map<String, ? extends Long> newMap, boolean isPackage) {
            Sequence sequence;
            Map<String, ? extends Long> $receiver;
            String internalName = className2.getInternalName();
            LazyStorage lazyStorage = this.getStorage();
            String string = internalName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"internalName");
            Map map = (Map)lazyStorage.get(string);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map oldMap = map;
            HashSet added = SetsKt.hashSetOf((Object[])new String[0]);
            HashSet changed = SetsKt.hashSetOf((Object[])new String[0]);
            Map map2 = oldMap;
            Set set = $receiver.keySet();
            $receiver = newMap;
            Set set2 = set;
            Set<String> set3 = $receiver.keySet();
            Set allFunctions = SetsKt.plus(set2, (Iterable)set3);
            for (String fn : allFunctions) {
                Long oldHash = (Long)oldMap.get(fn);
                Long newHash = newMap.get(fn);
                if (oldHash == null) {
                    added.add(fn);
                    continue;
                }
                if (!(Intrinsics.areEqual((Object)oldHash, (Object)newHash) ^ true)) continue;
                changed.add(fn);
            }
            if (MapsKt.isNotEmpty(newMap)) {
                LazyStorage<String, Map<String, ? extends Long>> lazyStorage2 = this.getStorage();
                String string2 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"internalName");
                lazyStorage2.set(string2, newMap);
            } else {
                LazyStorage lazyStorage3 = this.getStorage();
                String string3 = internalName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"internalName");
                lazyStorage3.remove(string3);
            }
            if (CollectionsKt.isNotEmpty((Collection)changed)) {
                IncrementalCacheImpl.this.dirtyInlineFunctionsMap.put(className2, CollectionsKt.toList((Iterable)changed));
            }
            if (IncrementalCompilation.isExperimental()) {
                FqName fqName = isPackage ? className2.getPackageFqName() : className2.getFqNameForClassNameWithoutDollars();
                sequence = SequencesKt.map((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)added), (Sequence)CollectionsKt.asSequence((Iterable)changed)), (Function1)((Function1)new Function1<String, ChangeInfo.MembersChanged>(fqName){
                    final /* synthetic */ FqName $fqName;

                    @NotNull
                    public final ChangeInfo.MembersChanged invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FqName fqName = this.$fqName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fqName, (String)"fqName");
                        return new ChangeInfo.MembersChanged(fqName, CollectionsKt.listOf((Object)StringsKt.substringBefore$default((String)it, (String)"(", null, (int)2)));
                    }
                    {
                        this.$fqName = fqName;
                        super(1);
                    }
                }));
            } else {
                sequence = SequencesKt.emptySequence();
            }
            Sequence changes2 = sequence;
            return new CompilationResult(false, false, CollectionsKt.isNotEmpty((Collection)changed), CollectionsKt.isNotEmpty((Collection)added), changes2, 3, null);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Map<String, ? extends Long> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.access$dumpMap(value, dumpValue.1.INSTANCE);
        }

        public InlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringToLongMapExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!B\u0001\u0005\u0004\u0011\t%\u0001\u0004\u0001\u001a\t%\u0011\u0011\"\u0001\r\u00021\u0003\t\u0003\"#\u0003\t\u00045\t\u0001D\u0001)\u0004\u0002E\u001b\u0011\u0001#\u0002&\u000f!\u0019Q\"\u0001M\u00043\rAA!D\u0001\u0019\n\u0015BAA\u0003\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\b\u0011\u001bi\u0011\u0001G\u0001\u001a\u0007!!Q\"\u0001M\u0005K\u001dAq!D\u0001\u0019\be\u0019\u0001\u0002B\u0007\u00021\u0013\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$PackagePartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "addPackagePart", "", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "dumpValue", "", "value", "isPackagePart", "remove"}, moduleName="jps-plugin")
    private final class PackagePartMap
    extends BasicStringMap<Boolean> {
        public final void addPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage<String, Boolean> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, true);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        public final boolean isPackagePart(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            return lazyStorage.contains(string);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public PackagePartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0005\u0003\na\u0001!G\u0004\n\u000b%!\u0011BA\u0005\u00021\u0007A\u0012\u0001'\u0001\"\u0011%%\u0001BA\u0007\u00021\u000b\u00016\u0011A)\u0004\u0003!\u0019QE\u0004E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\r\u0007\u0011\u0017iA!\u0003\u0002\n\u0003a\r\u0001$A\u0013\f\t)Aa!D\u0001\u0019\u0004e1\u0001RB\u0007\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003\u0015Z\u0001bB\u0007\u0006\u0013\tI\u0011\u0001g\u0001\r\u0002a\t\u0011d\u0001E\u0005\u001b\u0005A\u001a!J\u0004\t\u00105\t\u0001\u0004B\r\u0004\u0011!i\u0011\u0001G\u0003"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassFacadeMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "facadeName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "partNames", "dumpValue", "value", "getMultifileClassParts", "remove", "className"}, moduleName="jps-plugin")
    private final class MultifileClassFacadeMap
    extends BasicStringMap<List<? extends String>> {
        public final void add(@NotNull JvmClassName facadeName, @NotNull List<? extends String> partNames) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
            LazyStorage<String, List<? extends String>> lazyStorage = this.getStorage();
            String string = facadeName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"facadeName.internalName");
            lazyStorage.set(string, partNames);
        }

        @Nullable
        public final List<String> getMultifileClassParts(@NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            return (List)this.getStorage().get(facadeName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }

        public MultifileClassFacadeMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\t\u0005\u0013A\u0002A\r\u0005\u0013\tI\u0011\u0001G\u0001\u0019\u0002\u0005B\u0011\u0012\u0002E\u0002\u001b\u0005A\"\u0001UB\u0001#\u000e\t\u0001RA\u0013\f\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001\r\u00023\rAI!D\u0001\u0019\u0003\u0015BAA\u0003\u0005\u0006\u001b\u0005A\u0012!G\u0002\t\f5\t\u0001$A\u0013\t\u0011\u0019i!\u0001$\u0001\u0019\u0003e\u0019\u0001\u0002B\u0007\u00021\u0005)s\u0001#\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\b\u001b\u0005Az\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$MultifileClassPartMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "partName", "facadeName", "dumpValue", "value", "getFacadeName", "remove", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;"}, moduleName="jps-plugin")
    private final class MultifileClassPartMap
    extends BasicStringMap<String> {
        public final void add(@NotNull String partName, @NotNull String facadeName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            Intrinsics.checkParameterIsNotNull((Object)facadeName, (String)"facadeName");
            this.getStorage().set(partName, facadeName);
        }

        @Nullable
        public final String getFacadeName(@NotNull String partName) {
            Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
            return (String)this.getStorage().get(partName);
        }

        public final void remove(@NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.remove(string);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return value;
        }

        public MultifileClassPartMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)EnumeratorStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"EnumeratorStringDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0006\u0015\t\u0001bD\u0003\u0002\t\u0005!\u0011I\u0001\u0007\u00013\u001dIQ!\u0003\u0003\n\u0005%\t\u00014\u0001\r\u00021\u0003\t\u0003\"#\u0003\t\u00055\t\u0001T\u0001)\u0004\u0002E\u001b\u0011\u0001C\u0002&\u0017!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u0006e\u0019\u0001\"B\u0007\u00021\u0017)C\u0001B\u0006\t\r5\t\u0001\u0004B\u0013\b\u0011\u001bi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001M\u0003K-!!\u0002C\u0004\u000e\u0003a\r\u0011D\u0002E\b\u001b\u0011I!!C\u0001\u0019\u0004a\tQu\u0003\u0003D\t!AQ\u0002B\u0005\u0003\u0013\u0005AZ\u0001'\u0005\u001a\u0007!%Q\"\u0001M\u0003K!!\u0011\u0001C\u0005\u000e\u0003a!\u0011d\u0001E\n\u001b\u0005A\u001a\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$SourceToClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourceFile", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "clean", "clearOutputsForSource", "dumpValue", "value", "get", "", "remove", "path"}, moduleName="jps-plugin")
    private final class SourceToClassesMap
    extends BasicStringMap<List<? extends String>> {
        public final void clearOutputsForSource(@NotNull File sourceFile) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            this.remove(string);
        }

        public final void add(@NotNull File sourceFile, @NotNull JvmClassName className2) {
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            lazyStorage.append(string, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(className2){
                final /* synthetic */ JvmClassName $className;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$className.getInternalName());
                }
                {
                    this.$className = jvmClassName;
                    super(1);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<JvmClassName> get(@NotNull File sourceFile) {
            void destination;
            void $receiver;
            Intrinsics.checkParameterIsNotNull((Object)sourceFile, (String)"sourceFile");
            LazyStorage lazyStorage = this.getStorage();
            String string = sourceFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sourceFile.absolutePath");
            Iterable $receiver2 = CollectionsKt.orEmpty((List)((List)lazyStorage.get(string)));
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                String string2 = (String)item;
                void var11_8 = destination;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)it);
                var11_8.add(jvmClassName);
            }
            return (List)destination;
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return value.toString();
        }

        @Override
        public void clean() {
            Iterable $receiver = this.getStorage().getKeys();
            for (Object element : $receiver) {
                String it = (String)element;
                this.remove(it);
            }
        }

        private final void remove(String path) {
            this.getStorage().remove(path);
        }

        public SourceToClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            KeyDescriptor keyDescriptor = (KeyDescriptor)PathStringDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)keyDescriptor, (String)"PathStringDescriptor.INSTANCE");
            super(storageFile, (KeyDescriptor<String>)keyDescriptor, (DataExternalizer)StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001c\u0003\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001C\u0004\u0006\u0003\u0011\tQ!\u0001\u0005\u0010\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\u0001A!\u0011\u0002\r\u0001e!\u0011BA\u0005\u00021\u0005A\n!\t\u0005\n\n!\rQ\"\u0001\r\u0003!\u000e\u0005\u0011kA\u0001\t\u0006\u0015BAA\u0003\u0005\u0004\u001b\u0005A:!G\u0002\t\t5\t\u0001$A\u0013\u0007\u0011\u0013iA!\u0003\u0002\n\u0003a\u001d\u0001$B\u0013\b\u0011\u0017i\u0011\u0001G\u0001\u001a\u0007!1Q\"\u0001M\u0004K\u001dAi!D\u0001\u0019\u000fe\u0019\u0001BB\u0007\u00021\u000f)s\u0001c\u0004\u000e\u0003a9\u0011d\u0001\u0005\u0007\u001b\u0005A:\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyOutputClassesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "", "value", "getDirtyOutputClasses", "", "isDirty", "className", "markDirty", "", "notDirty"}, moduleName="jps-plugin")
    private final class DirtyOutputClassesMap
    extends BasicStringMap<Boolean> {
        public final void markDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().set(className2, true);
        }

        public final void notDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            this.getStorage().remove(className2);
        }

        @NotNull
        public final Collection<String> getDirtyOutputClasses() {
            return this.getStorage().getKeys();
        }

        public final boolean isDirty(@NotNull String className2) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            return this.getStorage().contains(className2);
        }

        @Override
        @NotNull
        protected String dumpValue(boolean value) {
            return "";
        }

        public DirtyOutputClassesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            DataExternalizer dataExternalizer = (DataExternalizer)BooleanDataDescriptor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataExternalizer, (String)"BooleanDataDescriptor.INSTANCE");
            super(storageFile, dataExternalizer);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u0003!\u0011R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tA!\u0011\u0002\r\u0001e9\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001g\u0001\u0019\u0003a\u0005\u0011\u0005CE\u0005\u0011\ti\u0011\u0001'\u0002Q\u0007\u0003\t6!\u0001\u0005\u0004K-!!\u0002c\u0002\u000e\u0003a\r\u0011D\u0002\u0005\u0005\u001b\u0011I!!C\u0001\u0019\u0004a\tQ\u0005\u0004E\u0005\u001b)I!!C\u0001\u0019\f%)\u0011\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u0001\u0019\u000b\u0015r\u0001BB\u0007\u00021\u001bI2\u0001C\u0004\u000e\u0003a-\u0011D\u0002E\b\u001b\u0011I!!C\u0001\u0019\u0004a\t\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$DirtyInlineFunctionsMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "dumpValue", "value", "getEntries", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "put", "", "className", "changedFunctions"}, moduleName="jps-plugin")
    private final class DirtyInlineFunctionsMap
    extends BasicStringMap<List<? extends String>> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<JvmClassName, List<? extends String>> getEntries() {
            Iterable $receiver = this.getStorage().getKeys();
            float capacity = (float)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10) / 0.75f + 1.0f;
            LinkedHashMap<JvmClassName, List> result = new LinkedHashMap<JvmClassName, List>(Math.max((int)capacity, 16));
            for (Object element : $receiver) {
                void it;
                String p1;
                String string = (String)element;
                LinkedHashMap<JvmClassName, List> linkedHashMap = result;
                JvmClassName jvmClassName = JvmClassName.byInternalName((String)p1);
                p1 = (String)element;
                Object v = this.getStorage().get(it);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                List list = (List)v;
                linkedHashMap.put(jvmClassName, list);
            }
            return result;
        }

        public final void put(@NotNull JvmClassName className2, @NotNull List<? extends String> changedFunctions) {
            Intrinsics.checkParameterIsNotNull((Object)className2, (String)"className");
            Intrinsics.checkParameterIsNotNull(changedFunctions, (String)"changedFunctions");
            LazyStorage<String, List<? extends String>> lazyStorage = this.getStorage();
            String string = className2.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.internalName");
            lazyStorage.set(string, changedFunctions);
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull List<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection((Collection)value);
        }

        public DirtyInlineFunctionsMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, StringListExternalizer.INSTANCE);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!yQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!A\u0001B!\u0003\u0019\u0001I\"\"\u0003\u0002\n\u0003a\t\u0011\"B\u0005\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0004a\u0005\u0011\u0005CE\u0005\u0011\u000bi\u0011\u0001G\u0002Q\u0007\u0003\t6!\u0001E\u0004K=AA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\tI2\u0001c\u0003\u000e\u0003a\u0011\u0011d\u0001\u0005\u0007\u001b\u0005A\"!\n\u0005\u0005\u0015!5Q\"\u0001\r\u00033\rAq!D\u0001\u0019\u0003\u0015ZAA\u0003E\b\u001b\u0005A\"!\u0007\u0004\t\u00115!\u0011BA\u0005\u00021\tA\u001a!j\b\u0005\u0007\u0012A\t\"\u0004\u0003\n\u0005%\t\u0001D\u0001M\u00023\rAQ!D\u0001\u0019\u0005e\u0019\u00012B\u0007\u00021\t\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl$InlineFunctionsFilesMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/PathFunctionPair;", "", "", "storageFile", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;Ljava/io/File;)V", "add", "", "sourcePath", "jvmSignature", "targetPath", "dumpKey", "key", "dumpValue", "value", "get"}, moduleName="jps-plugin")
    private final class InlineFunctionsFilesMap
    extends BasicMap<PathFunctionPair, Collection<? extends String>> {
        public final void add(@NotNull String sourcePath, @NotNull String jvmSignature, @NotNull String targetPath) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            Intrinsics.checkParameterIsNotNull((Object)targetPath, (String)"targetPath");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            this.getStorage().append(key, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(targetPath){
                final /* synthetic */ String $targetPath;

                public final void invoke(@NotNull DataOutput out) {
                    Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                    IOUtil.writeUTF((DataOutput)out, (String)this.$targetPath);
                }
                {
                    this.$targetPath = string;
                    super(1);
                }
            }));
        }

        @NotNull
        public final Collection<String> get(@NotNull String sourcePath, @NotNull String jvmSignature) {
            Intrinsics.checkParameterIsNotNull((Object)sourcePath, (String)"sourcePath");
            Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
            PathFunctionPair key = new PathFunctionPair(sourcePath, jvmSignature);
            Collection collection = (Collection)this.getStorage().get(key);
            if (collection == null) {
                collection = SetsKt.emptySet();
            }
            return collection;
        }

        @Override
        @NotNull
        protected String dumpKey(@NotNull PathFunctionPair key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return "(" + key.getPath() + ", " + key.getFunction() + ")";
        }

        @Override
        @NotNull
        protected String dumpValue(@NotNull Collection<? extends String> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return IncrementalCacheImplKt.dumpCollection(value);
        }

        public InlineFunctionsFilesMap(File storageFile) {
            Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
            super(storageFile, PathFunctionPairKeyDescriptor.INSTANCE, PathCollectionExternalizer.INSTANCE);
        }
    }
}

