/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public final class SdkMavenRepository
extends Enum<SdkMavenRepository> {
    public static final /* enum */ SdkMavenRepository ANDROID = new SdkMavenRepository("android", "Android Support Repository");
    public static final /* enum */ SdkMavenRepository GOOGLE = new SdkMavenRepository("google", "Google Support Repository");
    private final String mDir;
    private final String myDisplayName;
    private static final /* synthetic */ SdkMavenRepository[] $VALUES;

    public static SdkMavenRepository[] values() {
        return (SdkMavenRepository[])$VALUES.clone();
    }

    public static SdkMavenRepository valueOf(String name) {
        return Enum.valueOf(SdkMavenRepository.class, name);
    }

    private SdkMavenRepository(String dir, String displayName) {
        this.mDir = dir;
        this.myDisplayName = displayName;
    }

    public File getRepositoryLocation(File sdkHome, boolean requireExists) {
        if (sdkHome != null) {
            File dir = new File(sdkHome, "extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || dir.isDirectory()) {
                return dir;
            }
        }
        return null;
    }

    public boolean isInstalled(File sdkHome) {
        return this.getRepositoryLocation(sdkHome, true) != null;
    }

    public boolean isInstalled(LocalSdk sdk) {
        if (sdk != null) {
            LocalPkgInfo[] infos;
            for (LocalPkgInfo info : infos = sdk.getPkgsInfos(PkgType.PKG_EXTRA)) {
                IPkgDesc d = info.getDesc();
                if (!d.hasVendor() || !this.mDir.equals(d.getVendor().getId()) || !d.hasPath() || !"m2repository".equals(d.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public GradleCoordinate getHighestInstalledVersion(File sdkHome, String groupId, String artifactId, String filter, boolean allowPreview) {
        File repository = this.getRepositoryLocation(sdkHome, true);
        if (repository != null) {
            return SdkMavenRepository.getHighestInstalledVersion(groupId, artifactId, repository, filter, allowPreview);
        }
        return null;
    }

    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, String filter, boolean allowPreview) {
        assert ("m2repository".equals(repository.getName())) : repository;
        File versionDir = new File(repository, groupId.replace('.', File.separatorChar) + File.separator + artifactId);
        File[] versions = versionDir.listFiles();
        if (versions != null) {
            ArrayList versionCoordinates = Lists.newArrayList();
            for (File dir : versions) {
                GradleCoordinate gc;
                if (!dir.isDirectory() || filter != null && !dir.getName().startsWith(filter) || (gc = GradleCoordinate.parseCoordinateString(groupId + ":" + artifactId + ":" + dir.getName())) == null || !allowPreview && gc.getFullRevision().contains("-rc") || !allowPreview && "5.2.08".equals(gc.getFullRevision()) && "play-services".equals(gc.getArtifactId())) continue;
                FullRevision.parseRevision((String)gc.getFullRevision());
                versionCoordinates.add(gc);
            }
            if (!versionCoordinates.isEmpty()) {
                return Collections.max(versionCoordinates, GradleCoordinate.COMPARE_PLUS_HIGHER);
            }
        }
        return null;
    }

    public static SdkMavenRepository getByGroupId(String groupId) {
        if ("com.android.support".equals(groupId) || "com.android.support.test".equals(groupId)) {
            return ANDROID;
        }
        if (groupId.startsWith("com.google.android.")) {
            return GOOGLE;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }

    public IPkgDesc getPackageDescription() {
        return PkgDesc.Builder.newExtra((IdDisplay)new IdDisplay(this.mDir, ""), (String)"m2repository", (String)this.myDisplayName, null, (NoPreviewRevision)new NoPreviewRevision(1)).create();
    }

    static {
        $VALUES = new SdkMavenRepository[]{ANDROID, GOOGLE};
    }
}

