/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdParser;
import com.android.ide.common.vectordrawable.VdPath;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgLeafNode
extends SvgNode {
    private static Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private String mPathData;

    public SvgLeafNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    private String getAttributeValues(ImmutableMap<String, String> presentationMap) {
        StringBuilder sb = new StringBuilder("/>\n");
        for (String key : this.mVdAttributesMap.keySet()) {
            String vectorDrawableAttr = (String)presentationMap.get((Object)key);
            String svgValue = (String)this.mVdAttributesMap.get(key);
            String vdValue = svgValue.trim();
            if ("none".equals(vdValue)) {
                vdValue = "#00000000";
            } else if (vdValue.endsWith("px")) {
                vdValue = vdValue.substring(0, vdValue.length() - 2);
            } else if (vdValue.startsWith("rgb")) {
                vdValue = vdValue.substring(3, vdValue.length());
                if ((vdValue = this.convertRGBToHex(vdValue)) == null) {
                    this.getTree().logErrorLine("Unsupported Color format " + vdValue, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
                }
            }
            String attr = "\n        " + vectorDrawableAttr + "=\"" + vdValue + "\"";
            sb.insert(0, attr);
        }
        return sb.toString();
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    private String convertRGBToHex(String svgValue) {
        String result = null;
        String functionValue = svgValue.trim();
        String[] numbers = (functionValue = svgValue.substring(1, functionValue.length() - 1)).split(",");
        if (numbers.length != 3) {
            return null;
        }
        int[] color = new int[3];
        for (int i = 0; i < 3; ++i) {
            String number = numbers[i];
            if ((number = number.trim()).endsWith("%")) {
                float value = Float.parseFloat(number.substring(0, number.length() - 1));
                color[i] = SvgLeafNode.clamp((int)(value * 255.0f / 100.0f), 0, 255);
                continue;
            }
            int value = Integer.parseInt(number);
            color[i] = SvgLeafNode.clamp(value, 0, 255);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("#");
        for (int i = 0; i < 3; ++i) {
            builder.append(String.format("%02X", color[i]));
        }
        result = builder.toString();
        assert (result.length() == 7);
        return result;
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + (this.mPathData != null ? this.mPathData : " null pathData ") + (this.mName != null ? this.mName : " null name "));
    }

    public void setPathData(String pathData) {
        this.mPathData = pathData;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    @Override
    public void transform(float a, float b, float c, float d, float e, float f) {
        if (this.mPathData == null) {
            return;
        }
        VdPath.Node[] n = VdParser.parsePath(this.mPathData);
        if (a != 1.0f || d != 1.0f || b != 0.0f || c != 0.0f || e != 0.0f || f != 0.0f) {
            VdPath.Node.transform(a, b, c, d, e, f, n);
        }
        this.mPathData = VdPath.Node.NodeListToString(n);
    }

    @Override
    public void writeXML(OutputStreamWriter writer) throws IOException {
        boolean nothingToDraw;
        String fillColor = (String)this.mVdAttributesMap.get("fill");
        String strokeColor = (String)this.mVdAttributesMap.get("stroke");
        logger.log(Level.FINE, "fill color " + fillColor);
        boolean emptyFill = fillColor != null && ("none".equals(fillColor) || "#0000000".equals(fillColor));
        boolean emptyStroke = strokeColor == null || "none".equals(strokeColor);
        boolean emptyPath = this.mPathData == null;
        boolean bl = nothingToDraw = emptyPath || emptyFill && emptyStroke;
        if (nothingToDraw) {
            return;
        }
        writer.write("    <path\n");
        if (!this.mVdAttributesMap.containsKey("fill")) {
            logger.log(Level.FINE, "ADDING FILL SVG_FILL_COLOR");
            writer.write("        android:fillColor=\"#FF000000\"\n");
        }
        if (!emptyStroke && !this.mVdAttributesMap.containsKey("stroke-width")) {
            logger.log(Level.FINE, "Adding default stroke width");
            writer.write("        android:strokeWidth=\"1\"\n");
        }
        writer.write("        android:pathData=\"" + this.mPathData + "\"");
        writer.write(this.getAttributeValues(Svg2Vector.presentationMap));
    }

    public void fillPresentationAttributes(String name, String value) {
        this.fillPresentationAttributes(name, value, logger);
    }
}

