/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.SvgTree;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

abstract class SvgNode {
    protected String mName;
    private SvgTree mSvgTree;
    private Node mDocumentNode;
    protected Map<String, String> mVdAttributesMap = new HashMap<String, String>();

    public SvgNode(SvgTree svgTree, Node node, String name) {
        this.mName = name;
        this.mSvgTree = svgTree;
        this.mDocumentNode = node;
    }

    protected SvgTree getTree() {
        return this.mSvgTree;
    }

    public String getName() {
        return this.mName;
    }

    public Node getDocumentNode() {
        return this.mDocumentNode;
    }

    public abstract void dumpNode(String var1);

    public abstract void writeXML(OutputStreamWriter var1) throws IOException;

    public abstract boolean isGroupNode();

    public abstract void transform(float var1, float var2, float var3, float var4, float var5, float var6);

    protected void fillPresentationAttributes(String name, String value, Logger logger) {
        logger.log(Level.FINE, ">>>> PROP " + name + " = " + value);
        if (value.startsWith("url(")) {
            this.getTree().logErrorLine("Unsupported URL value: " + value, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
            return;
        }
        this.mVdAttributesMap.put(name, value);
    }

    public void fillEmptyAttributes(Map<String, String> parentAttributesMap) {
        for (Map.Entry<String, String> entry : parentAttributesMap.entrySet()) {
            String key = entry.getKey();
            if (this.mVdAttributesMap.containsKey(key)) continue;
            this.mVdAttributesMap.put(key, entry.getValue());
        }
    }
}

