/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.vectordrawable.SvgGroupNode;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class SvgTree {
    private static Logger logger = Logger.getLogger(SvgTree.class.getSimpleName());
    public float w;
    public float h;
    public float[] matrix;
    public float[] viewBox;
    public float mScaleFactor = 1.0f;
    private SvgGroupNode mRoot;
    private String mFileName;
    private ArrayList<String> mErrorLines = new ArrayList();
    private boolean mHasLeafNode = false;

    SvgTree() {
    }

    public void setHasLeafNode(boolean hasLeafNode) {
        this.mHasLeafNode = hasLeafNode;
    }

    public Document parse(File f) throws Exception {
        this.mFileName = f.getName();
        Document doc = PositionXmlParser.parse((InputStream)new FileInputStream(f), (boolean)false);
        return doc;
    }

    public void normalize() {
        if (this.matrix != null) {
            this.transform(this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[3], this.matrix[4], this.matrix[5]);
        }
        if (this.viewBox != null && (this.viewBox[0] != 0.0f || this.viewBox[1] != 0.0f)) {
            this.transform(1.0f, 0.0f, 0.0f, 1.0f, -this.viewBox[0], -this.viewBox[1]);
        }
        logger.log(Level.FINE, "matrix=" + Arrays.toString(this.matrix));
    }

    private void transform(float a, float b, float c, float d, float e, float f) {
        this.mRoot.transform(a, b, c, d, e, f);
    }

    public void dump(SvgGroupNode root) {
        logger.log(Level.FINE, "current file is :" + this.mFileName);
        root.dumpNode("");
    }

    public void setRoot(SvgGroupNode root) {
        this.mRoot = root;
    }

    public SvgGroupNode getRoot() {
        return this.mRoot;
    }

    public void logErrorLine(String s, Node node, SvgLogLevel level) {
        if (!Strings.isNullOrEmpty((String)s)) {
            if (node != null) {
                SourcePosition position = this.getPosition(node);
                this.mErrorLines.add(level.name() + "@ line " + (position.getStartLine() + 1) + " " + s + "\n");
            } else {
                this.mErrorLines.add(s);
            }
        }
    }

    public String getErrorLog() {
        StringBuilder errorBuilder = new StringBuilder();
        if (!this.mErrorLines.isEmpty()) {
            errorBuilder.append("In " + this.mFileName + ":\n");
        }
        for (String log : this.mErrorLines) {
            errorBuilder.append(log);
        }
        return errorBuilder.toString();
    }

    public boolean getHasLeafNode() {
        return this.mHasLeafNode;
    }

    private SourcePosition getPosition(Node node) {
        return PositionXmlParser.getPosition((Node)node);
    }

    public static enum SvgLogLevel {
        ERROR,
        WARNING;

    }
}

