/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerProvider;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0011)\u0011\u0001b\u0002\u0006\u0003!-Q!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u000e\u0015\u0001A\u0002\u0001\t\u00123\u0005A\n!(\u0001\u0012CSIQ\u0001C\u0001\u000e\u0007a\r\u0011&\u0001\r\u0003\u0013\rA)!D\u0001\u0019\u0007%\u0019\u0001rA\u0007\u00021\u0011I1\u0001#\u0003\u000e\u0003a)\u0011kA\u0001\t\f\u0015\"Aa\u0003E\t\u001b\u0005A\u0012\"\n\u0006\u0005\u0015!MQ\"\u0001\r\u00063\u0015A\u0011!D\u0002\u0019\u0004%\n\u0001DA\u0013\u000f\t)A!\"D\u0001\u0019\u0016e)\u0001\"A\u0007\u00041\u0007I\u0013\u0001\u0007\u0002\u001a\u0007!YQ\"\u0001\r\u0004K5!\u0011\u0001c\u0006\u000e\t%\u0011\u0011\"\u0001M\r11IR\u0001C\u0001\u000e\u0007a\r\u0011&\u0001\r\u0003K\u0011!!\u0002C\u0007\u000e\u0003amQ\u0005\u0002\u0003\f\u00119i\u0011\u0001'\b&\u0015\u0011Y\u0001bD\u0007\u00021%IR\u0001C\u0001\u000e\u0007a\r\u0011&\u0001\r\u0003K!!\u0011\u0001c\b\u000e\u0003aI\u0011d\u0001\u0005\u0011\u001b\u0005A\n#K\u0007\u0005\u0007rAa!D\u0001\u0019\u000bE\u001bq!\u0002\u0001\u000e\u0005\u00115\u0001bB\t\u0003\t\u001fA\u0001\"K\u0004\u0005\u0003\"A9!D\u0001\u0019\tE\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002#\u0003\u000e\u0003a)\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "tableColumnsNumber", "", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;I)V", "currentLine", "getCurrentLine", "()I", "setCurrentLine", "(I)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "fillCells", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "isTableLine", "line", "", "Companion"}, moduleName="intellij-markdown")
public final class GitHubTableMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    public static final Regex SPLIT_REGEX;
    private int currentLine;
    private final ProductionHolder productionHolder;
    private final int tableColumnsNumber;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.flavours.gfm.table.GitHubTableMarkerBlock$Companion.INSTANCE;
        SPLIT_REGEX = new Regex("\\|");
    }

    public final int getCurrentLine() {
        return this.currentLine;
    }

    public final void setCurrentLine(int n) {
        this.currentLine = n;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        int n = this.currentLine++;
        if (this.currentLine == 1) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), GFMTokenTypes.INSTANCE.getTABLE_SEPARATOR())));
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String line = pos.getCurrentLine();
        if (!this.isTableLine(line)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        List<SequentialParser.Node> cellsAndSeps = this.fillCells(pos);
        this.productionHolder.addProduction(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(((Number)((SequentialParser.Node)CollectionsKt.first(cellsAndSeps)).getRange().getStart()).intValue(), ((Number)((SequentialParser.Node)CollectionsKt.last(cellsAndSeps)).getRange().getEndInclusive()).intValue()), GFMElementTypes.Companion.getROW())), (Iterable)cellsAndSeps));
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return GFMElementTypes.Companion.getTABLE();
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SequentialParser.Node> fillCells(LookaheadText.Position pos) {
        ArrayList<SequentialParser.Node> result;
        block9: {
            int n;
            result = new ArrayList<SequentialParser.Node>();
            int offset = pos.getOffset();
            if (pos.getOffsetInCurrentLine() == -1) {
                offset += 1 + this.getConstraints().getCharsEaten(pos.getCurrentLine());
            }
            CharSequence line = this.getConstraints().eatItselfFromString(pos.getCurrentLine());
            List cells = Regex.split$default((Regex)Companion.getSPLIT_REGEX(), (CharSequence)line, (int)0, (int)2);
            int cellNodesAdded = 0;
            IntRange intRange = CollectionsKt.getIndices((Collection)cells);
            int n2 = intRange.getFirst();
            if (n2 > (n = intRange.getLast())) break block9;
            while (true) {
                void i;
                String cell;
                block11: {
                    block10: {
                        if (!StringsKt.isBlank((CharSequence)(cell = (String)cells.get((int)i)))) break block10;
                        void v1 = i;
                        boolean bl = true;
                        if (v1 < true) {
                            bl = false;
                        }
                        boolean bl2 = true;
                        if (v1 > CollectionsKt.getLastIndex((List)cells) - 1) {
                            bl2 = false;
                        }
                        if (!(bl & bl2)) break block11;
                    }
                    result.add(new SequentialParser.Node(new IntRange(offset, offset + cell.length()), GFMTokenTypes.INSTANCE.getCELL()));
                    ++cellNodesAdded;
                }
                offset += cell.length();
                if (i < CollectionsKt.getLastIndex((List)cells)) {
                    result.add(new SequentialParser.Node(new IntRange(offset, offset + 1), GFMTokenTypes.INSTANCE.getTABLE_SEPARATOR()));
                }
                ++offset;
                if (cellNodesAdded >= this.tableColumnsNumber) {
                    if (offset >= pos.getNextLineOrEofOffset()) break;
                    result.add(new SequentialParser.Node(new IntRange(offset, pos.getNextLineOrEofOffset()), GFMTokenTypes.INSTANCE.getTABLE_SEPARATOR()));
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
        return result;
    }

    private final boolean isTableLine(CharSequence line) {
        return GitHubTableMarkerProvider.Companion.contains(line, '|');
    }

    public GitHubTableMarkerBlock(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder, int tableColumnsNumber) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        super(constraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.tableColumnsNumber = tableColumnsNumber;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset(), pos.getNextLineOrEofOffset()), GFMElementTypes.Companion.getHEADER())));
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)this.fillCells(pos));
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock$Companion;", "", "()V", "SPLIT_REGEX", "Lkotlin/text/Regex;", "getSPLIT_REGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getSPLIT_REGEX() {
            return SPLIT_REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

