/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.ComparisonsKt;
import kotlin.Pair;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConsoleKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0004)\u0011\u0001D\u0001\u0006\u0003!\u0001Q!\u0001\u0003\u0002\u000b\u0005Aq!B\u0001\u0005\u0004\u0015\t\u0001\u0002B\u0003\u0002\t\u0007)\u0011\u0001#\u0003\u0006\u0003\u0011\rQ!\u0001E\u0006\u000b\u0005!!!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u0012\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0005\u0011\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0005G\u0006a\u0001!G\u0001\u0019\u0002u\u0005Q%i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&R!MQ\"\u0001\r\u00053\rA!\"D\u0001\u0019\u0016e\u0019\u0001bC\u0007\u00021\u0011I2\u0001c\u0006\u000e\u0003aa\u0011d\u0002E\r\u001b\u0015I1\u0001\"\u0001\n\u0003a\u0011\u0001$D\r\u0004\u00117i\u0011\u0001\u0007\b\u001a\t\u0011\t\u0001RD\u0007\u00021\u0011IR\u0001B\u0001\t\u001f5\u0011A\u0012\u0001M\u0010#\u000e\t\u0001\u0002E\u0013\u0005\t\u0005A\t#D\u0001\u0019#\u0015BA!\u0001E\u0011\u001b\u0005A\u0012#G\u0002\t$5\t\u0001$E\u0013\u001e\u0011Ii!\u0001$\u0001\u0019\u0016e\u0019\u0001RE\u0007\u00021MI2\u0001c\n\u000e\u0003a!\u0012d\u0001E\u0015\u001b\u0005AR#G\u0002\t,5\t\u0001DF\r\u0004\u0011[i\u0011\u0001G\f\u001a\t\u0011\t\u0001rF\u0007\u00021!)c\u0004\u0003\n\u000e\u00051\u0005\u0001TC\r\u0004\u0011Ki\u0011\u0001G\n\u001a\u0007!%R\"\u0001\r\u00163\rAY#D\u0001\u0019-e\u0019\u0001RF\u0007\u00021]IB\u0001B\u0001\t05\t\u0001\u0004C\r\u0005\t\u0005A\u0001$D\u0001\u0019\u0011\u0015:\u0001\u0012G\u0007\u0006\u0013\tI\u0011\u0001\u0007\u0002\r\u0002aIR5\u000eE\u001a\u001b\u0005AB!G\u0002\t55\t\u0001TC\r\u0004\u0011-i\u0011\u0001\u0007\u0003\u001a\u0007!]Q\"\u0001\r\r3\u001dAI\"D\u0003\n\u0007\u0011\u0005\u0011\"\u0001\r\u000315I2\u0001#\u000e\u000e\u0003aY\u0012d\u0001E\u001c\u001b\u0005Ab\"G\u0002\t95\t\u0001DD\r\u0005\t\u0005Ai\"D\u0001\u0019\te!A!\u0001E\u001d\u001b\u0005AR$G\u0003\u0005\u0003!yQB\u0001G\u00011?\t6!\u0001E\u001eKC!9\u0001\u0003\u0010\u000e\u0003au\u0012$\u0003E\r\u001b\u0015I1\u0001\"\u0001\n\u0003a\u0011\u0001$D\t\u00021\t\t6!\u0001\u0005 K\u001dAy$D\u0001\u0019>e\u0019\u0001RE\u0007\u00021M)3\u0002c\u0010\u000e\u0003au\u0012d\u0001E\u0013\u001b\u0005A2#G\u0002\t,5\t\u0001DF\u0013\u0015\t\u0005A\u0001%D\u0001\u0019>e\u0019\u0001RE\u0007\u00021MI2\u0001#\u000b\u000e\u0003a)\u0012d\u0001E\u0016\u001b\u0005Ab#G\u0002\t.5\t\u0001dF\u0013%\t\u0005A\t%\u0004\u0005\n\u0007%\u0011A\u0012\u0001M\u000b\u0013\tI\u0011\u0001G\u000b\u0019Ce\u0019\u00012I\u0007\u00021QI2\u0001#\n\u000e\u0003a\u0019\u0012d\u0001E\u0015\u001b\u0005AR#\u0007\u0007\tE5Q\u0011BA\u0005\u00021\rJ!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001M\u001f1\u000b*{\u0003B\u0001\tE5\t\u0001TH\u000b\u00021]IJ\u0001c\u0012\u000e\u0003a\u0019\u0003k!\u0001\u001a\n!!S\"\u0001\r\u0003!\u000e\t\u00114\u0002\u0003\u0002\u0011\u0013j\u0011\u0001\u0007\u0002Q\u0007\u0007I+\u0002B\"I\u0003!\rQ\"\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u000bA1!+\u0006\u0005\u0007\"\u000b\u0001rA\u0007\u00021\u0011\t6\u0001B\u0003\u0001\u001b\t!I\u0001C\u0003*\u0016\u0011\u0019\u0005*\u0001E\u0006\u001b\u0005Ab!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f%RAa\u0011\u0005\t\u00105\t\u0001\u0004C)\u0004\t\u0015\u0001QB\u0001C\t\u0011%\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectToCompileService", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "checkId", "detectCompilerClasspath", "", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "main", "", "([Ljava/lang/String;)V", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "category", "message", "source", "ClientOptions"}, moduleName="client")
public final class KotlinCompilerClient {
    public static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    public static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    public static final boolean verboseReporting;
    @NotNull
    public static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;
    public static final KotlinCompilerClient INSTANCE$;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Object object;
        block3: {
            connectToCompileService.1 newFlagFile$;
            block2: {
                Object $receiver;
                Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
                Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
                Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
                Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
                newFlagFile$ = connectToCompileService.1.INSTANCE;
                object = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY());
                if (object == null) break block2;
                String string = object;
                String it = (String)$receiver;
                object = DaemonParamsKt.trimQuotes((String)it);
                if (object == null || (object = (String)AddToStdlibKt.check((Object)object, (Function1)connectToCompileService.flagFile.2.INSTANCE)) == null) break block2;
                $receiver = object;
                it = (String)$receiver;
                object = (File)AddToStdlibKt.check((Object)new File(it), (Function1)connectToCompileService.flagFile.4.INSTANCE);
                if (object != null) break block3;
            }
            object = newFlagFile$.invoke();
        }
        Object flagFile2 = object;
        return this.connectToCompileService(compilerId, (File)flagFile2, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        int attempts = 0;
        try {
            while (attempts++ < DAEMON_CONNECT_CYCLE_ATTEMPTS) {
                void newJVMOptions;
                void service;
                Pair<CompileService, DaemonJVMOptions> pair = this.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, ? extends Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                    final /* synthetic */ DaemonReportingTargets $reportingTargets;

                    public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                        Intrinsics.checkParameterIsNotNull((Object)cat, (String)"cat");
                        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                        KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets, cat, msg, null, 4);
                    }
                    {
                        this.$reportingTargets = daemonReportingTargets;
                        super(2);
                    }
                }));
                CompileService compileService = (CompileService)pair.component1();
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)pair.component2();
                pair = null;
                if (service != null) {
                    service.registerClient(clientAliveFlagFile.getAbsolutePath());
                    KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4);
                    return service;
                }
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "no suitable daemon found", null, 4);
                if (!autostart) continue;
                this.startDaemon(compilerId, (DaemonJVMOptions)newJVMOptions, daemonOptions, reportingTargets);
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4);
            }
        }
        catch (Exception e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4);
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), false, false);
        Object object = compileService != null ? compileService.shutdown() : null;
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(null, null, port, 3, null), (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, operationsTracer).get()).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3) {
        if ((n3 & 0x20) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure((Object)this, (Function0)new Function0<Integer>(compileService, sessionId, targetPlatform, args, callbackServices, port, compilerOut, daemonOut, operationsTracer){
            final /* synthetic */ CompileService $compileService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilationServices $callbackServices;
            final /* synthetic */ int $port;
            final /* synthetic */ OutputStream $compilerOut;
            final /* synthetic */ OutputStream $daemonOut;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;

            public final int invoke() {
                return ((Number)this.$compileService.remoteIncrementalCompile(this.$sessionId, this.$targetPlatform, this.$args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(this.$callbackServices.getIncrementalCompilationComponents(), this.$callbackServices.getCompilationCanceledStatus(), this.$port), (RemoteOutputStream)new RemoteOutputStreamServer(this.$compilerOut, this.$port), CompileService.OutputFormat.XML, (RemoteOutputStream)new RemoteOutputStreamServer(this.$daemonOut, this.$port), this.$operationsTracer).get()).intValue();
            }
            {
                this.$compileService = compileService;
                this.$sessionId = n;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$callbackServices = compilationServices;
                this.$port = n2;
                this.$compilerOut = outputStream;
                this.$daemonOut = outputStream2;
                this.$operationsTracer = remoteOperationsTracer;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3) {
        if ((n3 & 0x80) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x100) != 0) {
            profiler = (Profiler)new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        Unit unit;
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String $receiver = string;
            String it = $receiver;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default((Iterable)StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes((String)it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6), opts.getMappers(), (String)"", null, (int)4);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])stringArray, (boolean)bl2, (boolean)bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{(OptionsGroup)compilerId, (OptionsGroup)daemonOptions, (OptionsGroup)daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable filteredArgs = DaemonParamsKt.filterExtractProps((Iterable)ArraysKt.asIterable((Object[])args), (OptionsGroup[])optionsGroupArray, (String)string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                Unit unit;
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    List<String> it = list2;
                    compilerId.setCompilerClasspath(it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            CharSequence charSequence = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"File.pathSeparator");
            ConsoleKt.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)charSequence, null, null, (int)0, null, null, (int)62)).toString());
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, 2, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            ConsoleKt.println((Object)"Shutdown the daemon");
            compileService.shutdown();
            ConsoleKt.println((Object)"Daemon shut down successfully");
            return;
        }
        if (CollectionsKt.none((Iterable)filteredArgs)) {
            ConsoleKt.println((Object)("Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId)));
            return;
        }
        ConsoleKt.println((Object)("Executing daemon compilation with args: " + CollectionsKt.joinToString$default((Iterable)filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62)));
        OutputStream outputStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"System.out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(outputStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, 0, 7, null);
        try {
            void $receiver;
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toArrayList((Iterable)filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            int n = CompileService.Companion.getNO_SESSION();
            CompileService compileService2 = compileService;
            void v6 = $receiver;
            if (v6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = (Collection)v6;
            String[] stringArray2 = thisCollection.toArray(new String[thisCollection.size()]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray2;
            CompileService.CallResult res = compileService2.remoteCompile(n, targetPlatform, (String[])objectArray, (CompilerCallbackServicesFacade)servicesFacade, (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, (RemoteOperationsTracer)null);
            long endTime = System.nanoTime();
            ConsoleKt.println((Object)("Compilation result code: " + res));
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            ConsoleKt.println((Object)("Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms"));
            ConsoleKt.println((Object)("Used memory " + memAfter + " (" + StringsKt.format((String)"%+d", (Object[])new Object[]{memAfter - memBefore}) + " kb)"));
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        void $receiver;
        Iterable $receiver2;
        String string = System.getProperty("java.class.path");
        Object object = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6);
        object = list;
        if (list == null) return null;
        Object $receiver3 = (Iterable)object;
        Iterable iterable = $receiver3;
        Collection destination = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            void it;
            String string3 = (String)item;
            Collection collection = destination;
            File file = new File((String)it).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination));
        object = list2;
        if (list2 == null) return null;
        $receiver3 = (Iterable)object;
        $receiver2 = $receiver3;
        destination = new ArrayList();
        Iterable iterable2 = $receiver2;
        for (Object element : $receiver) {
            Boolean bl;
            File file;
            Object element2 = element;
            File it = (File)element2;
            File file2 = it;
            if (file2 != null && (file2 = FilesKt.walk$default((File)file2, null, (int)1)) != null) {
                Object v8;
                block6: {
                    void $receiver4;
                    Sequence $i$f$map = (Sequence)file2;
                    for (Object element3 : $receiver4) {
                        File it2 = (File)element3;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element3;
                        break block6;
                    }
                    v8 = null;
                }
                file = v8;
            } else {
                file = null;
            }
            if (file != null) {
                void $receiver5;
                File file3 = file;
                void it3 = $receiver5;
                bl = destination.add(it3);
                continue;
            }
            bl = null;
        }
        File file = (File)CollectionsKt.firstOrNull((List)((List)destination));
        object = file;
        if (file == null) return null;
        $receiver3 = object;
        File it = (File)$receiver3;
        List list3 = CollectionsKt.listOf((Object)it.getAbsolutePath());
        return list3;
    }

    private final void report(DaemonReportingTargets $receiver, DaemonReportCategory category, String message, String source) {
        Unit unit;
        if (Intrinsics.areEqual((Object)category, (Object)DaemonReportCategory.DEBUG) && !verboseReporting) {
            return;
        }
        PrintStream printStream = $receiver.getOut();
        if (printStream != null) {
            printStream.println("[" + source + "] " + category.name() + ": " + message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Collection<DaemonReportMessage> collection = $receiver.getMessages();
        Boolean bl = collection != null ? Boolean.valueOf(collection.add(new DaemonReportMessage(category, "[" + source + "] " + message))) : null;
    }

    static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n) {
        if ((n & 4) != 0) {
            string2 = "daemon client";
        }
        kotlinCompilerClient.report(daemonReportingTargets, daemonReportCategory, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, ? extends Unit> report) {
        Sequence sequence;
        void comparator;
        Comparator comparator2 = ComparisonsKt.reversed((Comparator)((Comparator)new DaemonJVMOptionsMemoryComparator()));
        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ClientUtilsKt.walkDaemons$default((File)registryDir, (CompilerId)compilerId, null, report, (int)4), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.1.INSTANCE), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.2.INSTANCE);
        Comparator comparator3 = new Comparator<T>((Comparator)comparator){
            final /* synthetic */ Comparator $comparator;

            public int compare(T a, T b) {
                Pair it;
                Comparator comparator = this.$comparator;
                Pair pair = (Pair)a;
                Comparator comparator2 = comparator;
                DaemonJVMOptions daemonJVMOptions = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                it = (Pair)b;
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
            {
                this.$comparator = comparator;
            }
        };
        Sequence aliveWithOpts2 = SequencesKt.sortedWith((Sequence)sequence2, (Comparator)comparator3);
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default((DaemonJVMOptions)daemonJVMOptions, null, null, null, null, (int)15);
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)aliveWithOpts2);
        if (pair != null && (pair = (Pair)AddToStdlibKt.check((Object)pair, (Function1)((Function1)new Function1<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>, Boolean>(daemonJVMOptions){
            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;

            public final boolean invoke(@NotNull Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return DaemonParamsKt.memorywiseFitsInto((DaemonJVMOptions)this.$daemonJVMOptions, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get()));
            }
            {
                this.$daemonJVMOptions = daemonJVMOptions;
                super(1);
            }
        }))) != null) {
            void $receiver;
            Pair $i$f$compareBy = pair;
            Pair it = (Pair)$receiver;
            sequence = new Pair(it.getFirst(), (Object)DaemonParamsKt.updateMemoryUpperBounds((DaemonJVMOptions)optsCopy, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get())));
        } else {
            Pair pair2;
            Sequence $receiver = aliveWithOpts2;
            Object var17_13 = null;
            comparator3 = pair2;
            sequence2 = pair2;
            DaemonJVMOptions accumulator = optsCopy;
            for (Object element : $receiver) {
                void d;
                Pair pair3 = (Pair)element;
                DaemonJVMOptions opts = accumulator;
                accumulator = DaemonParamsKt.updateMemoryUpperBounds((DaemonJVMOptions)opts, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)d.getSecond()).get()));
            }
            DaemonJVMOptions daemonJVMOptions2 = accumulator;
            sequence = sequence2;
            comparator3(var17_13, daemonJVMOptions2);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        platformSpecificOptions = CollectionsKt.listOf((Object)"-Djava.awt.headless=true");
        v0 = new String[3];
        v0[0] = javaExecutable.getAbsolutePath();
        v0[1] = "-cp";
        v1 = compilerId.getCompilerClasspath();
        v2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"File.pathSeparator");
        v0[2] = CollectionsKt.joinToString$default((Iterable)v1, (CharSequence)v2, null, null, (int)0, null, null, (int)62);
        var8_7 = daemonJVMOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v0), (Iterable)platformSpecificOptions);
        var9_9 = $receiver;
        var10_10 = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        $receiver = daemonOptions.getMappers();
        var21_8 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $receiver = $receiver;
        destination = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        $receiver = compilerId.getMappers();
        var21_8 = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        $receiver = $receiver;
        destination = new ArrayList<E>();
        for (T element : $receiver) {
            it = (PropMapper)element;
            list = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        var22_18 = (List)destination;
        args = CollectionsKt.plus((Collection)var21_8, (Iterable)var22_18);
        KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62), null, 4);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        daemonLauncher = Native.get(ProcessLauncher.class);
        daemon = daemonLauncher.start(processBuilder);
        var11_11 = new Ref.ObjectRef();
        var11_11.element = new Semaphore(1);
        ((Semaphore)isEchoRead.element).acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, daemonOptions, (Ref.ObjectRef)isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ Ref.ObjectRef $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    TextStreamsKt.forEachLine((Reader)ByteStreamsKt.reader$default((InputStream)this.$daemon.getInputStream(), null, (int)1), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (StringsKt.isNotEmpty((CharSequence)this.this$0.$daemonOptions.getRunFilesPath()) && StringsKt.contains$default((CharSequence)it, (CharSequence)this.this$0.$daemonOptions.getRunFilesPath(), (boolean)false, (int)2)) {
                                ((Semaphore)this.this$0.$isEchoRead.element).release();
                                return;
                            }
                            KotlinCompilerClient.access$report(KotlinCompilerClient.INSTANCE, this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                }
            }
            {
                this.$daemon = process;
                this.$daemonOptions = daemonOptions;
                this.$isEchoRead = objectRef;
                this.$reportingTargets = daemonReportingTargets;
                super(0);
            }
        }), (int)31);
        try {
            v3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v3 == null) ** GOTO lbl-1000
            list = v3;
            it = (String)$receiver;
            try {
                var17_21 = StringsKt.toLong((String)it);
            }
            catch (Exception e) {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.INSTANCE.getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() + " ms", null, 4);
                var17_21 = null;
            }
            if ((v3 = var17_21) != null) {
                v4 = ((Number)v3).longValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = daemonStartupTimeout = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            if (StringsKt.isNotEmpty((CharSequence)daemonOptions.getRunFilesPath())) {
                succeeded = ((Semaphore)isEchoRead.element).tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                v5 = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"daemon");
                if (!KotlinCompilerClientKt.isProcessAlive(v5)) {
                    throw (Throwable)new Exception("Daemon terminated unexpectedly");
                }
                if (!succeeded) {
                    throw (Throwable)new Exception("Unable to get response from daemon in " + daemonStartupTimeout + " ms");
                }
            } else {
                Thread.sleep(daemonStartupTimeout);
            }
        }
        finally {
            if (stdoutThread.isAlive()) {
                stdoutThread.stop();
            }
        }
        isEchoRead = null;
    }

    static {
        new KotlinCompilerClient();
    }

    private KotlinCompilerClient() {
        INSTANCE = this;
        INSTANCE$ = this;
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    public static final /* synthetic */ void access$report(KotlinCompilerClient $this, DaemonReportingTargets $receiver, @NotNull DaemonReportCategory category, @NotNull String message, @NotNull String source) {
        $this.report($receiver, category, message, source);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dAa\u0011\u0003\r\u0001e\t\u0001\u0014AQ\b\u0013\u0011!\u0011\u0001C\u0001\u000e\u0003a\r\u0011kA\u0001\t\u0005\u0015&AaQ\u0004\t\u000e5\t\u00014AS\n\t\r\u001b\u0001bB\u0007\u00021\u0001IB\u0001B\u0001\t\u00035\t\u00014A\u0015\u0014\t-C\u0001RA\u0007\u000b\u0013!Iq!C\u0001\u0005\u0004%\tA1A\u0005\u0002\t\u0007A:\u0001G\u0002\u001dWE\u001b1!\u0004\u0002\u0005\t!%\u0011&\u0004\u0003D9!\tQ\"\u0001M\u0002#\u000e9Q\u0001A\u0007\u0003\t\u0015AY!\u0005\u0002\u0005\r!\u0011\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy"}, moduleName="client")
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf((Object)new BoolPropMapper((Object)this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

