/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.WeakList;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.NotNull;

public class LowMemoryWatcher {
    private static final long MEM_THRESHOLD = 0x500000L;
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcher");
    private static final List<LowMemoryWatcher> ourInstances = new WeakList<LowMemoryWatcher>();
    private static final ThreadPoolExecutor ourExecutor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), ConcurrencyUtil.newNamedThreadFactory("LowMemoryWatcher janitor"));
    private static boolean ourSubmitted;
    private static final Runnable ourJanitor;
    private static final NotificationListener ourLowMemoryListener;
    private final Runnable myRunnable;

    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        return new LowMemoryWatcher(runnable);
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        final Ref<LowMemoryWatcher> watcher = Ref.create(new LowMemoryWatcher(runnable));
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                ((LowMemoryWatcher)watcher.get()).stop();
                watcher.set(null);
            }
        });
    }

    private LowMemoryWatcher(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "<init>"));
        }
        this.myRunnable = runnable;
        ourInstances.add(this);
    }

    public void stop() {
        ourInstances.remove(this);
    }

    public static void stopAll() {
        ourExecutor.shutdown();
        ourInstances.clear();
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(ourLowMemoryListener);
        }
        catch (ListenerNotFoundException e) {
            LOG.error(e);
        }
    }

    static {
        ourJanitor = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOG.info("Low memory signal received.");
                try {
                    for (LowMemoryWatcher watcher : ourInstances) {
                        try {
                            watcher.myRunnable.run();
                        }
                        catch (Throwable e) {
                            LOG.info(e);
                        }
                    }
                }
                finally {
                    Runnable runnable = ourJanitor;
                    synchronized (runnable) {
                        ourSubmitted = false;
                    }
                }
            }
        };
        ourLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification n, Object hb) {
                if ("java.management.memory.threshold.exceeded".equals(n.getType()) || "java.management.memory.collection.threshold.exceeded".equals(n.getType())) {
                    Runnable runnable = ourJanitor;
                    synchronized (runnable) {
                        if (!ourSubmitted) {
                            ourSubmitted = true;
                            ourExecutor.submit(ourJanitor);
                        }
                    }
                }
            }
        };
        for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
            long threshold;
            if (bean.getType() != MemoryType.HEAP || !bean.isUsageThresholdSupported() || (threshold = bean.getUsage().getMax() - 0x500000L) <= 0L) continue;
            bean.setUsageThreshold(threshold);
            bean.setCollectionUsageThreshold(threshold);
        }
        ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(ourLowMemoryListener, null, null);
    }
}

