/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    private final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicInteger myInProgress;
    private final BlockingQueue<Runnable> myTaskQueue;

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this.myInProgress = new AtomicInteger();
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myBackendExecutor = backendExecutor;
        if (maxSimultaneousTasks < 1) {
            throw new IllegalArgumentException("maxSimultaneousTasks must be >=1 but got: " + maxSimultaneousTasks);
        }
        this.myMaxTasks = maxSimultaneousTasks;
    }

    public BoundedTaskExecutor(@NotNull Executor backendExecutor, int maxSimultaneousTasks, @NotNull Disposable parent) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/concurrency/BoundedTaskExecutor", "<init>"));
        }
        this(backendExecutor, maxSimultaneousTasks);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                BoundedTaskExecutor.this.shutdownNow();
            }
        });
    }

    public static Object info(Object task) {
        if (task instanceof FutureTask) {
            task = ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable");
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task");
        }
        return task;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shutdown");
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list = this.clearAndCancelAll();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "shutdownNow"));
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/BoundedTaskExecutor", "awaitTermination"));
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() first");
        }
        return true;
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "execute"));
        }
        this.myTaskQueue.offer(task);
        int inProgress = this.myInProgress.incrementAndGet();
        this.tryToPollAndExecuteNext(inProgress);
    }

    private void tryToPollAndExecuteNext(int inProgress) {
        while (!this.isShutdown()) {
            Runnable next;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxTasks && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                try {
                    this.myBackendExecutor.execute(this.wrap(next));
                    break;
                }
                catch (Error e) {
                    this.myInProgress.decrementAndGet();
                    throw e;
                }
                catch (RuntimeException e) {
                    this.myInProgress.decrementAndGet();
                    throw e;
                }
            }
            if (this.myInProgress.compareAndSet(inProgress, inProgress - 1)) break;
            inProgress = this.myInProgress.get();
        }
    }

    @NotNull
    private Runnable wrap(final @NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/BoundedTaskExecutor", "wrap"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    BoundedTaskExecutor.this.tryToPollAndExecuteNext(BoundedTaskExecutor.this.myInProgress.get());
                }
            }

            public String toString() {
                return String.valueOf(BoundedTaskExecutor.info(task));
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "wrap"));
        }
        return runnable;
    }

    public void waitAllTasksExecuted(int timeout, @NotNull TimeUnit unit) throws ExecutionException, InterruptedException {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/util/concurrency/BoundedTaskExecutor", "waitAllTasksExecuted"));
        }
        final CountDownLatch started = new CountDownLatch(this.myMaxTasks);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        final StringBuffer log = new StringBuffer("waitAllTasksExecuted: " + this + "\n");
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxTasks, null), new Function<Object, Future>(){

            @Override
            public Future fun(Object o) {
                log.append("Submit task");
                return BoundedTaskExecutor.this.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            started.countDown();
                            log.append("Task run. started=" + started);
                            readyToFinish.await();
                            log.append("Task finished.");
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
        try {
            if (!started.await(timeout, unit)) {
                throw new RuntimeException("Interrupted by timeout. " + this + "\nLog: " + log + "\n" + "; Thread dump:\n" + ThreadDumper.dumpThreadsToString());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get();
        }
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutor", "clearAndCancelAll"));
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxTasks + ") " + (this.isShutdown() ? "SHUTDOWN " : "") + "inProgress: " + this.myInProgress + "; tasks in queue: [" + ContainerUtil.map(this.myTaskQueue, new Function<Runnable, Object>(){

            @Override
            public Object fun(Runnable runnable) {
                return BoundedTaskExecutor.info(runnable);
            }
        }) + "]";
    }
}

