/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.lang.ref.WeakReference;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.InlineChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"9\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001E\u0013\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u00031\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002KQ!1\u0002c\u0002\u000e\u0003a!\u0011\u0003\u0002\u0003\u0001\u0011\u0013)\u0012\u0001G\u0003\u001a\r!-Q\u0002B\u0005\u0003\u0013\u0005!K\u0001\u0007\u0004\u001a\u0007!5Q\"\u0001\r\bK!!\u0011\u0001c\u0004\u000e\u0003a\u0005\u0011d\u0001\u0005\t\u001b\u0005A\n\"K\t\u0005\u0003rA\u0019!D\u0006\n\u0011%9\u0011BA\u0005\u00021\rI!!C\u0001\u0019\u0002a\u0015A\u0012\u0001\r\u0003#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineCheckerWrapper;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "checkersCache", "Ljava/lang/ref/WeakReference;", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "check", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "getChecker", "descriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;"}, moduleName="kotlin-compiler")
public final class InlineCheckerWrapper
implements CallChecker {
    private WeakReference<Map<DeclarationDescriptor, CallChecker>> checkersCache;

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (context.isAnnotationContext) {
            return;
        }
        for (DeclarationDescriptor parentDescriptor = context.scope.getOwnerDescriptor(); parentDescriptor != null; parentDescriptor = parentDescriptor.getContainingDeclaration()) {
            if (!InlineUtil.isInline(parentDescriptor)) continue;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            CallChecker checker = this.getChecker((SimpleFunctionDescriptor)declarationDescriptor);
            checker.check(resolvedCall, context);
        }
    }

    private final CallChecker getChecker(SimpleFunctionDescriptor descriptor2) {
        Object object;
        WeakReference<Object> weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> map2;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> weakReference2 = this.checkersCache;
        if (weakReference2 == null || (weakReference2 = (Map)weakReference2.get()) == null) {
            weakReference2 = map2 = (Map)MapsKt.hashMapOf(new Pair[0]);
        }
        if ((weakReference = this.checkersCache) == null) {
            weakReference = new WeakReference<Object>(map2);
        }
        this.checkersCache = weakReference;
        WeakReference<Map<DeclarationDescriptor, CallChecker>> $receiver = map2;
        Object value = $receiver.get(descriptor2);
        if (value == null && !$receiver.containsKey(descriptor2)) {
            InlineChecker answer = new InlineChecker(descriptor2);
            $receiver.put(descriptor2, answer);
            object = answer;
        } else {
            object = value;
        }
        return (CallChecker)object;
    }
}

