/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.component.AbstractArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ArrangementComboBoxUiComponent
extends AbstractArrangementUiComponent {
    @NotNull
    private final JComboBox myComboBox;

    public ArrangementComboBoxUiComponent(@NotNull List<ArrangementSettingsToken> tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementComboBoxUiComponent", "<init>"));
        }
        super(tokens);
        ArrangementSettingsToken[] tokensArray = tokens.toArray(new ArrangementSettingsToken[tokens.size()]);
        Arrays.sort(tokensArray, new Comparator<ArrangementSettingsToken>(){

            @Override
            public int compare(ArrangementSettingsToken t1, ArrangementSettingsToken t2) {
                return t1.getRepresentationValue().compareTo(t2.getRepresentationValue());
            }
        });
        this.myComboBox = new JComboBox<ArrangementSettingsToken>(tokensArray);
        this.myComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setText(((ArrangementSettingsToken)value).getRepresentationValue());
            }
        });
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ArrangementComboBoxUiComponent.this.fireStateChanged();
                }
            }
        });
        int minWidth = 0;
        ListCellRenderer renderer = this.myComboBox.getRenderer();
        JBList dummyList = new JBList();
        int max = this.myComboBox.getItemCount();
        for (int i = 0; i < max; ++i) {
            Component rendererComponent = renderer.getListCellRendererComponent(dummyList, this.myComboBox.getItemAt(i), i, false, true);
            minWidth = Math.max(minWidth, rendererComponent.getPreferredSize().width);
        }
        this.myComboBox.setPreferredSize(new Dimension(minWidth * 5 / 3, this.myComboBox.getPreferredSize().height));
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        ArrangementSettingsToken arrangementSettingsToken = (ArrangementSettingsToken)this.myComboBox.getSelectedItem();
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementComboBoxUiComponent", "getToken"));
        }
        return arrangementSettingsToken;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementComboBoxUiComponent", "chooseToken"));
        }
        this.myComboBox.setSelectedItem(data);
    }

    @NotNull
    public ArrangementMatchCondition getMatchCondition() {
        ArrangementSettingsToken token = this.getToken();
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = new ArrangementAtomMatchCondition(token, (Object)token);
        if (arrangementAtomMatchCondition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementComboBoxUiComponent", "getMatchCondition"));
        }
        return arrangementAtomMatchCondition;
    }

    @Override
    protected JComponent doGetUiComponent() {
        return this.myComboBox;
    }

    public boolean isSelected() {
        return true;
    }

    public void setSelected(boolean selected) {
    }

    @Override
    public boolean isEnabled() {
        return this.myComboBox.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myComboBox.setEnabled(enabled);
    }

    @Override
    protected void doReset() {
    }

    public int getBaselineToUse(int width, int height) {
        return -1;
    }

    public void handleMouseClickOnSelected() {
        this.setSelected(false);
    }
}

