/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.AbstractExpectedTypeSkipper;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSorting {
    private JavaCompletionSorting() {
    }

    public static CompletionResultSet addJavaSorting(CompletionParameters parameters, CompletionResultSet result2) {
        PsiElement position = parameters.getPosition();
        ExpectedTypeInfo[] expectedTypes = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)position) ? ExpectedTypeInfo.EMPTY_ARRAY : JavaSmartCompletionContributor.getExpectedTypes(parameters);
        CompletionType type = parameters.getCompletionType();
        boolean smart = type == CompletionType.SMART;
        boolean afterNew = JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position);
        ArrayList<LookupElementWeigher> afterProximity = new ArrayList<LookupElementWeigher>();
        afterProximity.add(new PreferContainingSameWords(expectedTypes));
        afterProximity.add(new PreferShorter(expectedTypes));
        CompletionSorter sorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)result2.getPrefixMatcher());
        if (!smart && afterNew) {
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{new PreferExpected(true, expectedTypes, position)});
        } else if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceList.class) == null) {
            sorter = ((CompletionSorterImpl)sorter).withClassifier("liftShorterClasses", true, new LiftShorterClasses(position));
        }
        if (smart) {
            sorter = sorter.weighAfter("priority", new LookupElementWeigher[]{new PreferDefaultTypeWeigher(expectedTypes, parameters)});
        }
        ArrayList afterPrefix = ContainerUtil.newArrayList();
        afterPrefix.add(new PreferByKindWeigher(type, position));
        if (!smart) {
            ContainerUtil.addIfNotNull((Collection)afterPrefix, (Object)JavaCompletionSorting.preferStatics(position, expectedTypes));
            if (!afterNew) {
                afterPrefix.add(new PreferExpected(false, expectedTypes, position));
            }
        }
        ContainerUtil.addIfNotNull((Collection)afterPrefix, (Object)JavaCompletionSorting.recursion(parameters, expectedTypes));
        Collections.addAll(afterPrefix, new LookupElementWeigher[]{new PreferSimilarlyEnding(expectedTypes), new PreferNonGeneric(), new PreferAccessible(position), new PreferSimple()});
        sorter = sorter.weighAfter("prefix", afterPrefix.toArray(new LookupElementWeigher[afterPrefix.size()]));
        sorter = sorter.weighAfter("proximity", afterProximity.toArray(new LookupElementWeigher[afterProximity.size()]));
        return result2.withRelevanceSorter(sorter);
    }

    @Nullable
    private static LookupElementWeigher recursion(CompletionParameters parameters, ExpectedTypeInfo[] expectedInfos) {
        PsiReferenceExpression reference;
        PsiElement position = parameters.getPosition();
        PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        PsiReferenceExpression psiReferenceExpression = reference = expression != null ? expression.getMethodExpression() : (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceExpression.class);
        if (reference == null) {
            return null;
        }
        return new RecursionWeigher(position, parameters.getCompletionType(), reference, expression, expectedInfos);
    }

    @Nullable
    private static LookupElementWeigher preferStatics(PsiElement position, final ExpectedTypeInfo[] infos) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class) != null) {
            return null;
        }
        if (position.getParent() instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)position.getParent();
            PsiElement qualifier = refExpr.getQualifier();
            if (qualifier == null) {
                return null;
            }
            if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !(((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiClass)) {
                return null;
            }
        }
        return new LookupElementWeigher("statics"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                }
                Object o = element.getObject();
                if (o instanceof PsiKeyword) {
                    Integer n = -3;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                    }
                    return n;
                }
                if (!(o instanceof PsiMember) || element.getUserData(JavaGenerateMemberCompletionContributor.GENERATE_ELEMENT) != null) {
                    Integer n = 0;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                    }
                    return n;
                }
                if (((PsiMember)o).hasModifierProperty("static") && !JavaCompletionSorting.hasNonVoid(infos)) {
                    if (o instanceof PsiMethod) {
                        Integer n = -5;
                        if (n == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                        }
                        return n;
                    }
                    if (o instanceof PsiField) {
                        Integer n = -4;
                        if (n == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                        }
                        return n;
                    }
                }
                if (o instanceof PsiClass) {
                    Integer n = -3;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                    }
                    return n;
                }
                Integer n = -5;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$1", "weigh"));
                }
                return n;
            }
        };
    }

    private static ExpectedTypeMatching getExpectedTypeMatching(LookupElement item, ExpectedTypeInfo[] expectedInfos, @Nullable String expectedMemberName) {
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        if (itemType != null) {
            PsiUtil.ensureValidType((PsiType)itemType);
            for (ExpectedTypeInfo expectedInfo : expectedInfos) {
                PsiType defaultType = expectedInfo.getDefaultType();
                PsiType expectedType = expectedInfo.getType();
                assert (expectedType.isValid());
                assert (defaultType.isValid());
                if (defaultType != expectedType && defaultType.isAssignableFrom(itemType)) {
                    return ExpectedTypeMatching.ofDefaultType;
                }
                if (!expectedType.isAssignableFrom(itemType)) continue;
                return ExpectedTypeMatching.expected;
            }
        }
        if (JavaCompletionSorting.hasNonVoid(expectedInfos)) {
            String keyword;
            if (item.getObject() instanceof PsiKeyword && ("new".equals(keyword = ((PsiKeyword)item.getObject()).getText()) || "null".equals(keyword))) {
                return ExpectedTypeMatching.maybeExpected;
            }
        } else if (expectedInfos.length > 0) {
            return ExpectedTypeMatching.unexpected;
        }
        return JavaCompletionSorting.preferByMemberName(expectedMemberName, itemType);
    }

    @NotNull
    private static ExpectedTypeMatching preferByMemberName(@Nullable String expectedMemberName, @Nullable PsiType itemType) {
        PsiClass itemClass;
        if (expectedMemberName != null && (itemClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)itemType)) != null && (itemClass.findMethodsByName(expectedMemberName, true).length > 0 || itemClass.findFieldByName(expectedMemberName, true) != null || itemClass.findInnerClassByName(expectedMemberName, true) != null)) {
            ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.expected;
            if (expectedTypeMatching == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting", "preferByMemberName"));
            }
            return expectedTypeMatching;
        }
        ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.normal;
        if (expectedTypeMatching == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting", "preferByMemberName"));
        }
        return expectedTypeMatching;
    }

    private static boolean hasNonVoid(ExpectedTypeInfo[] expectedInfos) {
        boolean hasNonVoid = false;
        for (ExpectedTypeInfo info : expectedInfos) {
            if (PsiType.VOID.equals((Object)info.getType())) continue;
            hasNonVoid = true;
        }
        return hasNonVoid;
    }

    @Nullable
    private static String getLookupObjectName(Object o) {
        if (o instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)o;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
            VariableKind variableKind = codeStyleManager.getVariableKind(variable);
            return codeStyleManager.variableNameToPropertyName(variable.getName(), variableKind);
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getName();
        }
        return null;
    }

    private static int getNameEndMatchingDegree(String name, ExpectedTypeInfo[] expectedInfos) {
        int res = 0;
        if (name != null && expectedInfos != null) {
            List words = NameUtil.nameToWordsLowerCase((String)name);
            List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name));
            int max1 = JavaCompletionSorting.calcMatch(words, 0, expectedInfos);
            res = max1 = JavaCompletionSorting.calcMatch(wordsNoDigits, max1, expectedInfos);
        }
        return res;
    }

    private static String truncDigits(String name) {
        char c;
        int count;
        for (count = name.length() - 1; count >= 0 && Character.isDigit(c = name.charAt(count)); --count) {
        }
        return name.substring(0, count + 1);
    }

    private static int calcMatch(List<String> words, int max, ExpectedTypeInfo[] myExpectedInfos) {
        for (ExpectedTypeInfo myExpectedInfo : myExpectedInfos) {
            String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
            if (expectedName == null) continue;
            max = JavaCompletionSorting.calcMatch(expectedName, words, max);
            max = JavaCompletionSorting.calcMatch(JavaCompletionSorting.truncDigits(expectedName), words, max);
        }
        return max;
    }

    private static int calcMatch(String expectedName, List<String> words, int max) {
        String expectedWord;
        String word;
        if (expectedName == null) {
            return max;
        }
        String[] expectedWords = NameUtil.nameToWords((String)expectedName);
        int limit = Math.min(words.size(), expectedWords.length);
        for (int i = 0; i < limit && (word = words.get(words.size() - i - 1)).equalsIgnoreCase(expectedWord = expectedWords[expectedWords.length - i - 1]); ++i) {
            max = Math.max(max, i + 1);
        }
        return max;
    }

    private static class LiftShorterClasses
    extends ClassifierFactory<LookupElement> {
        final ProjectFileIndex fileIndex;
        private final PsiElement myPosition;

        public LiftShorterClasses(PsiElement position) {
            super("liftShorterClasses");
            this.myPosition = position;
            this.fileIndex = ProjectRootManager.getInstance((Project)this.myPosition.getProject()).getFileIndex();
        }

        @Override
        public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
            return new LiftShorterItemsClassifier("liftShorterClasses", next, new LiftShorterItemsClassifier.LiftingCondition(){

                @Override
                public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
                    VirtualFile vFile;
                    PsiClass psiClass;
                    PsiFile file2;
                    Object object = shorterElement.getObject();
                    return object instanceof PsiClass && longerElement.getObject() instanceof PsiClass && (file2 = (psiClass = (PsiClass)object).getContainingFile()) != null && (vFile = file2.getOriginalFile().getVirtualFile()) != null && LiftShorterClasses.this.fileIndex.isInSource(vFile);
                }
            }, true);
        }
    }

    private static class PreferShorter
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        public PreferShorter(ExpectedTypeInfo[] expectedTypes) {
            super("shorter");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferShorter", "weigh"));
            }
            Object object = element.getObject();
            String name = JavaCompletionSorting.getLookupObjectName(object);
            if (name != null && JavaCompletionSorting.getNameEndMatchingDegree(name, this.myExpectedTypes) != 0) {
                Integer n = NameUtil.nameToWords((String)name).length - 1000;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferShorter", "weigh"));
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferShorter", "weigh"));
            }
            return n;
        }
    }

    private static class PreferContainingSameWords
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        public PreferContainingSameWords(ExpectedTypeInfo[] expectedTypes) {
            super("sameWords");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferContainingSameWords", "weigh"));
            }
            Object object = element.getObject();
            String name = JavaCompletionSorting.getLookupObjectName(object);
            if (name != null) {
                int max = 0;
                List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name));
                for (ExpectedTypeInfo myExpectedInfo : this.myExpectedTypes) {
                    String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
                    if (expectedName == null) continue;
                    THashSet set = new THashSet((Collection)NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(expectedName)));
                    set.retainAll((Collection)wordsNoDigits);
                    max = Math.max(max, set.size());
                }
                Integer n = -max;
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferContainingSameWords", "weigh"));
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferContainingSameWords", "weigh"));
            }
            return n;
        }
    }

    private static class PreferSimilarlyEnding
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        public PreferSimilarlyEnding(ExpectedTypeInfo[] expectedTypes) {
            super("nameEnd");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimilarlyEnding", "weigh"));
            }
            String name = JavaCompletionSorting.getLookupObjectName(element.getObject());
            Integer n = -JavaCompletionSorting.getNameEndMatchingDegree(name, this.myExpectedTypes);
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimilarlyEnding", "weigh"));
            }
            return n;
        }
    }

    private static class PreferExpected
    extends LookupElementWeigher {
        private final boolean myConstructorPossible;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final List<PsiType> myExpectedClasses = new SmartList();
        private final String myExpectedMemberName;

        public PreferExpected(boolean constructorPossible, ExpectedTypeInfo[] expectedTypes, PsiElement position) {
            super("expectedType");
            this.myConstructorPossible = constructorPossible;
            this.myExpectedTypes = expectedTypes;
            for (ExpectedTypeInfo info : expectedTypes) {
                ContainerUtil.addIfNotNull(this.myExpectedClasses, (Object)PsiUtil.substituteTypeParameter((PsiType)info.getDefaultType(), (String)"java.lang.Class", (int)0, (boolean)false));
            }
            this.myExpectedMemberName = PreferExpected.calcExpectedMemberNameByParentCall(position);
        }

        @Nullable
        private static String calcExpectedMemberNameByParentCall(PsiElement position) {
            PsiElement grand;
            if (position.getParent() instanceof PsiJavaCodeReferenceElement && (grand = position.getParent().getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)grand).getQualifier() == position.getParent()) {
                return ((PsiJavaCodeReferenceElement)grand).getReferenceName();
            }
            return null;
        }

        @NotNull
        public ExpectedTypeMatching weigh(@NotNull LookupElement item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected", "weigh"));
            }
            if (item.getObject() instanceof PsiClass && !this.myConstructorPossible) {
                PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
                if (itemType != null) {
                    for (PsiType expectedClass : this.myExpectedClasses) {
                        if (!expectedClass.isAssignableFrom(itemType)) continue;
                        ExpectedTypeMatching expectedTypeMatching = ExpectedTypeMatching.expected;
                        if (expectedTypeMatching == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected", "weigh"));
                        }
                        return expectedTypeMatching;
                    }
                }
                ExpectedTypeMatching expectedTypeMatching = JavaCompletionSorting.preferByMemberName(this.myExpectedMemberName, itemType);
                if (expectedTypeMatching == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected", "weigh"));
                }
                return expectedTypeMatching;
            }
            ExpectedTypeMatching expectedTypeMatching = JavaCompletionSorting.getExpectedTypeMatching(item, this.myExpectedTypes, this.myExpectedMemberName);
            if (expectedTypeMatching == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferExpected", "weigh"));
            }
            return expectedTypeMatching;
        }
    }

    private static class PreferSimple
    extends LookupElementWeigher {
        public PreferSimple() {
            super("simple");
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimple", "weigh"));
            }
            PsiTypeLookupItem lookupItem = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY);
            if (lookupItem != null) {
                Integer n = lookupItem.getBracketsCount() * 10 + (lookupItem.isAddArrayInitializer() ? 1 : 0);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimple", "weigh"));
                }
                return n;
            }
            Integer n = 0;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferSimple", "weigh"));
            }
            return n;
        }
    }

    private static class PreferNonGeneric
    extends LookupElementWeigher {
        public PreferNonGeneric() {
            super("nonGeneric");
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferNonGeneric", "weigh"));
            }
            Object object = element.getObject();
            if (object instanceof PsiMethod) {
                PsiType type = ((PsiMethod)object).getReturnType();
                JavaMethodCallElement callItem = (JavaMethodCallElement)element.as(JavaMethodCallElement.CLASS_CONDITION_KEY);
                if (callItem != null) {
                    type = callItem.getSubstitutor().substitute(type);
                }
                if (type instanceof PsiClassType && ((PsiClassType)type).resolve() instanceof PsiTypeParameter) {
                    Integer n = 1;
                    if (n == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferNonGeneric", "weigh"));
                    }
                    return n;
                }
            }
            Integer n = 0;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferNonGeneric", "weigh"));
            }
            return n;
        }
    }

    private static class PreferAccessible
    extends LookupElementWeigher {
        private final PsiElement myPosition;

        public PreferAccessible(PsiElement position) {
            super("accessible");
            this.myPosition = position;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible", "weigh"));
            }
            Object object = element.getObject();
            if (object instanceof PsiDocCommentOwner) {
                PsiDocCommentOwner member = (PsiDocCommentOwner)object;
                if (!JavaPsiFacade.getInstance((Project)member.getProject()).getResolveHelper().isAccessible((PsiMember)member, this.myPosition, null)) {
                    MyEnum myEnum = MyEnum.INACCESSIBLE;
                    if (myEnum == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible", "weigh"));
                    }
                    return myEnum;
                }
                if (member.isDeprecated()) {
                    MyEnum myEnum = MyEnum.DEPRECATED;
                    if (myEnum == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible", "weigh"));
                    }
                    return myEnum;
                }
            }
            MyEnum myEnum = MyEnum.NORMAL;
            if (myEnum == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferAccessible", "weigh"));
            }
            return myEnum;
        }

        private static enum MyEnum {
            NORMAL,
            DEPRECATED,
            INACCESSIBLE;

        }
    }

    private static enum ExpectedTypeMatching {
        ofDefaultType,
        expected,
        maybeExpected,
        normal,
        unexpected;

    }

    private static class PreferDefaultTypeWeigher
    extends LookupElementWeigher {
        private final PsiTypeParameter myTypeParameter;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final CompletionParameters myParameters;
        private final CompletionLocation myLocation;

        public PreferDefaultTypeWeigher(ExpectedTypeInfo[] expectedTypes, CompletionParameters parameters) {
            super("defaultType");
            this.myExpectedTypes = expectedTypes == null ? null : (ExpectedTypeInfo[])ContainerUtil.map2Array((Object[])expectedTypes, ExpectedTypeInfo.class, (Function)new Function<ExpectedTypeInfo, ExpectedTypeInfo>(){

                public ExpectedTypeInfo fun(ExpectedTypeInfo info) {
                    PsiType type = PreferDefaultTypeWeigher.removeClassWildcard(info.getType());
                    PsiType defaultType = PreferDefaultTypeWeigher.removeClassWildcard(info.getDefaultType());
                    if (type == info.getType() && defaultType == info.getDefaultType()) {
                        return info;
                    }
                    return new ExpectedTypeInfoImpl(type, info.getKind(), defaultType, info.getTailType(), null, ExpectedTypeInfoImpl.NULL);
                }
            });
            this.myParameters = parameters;
            Pair<PsiClass, Integer> pair = TypeArgumentCompletionProvider.getTypeParameterInfo(parameters.getPosition());
            this.myTypeParameter = pair == null ? null : ((PsiClass)pair.first).getTypeParameters()[(Integer)pair.second];
            this.myLocation = new CompletionLocation(this.myParameters);
        }

        @NotNull
        public MyResult weigh(@NotNull LookupElement item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
            }
            Object object = item.getObject();
            if (object instanceof PsiClass) {
                if (object instanceof PsiTypeParameter) {
                    MyResult myResult = MyResult.typeParameter;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                    }
                    return myResult;
                }
                if (this.myTypeParameter != null && object.equals(PsiUtil.resolveClassInType((PsiType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)this.myTypeParameter)))) {
                    MyResult myResult = MyResult.exactlyExpected;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                    }
                    return myResult;
                }
            }
            if (this.myExpectedTypes == null) {
                MyResult myResult = MyResult.normal;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                }
                return myResult;
            }
            PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
            if (itemType == null || !itemType.isValid()) {
                MyResult myResult = MyResult.normal;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                }
                return myResult;
            }
            if (object instanceof PsiClass) {
                for (ExpectedTypeInfo info : this.myExpectedTypes) {
                    if (!TypeConversionUtil.erasure((PsiType)info.getType().getDeepComponentType()).equals(TypeConversionUtil.erasure((PsiType)itemType))) continue;
                    MyResult myResult = AbstractExpectedTypeSkipper.skips(item, this.myLocation) ? MyResult.expectedNoSelect : MyResult.exactlyExpected;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                    }
                    return myResult;
                }
            }
            for (ExpectedTypeInfo expectedInfo : this.myExpectedTypes) {
                PsiType defaultType = expectedInfo.getDefaultType();
                PsiType expectedType = expectedInfo.getType();
                if (!expectedType.isValid()) {
                    MyResult myResult = MyResult.normal;
                    if (myResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                    }
                    return myResult;
                }
                if (defaultType != expectedType) {
                    if (defaultType.equals(itemType)) {
                        MyResult myResult = MyResult.exactlyDefault;
                        if (myResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                        }
                        return myResult;
                    }
                    if (defaultType.isAssignableFrom(itemType)) {
                        MyResult myResult = MyResult.ofDefaultType;
                        if (myResult == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                        }
                        return myResult;
                    }
                }
                if (!PsiType.VOID.equals((Object)itemType) || !PsiType.VOID.equals((Object)expectedType)) continue;
                MyResult myResult = MyResult.exactlyExpected;
                if (myResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
                }
                return myResult;
            }
            MyResult myResult = MyResult.normal;
            if (myResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionSorting$PreferDefaultTypeWeigher", "weigh"));
            }
            return myResult;
        }

        private static PsiType removeClassWildcard(PsiType type) {
            PsiClassType erased;
            PsiType[] parameters;
            PsiClass psiClass;
            if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(psiClass.getQualifiedName()) && (parameters = (erased = (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)type)).getParameters()).length == 1 && !parameters[0].equalsToText("java.lang.Object")) {
                return erased;
            }
            return type;
        }

        private static enum MyResult {
            expectedNoSelect,
            typeParameter,
            exactlyDefault,
            ofDefaultType,
            exactlyExpected,
            normal;

        }
    }
}

