/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.SlowerTypeConversions;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementExtractorFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ModifierFilter;
import com.intellij.psi.filters.types.AssignableFromFilter;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceExpressionCompletionContributor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor");
    public static final ElementPattern<PsiElement> IN_SWITCH_LABEL = PsiJavaPatterns.psiElement().withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class).withSuperParent(2, PsiSwitchStatement.class));

    @NotNull
    static ElementFilter getReferenceFilter(PsiElement element, boolean allowRecursion) {
        ElementFilter filter;
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withParent(PsiThrowStatement.class))).accepts((Object)element)) {
            ElementFilter elementFilter = TrueFilter.INSTANCE;
            if (elementFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementFilter;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class), PsiJavaPatterns.psiElement(PsiSwitchLabelStatement.class)}))).accepts((Object)element)) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(new AndFilter((ElementFilter)new ClassFilter(PsiField.class), (ElementFilter)new ModifierFilter("static", "final")));
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        final PsiForeachStatement foreach = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiForeachStatement.class);
        if (foreach != null && !PsiTreeUtil.isAncestor((PsiElement)foreach.getBody(), (PsiElement)element, (boolean)false)) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(new ElementFilter(){

                public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                    return element != foreach.getIterationParameter();
                }

                public boolean isClassAcceptable(Class hintClass) {
                    return true;
                }
            });
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        if (!allowRecursion && (filter = RecursionWeigher.recursionFilter(element)) != null) {
            ElementExtractorFilter elementExtractorFilter = new ElementExtractorFilter(filter);
            if (elementExtractorFilter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
            }
            return elementExtractorFilter;
        }
        ElementFilter elementFilter = TrueFilter.INSTANCE;
        if (elementFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "getReferenceFilter"));
        }
        return elementFilter;
    }

    @Nullable
    public static Runnable fillCompletionVariants(JavaSmartCompletionParameters parameters, Consumer<LookupElement> result2) {
        PsiElement element = parameters.getPosition();
        if (JavaSmartCompletionContributor.INSIDE_TYPECAST_EXPRESSION.accepts((Object)element)) {
            return null;
        }
        if (JavaKeywordCompletion.isAfterPrimitiveOrArrayType(element)) {
            return null;
        }
        int offset = parameters.getParameters().getOffset();
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)element.getContainingFile(), (int)offset, PsiJavaCodeReferenceElement.class, (boolean)false);
        if (reference != null) {
            ElementFilter filter = ReferenceExpressionCompletionContributor.getReferenceFilter(element, false);
            for (LookupElement item : ReferenceExpressionCompletionContributor.completeFinalReference(element, reference, filter, parameters)) {
                result2.consume((Object)item);
            }
            boolean secondTime = parameters.getParameters().getInvocationCount() >= 2;
            Set<LookupElement> base = JavaSmartCompletionContributor.completeReference(element, reference, filter, false, true, parameters.getParameters(), PrefixMatcher.ALWAYS_TRUE);
            for (LookupElement item : new LinkedHashSet<LookupElement>(base)) {
                ExpressionLookupItem access = ArrayMemberAccess.accessFirstElement(element, item);
                if (access == null) continue;
                base.add(access);
                PsiType type = access.getType();
                if (type == null || !parameters.getExpectedType().isAssignableFrom(type)) continue;
                result2.consume((Object)access);
            }
            if (secondTime) {
                return new SlowerTypeConversions(base, element, reference, parameters, result2);
            }
        }
        return null;
    }

    static Set<LookupElement> completeFinalReference(final PsiElement element, PsiJavaCodeReferenceElement reference, ElementFilter filter, final JavaSmartCompletionParameters parameters) {
        final Set<Object> used = parameters.getParameters().getInvocationCount() < 2 ? ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(element) : Collections.emptySet();
        Set<LookupElement> elements = JavaSmartCompletionContributor.completeReference(element, reference, new AndFilter(filter, new ElementFilter(){

            public boolean isAcceptable(Object o, PsiElement context) {
                if (o instanceof CandidateInfo) {
                    CandidateInfo info = (CandidateInfo)o;
                    PsiElement member = info.getElement();
                    PsiType expectedType = parameters.getExpectedType();
                    if (expectedType.equals(PsiType.VOID)) {
                        return member instanceof PsiMethod;
                    }
                    if (member instanceof PsiEnumConstant && used.contains(CompletionUtil.getOriginalOrSelf(member))) {
                        return false;
                    }
                    return AssignableFromFilter.isAcceptable(member, element, expectedType, info.getSubstitutor());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }), false, true, parameters.getParameters(), PrefixMatcher.ALWAYS_TRUE);
        for (LookupElement lookupElement : elements) {
            PsiMethod method;
            JavaMethodCallElement item;
            if (!(lookupElement.getObject() instanceof PsiMethod) || (item = (JavaMethodCallElement)lookupElement.as(JavaMethodCallElement.CLASS_CONDITION_KEY)) == null || !SmartCompletionDecorator.hasUnboundTypeParams(method = (PsiMethod)lookupElement.getObject(), parameters.getExpectedType())) continue;
            item.setInferenceSubstitutor(SmartCompletionDecorator.calculateMethodReturnTypeSubstitutor(method, parameters.getExpectedType()), element);
        }
        return elements;
    }

    @NotNull
    public static Set<PsiField> findConstantsUsedInSwitch(@Nullable PsiElement position) {
        if (IN_SWITCH_LABEL.accepts((Object)position)) {
            LinkedHashSet used = ContainerUtil.newLinkedHashSet();
            PsiSwitchStatement sw = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiSwitchStatement.class);
            assert (sw != null);
            PsiCodeBlock body = sw.getBody();
            assert (body != null);
            for (PsiStatement statement : body.getStatements()) {
                PsiElement target;
                PsiExpression value;
                if (!(statement instanceof PsiSwitchLabelStatement) || !((value = ((PsiSwitchLabelStatement)statement).getCaseValue()) instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)value).resolve()) instanceof PsiField)) continue;
                used.add(CompletionUtil.getOriginalOrSelf((PsiField)target));
            }
            LinkedHashSet linkedHashSet = used;
            if (linkedHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "findConstantsUsedInSwitch"));
            }
            return linkedHashSet;
        }
        Set<PsiField> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "findConstantsUsedInSwitch"));
        }
        return set;
    }

    static PsiExpression createExpression(String text, PsiElement element) {
        return JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createExpressionFromText(text, element);
    }

    static String getQualifierText(@Nullable PsiElement qualifier) {
        return qualifier == null ? "" : qualifier.getText() + ".";
    }

    @Nullable
    public static PsiReferenceExpression createMockReference(PsiElement place, @NotNull PsiType qualifierType, LookupElement qualifierItem) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/codeInsight/completion/ReferenceExpressionCompletionContributor", "createMockReference"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        if (qualifierItem.getObject() instanceof PsiClass) {
            String qname = ((PsiClass)qualifierItem.getObject()).getQualifiedName();
            if (qname == null) {
                return null;
            }
            String text = qname + ".xxx";
            try {
                PsiExpression expr = factory.createExpressionFromText(text, place);
                if (expr instanceof PsiReferenceExpression) {
                    return (PsiReferenceExpression)expr;
                }
                return null;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }
        return (PsiReferenceExpression)factory.createExpressionFromText("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(place, qualifierType));
    }

    static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }
}

