/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.Processor;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectWordHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.SelectWordHandler");
    private final EditorActionHandler myOriginalHandler;

    public SelectWordHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        Project project;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordHandler", "doExecute"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: execute(editor='" + editor + "')");
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()))) == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        TextRange range = SelectWordHandler.selectWord(editor, project);
        if (editor instanceof EditorWindow && (range == null || !SelectWordHandler.isInsideEditableInjection((EditorWindow)editor, range, project) || TextRange.from((int)0, (int)editor.getDocument().getTextLength()).equals((Object)new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd())))) {
            editor = ((EditorWindow)editor).getDelegate();
            range = SelectWordHandler.selectWord(editor, project);
        }
        if (range == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
        } else {
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private static boolean isInsideEditableInjection(EditorWindow editor, TextRange range, Project project) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile((Document)editor.getDocument());
        if (file2 == null) {
            return true;
        }
        List editables = InjectedLanguageManager.getInstance((Project)project).intersectWithAllEditableFragments(file2, range);
        return editables.size() == 1 && range.equals(editables.get(0));
    }

    @Nullable(value="null means unable to select")
    private static TextRange selectWord(@NotNull Editor editor, @NotNull Project project) {
        PsiElement elementInOtherTree;
        PsiElement anotherElement;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordHandler", "selectWord"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/SelectWordHandler", "selectWord"));
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        if (file2 == null) {
            return null;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.select.word");
        int caretOffset = SelectWordHandler.adjustCaretOffset(editor);
        PsiElement element = SelectWordHandler.findElementAt(file2, caretOffset);
        if (element instanceof PsiWhiteSpace && caretOffset > 0 && !((anotherElement = SelectWordHandler.findElementAt(file2, caretOffset - 1)) instanceof PsiWhiteSpace)) {
            element = anotherElement;
        }
        while (element instanceof PsiWhiteSpace || element != null && StringUtil.isEmptyOrSpaces((String)element.getText())) {
            while (element.getNextSibling() == null) {
                if (element instanceof PsiFile) {
                    return null;
                }
                PsiElement parent = element.getParent();
                PsiElement[] children2 = parent.getChildren();
                if (children2.length > 0 && children2[children2.length - 1] == element) {
                    element = parent;
                    continue;
                }
                element = parent;
                break;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            if ((element = element.getNextSibling()) == null) {
                return null;
            }
            TextRange range = element.getTextRange();
            if (range == null) {
                return null;
            }
            caretOffset = range.getStartOffset();
        }
        if (element instanceof OuterLanguageElement && ((elementInOtherTree = file2.getViewProvider().findElementAt(element.getTextOffset(), element.getLanguage())) == null || elementInOtherTree.getContainingFile() != element.getContainingFile())) {
            while (elementInOtherTree != null && elementInOtherTree.getPrevSibling() == null) {
                elementInOtherTree = elementInOtherTree.getParent();
            }
            if (elementInOtherTree != null) {
                assert (elementInOtherTree.getTextOffset() == caretOffset);
                element = elementInOtherTree;
            }
        }
        SelectWordHandler.checkElementRange(document, element);
        final TextRange selectionRange = new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        final Ref minimumRange = new Ref((Object)new TextRange(0, editor.getDocument().getTextLength()));
        SelectWordUtil.processRanges(element, editor.getDocument().getCharsSequence(), caretOffset, editor, new Processor<TextRange>(){

            public boolean process(@NotNull TextRange range) {
                if (range == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/editorActions/SelectWordHandler$1", "process"));
                }
                if (range.contains(selectionRange) && !range.equals((Object)selectionRange) && ((TextRange)minimumRange.get()).contains(range)) {
                    minimumRange.set((Object)range);
                    return true;
                }
                return false;
            }
        });
        return (TextRange)minimumRange.get();
    }

    private static void checkElementRange(Document document, PsiElement element) {
        if (element != null && element.getTextRange().getEndOffset() > document.getTextLength()) {
            throw new AssertionError((Object)DebugUtil.diagnosePsiDocumentInconsistency(element, document));
        }
    }

    private static int adjustCaretOffset(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/SelectWordHandler", "adjustCaretOffset"));
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset == 0) {
            return caretOffset;
        }
        CharSequence text = editor.getDocument().getCharsSequence();
        char prev = text.charAt(caretOffset - 1);
        if (caretOffset < text.length() && !Character.isJavaIdentifierPart(text.charAt(caretOffset)) && Character.isJavaIdentifierPart(prev)) {
            return caretOffset - 1;
        }
        if ((caretOffset == text.length() || Character.isWhitespace(text.charAt(caretOffset))) && !Character.isWhitespace(prev)) {
            return caretOffset - 1;
        }
        return caretOffset;
    }

    @Nullable
    private static PsiElement findElementAt(@NotNull PsiFile file2, int caretOffset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/SelectWordHandler", "findElementAt"));
        }
        PsiElement elementAt = file2.findElementAt(caretOffset);
        if (elementAt != null && SelectWordHandler.isLanguageExtension(file2, elementAt)) {
            return file2.getViewProvider().findElementAt(caretOffset, file2.getLanguage());
        }
        return elementAt;
    }

    private static boolean isLanguageExtension(@NotNull PsiFile file2, @NotNull PsiElement elementAt) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/SelectWordHandler", "isLanguageExtension"));
        }
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/codeInsight/editorActions/SelectWordHandler", "isLanguageExtension"));
        }
        Language elementLanguage = elementAt.getLanguage();
        if (file2.getLanguage() instanceof CompositeLanguage) {
            Language[] extensions;
            CompositeLanguage compositeLanguage = (CompositeLanguage)file2.getLanguage();
            for (Language extension : extensions = compositeLanguage.getLanguageExtensionsForFile(file2)) {
                if (extension != elementLanguage) continue;
                return true;
            }
        }
        return false;
    }
}

