/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseColorIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertColorRepresentationIntentionAction
extends BaseColorIntentionAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression == null) {
            return false;
        }
        PsiExpressionList arguments = expression.getArgumentList();
        if (arguments == null) {
            return false;
        }
        PsiMethod constructor = expression.resolveConstructor();
        if (constructor == null) {
            return false;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.convert.color.representation.text", (Object[])new Object[]{newArguments.getText()}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression == null) {
            return;
        }
        PsiExpressionList arguments = expression.getArgumentList();
        if (arguments == null) {
            return;
        }
        PsiMethod constructor = expression.resolveConstructor();
        if (constructor == null) {
            return;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return;
        }
        arguments.replace((PsiElement)newArguments);
    }

    @Nullable
    private static PsiExpressionList createNewArguments(@NotNull PsiElementFactory factory, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createNewArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createNewArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createNewArguments"));
        }
        String[] newValues = ConvertColorRepresentationIntentionAction.createArguments(parameters, arguments);
        if (newValues == null) {
            return null;
        }
        PsiExpressionList result2 = ((PsiNewExpression)factory.createExpressionFromText("new Object()", (PsiElement)parameters[0])).getArgumentList();
        if (result2 == null) {
            return null;
        }
        for (String value : newValues) {
            result2.add((PsiElement)factory.createExpressionFromText(value, (PsiElement)parameters[0]));
        }
        return result2;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (parameters.length != arguments.length) {
            return null;
        }
        switch (parameters.length) {
            default: {
                return null;
            }
            case 1: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0]);
            }
            case 2: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1]);
            }
            case 3: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2]);
            }
            case 4: 
        }
        return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression) {
        if (rgbExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rgbExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        return ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 3);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, @NotNull PsiExpression hasAlphaExpression) {
        if (rgbExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rgbExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (hasAlphaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasAlphaExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        Boolean hasAlpha = ConvertColorRepresentationIntentionAction.computeBoolean(hasAlphaExpression);
        if (hasAlpha == null) {
            return null;
        }
        return hasAlpha != false ? ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 4) : ConvertColorRepresentationIntentionAction.createArguments(rgbExpression);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression) {
        String[] stringArray;
        if (rExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (gExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (bExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        Integer value = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression));
        if (value != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "0x" + Integer.toHexString(value);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression, @NotNull PsiExpression aExpression) {
        if (rExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (gExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (bExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        if (aExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        Integer value = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression), ConvertColorRepresentationIntentionAction.computeInteger(aExpression));
        if (value == null) {
            return null;
        }
        return new String[]{"0x" + Integer.toHexString(value), "true"};
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, int parts) {
        if (rgbExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rgbExpression", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "createArguments"));
        }
        Integer rgb = ConvertColorRepresentationIntentionAction.computeInteger(rgbExpression);
        if (rgb == null) {
            return null;
        }
        String[] result2 = new String[parts];
        for (int i = 0; i < result2.length; ++i) {
            result2[result2.length - i - 1] = String.valueOf(rgb >> i * 8 & 0xFF);
        }
        return result2;
    }

    @Nullable
    private static Integer createInt(Integer ... ints) {
        int result2 = 0;
        for (Integer i : ints) {
            if (i == null) {
                return null;
            }
            result2 = result2 << 8 | i & 0xFF;
        }
        return result2;
    }

    @Nullable
    public static Integer computeInteger(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "computeInteger"));
        }
        Object result2 = ConvertColorRepresentationIntentionAction.compute(expr);
        return result2 instanceof Integer ? (Integer)result2 : null;
    }

    @Nullable
    public static Boolean computeBoolean(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "computeBoolean"));
        }
        Object result2 = ConvertColorRepresentationIntentionAction.compute(expr);
        return result2 instanceof Boolean ? (Boolean)result2 : null;
    }

    @Nullable
    private static Object compute(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "compute"));
        }
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr, true);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.convert.color.representation.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ConvertColorRepresentationIntentionAction", "getFamilyName"));
        }
        return string;
    }
}

