/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PushConditionInCallAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        if ("Push condition inside call" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "getFamilyName"));
        }
        return "Push condition inside call";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "isAvailable"));
        }
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        if (conditionalExpression == null) {
            return false;
        }
        String conditionText = conditionalExpression.getCondition().getText();
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        return this.isAvailable(conditionText, thenExpression, elseExpression, 0);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        if (conditionalExpression == null) {
            return;
        }
        PsiExpression thenExpression = conditionalExpression.getThenExpression();
        if (thenExpression == null) {
            return;
        }
        thenExpression = (PsiExpression)thenExpression.copy();
        PushConditionInCallAction.replaceRecursively(project, conditionalExpression, thenExpression, conditionalExpression.getElseExpression());
        CodeStyleManager.getInstance((Project)project).reformat(conditionalExpression.replace((PsiElement)thenExpression));
    }

    private boolean isAvailable(String conditionText, PsiExpression thenExpression, PsiExpression elseExpression, int level) {
        if (!(thenExpression instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod thenMethod = ((PsiCallExpression)thenExpression).resolveMethod();
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression).getArgumentList();
        if (thenArgsList == null) {
            return false;
        }
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        if (!(elseExpression instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod elseMethod = ((PsiCallExpression)elseExpression).resolveMethod();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression).getArgumentList();
        if (elseArgsList == null) {
            return false;
        }
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        if (thenMethod != elseMethod || thenMethod == null) {
            return false;
        }
        if (thenExpressions.length != elseExpressions.length) {
            return false;
        }
        Pair<PsiExpression, PsiExpression> qualifiers = PushConditionInCallAction.getQualifiers(thenExpression, elseExpression);
        if (qualifiers != null) {
            if (!PushConditionInCallAction.isSameCall(thenExpressions, elseExpressions) && level == 0) {
                return false;
            }
            if (level > 0) {
                this.setText("Push condition '" + conditionText + "' inside " + (thenMethod.isConstructor() ? "constructor" : "method") + " call");
                return true;
            }
            return level > 0 || this.isAvailable(conditionText, (PsiExpression)qualifiers.first, (PsiExpression)qualifiers.second, level + 1);
        }
        PsiExpression tExpr = null;
        for (int i = 0; i < thenExpressions.length; ++i) {
            PsiExpression lExpr = thenExpressions[i];
            PsiExpression rExpr = elseExpressions[i];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            if (tExpr == null) {
                tExpr = lExpr;
                continue;
            }
            return false;
        }
        this.setText("Push condition '" + conditionText + "' inside " + (thenMethod.isConstructor() ? "constructor" : "method") + " call");
        return true;
    }

    private static boolean isSameCall(PsiExpression[] thenExpressions, PsiExpression[] elseExpressions) {
        for (int i = 0; i < thenExpressions.length; ++i) {
            PsiExpression lExpr = thenExpressions[i];
            PsiExpression rExpr = elseExpressions[i];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            return false;
        }
        return true;
    }

    private static Pair<PsiExpression, PsiExpression> getQualifiers(PsiExpression thenExpression, PsiExpression elseExpression) {
        PsiExpression thenQualifier = null;
        PsiExpression elseQualifier = null;
        if (thenExpression instanceof PsiMethodCallExpression && elseExpression instanceof PsiMethodCallExpression) {
            thenQualifier = ((PsiMethodCallExpression)thenExpression).getMethodExpression().getQualifierExpression();
            elseQualifier = ((PsiMethodCallExpression)elseExpression).getMethodExpression().getQualifierExpression();
        } else if (thenExpression instanceof PsiNewExpression && elseExpression instanceof PsiNewExpression) {
            thenQualifier = ((PsiNewExpression)thenExpression).getQualifier();
            elseQualifier = ((PsiNewExpression)elseExpression).getQualifier();
        }
        if (thenQualifier == null ^ elseQualifier == null || thenQualifier != null && !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)thenQualifier, (PsiElement)elseQualifier)) {
            return Pair.create((Object)thenQualifier, (Object)elseQualifier);
        }
        return null;
    }

    private static void replaceRecursively(@NotNull Project project, PsiConditionalExpression conditionalExpression, PsiExpression thenExpression, PsiExpression elseExpression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "replaceRecursively"));
        }
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression).getArgumentList();
        if (thenArgsList == null) {
            return;
        }
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression).getArgumentList();
        if (elseArgsList == null) {
            return;
        }
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        Pair<PsiExpression, PsiExpression> qualifiers = PushConditionInCallAction.getQualifiers(thenExpression, elseExpression);
        if (qualifiers != null) {
            if (PushConditionInCallAction.isSameCall(thenExpressions, elseExpressions)) {
                PushConditionInCallAction.replaceRecursively(project, conditionalExpression, (PsiExpression)qualifiers.first, (PsiExpression)qualifiers.second);
            } else {
                PushConditionInCallAction.pushConditional(project, conditionalExpression, thenExpression, elseExpression);
            }
        } else {
            PsiExpression rExpr;
            PsiExpression lExpr;
            for (int i = 0; i < thenExpressions.length && !PushConditionInCallAction.pushConditional(project, conditionalExpression, lExpr = thenExpressions[i], rExpr = elseExpressions[i]); ++i) {
            }
        }
    }

    private static boolean pushConditional(@NotNull Project project, PsiConditionalExpression conditionalExpression, PsiExpression thenExpression, PsiExpression elseExpression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/PushConditionInCallAction", "pushConditional"));
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)thenExpression, (PsiElement)elseExpression)) {
            thenExpression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(conditionalExpression.getCondition().getText() + "?" + thenExpression.getText() + ":" + elseExpression.getText(), (PsiElement)thenExpression));
            return true;
        }
        return false;
    }
}

